/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.DanglingHREFException;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMISaveImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLSaveImpl;
import org.eclipse.hyades.models.hierarchy.util.ContainmentTraverser;
import org.eclipse.hyades.models.hierarchy.util.EObjectVisitor;
import org.eclipse.hyades.models.hierarchy.util.HierarchyXMLString;

public class HierarchyXMISaveImpl
extends XMISaveImpl {
    protected final int BUFFER_SIZE = 262144;
    protected List elementFeaturesPool = new ArrayList();
    protected StringBuffer ids = new StringBuffer(200);
    protected StringBuffer xsiSchemaLocation = new StringBuffer(100);
    protected char[] buffer = new char[262144];
    protected byte[] bytes = new byte[262144];
    protected int[] featureKinds;
    protected int currentDepth;
    protected int elementFeaturesCount = 0;
    private byte[] byteArray;
    private char[] charArray;

    public HierarchyXMISaveImpl(XMLHelper xMLHelper) {
        super(xMLHelper);
    }

    public HierarchyXMISaveImpl(Map map, XMLHelper xMLHelper, String string) {
        super(map, xMLHelper, string);
    }

    public void addNamespaceDeclarations() {
        Object object;
        Object object2;
        EPackage ePackage;
        int n;
        ((XMLSaveImpl)this).doc.addAttribute("xmi:version", "2.0");
        ((XMLSaveImpl)this).doc.addAttribute("xmlns:xmi", "http://www.omg.org/XMI");
        EPackage[] ePackageArray = ((XMLSaveImpl)this).helper.packages();
        this.xsiSchemaLocation.setLength(0);
        if (((XMLSaveImpl)this).declareSchemaLocation) {
            n = 0;
            while (n < ePackageArray.length) {
                Resource resource;
                ePackage = ePackageArray[n];
                object2 = EcoreUtil.getRootContainer((EObject)ePackage);
                if (object2 instanceof EPackage && (resource = (object = (EPackage)object2).eResource()) != null) {
                    URI uRI = resource.getURI();
                    String string = object.getNsURI();
                    boolean bl = uRI == null ? string != null : !uRI.toString().equals(string);
                    if (bl) {
                        ((XMLSaveImpl)this).declareXSI = true;
                        if (this.xsiSchemaLocation.length() > 0) {
                            this.xsiSchemaLocation.append(' ');
                        }
                        this.xsiSchemaLocation.append(string);
                        this.xsiSchemaLocation.append(' ');
                        this.xsiSchemaLocation.append(((XMLSaveImpl)this).helper.getHREF((EObject)object));
                    }
                }
                ++n;
            }
        }
        ((XMLSaveImpl)this).doc.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        n = 0;
        while (n < ePackageArray.length) {
            ePackage = ePackageArray[n];
            object2 = ePackage.getNsURI();
            object = ePackage.getNsPrefix();
            ((XMLSaveImpl)this).doc.addAttributeNS("xmlns", (String)object, (String)object2);
            ++n;
        }
        if (this.xsiSchemaLocation != null && this.xsiSchemaLocation.length() > 0) {
            ((XMLSaveImpl)this).doc.addAttribute("xsi:schemaLocation", this.xsiSchemaLocation.toString());
        }
    }

    public void save(XMLResource xMLResource, OutputStream outputStream, Map map) throws IOException {
        DanglingHREFException danglingHREFException;
        this.init(xMLResource, map);
        ((XMLSaveImpl)this).doc = new HierarchyXMLString(null);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, ((XMLSaveImpl)this).helper.getJavaEncoding(((XMLSaveImpl)this).encoding)), 262144);
        ((HierarchyXMLString)((XMLSaveImpl)this).doc).setWriter(bufferedWriter);
        this.traverse((List)xMLResource.getContents());
        ((Writer)bufferedWriter).flush();
        ((XMLSaveImpl)this).featureTable = null;
        ((XMLSaveImpl)this).doc = null;
        if ((((XMLSaveImpl)this).processDanglingHREF == null || "THROW".equals(((XMLSaveImpl)this).processDanglingHREF)) && (danglingHREFException = ((XMLSaveImpl)this).helper.getDanglingHREFException()) != null) {
            ((XMLSaveImpl)this).helper = null;
            throw new Resource.IOWrappedException((Exception)danglingHREFException);
        }
        ((XMLSaveImpl)this).helper = null;
    }

    public char[] toChar() {
        int n = ((XMLSaveImpl)this).doc.getLength();
        char[] cArray = this.allocCharArray(n);
        ((XMLSaveImpl)this).doc.getChars(cArray, 0);
        return cArray;
    }

    public void traverse(List list) {
        int n;
        if (((XMLSaveImpl)this).declareXML) {
            ((XMLSaveImpl)this).doc.add("<?xml version=\"1.0\" encoding=\"" + ((XMLSaveImpl)this).encoding + "\"?>");
            ((XMLSaveImpl)this).doc.addLine();
        }
        Object object = (n = list.size()) == 1 ? this.writeTopObject((EObject)list.get(0)) : this.writeTopObjects(list);
        ((XMLSaveImpl)this).doc.resetToMark(object);
    }

    public void write(OutputStreamWriter outputStreamWriter) throws IOException {
        int n = 0;
        Iterator iterator = ((XMLSaveImpl)this).doc.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n2 = string.length();
            if (n2 + n >= this.buffer.length) {
                outputStreamWriter.write(this.buffer, 0, n);
                n = 0;
                if (n2 > this.buffer.length) {
                    this.buffer = this.allocCharArray(n2);
                }
            }
            string.getChars(0, n2, this.buffer, n);
            n += n2;
        }
        outputStreamWriter.write(this.buffer, 0, n);
        outputStreamWriter.flush();
    }

    public void writeAscii(OutputStream outputStream) throws IOException {
        int n = 0;
        Iterator iterator = ((XMLSaveImpl)this).doc.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n2 = string.length();
            if (n2 + n >= this.buffer.length) {
                int n3 = 0;
                while (n3 < n) {
                    this.bytes[n3] = (byte)(this.buffer[n3] & 0xFF);
                    ++n3;
                }
                outputStream.write(this.bytes, 0, n);
                n = 0;
                if (n2 > this.buffer.length) {
                    this.buffer = this.allocCharArray(n2);
                    this.bytes = this.allocByteArray(n2);
                }
            }
            string.getChars(0, n2, this.buffer, n);
            n += n2;
        }
        int n4 = 0;
        while (n4 < n) {
            this.bytes[n4] = (byte)(this.buffer[n4] & 0xFF);
            ++n4;
        }
        outputStream.write(this.bytes, 0, n);
        outputStream.flush();
    }

    public Object writeTopObjects(List list) {
        ((XMLSaveImpl)this).doc.startElement("xmi:XMI");
        this.addExtraPackages(list, Integer.MAX_VALUE);
        this.addNamespaceDeclarations();
        Object object = ((XMLSaveImpl)this).doc.mark();
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            EObject eObject = (EObject)list.get(n);
            EClass eClass = eObject.eClass();
            String string = ((XMLSaveImpl)this).helper.getQName(eClass);
            ((XMLSaveImpl)this).doc.startElement(string);
            this.saveElementID(eObject);
            ++n;
        }
        ((XMLSaveImpl)this).doc.endElement();
        return object;
    }

    protected String getContent(EObject eObject, EStructuralFeature[] eStructuralFeatureArray) {
        XMLResource.XMLMap xMLMap = ((XMLSaveImpl)this).helper.getXMLMap();
        if (xMLMap == null) {
            return null;
        }
        int n = 0;
        while (n < eStructuralFeatureArray.length) {
            XMLResource.XMLInfo xMLInfo = xMLMap.getInfo((ENamedElement)eStructuralFeatureArray[n]);
            if (xMLInfo != null && xMLInfo.getXMLRepresentation() == 2) {
                Object object = ((XMLSaveImpl)this).helper.getValue(eObject, eStructuralFeatureArray[n]);
                if (object == null) {
                    return null;
                }
                EDataType eDataType = (EDataType)eStructuralFeatureArray[n].getEType();
                EPackage ePackage = eDataType.getEPackage();
                EFactory eFactory = ePackage.getEFactoryInstance();
                String string = eFactory.convertToString(eDataType, object);
                if (((XMLSaveImpl)this).escape != null) {
                    string = ((XMLSaveImpl)this).escape.convert(string);
                }
                return string;
            }
            ++n;
        }
        return null;
    }

    protected byte[] allocByteArray(int n) {
        if (this.byteArray.length < n) {
            this.byteArray = new byte[n];
        }
        return this.byteArray;
    }

    protected char[] allocCharArray(int n) {
        if (this.charArray.length < n) {
            this.charArray = new char[n];
        }
        return this.charArray;
    }

    protected void saveDataTypeElementSingle(EObject eObject, EStructuralFeature eStructuralFeature) {
        String string = ((XMLSaveImpl)this).helper.getQName(eStructuralFeature);
        Object object = ((XMLSaveImpl)this).helper.getValue(eObject, eStructuralFeature);
        if (object == null) {
            ((XMLSaveImpl)this).doc.startElement(string);
            ((XMLSaveImpl)this).doc.addAttribute("xsi:nil", "true");
            ((XMLSaveImpl)this).doc.endEmptyElement();
            ((XMLSaveImpl)this).declareXSI = true;
        } else {
            EDataType eDataType = (EDataType)eStructuralFeature.getEType();
            EPackage ePackage = eDataType.getEPackage();
            EFactory eFactory = ePackage.getEFactoryInstance();
            ((XMLSaveImpl)this).doc.startElement(string);
            String string2 = eFactory.convertToString(eDataType, object);
            if (((XMLSaveImpl)this).escape != null) {
                string2 = ((XMLSaveImpl)this).escape.convert(string2);
            }
            ((XMLSaveImpl)this).doc.endContentElement(string2);
        }
    }

    protected void saveDataTypeMany(EObject eObject, EStructuralFeature eStructuralFeature) {
        EDataType eDataType = (EDataType)eStructuralFeature.getEType();
        EPackage ePackage = eDataType.getEPackage();
        EFactory eFactory = ePackage.getEFactoryInstance();
        List list = (List)((XMLSaveImpl)this).helper.getValue(eObject, eStructuralFeature);
        int n = list.size();
        if (n > 0) {
            String string = ((XMLSaveImpl)this).helper.getQName(eStructuralFeature);
            int n2 = 0;
            while (n2 < n) {
                Object e = list.get(n2);
                if (e == null) {
                    ((XMLSaveImpl)this).doc.startElement(string);
                    ((XMLSaveImpl)this).doc.addAttribute("xsi:nil", "true");
                    ((XMLSaveImpl)this).doc.endEmptyElement();
                    ((XMLSaveImpl)this).declareXSI = true;
                } else {
                    ((XMLSaveImpl)this).doc.startElement(string);
                    String string2 = eFactory.convertToString(eDataType, e);
                    if (((XMLSaveImpl)this).escape != null) {
                        string2 = ((XMLSaveImpl)this).escape.convert(string2);
                    }
                    ((XMLSaveImpl)this).doc.endContentElement(string2);
                }
                ++n2;
            }
        }
    }

    protected void saveDataTypeSingle(EObject eObject, EStructuralFeature eStructuralFeature) {
        EDataType eDataType = (EDataType)eStructuralFeature.getEType();
        EPackage ePackage = eDataType.getEPackage();
        EFactory eFactory = ePackage.getEFactoryInstance();
        Object object = ((XMLSaveImpl)this).helper.getValue(eObject, eStructuralFeature);
        if (object != null) {
            String string = eFactory.convertToString(eDataType, object);
            if (((XMLSaveImpl)this).escape != null) {
                string = ((XMLSaveImpl)this).escape.convert(string);
            }
            ((XMLSaveImpl)this).doc.addAttribute(((XMLSaveImpl)this).helper.getQName(eStructuralFeature), string);
        }
    }

    protected boolean saveFeatures(EObject eObject) {
        EClass eClass = eObject.eClass();
        EStructuralFeature[] eStructuralFeatureArray = ((XMLSaveImpl)this).featureTable.getFeatures(eClass);
        int[] nArray = ((XMLSaveImpl)this).featureTable.getKinds(eClass, eStructuralFeatureArray);
        int[] nArray2 = null;
        int n = 0;
        int n2 = 0;
        while (n2 < eStructuralFeatureArray.length) {
            int n3 = nArray[n2];
            EStructuralFeature eStructuralFeature = eStructuralFeatureArray[n2];
            if (n3 != 0 && eObject.eIsSet(eStructuralFeature)) {
                switch (n3) {
                    case 2: {
                        if (nArray2 == null) {
                            nArray2 = this.allocElementFeatures(eStructuralFeatureArray.length);
                        }
                        nArray2[n++] = n2;
                        break;
                    }
                    case 1: {
                        this.saveDataTypeSingle(eObject, eStructuralFeature);
                        break;
                    }
                    case 4: {
                        if (this.isNil(eObject, eStructuralFeature)) {
                            if (nArray2 == null) {
                                nArray2 = this.allocElementFeatures(eStructuralFeatureArray.length);
                            }
                            nArray2[n++] = n2;
                            break;
                        }
                        this.saveDataTypeSingle(eObject, eStructuralFeature);
                        break;
                    }
                    case 12: {
                        if (this.isNil(eObject, eStructuralFeature)) {
                            if (nArray2 == null) {
                                nArray2 = this.allocElementFeatures(eStructuralFeatureArray.length);
                            }
                            nArray2[n++] = n2;
                            break;
                        }
                    }
                    case 8: {
                        if (((XMLSaveImpl)this).useEncodedAttributeStyle) {
                            this.saveEObjectSingle(eObject, eStructuralFeature);
                            break;
                        }
                        switch (this.sameDocSingle(eObject, eStructuralFeature)) {
                            case 1: {
                                this.saveIDRefSingle(eObject, eStructuralFeature);
                                break;
                            }
                            case 2: {
                                if (nArray2 == null) {
                                    nArray2 = this.allocElementFeatures(eStructuralFeatureArray.length);
                                }
                                nArray2[n++] = n2;
                            }
                        }
                        break;
                    }
                    case 13: {
                        if (this.isEmpty(eObject, eStructuralFeature)) {
                            this.saveManyEmpty(eStructuralFeature);
                            break;
                        }
                    }
                    case 9: {
                        if (((XMLSaveImpl)this).useEncodedAttributeStyle) {
                            this.saveEObjectMany(eObject, eStructuralFeature);
                            break;
                        }
                        switch (this.sameDocMany(eObject, eStructuralFeature)) {
                            case 1: {
                                this.saveIDRefMany(eObject, eStructuralFeature);
                                break;
                            }
                            case 2: {
                                if (nArray2 == null) {
                                    nArray2 = this.allocElementFeatures(eStructuralFeatureArray.length);
                                }
                                nArray2[n++] = n2;
                            }
                        }
                        break;
                    }
                    case 5: 
                    case 11: {
                        if (this.isEmpty(eObject, eStructuralFeature)) {
                            this.saveManyEmpty(eStructuralFeature);
                            break;
                        }
                    }
                    case 6: 
                    case 7: 
                    case 10: 
                    case 14: 
                    case 15: {
                        if (nArray2 == null) {
                            nArray2 = this.allocElementFeatures(eStructuralFeatureArray.length);
                        }
                        nArray2[n++] = n2;
                    }
                }
            }
            ++n2;
        }
        String string = this.getContent(eObject, eStructuralFeatureArray);
        if (nArray2 == null) {
            if (string == null) {
                this.endSaveFeatures(eObject, 1, null);
                if (nArray2 != null) {
                    this.dealocElementFeatures();
                }
                return false;
            }
            this.endSaveFeatures(eObject, 2, string);
            if (nArray2 != null) {
                this.dealocElementFeatures();
            }
            return true;
        }
        int n4 = 0;
        while (n4 < n) {
            int n5 = nArray[nArray2[n4]];
            EStructuralFeature eStructuralFeature = eStructuralFeatureArray[nArray2[n4]];
            switch (n5) {
                case 4: {
                    this.saveNil(eStructuralFeature);
                    break;
                }
                case 5: {
                    this.saveDataTypeMany(eObject, eStructuralFeature);
                    break;
                }
                case 2: {
                    this.saveDataTypeElementSingle(eObject, eStructuralFeature);
                    break;
                }
                case 10: {
                    if (this.isNil(eObject, eStructuralFeature)) {
                        this.saveNil(eStructuralFeature);
                        break;
                    }
                }
                case 6: {
                    this.saveContainedSingle(eObject, eStructuralFeature);
                    break;
                }
                case 7: 
                case 11: {
                    this.saveContainedMany(eObject, eStructuralFeature);
                    break;
                }
                case 12: {
                    if (this.isNil(eObject, eStructuralFeature)) {
                        this.saveNil(eStructuralFeature);
                        break;
                    }
                }
                case 8: {
                    this.saveHRefSingle(eObject, eStructuralFeature);
                    break;
                }
                case 9: 
                case 13: {
                    this.saveHRefMany(eObject, eStructuralFeature);
                    break;
                }
                case 14: {
                    this.saveElementReferenceSingle(eObject, eStructuralFeature);
                    break;
                }
                case 15: {
                    this.saveElementReferenceMany(eObject, eStructuralFeature);
                }
            }
            ++n4;
        }
        this.endSaveFeatures(eObject, 0, null);
        if (nArray2 != null) {
            this.dealocElementFeatures();
        }
        return true;
    }

    protected void saveIDRefMany(EObject eObject, EStructuralFeature eStructuralFeature) {
        InternalEList internalEList = (InternalEList)((XMLSaveImpl)this).helper.getValue(eObject, eStructuralFeature);
        if (!internalEList.isEmpty()) {
            String string = ((XMLSaveImpl)this).helper.getQName(eStructuralFeature);
            this.ids.setLength(0);
            Iterator iterator = internalEList.basicIterator();
            while (true) {
                EObject eObject2 = (EObject)iterator.next();
                String string2 = ((XMLSaveImpl)this).helper.getIDREF(eObject2);
                this.ids.append(string2);
                if (!iterator.hasNext()) break;
                this.ids.append(" ");
            }
            ((XMLSaveImpl)this).doc.addAttribute(string, this.ids.toString());
        }
    }

    protected Object writeTopObject(EObject eObject) {
        EClass eClass = eObject.eClass();
        BasicEList basicEList = new BasicEList();
        basicEList.add(eObject);
        this.addExtraPackages((List)basicEList, Integer.MAX_VALUE);
        String string = ((XMLSaveImpl)this).helper.getQName(eClass);
        ((XMLSaveImpl)this).doc.startElement(string);
        this.addNamespaceDeclarations();
        Object object = ((XMLSaveImpl)this).doc.mark();
        this.saveElementID(eObject);
        return object;
    }

    private void addExtraPackages(List list, final int n) {
        this.currentDepth = 0;
        ContainmentTraverser containmentTraverser = new ContainmentTraverser(list);
        EObjectVisitor eObjectVisitor = new EObjectVisitor(){

            public boolean afterChildren(EObject eObject) {
                --HierarchyXMISaveImpl.this.currentDepth;
                ((XMLSaveImpl)HierarchyXMISaveImpl.this).helper.getQName(eObject.eClass());
                return true;
            }

            public boolean beforeChildren(EObject eObject) {
                if (HierarchyXMISaveImpl.this.currentDepth > n) {
                    return false;
                }
                ++HierarchyXMISaveImpl.this.currentDepth;
                return true;
            }
        };
        containmentTraverser.registerVisitors(eObjectVisitor);
        containmentTraverser.traverse();
    }

    private int[] allocElementFeatures(int n) {
        int[] nArray;
        if (this.elementFeaturesCount == this.elementFeaturesPool.size()) {
            nArray = new int[n];
            this.elementFeaturesPool.add(nArray);
        } else {
            nArray = (int[])this.elementFeaturesPool.get(this.elementFeaturesCount);
            if (nArray.length < n) {
                nArray = new int[n];
                this.elementFeaturesPool.set(this.elementFeaturesCount, nArray);
            }
        }
        ++this.elementFeaturesCount;
        return nArray;
    }

    private void dealocElementFeatures() {
        if (this.elementFeaturesCount > 0) {
            --this.elementFeaturesCount;
        }
    }
}

