/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util;

public final class IndexHashTable {
    public Object[] keyTable;
    public int[] valueTable;
    int elementSize = 0;
    int threshold;

    public IndexHashTable() {
        this(13);
    }

    public IndexHashTable(int n) {
        this.threshold = n;
        int n2 = (int)((float)n * 1.75f);
        if (this.threshold == n2) {
            ++n2;
        }
        this.keyTable = new Object[n2];
        this.valueTable = new int[n2];
    }

    public boolean containsKey(Object object) {
        Object object2;
        int n = object.hashCode() % this.valueTable.length;
        while ((object2 = this.keyTable[n]) != null) {
            if (object2 == object) {
                return true;
            }
            n = (n + 1) % this.keyTable.length;
        }
        return false;
    }

    public int get(Object object) {
        Object object2;
        int n = object.hashCode() % this.valueTable.length;
        while ((object2 = this.keyTable[n]) != null) {
            if (object2 == object) {
                return this.valueTable[n];
            }
            n = (n + 1) % this.keyTable.length;
        }
        return -1;
    }

    public int put(Object object, int n) {
        Object object2;
        int n2 = object.hashCode() % this.valueTable.length;
        while ((object2 = this.keyTable[n2]) != null) {
            if (object2 == object) {
                this.valueTable[n2] = n;
                return this.valueTable[n2];
            }
            n2 = (n2 + 1) % this.keyTable.length;
        }
        this.keyTable[n2] = object;
        this.valueTable[n2] = n;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return n;
    }

    private void rehash() {
        IndexHashTable indexHashTable = new IndexHashTable(this.elementSize * 2);
        int n = this.keyTable.length;
        while (--n >= 0) {
            Object object = this.keyTable[n];
            if (object == null) continue;
            indexHashTable.put(object, this.valueTable[n]);
        }
        this.keyTable = indexHashTable.keyTable;
        this.valueTable = indexHashTable.valueTable;
        this.threshold = indexHashTable.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        String string = "";
        int n = 0;
        int n2 = this.valueTable.length;
        while (n < n2) {
            int n3 = this.valueTable[n];
            if (n3 != -1) {
                string = string + this.keyTable[n] + " -> " + n3 + "\n";
            }
            ++n;
        }
        return string;
    }
}

