/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.internal.ui;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.impl.HierarchyFactoryImpl;
import org.eclipse.hyades.models.hierarchy.impl.HierarchyPackageImpl;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.trace.internal.ui.TraceSelection;
import org.eclipse.hyades.trace.ui.IDeleteListener;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.ui.internal.console.ConsoleDataProcessor;
import org.eclipse.hyades.trace.ui.internal.console.ConsoleManager;
import org.eclipse.hyades.trace.ui.internal.util.ColorManager;
import org.eclipse.hyades.trace.ui.internal.util.TraceManager;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class TraceUIManager
implements ISelectionChangedListener {
    private static TraceUIManager traceUIManager;
    protected ResourceSet resourceSet;
    protected HierarchyFactory factory;
    protected TraceManager fTraceManager;
    protected ConsoleManager fConsoleManager;
    protected HashMap fSelectionModel = new HashMap();
    protected ProfileEvent fProfileEvent = new ProfileEvent();
    protected ViewSelectionChangedEvent pdViewEvent = new ViewSelectionChangedEvent();
    protected ProfileEvent updateModelEvent = new ProfileEvent(32);
    protected ProfileEvent refreshViewsEvent = new ProfileEvent(64);
    protected ListenerList fProfileEventListeners = new ListenerList(20);
    protected ListenerList fPDViewEventListeners = new ListenerList(20);
    protected List fSelectionParts = new ArrayList(2);
    protected List fSelectionProviders = new ArrayList(2);
    protected ListenerList fListeners = new ListenerList(2);
    protected ArrayList fDeleteListener = new ArrayList(1);

    private TraceUIManager() {
    }

    public static TraceUIManager getTraceUIManager() {
        if (traceUIManager == null) {
            traceUIManager = new TraceUIManager();
        }
        return traceUIManager;
    }

    public ConsoleManager getConsoleManager() {
        if (this.fConsoleManager == null) {
            this.fConsoleManager = new ConsoleManager();
            this.addSelectionListener(this.fConsoleManager);
        }
        return this.fConsoleManager;
    }

    public void addSelectionListener(ISelectionListener iSelectionListener) {
        this.fListeners.add((Object)iSelectionListener);
    }

    public void removeSelectionListener(ISelectionListener iSelectionListener) {
        this.fListeners.remove((Object)iSelectionListener);
    }

    public void addSelectionProvider(ISelectionProvider iSelectionProvider, IWorkbenchPart iWorkbenchPart) {
        this.fSelectionProviders.add(iSelectionProvider);
        this.fSelectionParts.add(iWorkbenchPart);
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void deregisterLaunchProcess(TRCProcessProxy tRCProcessProxy) {
        this.getConsoleManager().deregisterLaunchProcess(tRCProcessProxy);
    }

    public ColorManager getColorManager() {
        return this.fConsoleManager.getColorManager();
    }

    public HierarchyFactory getPerftraceFactory() {
        return this.factory;
    }

    public ResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            HierarchyPackageImpl.init();
            this.factory = new HierarchyFactoryImpl();
            this.resourceSet = HierarchyResourceSetImpl.getInstance();
        }
        return this.resourceSet;
    }

    public TraceManager getTraceManager() {
        if (this.fTraceManager == null) {
            this.fTraceManager = new TraceManager();
        }
        return this.fTraceManager;
    }

    public void registerLaunchProcess(ConsoleDataProcessor consoleDataProcessor) {
        this.getConsoleManager().registerLaunchProcess(consoleDataProcessor);
    }

    public void removeSelectionProvider(ISelectionProvider iSelectionProvider, IWorkbenchPart iWorkbenchPart) {
        this.fSelectionProviders.remove(iSelectionProvider);
        this.fSelectionParts.remove(iWorkbenchPart);
        iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.selectionChanged(null);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        int n;
        Object[] objectArray = this.fListeners.getListeners();
        ISelection iSelection = null;
        ISelectionProvider iSelectionProvider = null;
        IWorkbenchPart iWorkbenchPart = null;
        if (selectionChangedEvent != null) {
            iSelection = selectionChangedEvent.getSelection();
            iSelectionProvider = (ISelectionProvider)selectionChangedEvent.getSource();
            n = this.fSelectionProviders.indexOf(iSelectionProvider);
            if (n == -1) {
                return;
            }
        } else {
            return;
        }
        iWorkbenchPart = (IWorkbenchPart)this.fSelectionParts.get(n);
        n = 0;
        while (n < objectArray.length) {
            ISelectionListener iSelectionListener = (ISelectionListener)objectArray[n];
            iSelectionListener.selectionChanged(iWorkbenchPart, iSelection);
            ++n;
        }
    }

    public void dispose() {
        if (this.fConsoleManager != null) {
            this.fConsoleManager.getColorManager().dispose();
            this.fConsoleManager = null;
        }
        this.fListeners.clear();
        this.fDeleteListener.clear();
        this.fSelectionParts.clear();
        this.fSelectionProviders.clear();
        this.resourceSet = null;
        this.factory = null;
        this.fPDViewEventListeners.clear();
        this.fDeleteListener.clear();
        this.fProfileEventListeners.clear();
        this.fSelectionModel.clear();
        this.fProfileEvent = null;
        this.pdViewEvent = null;
        this.refreshViewsEvent = null;
        this.updateModelEvent = null;
        if (this.fTraceManager != null) {
            this.fTraceManager.getTraces().clear();
        }
        this.fTraceManager = null;
        traceUIManager = null;
    }

    public void addProfileEventListener(IProfileEventListener iProfileEventListener) {
        this.fProfileEventListeners.add((Object)iProfileEventListener);
    }

    public void removeProfileEventListener(IProfileEventListener iProfileEventListener) {
        this.fProfileEventListeners.remove((Object)iProfileEventListener);
    }

    public void addDeleteListener(IDeleteListener iDeleteListener) {
        this.fDeleteListener.add(iDeleteListener);
    }

    public void addViewSelectionChangedListener(IViewSelectionChangedListener iViewSelectionChangedListener) {
        this.fPDViewEventListeners.add((Object)iViewSelectionChangedListener);
    }

    public void addSelectionModel(EObject eObject, ITraceSelection iTraceSelection) {
        this.fSelectionModel.put(eObject, iTraceSelection);
    }

    public ArrayList getDeleteListeners() {
        return this.fDeleteListener;
    }

    public ViewSelectionChangedEvent getViewSelectionChangedEvent() {
        return this.pdViewEvent;
    }

    public ProfileEvent getProfileEvent() {
        return this.fProfileEvent;
    }

    public ProfileEvent getRefreshViewEvent(Object object) {
        this.refreshViewsEvent.setSource(object);
        return this.refreshViewsEvent;
    }

    public ITraceSelection getSelectionModel(EObject eObject) {
        Object object = this.fSelectionModel.get(eObject);
        if (object == null) {
            object = new TraceSelection();
            this.fSelectionModel.put(eObject, object);
        }
        return (ITraceSelection)object;
    }

    public ProfileEvent getUpdateModelEvent(Object object) {
        this.updateModelEvent.setSource(object);
        return this.updateModelEvent;
    }

    public void notifyViewSelectionChangedListener(ViewSelectionChangedEvent viewSelectionChangedEvent) {
        Object[] objectArray = this.fPDViewEventListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IViewSelectionChangedListener)objectArray[n]).handleViewSelectionChangedEvent(viewSelectionChangedEvent);
            ++n;
        }
    }

    public void notifyProfileEventListener(ProfileEvent profileEvent) {
        Object[] objectArray = this.fProfileEventListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IProfileEventListener)objectArray[n]).handleProfileEvent(profileEvent);
            ++n;
        }
    }

    public void removeDeleteListener(IDeleteListener iDeleteListener) {
        ((AbstractCollection)this.fDeleteListener).remove(iDeleteListener);
    }

    public void removeViewSelectionChangedListener(IViewSelectionChangedListener iViewSelectionChangedListener) {
        this.fPDViewEventListeners.remove((Object)iViewSelectionChangedListener);
    }

    public void removeSelectionModel(EObject eObject) {
        this.fSelectionModel.remove(eObject);
    }
}

