/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.trace.ui.DefaultPage;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.IDeleteListener;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.ui.internal.editor.action.ActionHandlerListener;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;

public abstract class TraceViewer
extends ViewPart
implements IMenuListener,
ISelectionListener,
IProfileEventListener,
IDeleteListener {
    protected boolean _initializedMenu = false;
    protected Hashtable _pages = new Hashtable();
    private PageBook book;
    private IPage currentPage;
    private IPage defaultPage;
    private IDialogSettings settings;
    protected Menu fContextMenu;
    public final String GROUP_ADD_VIEWS = "open.views";
    public final String GROUP_GENERIC = "generic.action";
    protected boolean fRefreshView = false;
    protected boolean fPartVisible = true;
    protected IPartListener2 fPartListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
            if (iWorkbenchPartReference != null && iWorkbenchPartReference.getPart(false) == TraceViewer.this) {
                TraceViewer.this.fPartVisible = true;
                if (TraceViewer.this.fRefreshView) {
                    TraceViewer.this.fRefreshView = false;
                    TraceViewer.this.refreshVisiblePage();
                }
            }
        }

        public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
            if (iWorkbenchPartReference != null && iWorkbenchPartReference.getPart(false) == TraceViewer.this) {
                TraceViewer.this.fPartVisible = false;
            }
        }
    };
    private int previousSelection = 0;

    public void addViewPage(EObject eObject) {
        if (this.book == null) {
            UIPlugin.getDefault().removeSelectionListener(this);
            return;
        }
        EObject eObject2 = this.getObjectToView(eObject);
        this.setViewTitle(eObject2);
        if (eObject2 == null) {
            this.showPage(this.defaultPage);
            return;
        }
        boolean bl = false;
        TraceViewerPage traceViewerPage = this.getPage(eObject2);
        if (this.defaultPage == traceViewerPage) {
            return;
        }
        if (traceViewerPage == null) {
            Enumeration enumeration = this._pages.elements();
            while (enumeration.hasMoreElements()) {
                ((IPage)enumeration.nextElement()).dispose();
            }
            this._pages.clear();
            this.makeActions();
            traceViewerPage = this.createPage(eObject2);
            traceViewerPage.createControl((Composite)this.book);
            this._pages.put(eObject2, traceViewerPage);
            bl = true;
        }
        if (bl) {
            traceViewerPage.update(bl);
        }
        if (traceViewerPage.isEmpty()) {
            this.showPage(this.defaultPage);
        } else {
            this.showPage((IPage)traceViewerPage);
        }
    }

    public EObject getObjectToView(EObject eObject) {
        return eObject;
    }

    protected IPage createDefaultPage(PageBook pageBook) {
        DefaultPage defaultPage = new DefaultPage();
        defaultPage.createControl((Composite)pageBook);
        defaultPage.setMessage(UIPlugin.getResourceString("STR_NODATA"));
        return defaultPage;
    }

    public abstract TraceViewerPage createPage(EObject var1);

    public void createPartControl(Composite composite) {
        this.book = new PageBook(composite, 0);
        this.defaultPage = this.createDefaultPage(this.book);
        this.addViewPage(HyadesUtil.getMofObject());
        UIPlugin.getDefault().addSelectionListener(this);
        UIPlugin.getDefault().addProfileEventListener(this);
        UIPlugin.getDefault().addDeleteListener(this);
        this.getViewSite().getPage().addPartListener(this.fPartListener);
        this.settings = UIPlugin.getDefault().getDialogSettings();
    }

    public IPage getCurrentPage() {
        if (this.currentPage == null || !(this.currentPage instanceof TraceViewerPage)) {
            return null;
        }
        return this.currentPage;
    }

    public TraceViewerPage getPage(EObject eObject) {
        Object v;
        if (eObject != null && (v = this._pages.get(eObject)) != null) {
            return (TraceViewerPage)((Object)v);
        }
        return null;
    }

    public void dispose() {
        this.settings = null;
        UIPlugin.getDefault().removeSelectionListener(this);
        UIPlugin.getDefault().removeProfileEventListener(this);
        UIPlugin.getDefault().removeDeleteListener(this);
        this.getSite().getPage().removePartListener(this.fPartListener);
        Enumeration enumeration = this._pages.elements();
        while (enumeration.hasMoreElements()) {
            ((IPage)enumeration.nextElement()).dispose();
        }
        this._pages.clear();
        if (this.book != null) {
            this.book.dispose();
            this.book = null;
        }
        if (this.currentPage != null) {
            this.currentPage.dispose();
            this.currentPage = null;
        }
        if (this.defaultPage != null) {
            this.defaultPage.dispose();
            this.defaultPage = null;
        }
        this.fPartListener = null;
        super.dispose();
    }

    public void initializedMenu(boolean bl) {
        this._initializedMenu = bl;
    }

    protected boolean isImportant(IWorkbenchPart iWorkbenchPart) {
        return true;
    }

    public boolean isInitializedMenu() {
        return this._initializedMenu;
    }

    public boolean isSaveNeeded() {
        return false;
    }

    public void makeActions() {
    }

    protected void refreshPage(Object object) {
        if (this._pages == null) {
            return;
        }
        if (object != null) {
            Object v = this._pages.get(object);
            if (v == null) {
                this.fRefreshView = true;
                return;
            }
            if (v instanceof TraceViewerPage) {
                ((TraceViewerPage)((Object)v)).refreshPage();
                if (((TraceViewerPage)((Object)v)).isEmpty()) {
                    this.showPage(this.defaultPage);
                } else {
                    this.showPage((IPage)((TraceViewerPage)((Object)v)));
                }
            }
        }
    }

    protected void selectionChanged(Object object) {
        if (object == null) {
            return;
        }
        Object v = this._pages.get(object);
        if (v != null && v instanceof TraceViewerPage) {
            ((TraceViewerPage)((Object)v)).selectionChanged();
        }
    }

    public void removePage(Object object) {
        if (object == null || !(object instanceof EObject)) {
            return;
        }
        Object v = this._pages.get(this.getObjectToView((EObject)object));
        this._pages.remove(object);
        if (v != null) {
            if (v == this.currentPage) {
                this.showPage(this.defaultPage);
            }
            ((IPage)v).dispose();
        }
    }

    public void setFocus() {
    }

    public void showPage(IPage iPage) {
        this.book.showPage(iPage.getControl());
        this.currentPage = iPage;
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        this.fRefreshView = true;
        boolean bl = ((INavigator)iWorkbenchPart).isLinkingEnabled();
        if (!this.fPartVisible || iWorkbenchPart == null || iWorkbenchPart.getSite().getWorkbenchWindow() != this.getSite().getWorkbenchWindow()) {
            return;
        }
        if (!bl) {
            return;
        }
        if (iSelection == null || iSelection.isEmpty() || !(iSelection instanceof IStructuredSelection)) {
            this.addViewPage(null);
            return;
        }
        Object object = ((IStructuredSelection)iSelection).getFirstElement();
        if (object == null || !(object instanceof EObject)) {
            this.addViewPage(null);
        } else {
            if (this.previousSelection != object.hashCode()) {
                this.fRefreshView = true;
                this.previousSelection = object.hashCode();
            } else {
                this.fRefreshView = false;
            }
            this.addViewPage((EObject)object);
        }
    }

    public void init(IViewSite iViewSite) throws PartInitException {
        super.init(iViewSite);
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
        this.enableEditActions();
    }

    public abstract String getViewTitle();

    public void handleProfileEvent(ProfileEvent profileEvent) {
        int n = profileEvent.getType();
        if (!this.fPartVisible) {
            if (n == 64 || n == 32) {
                this.fRefreshView = true;
            }
            return;
        }
        this.fRefreshView = false;
        if ((n == 64 || n == 32) && profileEvent.getSource() instanceof EObject) {
            this.refreshPage(this.getObjectToView((EObject)profileEvent.getSource()));
        }
    }

    protected void setViewTitle(Object object) {
        if (object != null && object instanceof TRCAgentProxy) {
            TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)object;
            this.setTitle(this.getViewTitle() + " - " + HyadesUtil.getProcessName(tRCAgentProxy.getProcessProxy()));
            return;
        }
        this.setTitle(this.getViewTitle());
    }

    public void initializeActionBar() {
    }

    public void setRecordSelection(EObject eObject, EObject eObject2) {
    }

    public boolean isProcessRefreshEvents() {
        return this.fPartVisible;
    }

    private void refreshVisiblePage() {
        EObject eObject = HyadesUtil.getMofObject();
        this.addViewPage(eObject);
        EObject eObject2 = this.getObjectToView(eObject);
        this.refreshPage(eObject2);
        this.selectionChanged(eObject2);
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        if (this.getCurrentPage() != null && this.getCurrentPage() instanceof TraceViewerPage) {
            ((TraceViewerPage)this.getCurrentPage()).fillContextMenu(iMenuManager);
        }
        iMenuManager.add((IContributionItem)new Separator("open.views"));
        iMenuManager.add((IContributionItem)new Separator("generic.action"));
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    public void deregister(Object object) {
        this.removePage(object);
    }

    protected void enableEditActions() {
        ActionHandlerListener.DEFAULT.connectPart((IWorkbenchPart)this);
    }
}

