/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui;

import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.internal.execution.local.control.Application;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.internal.ui.TraceUIManager;
import org.eclipse.hyades.trace.ui.IDeleteListener;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.ui.internal.console.ConsoleDataProcessor;
import org.eclipse.hyades.trace.ui.internal.console.ConsoleManager;
import org.eclipse.hyades.trace.ui.internal.util.ColorManager;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class UIPlugin
extends AbstractUIPlugin
implements Application {
    protected static UIPlugin inst;
    protected ResourceBundle fResourceBundle;

    public UIPlugin(IPluginDescriptor iPluginDescriptor) {
        super(iPluginDescriptor);
        if (inst == null) {
            inst = this;
        }
        try {
            this.fResourceBundle = this.getDescriptor().getResourceBundle();
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
        }
    }

    public void addSelectionListener(ISelectionListener iSelectionListener) {
        TraceUIManager.getTraceUIManager().addSelectionListener(iSelectionListener);
    }

    public void removeSelectionListener(ISelectionListener iSelectionListener) {
        TraceUIManager.getTraceUIManager().removeSelectionListener(iSelectionListener);
    }

    public void addSelectionProvider(ISelectionProvider iSelectionProvider, IWorkbenchPart iWorkbenchPart) {
        TraceUIManager.getTraceUIManager().addSelectionProvider(iSelectionProvider, iWorkbenchPart);
    }

    public void deregisterLaunchProcess(TRCProcessProxy tRCProcessProxy) {
        this.getConsoleManager().deregisterLaunchProcess(tRCProcessProxy);
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchPage iWorkbenchPage = UIPlugin.getActiveWorkbenchWindow().getActivePage();
        if (iWorkbenchPage == null || !iWorkbenchPage.getPerspective().getId().equals("org.eclipse.hyades.trace.internal.ui.tracePerspective")) {
            IWorkbenchWindow iWorkbenchWindow = UIPlugin.getActiveWorkbenchWindow();
            iWorkbenchPage = null;
            try {
                IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindow.getPages();
                int n = 0;
                while (n < iWorkbenchPageArray.length) {
                    if (iWorkbenchPageArray[n].getPerspective().getId().equals("org.eclipse.hyades.trace.internal.ui.tracePerspective")) {
                        iWorkbenchPage = iWorkbenchPageArray[n];
                        iWorkbenchWindow.setActivePage(iWorkbenchPage);
                        break;
                    }
                    ++n;
                }
                if (iWorkbenchPage == null) {
                    IWorkspaceRoot iWorkspaceRoot = UIPlugin.getPluginWorkbench().getRoot();
                    IWorkbench iWorkbench = iWorkbenchWindow.getWorkbench();
                    if (iWorkbench != null && iWorkspaceRoot != null) {
                        iWorkbenchPage = iWorkbench.showPerspective("org.eclipse.hyades.trace.internal.ui.tracePerspective", UIPlugin.getActiveWorkbenchWindow(), (IAdaptable)iWorkspaceRoot);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return iWorkbenchPage;
    }

    public static Shell getActiveWorkbenchShell() {
        return UIPlugin.getActiveWorkbenchWindow().getShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public ColorManager getColorManager() {
        return TraceUIManager.getTraceUIManager().getColorManager();
    }

    public ConsoleManager getConsoleManager() {
        return TraceUIManager.getTraceUIManager().getConsoleManager();
    }

    public static UIPlugin getDefault() {
        return inst;
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        return PDPluginImages.getImageDescriptor(string);
    }

    public HierarchyFactory getPerftraceFactory() {
        return TraceUIManager.getTraceUIManager().getPerftraceFactory();
    }

    public static String getPluginId() {
        return UIPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public static IWorkspace getPluginWorkbench() {
        return ResourcesPlugin.getWorkspace();
    }

    public ResourceBundle getResourceBundle() {
        return this.fResourceBundle;
    }

    public ResourceSet getResourceSet() {
        return TraceUIManager.getTraceUIManager().getResourceSet();
    }

    public static String getResourceString(String string) {
        ResourceBundle resourceBundle = UIPlugin.getDefault().getResourceBundle();
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public TraceManager getTraceManager() {
        return TraceUIManager.getTraceUIManager().getTraceManager();
    }

    public PDProjectExplorer getViewer() {
        return PDProjectExplorer.getFromActivePerspective();
    }

    protected void initializeDefaultPreferences(IPreferenceStore iPreferenceStore) {
        iPreferenceStore.setDefault("use_host", "localhost:10002");
        iPreferenceStore.setDefault("localhost_port", "10002");
        iPreferenceStore.setDefault("prj_name", "ProfileProject");
        iPreferenceStore.setDefault("mon_name", "DefaultMonitor");
        iPreferenceStore.setDefault("log_option", false);
        iPreferenceStore.setDefault("prof_option", true);
        iPreferenceStore.setDefault("profile_tips", true);
        iPreferenceStore.setDefault("new_snapshot_tips", true);
        iPreferenceStore.setDefault("prof_exec_stat", true);
        iPreferenceStore.setDefault("prof_heap_stat", true);
        iPreferenceStore.setDefault("prof_heap_inst", false);
        iPreferenceStore.setDefault("prof_auto_monitor", true);
        iPreferenceStore.setDefault("refresh_type", 0);
        iPreferenceStore.setDefault("refresh_int", 3);
        iPreferenceStore.setDefault("show_folder", false);
        iPreferenceStore.setDefault("show_monitor", false);
        iPreferenceStore.setDefault("show_node", false);
        iPreferenceStore.setDefault("show_process", true);
        iPreferenceStore.setDefault("show_log", true);
        iPreferenceStore.setDefault("show_prof", true);
        String string = UIPlugin.getResourceString("STR_DEFAULT_SET_NAME");
        iPreferenceStore.setDefault("filter_name", string);
        String string2 = TraceConstants.DEFAULT_FILTER_SET;
        iPreferenceStore.setDefault("set_filters", string2);
        iPreferenceStore.setDefault("prof_heap_size", true);
        iPreferenceStore.setDefault("prof_execution", false);
        iPreferenceStore.setDefault("prof_execution_boundary", false);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"Console.stdOutColor", (RGB)new RGB(0, 0, 255));
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"Console.stdInColor", (RGB)new RGB(0, 200, 125));
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"Console.stdErrColor", (RGB)new RGB(255, 0, 0));
        iPreferenceStore.setDefault("limitInvoc", false);
        iPreferenceStore.setDefault("limitTime", false);
        iPreferenceStore.setDefault("invoc_nb", "10000");
        iPreferenceStore.setDefault("timeSec", "5");
        iPreferenceStore.setDefault("collect_depth", "1");
    }

    public void registerLaunchProcess(ConsoleDataProcessor consoleDataProcessor) {
        this.getConsoleManager().registerLaunchProcess(consoleDataProcessor);
    }

    public void removeSelectionProvider(ISelectionProvider iSelectionProvider, IWorkbenchPart iWorkbenchPart) {
        TraceUIManager.getTraceUIManager().removeSelectionProvider(iSelectionProvider, iWorkbenchPart);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        TraceUIManager.getTraceUIManager().selectionChanged(selectionChangedEvent);
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        this.getConsoleManager().selectionChanged(iWorkbenchPart, iSelection);
    }

    public void shutdown() throws CoreException {
        super.shutdown();
        PDPluginImages.shutdown();
        TraceUIManager.getTraceUIManager().dispose();
        try {
            PDCoreUtil.detachAgents();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.fResourceBundle = null;
    }

    public void startup() throws CoreException {
        super.startup();
    }

    public void addProfileEventListener(IProfileEventListener iProfileEventListener) {
        TraceUIManager.getTraceUIManager().addProfileEventListener(iProfileEventListener);
    }

    public void removeProfileEventListener(IProfileEventListener iProfileEventListener) {
        TraceUIManager.getTraceUIManager().removeProfileEventListener(iProfileEventListener);
    }

    public void addDeleteListener(IDeleteListener iDeleteListener) {
        TraceUIManager.getTraceUIManager().addDeleteListener(iDeleteListener);
    }

    public void addViewSelectionChangedListener(IViewSelectionChangedListener iViewSelectionChangedListener) {
        TraceUIManager.getTraceUIManager().addViewSelectionChangedListener(iViewSelectionChangedListener);
    }

    public void addSelectionModel(EObject eObject, ITraceSelection iTraceSelection) {
        TraceUIManager.getTraceUIManager().addSelectionModel(eObject, iTraceSelection);
    }

    public ArrayList getDeleteListeners() {
        return TraceUIManager.getTraceUIManager().getDeleteListeners();
    }

    public ViewSelectionChangedEvent getViewSelectionChangedEvent() {
        return TraceUIManager.getTraceUIManager().getViewSelectionChangedEvent();
    }

    public ProfileEvent getProfileEvent() {
        return TraceUIManager.getTraceUIManager().getProfileEvent();
    }

    public ProfileEvent getRefreshViewEvent(Object object) {
        return TraceUIManager.getTraceUIManager().getRefreshViewEvent(object);
    }

    public ITraceSelection getSelectionModel(EObject eObject) {
        return TraceUIManager.getTraceUIManager().getSelectionModel(eObject);
    }

    public ProfileEvent getUpdateModelEvent(Object object) {
        return TraceUIManager.getTraceUIManager().getUpdateModelEvent(object);
    }

    public void notifyViewSelectionChangedListener(ViewSelectionChangedEvent viewSelectionChangedEvent) {
        TraceUIManager.getTraceUIManager().notifyViewSelectionChangedListener(viewSelectionChangedEvent);
    }

    public void notifyProfileEventListener(ProfileEvent profileEvent) {
        TraceUIManager.getTraceUIManager().notifyProfileEventListener(profileEvent);
    }

    public void removeDeleteListener(IDeleteListener iDeleteListener) {
        TraceUIManager.getTraceUIManager().removeDeleteListener(iDeleteListener);
    }

    public void removeViewSelectionChangedListener(IViewSelectionChangedListener iViewSelectionChangedListener) {
        TraceUIManager.getTraceUIManager().removeViewSelectionChangedListener(iViewSelectionChangedListener);
    }

    public void removeSelectionModel(EObject eObject) {
        TraceUIManager.getTraceUIManager().removeSelectionModel(eObject);
    }

    public String getName() {
        return UIPlugin.getPluginId();
    }
}

