/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.DeleteAction;
import org.eclipse.hyades.trace.ui.internal.actions.OpenWizardAction;
import org.eclipse.hyades.trace.ui.internal.actions.RefreshFromLocalAction;
import org.eclipse.hyades.trace.ui.internal.actions.RefreshTreeAction;
import org.eclipse.hyades.trace.ui.internal.actions.SaveAction;
import org.eclipse.hyades.trace.ui.internal.actions.ToggleLinkingAction;
import org.eclipse.hyades.trace.ui.internal.core.TraceAssociationManager;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.IAssociationMappingRegistry;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.ExportResourcesAction;
import org.eclipse.ui.actions.ImportResourcesAction;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TraceLogActionGroup
extends NavigatorActionGroup {
    protected DeleteAction fDeleteAction;
    protected OpenWizardAction fOpenLogAgentAction;
    protected OpenWizardAction fOpenNodeAction;
    protected SaveAction fSaveToFile;
    protected ToggleLinkingAction toggleLinkingAction;
    protected RefreshTreeAction fRefreshTree;
    protected RefreshFromLocalAction fRefreshLocal;
    protected Separator fRefreshGrp;
    protected ActionGroup fImportActionGroup;
    protected Separator fAttachGrp;
    protected Separator fMonitorGrp;
    protected Separator fTerminateGrp;
    protected Separator fNewSnapshotGrp;
    protected Separator fGCGroup;
    protected final String GROUP_ADD_VIEWS = "group.add.views";
    protected final String GROUP_DELETE = "group.delete";
    protected final String GROUP_OPEN = "group.open";
    protected final String GROUP_SAVE = "group.save";
    protected final String GROUP_OPEN_PROPERTY = "group.open.property";
    protected final String GROUP_REFRESH = "group.refresh";
    protected Map traceViewsMap;
    static /* synthetic */ Class class$org$eclipse$hyades$trace$ui$internal$wizard$OpenLogAgentWizard;
    static /* synthetic */ Class class$org$eclipse$hyades$trace$ui$internal$wizard$OpenNodeWizard;

    public TraceLogActionGroup(INavigator iNavigator) {
        super(iNavigator);
    }

    protected void createActions() {
        this.traceViewsMap = new HashMap();
        this.toggleLinkingAction = new ToggleLinkingAction(this.getNavigator(), UIPlugin.getResourceString("STR_LINK_VIEW"));
        this.toggleLinkingAction.setToolTipText(UIPlugin.getResourceString("STR_LINK_VIEW_TIP"));
        this.toggleLinkingAction.setImageDescriptor(this.getImageDescriptor("elcl16/synced.gif"));
        this.toggleLinkingAction.setHoverImageDescriptor(this.getImageDescriptor("clcl16/synced.gif"));
        this.fImportActionGroup = new ImportActionGroup(this.getNavigator());
        this.fNewSnapshotGrp = new Separator("newSnapshotGroup");
        this.fGCGroup = new Separator("gcGroup");
        this.fRefreshGrp = new Separator("refreshGroup");
        this.fAttachGrp = new Separator("attachGroup");
        this.fTerminateGrp = new Separator("terminateGroup");
        this.fRefreshTree = new RefreshTreeAction(this.getNavigator());
        this.fMonitorGrp = new Separator("monitoringGroup");
        this.fSaveToFile = new SaveAction(this.getNavigator());
        this.fRefreshLocal = new RefreshFromLocalAction(this.getNavigator());
        this.fOpenLogAgentAction = new OpenWizardAction(this.getNavigator(), class$org$eclipse$hyades$trace$ui$internal$wizard$OpenLogAgentWizard == null ? (class$org$eclipse$hyades$trace$ui$internal$wizard$OpenLogAgentWizard = TraceLogActionGroup.class$("org.eclipse.hyades.trace.ui.internal.wizard.OpenLogAgentWizard")) : class$org$eclipse$hyades$trace$ui$internal$wizard$OpenLogAgentWizard, UIPlugin.getResourceString("PROPERTIES"));
        this.fOpenNodeAction = new OpenWizardAction(this.getNavigator(), class$org$eclipse$hyades$trace$ui$internal$wizard$OpenNodeWizard == null ? (class$org$eclipse$hyades$trace$ui$internal$wizard$OpenNodeWizard = TraceLogActionGroup.class$("org.eclipse.hyades.trace.ui.internal.wizard.OpenNodeWizard")) : class$org$eclipse$hyades$trace$ui$internal$wizard$OpenNodeWizard, UIPlugin.getResourceString("PROPERTIES"));
        this.fDeleteAction = new DeleteAction(this.getNavigator());
    }

    public void dispose() {
        if (this.traceViewsMap != null) {
            this.traceViewsMap.clear();
            this.traceViewsMap = null;
        }
        if (this.fImportActionGroup != null) {
            this.fImportActionGroup.dispose();
            this.fImportActionGroup = null;
        }
        this.deleteSeparators();
        this.deleteActions();
        super.dispose();
    }

    private void deleteSeparators() {
        if (this.fAttachGrp != null) {
            this.fAttachGrp.dispose();
            this.fAttachGrp = null;
        }
        if (this.fRefreshGrp != null) {
            this.fRefreshGrp.dispose();
            this.fRefreshGrp = null;
        }
        if (this.fTerminateGrp != null) {
            this.fTerminateGrp.dispose();
            this.fTerminateGrp = null;
        }
        if (this.fMonitorGrp != null) {
            this.fMonitorGrp.dispose();
            this.fMonitorGrp = null;
        }
        if (this.fNewSnapshotGrp != null) {
            this.fNewSnapshotGrp.dispose();
            this.fNewSnapshotGrp = null;
        }
        if (this.fGCGroup != null) {
            this.fGCGroup.dispose();
            this.fGCGroup = null;
        }
    }

    private void deleteActions() {
        if (this.fSaveToFile != null) {
            this.fSaveToFile.dispose();
            this.fSaveToFile = null;
        }
        if (this.fDeleteAction != null) {
            this.fDeleteAction.dispose();
            this.fDeleteAction = null;
        }
        if (this.fOpenLogAgentAction != null) {
            this.fOpenLogAgentAction.dispose();
            this.fOpenLogAgentAction = null;
        }
        if (this.fOpenNodeAction != null) {
            this.fOpenNodeAction.dispose();
            this.fOpenNodeAction = null;
        }
        if (this.fRefreshLocal != null) {
            this.fRefreshLocal.dispose();
            this.fRefreshLocal = null;
        }
        if (this.fRefreshTree != null) {
            this.fRefreshTree.dispose();
            this.fRefreshTree = null;
        }
        if (this.toggleLinkingAction != null) {
            this.toggleLinkingAction.dispose();
            this.toggleLinkingAction = null;
        }
    }

    public void fillActionBars(IActionBars iActionBars) {
        IMenuManager iMenuManager = iActionBars.getMenuManager();
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.toggleLinkingAction);
        iActionBars.updateActionBars();
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.toggleLinkingAction);
    }

    protected boolean areSameClass(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection == null || iStructuredSelection.isEmpty()) {
            return true;
        }
        Class<?> clazz = iStructuredSelection.getFirstElement().getClass();
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            if (clazz.equals(iterator.next().getClass())) continue;
            return false;
        }
        return true;
    }

    protected ImageDescriptor getImageDescriptor(String string) {
        String string2 = "icons/full/";
        try {
            AbstractUIPlugin abstractUIPlugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
            URL uRL = abstractUIPlugin.getDescriptor().getInstallURL();
            URL uRL2 = new URL(uRL, string2 + string);
            return ImageDescriptor.createFromURL((URL)uRL2);
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public void handleDoubleClick(DoubleClickEvent doubleClickEvent) {
        IAction[] iActionArray;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)doubleClickEvent.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (object == null || !(object instanceof EObject)) {
            return;
        }
        if (object instanceof TRCAgentProxy && (iActionArray = this.getViewMappingForType(((TRCAgentProxy)object).getType())).length > 0 && iActionArray[0] != null) {
            iActionArray[0].run();
        }
    }

    protected IAction[] getViewMappingForType(String string) {
        Object v = this.traceViewsMap.get(string);
        if (v != null) {
            return (IAction[])v;
        }
        IAssociationMappingRegistry iAssociationMappingRegistry = TraceAssociationManager.getTraceViewMappingRegistry();
        IAssociationMapping iAssociationMapping = iAssociationMappingRegistry.getAssociationMapping("analyzerExtensions");
        if (iAssociationMapping == null) {
            IAction[] iActionArray = new IAction[]{};
            this.traceViewsMap.put(string, iActionArray);
            return iActionArray;
        }
        IAssociationDescriptor[] iAssociationDescriptorArray = iAssociationMapping.getAssociationDescriptors(string);
        IAction[] iActionArray = new IAction[iAssociationDescriptorArray.length];
        int n = 0;
        while (n < iAssociationDescriptorArray.length) {
            IAssociationDescriptor iAssociationDescriptor = iAssociationDescriptorArray[n];
            try {
                IAction iAction = (IAction)iAssociationDescriptor.createImplementationClassInstance();
                if (iAction != null) {
                    iAction.setText(iAssociationDescriptor.getName());
                    iAction.setImageDescriptor(iAssociationDescriptor.getImageDescriptor());
                    iActionArray[n] = iAction;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
        this.traceViewsMap.put(string, iActionArray);
        return iActionArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ImportActionGroup
    extends ActionGroup {
        private final String GROUP_IMPORT = "group.import";
        private ImportResourcesAction fImportAction;
        private ExportResourcesAction fExportAction;

        public ImportActionGroup(INavigator iNavigator) {
            IWorkbenchWindow iWorkbenchWindow = iNavigator.getSite().getWorkbenchWindow();
            this.fImportAction = new ImportResourcesAction(iWorkbenchWindow);
            this.fExportAction = new ExportResourcesAction(iWorkbenchWindow);
            PDPluginImages.setImageDescriptors((IAction)this.fImportAction, "lcl16", "import_wiz.gif");
            PDPluginImages.setImageDescriptors((IAction)this.fExportAction, "lcl16", "export_wiz.gif");
        }

        public void fillContextMenu(IMenuManager iMenuManager) {
            iMenuManager.appendToGroup("group.reorganize", (IContributionItem)new Separator("group.import"));
            iMenuManager.appendToGroup("group.import", (IAction)this.fImportAction);
            iMenuManager.appendToGroup("group.import", (IAction)this.fExportAction);
            super.fillContextMenu(iMenuManager);
        }
    }
}

