/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TraceOptionsUI
implements SelectionListener,
ModifyListener {
    private Button _enableProf;
    private Button _enableLog;
    private Button _enableInfoMsg;
    private Text _projectName;
    private Text _localPort;
    private PreferencePage _preferencePage;
    private Button _manualRefreshBtn;
    private Button _automaticRefreshBtn;
    private Text _refreshIntervalText;
    private Label _refreshLabel;

    public TraceOptionsUI(PreferencePage preferencePage) {
        this._preferencePage = preferencePage;
    }

    public TraceOptionsUI() {
    }

    public Composite createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 10;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)GridUtil.createFill());
        Group group = new Group(composite2, 0);
        group.setText(UIPlugin.getResourceString("PROF_LOG_GRP"));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._enableProf = new Button((Composite)group, 32);
        this._enableProf.setText(UIPlugin.getResourceString("ENABLE_PROFILE_TEXT"));
        GridData gridData = new GridData();
        this._enableProf.setLayoutData((Object)gridData);
        this._enableLog = new Button((Composite)group, 32);
        this._enableLog.setText(UIPlugin.getResourceString("ENABLE_LOGGING"));
        gridData = new GridData();
        this._enableLog.setLayoutData((Object)gridData);
        Group group2 = new Group(composite2, 0);
        group2.setText(UIPlugin.getResourceString("PROF_INFO_GRP"));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group2.setLayout((Layout)gridLayout);
        group2.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label label = new Label((Composite)group2, 0);
        label.setText(UIPlugin.getResourceString("TRACEOPTIONSUI_TEXT"));
        this._projectName = new Text((Composite)group2, 2048);
        gridData = GridUtil.createHorizontalFill();
        this._projectName.setLayoutData((Object)gridData);
        Label label2 = new Label((Composite)group2, 0);
        label2.setText(UIPlugin.getResourceString("RAC_LOCALHOST_PORT_TEXT"));
        this._localPort = new Text((Composite)group2, 2048);
        gridData = GridUtil.createHorizontalFill();
        this._localPort.setLayoutData((Object)gridData);
        this._localPort.addModifyListener((ModifyListener)this);
        this._enableInfoMsg = new Button((Composite)group2, 32);
        this._enableInfoMsg.setText(UIPlugin.getResourceString("SHOW_PROFILE_TIPS"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this._enableInfoMsg.setLayoutData((Object)gridData);
        Group group3 = new Group(composite2, 0);
        group3.setText(UIPlugin.getResourceString("REFRESH_V_GRP"));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group3.setLayout((Layout)gridLayout);
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 2;
        group3.setLayoutData((Object)gridData);
        this._manualRefreshBtn = new Button((Composite)group3, 16);
        this._manualRefreshBtn.setText(UIPlugin.getResourceString("MANUAL_REF"));
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 2;
        this._manualRefreshBtn.setLayoutData((Object)gridData);
        this._automaticRefreshBtn = new Button((Composite)group3, 16);
        this._automaticRefreshBtn.setText(UIPlugin.getResourceString("AUT_REF"));
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 2;
        this._automaticRefreshBtn.setLayoutData((Object)gridData);
        this._refreshLabel = new Label((Composite)group3, 0);
        gridData = new GridData();
        gridData.horizontalIndent = 20;
        this._refreshLabel.setLayoutData((Object)gridData);
        this._refreshLabel.setText(UIPlugin.getResourceString("REF_INTERVAL"));
        this._refreshIntervalText = new Text((Composite)group3, 2048);
        this._refreshIntervalText.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._enableProf.addSelectionListener((SelectionListener)this);
        this._manualRefreshBtn.addSelectionListener((SelectionListener)this);
        this._automaticRefreshBtn.addSelectionListener((SelectionListener)this);
        this.initializeValues();
        return composite2;
    }

    public boolean getLogOption() {
        return this._enableLog.getSelection();
    }

    public boolean getProfOption() {
        return this._enableProf.getSelection();
    }

    public boolean getInfoMsgOption() {
        return this._enableInfoMsg.getSelection();
    }

    public int getRefreshType() {
        return this._automaticRefreshBtn.getSelection() ? 1 : 0;
    }

    public int getRefreshInterval() {
        try {
            return Integer.parseInt(this._refreshIntervalText.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            return UIPlugin.getDefault().getPreferenceStore().getDefaultInt("refresh_int");
        }
    }

    public String getProjectName() {
        return this._projectName.getText().trim();
    }

    public String getLocalPortNumber() {
        return this._localPort.getText().trim();
    }

    private void initializeValues() {
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        this.setProfOption(iPreferenceStore.getBoolean("prof_option"));
        this.setLogOption(iPreferenceStore.getBoolean("log_option"));
        this.setProjectName(iPreferenceStore.getString("prj_name"));
        this.setLocalHostPort(iPreferenceStore.getString("localhost_port"));
        this.setInfoMsgOption(iPreferenceStore.getBoolean("profile_tips"));
        this.setRefreshType(iPreferenceStore.getInt("refresh_type"), iPreferenceStore.getInt("refresh_int"));
    }

    public void setLogOption(boolean bl) {
        this._enableLog.setSelection(bl);
    }

    public void setRefreshType(int n, int n2) {
        if (n == 1) {
            this._manualRefreshBtn.setSelection(false);
            this._automaticRefreshBtn.setSelection(true);
        } else {
            this._manualRefreshBtn.setSelection(true);
            this._automaticRefreshBtn.setSelection(false);
            this._refreshLabel.setEnabled(false);
            this._refreshIntervalText.setEnabled(false);
        }
        this._refreshIntervalText.setText(String.valueOf(n2));
    }

    public void setInfoMsgOption(boolean bl) {
        this._enableInfoMsg.setSelection(bl);
    }

    public void setProfOption(boolean bl) {
        this._enableProf.setSelection(bl);
    }

    public void setProjectName(String string) {
        this._projectName.setText(string);
    }

    public void setLocalHostPort(String string) {
        this._localPort.setText(string);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this._manualRefreshBtn || selectionEvent.widget == this._automaticRefreshBtn) {
            this._refreshLabel.setEnabled(this._automaticRefreshBtn.getSelection());
            this._refreshIntervalText.setEnabled(this._automaticRefreshBtn.getSelection());
        }
    }

    public void modifyText(ModifyEvent modifyEvent) {
        if (modifyEvent.widget == this._localPort) {
            try {
                if (this._localPort.getText().trim() == "") {
                    this._preferencePage.setErrorMessage(UIPlugin.getResourceString("RAC_EMPTY_PORT"));
                    return;
                }
                int n = Integer.parseInt(this._localPort.getText().trim());
                if (n < 0) {
                    this._preferencePage.setErrorMessage(UIPlugin.getResourceString("RAC_INVALID_PORT"));
                    this._localPort.setFocus();
                    return;
                }
                this._preferencePage.setErrorMessage(null);
            }
            catch (NumberFormatException numberFormatException) {
                if (this._preferencePage != null) {
                    this._preferencePage.setErrorMessage(UIPlugin.getResourceString("RAC_INVALID_PORT"));
                }
                this._localPort.setFocus();
            }
        }
    }
}

