/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileCollectionsUI;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.wizard.OpenProfAgentWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class OpenProfCollectionsPage
extends WizardPage {
    protected PDProjectExplorer fViewer;
    protected TraceProfileCollectionsUI _optionsUI;

    public OpenProfCollectionsPage(String string, PDProjectExplorer pDProjectExplorer) {
        super(string);
        this.setTitle(UIPlugin.getResourceString("PROF_LIMIT_TITLE"));
        this.setDescription(UIPlugin.getResourceString("PROF_LIMIT_DESC"));
        this.fViewer = pDProjectExplorer;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 5;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createFill();
        composite2.setLayoutData((Object)gridData);
        this._optionsUI = new TraceProfileCollectionsUI();
        this._optionsUI.createControl(composite2);
        this._optionsUI.setWizardPage(this);
        TRCAgentProxy tRCAgentProxy = ((OpenProfAgentWizard)this.getWizard()).getAgent();
        this.setControl((Control)composite2);
        this.populateData();
        this._optionsUI.enable(false);
        if (tRCAgentProxy == null || !tRCAgentProxy.isActive()) {
            this.setPageComplete(false);
            this._optionsUI.enable(false);
        }
        WorkbenchHelp.setHelp((Control)composite, (String)(UIPlugin.getPluginId() + ".opcp0000"));
    }

    public boolean finish(boolean bl) {
        TRCAgentProxy tRCAgentProxy = ((OpenProfAgentWizard)this.getWizard()).getAgent();
        if (tRCAgentProxy == null || !tRCAgentProxy.isActive()) {
            return true;
        }
        try {
            TRCConfiguration tRCConfiguration;
            HierarchyFactory hierarchyFactory;
            Object[] objectArray = tRCAgentProxy.getConfigurations().toArray();
            if (objectArray.length > 0) {
                this.setConfiguration((TRCConfiguration)objectArray[0]);
            } else {
                hierarchyFactory = UIPlugin.getDefault().getPerftraceFactory();
                tRCConfiguration = hierarchyFactory.createTRCConfiguration();
                tRCConfiguration.setAgentProxy(tRCAgentProxy);
                tRCAgentProxy.getConfigurations().add(tRCConfiguration);
                this.setConfiguration(tRCConfiguration);
            }
            if (bl && tRCAgentProxy.isActive() && tRCAgentProxy.isMonitored()) {
                hierarchyFactory = tRCAgentProxy.getProcessProxy();
                tRCConfiguration = hierarchyFactory.getNode();
                this.sendConfigurationToAgent(tRCAgentProxy, tRCConfiguration.getName(), hierarchyFactory.getPid());
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            concurrentModificationException.printStackTrace();
        }
        return true;
    }

    public boolean finish() {
        return this.finish(true);
    }

    private void sendConfigurationToAgent(TRCAgentProxy tRCAgentProxy, String string, int n) {
        Node node = PDCoreUtil.profileConnect(string, String.valueOf(tRCAgentProxy.getProcessProxy().getNode().getPort()));
        if (node == null) {
            return;
        }
        Process process = node.getProcess(String.valueOf(n));
        if (process != null) {
            try {
                Agent agent = process.getAgent(tRCAgentProxy.getName());
                PDCoreUtil.setAgentConfiguration(tRCAgentProxy, agent);
                if (agent != null && agent.isActive()) {
                    agent.publishConfiguration();
                    CustomCommand customCommand = new CustomCommand();
                    customCommand.setData("APPLYFILTERS");
                    agent.invokeCustomCommand(customCommand);
                }
            }
            catch (InactiveAgentException inactiveAgentException) {
                // empty catch block
            }
        }
    }

    protected void populateData() {
        TRCAgentProxy tRCAgentProxy = ((OpenProfAgentWizard)this.getWizard()).getAgent();
        if (tRCAgentProxy == null) {
            return;
        }
        EList eList = null;
        EList eList2 = tRCAgentProxy.getConfigurations();
        Iterator iterator = eList2.iterator();
        if (iterator.hasNext()) {
            TRCConfiguration tRCConfiguration = (TRCConfiguration)iterator.next();
            eList = tRCConfiguration.getOptions();
            this.updateConfigData(eList);
            return;
        }
        this.updateConfigData(eList);
    }

    protected void setConfiguration(TRCConfiguration tRCConfiguration) {
        try {
            Object[] objectArray = tRCConfiguration.getOptions().toArray();
            HierarchyFactory hierarchyFactory = UIPlugin.getDefault().getPerftraceFactory();
            if (this._optionsUI.getLimitInvocations()) {
                TRCOption tRCOption;
                TRCOption tRCOption2 = hierarchyFactory.createTRCOption();
                tRCOption2.setKey("BURST_MODE");
                if (this._optionsUI.getLimitTime()) {
                    tRCOption2.setValue("secondsAndInvocations");
                    tRCOption = hierarchyFactory.createTRCOption();
                    tRCOption.setKey("BURST_SECONDS");
                    tRCOption.setValue(String.valueOf(this._optionsUI.getLimitTimeNb()));
                    tRCOption.setConfiguration(tRCConfiguration);
                } else {
                    tRCOption2.setValue("invocations");
                }
                tRCOption2.setConfiguration(tRCConfiguration);
                tRCOption = hierarchyFactory.createTRCOption();
                tRCOption.setKey("BURST_INVOCATIONS");
                tRCOption.setValue(String.valueOf(this._optionsUI.getLimitInvocNb()));
                tRCOption.setConfiguration(tRCConfiguration);
            } else if (this._optionsUI.getLimitTime()) {
                TRCOption tRCOption = hierarchyFactory.createTRCOption();
                tRCOption.setKey("BURST_MODE");
                tRCOption.setKey("seconds");
                tRCOption.setConfiguration(tRCConfiguration);
                tRCOption = hierarchyFactory.createTRCOption();
                tRCOption.setKey("BURST_SECONDS");
                tRCOption.setValue(String.valueOf(this._optionsUI.getLimitTimeNb()));
                tRCOption.setConfiguration(tRCConfiguration);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            concurrentModificationException.printStackTrace();
        }
    }

    protected void updateConfigData(EList eList) {
        if (eList != null) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                TRCOption tRCOption = (TRCOption)iterator.next();
                if (tRCOption.getKey().equals("BURST_MODE")) {
                    if (tRCOption.getValue().equals("secondsAndInvocations")) {
                        this._optionsUI.setLimitInvocations(true);
                        this._optionsUI.setLimitTime(true);
                        continue;
                    }
                    if (tRCOption.getValue().equals("invocations")) {
                        this._optionsUI.setLimitInvocations(true);
                        this._optionsUI.setLimitTime(false);
                        continue;
                    }
                    if (!tRCOption.getValue().equals("seconds")) continue;
                    this._optionsUI.setLimitInvocations(false);
                    this._optionsUI.setLimitTime(true);
                    continue;
                }
                if (tRCOption.getKey().equals("BURST_INVOCATIONS")) {
                    this._optionsUI.setLimitInvocNb(tRCOption.getValue());
                    continue;
                }
                if (!tRCOption.getKey().equals("BURST_SECONDS")) continue;
                this._optionsUI.setLimitTimeNb(tRCOption.getValue());
            }
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            if (!((OpenProfAgentWizard)this.getWizard()).isProfilingAgent()) {
                this.getControl().setEnabled(false);
                this.getControl().setVisible(false);
                this.setDescription(UIPlugin.getResourceString("STR_LIMIT_IGNORED"));
            } else {
                this.getControl().setEnabled(true);
                this.getControl().setVisible(true);
                this.setDescription(UIPlugin.getResourceString("PROF_LIMIT_DESC"));
            }
        }
    }
}

