/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserFactory;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttribute;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleElement;
import org.eclipse.hyades.logging.adapter.model.internal.parser.SubstitutionRuleType;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTerm;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.util.XSDResourceImpl;

public final class AcadEditorPlugin
extends EMFPlugin {
    private static final String extensionPointID = "cbeSchema";
    public static final String cbeName = "CommonBaseEvent";
    protected String identifier;
    public static final AcadEditorPlugin INSTANCE = new AcadEditorPlugin();
    private static Implementation plugin;
    private HashMap elementMap;
    private HashMap inheritedTypesMap;
    private XSDSchema schema;

    public AcadEditorPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public HashMap getCBEElements() {
        if (this.elementMap == null) {
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                public void run() {
                    AcadEditorPlugin.this.loadCBEPackageInfo();
                }
            });
        }
        return this.elementMap;
    }

    public void loadCBEPackageInfo() {
        XSDSchema xSDSchema = this.getCBESchema();
        this.elementMap = new HashMap();
        this.inheritedTypesMap = new HashMap();
        if (xSDSchema == null) {
            String string = AcadEditorPlugin.getPlugin().getString("STR_SCHEMA_ERROR");
            Status status = new Status(2, "org.eclipse.core.resources", 566, string, null);
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)AcadEditorPlugin.getPlugin().getString("STR_AD_MSG_TITLE"), (String)"", (IStatus)status);
            return;
        }
        EList eList = xSDSchema.getElementDeclarations();
        int n = 0;
        while (n < eList.size()) {
            XSDElementDeclaration xSDElementDeclaration = (XSDElementDeclaration)eList.get(n);
            this.elementMap.put(xSDElementDeclaration.getName(), xSDElementDeclaration);
            ++n;
        }
        eList = xSDSchema.getTypeDefinitions();
        int n2 = 0;
        while (n2 < eList.size()) {
            XSDTypeDefinition xSDTypeDefinition;
            XSDTypeDefinition xSDTypeDefinition2 = (XSDTypeDefinition)eList.get(n2);
            Object v = this.inheritedTypesMap.get(xSDTypeDefinition2);
            if (v == null) {
                this.inheritedTypesMap.put(xSDTypeDefinition2, new ArrayList());
            }
            if ((xSDTypeDefinition = xSDTypeDefinition2.getBaseType()) != null) {
                v = this.inheritedTypesMap.get(xSDTypeDefinition);
                if (v == null) {
                    ArrayList<XSDTypeDefinition> arrayList = new ArrayList<XSDTypeDefinition>();
                    arrayList.add(xSDTypeDefinition2);
                    this.inheritedTypesMap.put(xSDTypeDefinition, arrayList);
                } else {
                    ((ArrayList)v).add(xSDTypeDefinition2);
                }
            }
            ++n2;
        }
    }

    protected XSDSchema getCBESchema() {
        if (this.schema != null) {
            return this.schema;
        }
        IExtensionPoint iExtensionPoint = AcadEditorPlugin.getPlugin().getDescriptor().getExtensionPoint(extensionPointID);
        if (iExtensionPoint != null) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
                String string = iConfigurationElement.getAttribute("name");
                if (string == null || string.length() == 0) {
                    return null;
                }
                ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
                URI uRI = URI.createURI((String)(AcadEditorPlugin.getPlugin().getDescriptor().getInstallURL().toString() + string));
                XSDResourceImpl xSDResourceImpl = (XSDResourceImpl)resourceSetImpl.getResource(uRI, true);
                Iterator iterator = resourceSetImpl.getResources().iterator();
                while (iterator.hasNext()) {
                    Resource resource = (Resource)iterator.next();
                    if (!(resource instanceof XSDResourceImpl)) continue;
                    XSDResourceImpl xSDResourceImpl2 = (XSDResourceImpl)resource;
                    this.schema = xSDResourceImpl2.getSchema();
                    return this.schema;
                }
                ++n;
            }
        }
        return null;
    }

    public Object getElementDefinitionForType(RuleElement ruleElement) {
        String string = ruleElement.getName();
        if (string == null) {
            return null;
        }
        Object object = INSTANCE.getCBEElements().get(string);
        if (object != null) {
            return object;
        }
        EObject eObject = ruleElement.eContainer();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (eObject != null && eObject instanceof RuleElement && object == null) {
            object = INSTANCE.getCBEElements().get(((RuleElement)eObject).getName());
            if (object == null) {
                String string2 = ((RuleElement)eObject).getName();
                arrayList.add(string2);
            }
            eObject = ((RuleElement)eObject).eContainer();
        }
        if (object == null) {
            return null;
        }
        int n = arrayList.size() - 1;
        while (n >= 0) {
            if ((object = INSTANCE.getElementDefinitionFromType(((XSDElementDeclaration)object).getType(), arrayList.get(n).toString())) == null) break;
            --n;
        }
        if (object != null && object instanceof XSDElementDeclaration) {
            return this.getElementDefinitionFromType(((XSDElementDeclaration)object).getTypeDefinition(), string);
        }
        if (object instanceof XSDTypeDefinition) {
            return this.getElementDefinitionFromType((XSDTypeDefinition)object, string);
        }
        return null;
    }

    public Object getElementDefinitionFromType(XSDTypeDefinition xSDTypeDefinition, String string) {
        if (xSDTypeDefinition == null || string == null) {
            return null;
        }
        if (xSDTypeDefinition instanceof XSDComplexTypeDefinition) {
            XSDTypeDefinition xSDTypeDefinition2;
            ArrayList arrayList;
            Object object;
            XSDComplexTypeDefinition xSDComplexTypeDefinition = (XSDComplexTypeDefinition)xSDTypeDefinition;
            if (xSDComplexTypeDefinition.isAbstract() && (object = this.getInheritedTypes((XSDTypeDefinition)xSDComplexTypeDefinition)) != null) {
                arrayList = (ArrayList)object;
                int n = 0;
                while (n < arrayList.size()) {
                    xSDTypeDefinition2 = (XSDTypeDefinition)arrayList.get(n);
                    if (xSDTypeDefinition2.getName().equals(string)) {
                        return xSDTypeDefinition2;
                    }
                    ++n;
                }
            }
            if ((object = xSDComplexTypeDefinition.getContentType()) != null && object instanceof XSDParticle && (arrayList = ((XSDParticle)object).getContent()) instanceof XSDModelGroup) {
                XSDModelGroup xSDModelGroup = (XSDModelGroup)arrayList;
                xSDTypeDefinition2 = xSDModelGroup.getContents();
                int n = 0;
                while (n < xSDTypeDefinition2.size()) {
                    XSDElementDeclaration xSDElementDeclaration;
                    XSDParticle xSDParticle = (XSDParticle)xSDTypeDefinition2.get(n);
                    XSDTerm xSDTerm = xSDParticle.getTerm();
                    if (xSDTerm instanceof XSDElementDeclaration) {
                        xSDElementDeclaration = (XSDElementDeclaration)xSDTerm;
                        if (xSDElementDeclaration.getName().equals(string)) {
                            return xSDElementDeclaration;
                        }
                    } else if (xSDTerm instanceof XSDModelGroup) {
                        xSDElementDeclaration = ((XSDModelGroup)xSDTerm).getContents();
                        int n2 = 0;
                        while (n2 < xSDElementDeclaration.size()) {
                            XSDElementDeclaration xSDElementDeclaration2;
                            XSDTerm xSDTerm2 = ((XSDParticle)xSDElementDeclaration.get(n2)).getTerm();
                            if (xSDTerm2 instanceof XSDElementDeclaration && (xSDElementDeclaration2 = (XSDElementDeclaration)xSDTerm2).getName().equals(string)) {
                                return xSDElementDeclaration2;
                            }
                            ++n2;
                        }
                    } else if (xSDTerm instanceof XSDWildcard && (xSDElementDeclaration = (XSDWildcard)xSDTerm).getStringLexicalNamespaceConstraint().equals(string)) {
                        return xSDElementDeclaration;
                    }
                    ++n;
                }
            }
        }
        return null;
    }

    public Object getInheritedTypes(XSDTypeDefinition xSDTypeDefinition) {
        if (this.inheritedTypesMap == null) {
            return null;
        }
        return this.inheritedTypesMap.get(xSDTypeDefinition);
    }

    public Object getTypeFromName(String string) {
        if (this.inheritedTypesMap == null) {
            return null;
        }
        Iterator iterator = this.inheritedTypesMap.keySet().iterator();
        while (iterator.hasNext()) {
            XSDTypeDefinition xSDTypeDefinition = (XSDTypeDefinition)iterator.next();
            if (!xSDTypeDefinition.getName().equals(string)) continue;
            return xSDTypeDefinition;
        }
        return null;
    }

    public static AcadEditorPlugin getDefault() {
        return INSTANCE;
    }

    public void logMessage(IStatus iStatus, boolean bl) {
        plugin.getLog().log(iStatus);
        if (bl) {
            ErrorDialog.openError((Shell)this.getActiveWorkbenchWindow().getShell(), (String)"Generic Adaptor Message", null, (IStatus)iStatus, (int)4);
        }
    }

    public void logMessage(IStatus iStatus) {
        this.logMessage(iStatus, false);
    }

    public void log(Object object) {
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            Status status = new Status(4, this.getPluginId(), 0, throwable.getLocalizedMessage(), null);
            this.logMessage((IStatus)status, true);
        } else {
            Status status = new Status(4, this.getPluginId(), 0, object.toString(), null);
            this.logMessage((IStatus)status, true);
        }
    }

    public IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public IWorkbenchPage getActivePage() {
        IWorkbenchWindow iWorkbenchWindow = this.getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage iWorkbenchPage = this.getActiveWorkbenchWindow().getActivePage();
        if (iWorkbenchPage == null || !iWorkbenchPage.getPerspective().getId().equals("org.eclipse.hyades.logging.adapter.ui.perspective")) {
            IWorkbenchWindow iWorkbenchWindow2 = this.getActiveWorkbenchWindow();
            iWorkbenchPage = null;
            try {
                IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindow2.getPages();
                int n = 0;
                while (n < iWorkbenchPageArray.length) {
                    if (iWorkbenchPageArray[n].getPerspective().getId().equals("org.eclipse.hyades.logging.adapter.ui.perspective")) {
                        iWorkbenchPage = iWorkbenchPageArray[n];
                        iWorkbenchWindow2.setActivePage(iWorkbenchPage);
                        break;
                    }
                    ++n;
                }
                if (iWorkbenchPage == null) {
                    IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    IWorkbench iWorkbench = iWorkbenchWindow2.getWorkbench();
                    if (iWorkbench != null && iWorkspaceRoot != null) {
                        iWorkbenchPage = iWorkbench.showPerspective("org.eclipse.hyades.logging.adapter.ui.perspective", this.getActiveWorkbenchWindow(), (IAdaptable)iWorkspaceRoot);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return iWorkbenchPage;
    }

    public String getPluginId() {
        if (this.identifier == null) {
            this.identifier = plugin.getDescriptor().getUniqueIdentifier();
        }
        return this.identifier;
    }

    public void createRequiredAttributes(RuleElement ruleElement, XSDTypeDefinition xSDTypeDefinition) {
        if (xSDTypeDefinition instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition xSDComplexTypeDefinition = (XSDComplexTypeDefinition)xSDTypeDefinition;
            EList eList = xSDComplexTypeDefinition.getAttributeUses();
            int n = 0;
            while (n < eList.size()) {
                XSDAttributeUse xSDAttributeUse = (XSDAttributeUse)eList.get(n);
                if (xSDAttributeUse.isRequired()) {
                    RuleAttribute ruleAttribute = ParserFactory.eINSTANCE.createRuleAttribute();
                    ruleAttribute.setUsePreviousMatchSubstitutionAsDefault(true);
                    ruleAttribute.setUsePreviousMatchSubstitutionAsDefault(false);
                    ruleAttribute.setName(xSDAttributeUse.getAttributeDeclaration().getName());
                    ruleElement.getRuleAttribute().add(ruleAttribute);
                    SubstitutionRuleType substitutionRuleType = ParserFactory.eINSTANCE.createSubstitutionRuleType();
                    substitutionRuleType.setMatch("^(.*)");
                    substitutionRuleType.setSubstitute("replace with our message text");
                    substitutionRuleType.setUseBuiltInFunction(true);
                    substitutionRuleType.setUseBuiltInFunction(false);
                    ruleAttribute.getSubstitutionRule().add(substitutionRuleType);
                }
                ++n;
            }
        }
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public Implementation(IPluginDescriptor iPluginDescriptor) {
            super(iPluginDescriptor);
            plugin = this;
        }
    }
}

