/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.hyades.logging.adapter.ui.internal.actions.CopyAction;
import org.eclipse.hyades.logging.adapter.ui.internal.actions.CutAction;
import org.eclipse.hyades.logging.adapter.ui.internal.actions.EditAction;
import org.eclipse.hyades.logging.adapter.ui.internal.actions.PasteAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.PartSite;

public class ActionHandlerListener
implements IPartListener,
MenuListener {
    public static final ActionHandlerListener DEFAULT = new ActionHandlerListener();
    private List workbenchWindows = new ArrayList();
    private List registeredParts = new ArrayList();
    private EditAction cut;
    private EditAction copy;
    private EditAction paste;

    public ActionHandlerListener() {
        this.createEditActions();
    }

    protected void createEditActions() {
        this.cut = new CutAction();
        this.copy = new CopyAction();
        this.paste = new PasteAction();
    }

    protected void listenToWorkbenchWindow(IWorkbenchWindow iWorkbenchWindow) {
        if (!this.workbenchWindows.contains(iWorkbenchWindow)) {
            this.workbenchWindows.add(iWorkbenchWindow);
            iWorkbenchWindow.getPartService().addPartListener((IPartListener)this);
            MenuManager menuManager = (MenuManager)((ApplicationWindow)iWorkbenchWindow).getMenuBarManager().findMenuUsingPath("edit");
            if (menuManager != null) {
                menuManager.getMenu().addMenuListener((MenuListener)this);
            }
            if ((menuManager = (MenuManager)((ApplicationWindow)iWorkbenchWindow).getMenuBarManager().findMenuUsingPath("file")) != null) {
                menuManager.getMenu().addMenuListener((MenuListener)this);
            }
        }
    }

    protected IActionBars getActionBars(IWorkbenchPart iWorkbenchPart) {
        IWorkbenchPartSite iWorkbenchPartSite;
        IActionBars iActionBars = null;
        if (iWorkbenchPart != null && (iWorkbenchPartSite = iWorkbenchPart.getSite()) instanceof PartSite) {
            iActionBars = ((PartSite)iWorkbenchPartSite).getActionBars();
        }
        return iActionBars;
    }

    public void connectPart(IWorkbenchPart iWorkbenchPart) {
        IWorkbenchWindow iWorkbenchWindow = iWorkbenchPart.getSite().getWorkbenchWindow();
        this.listenToWorkbenchWindow(iWorkbenchWindow);
        this.registerPartId(iWorkbenchPart);
        this.connectCutCopyPasteActions(iWorkbenchPart);
    }

    protected boolean isRegisteredPart(IWorkbenchPart iWorkbenchPart) {
        String string = iWorkbenchPart.getSite().getId();
        return this.registeredParts.contains(string);
    }

    protected void registerPartId(IWorkbenchPart iWorkbenchPart) {
        if (!this.isRegisteredPart(iWorkbenchPart)) {
            String string = iWorkbenchPart.getSite().getId();
            this.registeredParts.add(string);
        }
    }

    protected void connectCutCopyPasteActions(IWorkbenchPart iWorkbenchPart) {
        IActionBars iActionBars = this.getActionBars(iWorkbenchPart);
        if (iActionBars != null) {
            iWorkbenchPart.getSite().getKeyBindingService().registerAction((IAction)this.cut);
            iWorkbenchPart.getSite().getKeyBindingService().registerAction((IAction)this.copy);
            iWorkbenchPart.getSite().getKeyBindingService().registerAction((IAction)this.paste);
            this.connectCutCopyPasteActions(iActionBars);
        }
    }

    protected void connectCutCopyPasteActions(IActionBars iActionBars) {
        if (iActionBars.getGlobalActionHandler("cut") == null) {
            iActionBars.setGlobalActionHandler("cut", (IAction)this.cut);
        }
        if (iActionBars.getGlobalActionHandler("copy") == null) {
            iActionBars.setGlobalActionHandler("copy", (IAction)this.copy);
        }
        if (iActionBars.getGlobalActionHandler("paste") == null) {
            iActionBars.setGlobalActionHandler("paste", (IAction)this.paste);
        }
        this.enableActions();
        iActionBars.updateActionBars();
    }

    protected IWorkbenchPart getWorkbenchPart() {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage == null) {
            return null;
        }
        return iWorkbenchPage.getActivePart();
    }

    protected void updateActions() {
        IWorkbenchPart iWorkbenchPart = this.getWorkbenchPart();
        if (iWorkbenchPart != null && this.isRegisteredPart(iWorkbenchPart)) {
            IActionBars iActionBars = this.getActionBars(iWorkbenchPart);
            Control control = this.cut.getFocusControl();
            if (this.isValidFocusControl() && iActionBars != null) {
                String string = this.paste.getClipboardText();
                String string2 = this.copy.getSelectionText();
                boolean bl = this.paste.isReadOnlyFocusControl();
                boolean bl2 = string != null && !string.equals("");
                boolean bl3 = string2 != null && !string2.equals("");
                this.cut.setEnabled(!bl && bl3);
                this.copy.setEnabled(bl3 && (!(control instanceof Combo) || !bl));
                this.paste.setEnabled(!bl && bl2);
            } else {
                this.cut.setEnabled(false);
                this.copy.setEnabled(false);
                this.paste.setEnabled(false);
            }
            iActionBars.updateActionBars();
        }
    }

    protected boolean isValidFocusControl() {
        return this.cut.isValidFocusControl();
    }

    protected void enableActions() {
        this.cut.setEnabled(true);
        this.copy.setEnabled(true);
        this.paste.setEnabled(true);
    }

    public void partActivated(IWorkbenchPart iWorkbenchPart) {
        if (this.isRegisteredPart(iWorkbenchPart)) {
            this.connectCutCopyPasteActions(iWorkbenchPart);
        }
    }

    public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
    }

    public void partClosed(IWorkbenchPart iWorkbenchPart) {
    }

    public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
    }

    public void partOpened(IWorkbenchPart iWorkbenchPart) {
    }

    public void menuHidden(MenuEvent menuEvent) {
        IWorkbenchPart iWorkbenchPart = this.getWorkbenchPart();
        if (iWorkbenchPart != null && this.isRegisteredPart(iWorkbenchPart)) {
            this.enableActions();
            IActionBars iActionBars = this.getActionBars(iWorkbenchPart);
            iActionBars.updateActionBars();
        }
    }

    public void menuShown(MenuEvent menuEvent) {
        this.updateActions();
    }
}

