/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.presentation;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttribute;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleElement;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleElementType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;

public class AdaptorActionBarContributor
extends EditingDomainActionBarContributor
implements ISelectionChangedListener {
    protected IEditorPart activeEditorPart;
    protected ISelectionProvider selectionProvider;
    protected Collection createChildActions;
    protected IMenuManager createChildMenuManager;

    public void contributeToToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IContributionItem)new Separator("adaptor-settings"));
        iToolBarManager.add((IContributionItem)new Separator("adaptor-additions"));
    }

    public void contributeToMenu(IMenuManager iMenuManager) {
        super.contributeToMenu(iMenuManager);
        MenuManager menuManager = new MenuManager(AcadEditorPlugin.INSTANCE.getString("_UI_AdaptorEditor_menu"), "org.eclipse.hyades.acad.model.internal.adaptorMenuID");
        iMenuManager.insertAfter("additions", (IContributionItem)menuManager);
        menuManager.add((IContributionItem)new Separator("settings"));
        menuManager.add((IContributionItem)new Separator("actions"));
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator("additions-end"));
        this.createChildMenuManager = new MenuManager(AcadEditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
        menuManager.insertBefore("additions", (IContributionItem)this.createChildMenuManager);
    }

    public void setActiveEditor(IEditorPart iEditorPart) {
        super.setActiveEditor(iEditorPart);
        this.activeEditorPart = iEditorPart;
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (iEditorPart == null) {
            this.selectionProvider = null;
        } else {
            this.selectionProvider = iEditorPart.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        if (this.createChildMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
        }
        Collection collection = null;
        ISelection iSelection = selectionChangedEvent.getSelection();
        if (iSelection instanceof IStructuredSelection && ((IStructuredSelection)iSelection).size() == 1) {
            Object object = ((IStructuredSelection)iSelection).getFirstElement();
            EditingDomain editingDomain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
            collection = editingDomain.getNewChildDescriptors(object, null);
        }
        this.createChildActions = this.generateCreateChildActions(collection, iSelection);
        if (this.createChildMenuManager != null) {
            this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
            this.createChildMenuManager.update(true);
        }
    }

    protected Collection generateCreateChildActions(Collection collection, ISelection iSelection) {
        LinkedList<CreateChildAction> linkedList = new LinkedList<CreateChildAction>();
        Object object = ((IStructuredSelection)iSelection).getFirstElement();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            block0: while (iterator.hasNext()) {
                Object object2;
                CommandParameter commandParameter = (CommandParameter)iterator.next();
                CreateChildAction createChildAction = new CreateChildAction(this.activeEditorPart, iSelection, (Object)commandParameter);
                linkedList.add(createChildAction);
                if (object instanceof ParserConfigType) {
                    object2 = commandParameter.getValue();
                    createChildAction.setText(((RuleElement)object2).getName());
                    EList eList = ((ParserConfigType)object).getRuleElement();
                    int n = 0;
                    while (n < eList.size()) {
                        RuleElementType ruleElementType = (RuleElementType)eList.get(n);
                        if (ruleElementType.getName() != null && ruleElementType.getName().equals(createChildAction.getText())) {
                            createChildAction.setEnabled(false);
                            continue block0;
                        }
                        ++n;
                    }
                    continue;
                }
                if (!(object instanceof RuleElement)) continue;
                object2 = commandParameter.getValue();
                if (object2 != null && object2 instanceof RuleAttribute) {
                    createChildAction.setText(((RuleAttribute)object2).getName());
                    this.enableAttributeAction((Action)createChildAction, (RuleElement)object);
                }
                if (object2 == null || !(object2 instanceof RuleElement)) continue;
                createChildAction.setText(((RuleElement)object2).getName());
                this.enableElementAction((Action)createChildAction, (RuleElement)object);
            }
        }
        return linkedList;
    }

    protected void populateManager(IContributionManager iContributionManager, Collection collection, String string) {
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                IAction iAction = (IAction)iterator.next();
                if (string != null) {
                    iContributionManager.insertBefore(string, iAction);
                    continue;
                }
                iContributionManager.add(iAction);
            }
        }
    }

    protected void depopulateManager(IContributionManager iContributionManager, Collection collection) {
        if (collection != null) {
            IContributionItem[] iContributionItemArray = iContributionManager.getItems();
            int n = 0;
            while (n < iContributionItemArray.length) {
                IAction iAction;
                IContributionItem iContributionItem = iContributionItemArray[n];
                while (iContributionItem instanceof SubContributionItem) {
                    iContributionItem = ((SubContributionItem)iContributionItem).getInnerItem();
                }
                if (iContributionItem instanceof ActionContributionItem && collection.contains(iAction = ((ActionContributionItem)iContributionItem).getAction())) {
                    iContributionManager.remove(iContributionItem);
                }
                ++n;
            }
        }
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        super.menuAboutToShow(iMenuManager);
        MenuManager menuManager = null;
        menuManager = new MenuManager("Add");
        this.populateManager((IContributionManager)menuManager, this.createChildActions, null);
        iMenuManager.insertBefore("additions", (IContributionItem)menuManager);
    }

    protected void enableAttributeAction(Action action, RuleElement ruleElement) {
        String string = action.getText();
        if (string == null) {
            return;
        }
        Object object = AcadEditorPlugin.INSTANCE.getElementDefinitionForType(ruleElement);
        if (object == null) {
            return;
        }
        XSDTypeDefinition xSDTypeDefinition = null;
        if (object instanceof XSDTypeDefinition) {
            xSDTypeDefinition = (XSDTypeDefinition)object;
        } else if (object instanceof XSDElementDeclaration) {
            xSDTypeDefinition = ((XSDElementDeclaration)object).getTypeDefinition();
        }
        if (xSDTypeDefinition == null || xSDTypeDefinition instanceof XSDSimpleTypeDefinition) {
            return;
        }
        EList eList = ruleElement.getRuleAttribute();
        int n = 0;
        while (n < eList.size()) {
            if (string.equals(((RuleAttribute)eList.get(n)).getName())) {
                action.setEnabled(false);
                return;
            }
            ++n;
        }
        action.setEnabled(true);
    }

    protected void enableElementAction(Action action, RuleElement ruleElement) {
        block8: {
            String string;
            block7: {
                string = action.getText();
                String string2 = ruleElement.getName();
                Object object = AcadEditorPlugin.INSTANCE.getElementDefinitionForType(ruleElement);
                if (object == null || !(object instanceof XSDElementDeclaration)) break block7;
                Object object2 = AcadEditorPlugin.INSTANCE.getElementDefinitionFromType(((XSDElementDeclaration)object).getType(), string);
                if (object2 == null || !(object2 instanceof XSDElementDeclaration)) {
                    EList eList = ruleElement.getRuleElement();
                    int n = 0;
                    while (n < eList.size()) {
                        RuleElement ruleElement2 = (RuleElement)eList.get(n);
                        if (string.equals(ruleElement2.getName())) {
                            action.setEnabled(false);
                        }
                        ++n;
                    }
                    return;
                }
                String string3 = ((XSDElementDeclaration)object2).getElement().getAttribute("maxOccurs");
                if (string3 == null || !string3.equals("1")) break block8;
                EList eList = ruleElement.getRuleElement();
                int n = 0;
                while (n < eList.size()) {
                    RuleElement ruleElement3 = (RuleElement)eList.get(n);
                    if (string.equals(ruleElement3.getName())) {
                        action.setEnabled(false);
                    }
                    ++n;
                }
                break block8;
            }
            EList eList = ruleElement.getRuleElement();
            int n = 0;
            while (n < eList.size()) {
                RuleElement ruleElement4 = (RuleElement)eList.get(n);
                if (string.equals(ruleElement4.getName())) {
                    action.setEnabled(false);
                }
                ++n;
            }
        }
    }

    protected void enableComplexType(Action action, XSDComplexTypeDefinition xSDComplexTypeDefinition, RuleElement ruleElement) {
        String string = action.getText();
        String string2 = xSDComplexTypeDefinition.getElement().getAttribute("maxOccurs");
        if (string2 != null && string2.equals("1")) {
            EList eList = ruleElement.getRuleElement();
            int n = 0;
            while (n < eList.size()) {
                RuleElement ruleElement2 = (RuleElement)eList.get(n);
                if (string.equals(ruleElement2.getName())) {
                    action.setEnabled(false);
                    return;
                }
                ++n;
            }
        }
        action.setEnabled(true);
    }
}

