/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.configuration.ConfigurationItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.configuration.ContextInstanceTypeItemProvider;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.hyades.logging.adapter.ui.internal.util.IDetails;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleBuilderWidgetFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ContextInstanceSection
extends Composite
implements IDetails,
ModifyListener,
INotifyChangedListener,
SelectionListener {
    protected Text descriptionText;
    protected Button continousBtn;
    protected Text idleText;
    protected Text pauseText;
    protected Label uniqueId;
    protected boolean isDisplaying;
    protected ContextInstanceType currentSelection;
    protected ContextInstanceTypeItemProvider itemProvider;
    protected ConfigurationItemProviderAdapterFactory itemFactory = new ConfigurationItemProviderAdapterFactory();

    public ContextInstanceSection(RuleBuilderWidgetFactory ruleBuilderWidgetFactory, Composite composite, int n) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 5;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(GridUtil.createFill());
        Label label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTI_DESCR"), 0);
        this.descriptionText = ruleBuilderWidgetFactory.createText(this, "", 2);
        this.descriptionText.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTI_ID"), 0);
        this.uniqueId = ruleBuilderWidgetFactory.createLabel(this, "");
        this.uniqueId.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, "", 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.continousBtn = ruleBuilderWidgetFactory.createButton(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTI_CONT"), 32);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.continousBtn.setLayoutData((Object)gridData);
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTI_TIME"), 0);
        this.idleText = ruleBuilderWidgetFactory.createText(this, "", 0);
        this.idleText.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTI_PAUSEI"), 0);
        this.pauseText = ruleBuilderWidgetFactory.createText(this, "", 0);
        this.pauseText.setLayoutData((Object)new GridData(768));
        this.descriptionText.addModifyListener((ModifyListener)this);
        this.idleText.addModifyListener((ModifyListener)this);
        this.pauseText.addModifyListener((ModifyListener)this);
        this.continousBtn.addSelectionListener((SelectionListener)this);
        this.itemProvider = (ContextInstanceTypeItemProvider)this.itemFactory.createContextInstanceTypeAdapter();
        this.itemProvider.addListener(this);
    }

    public void display(EObject eObject) {
        if (eObject != null) {
            AcadGuiModelManager.setCurrentModel((ContextInstanceType)eObject);
        }
        if (this.currentSelection == eObject) {
            return;
        }
        if (this.descriptionText.isFocusControl() || this.uniqueId.isFocusControl() || this.idleText.isFocusControl() || this.pauseText.isFocusControl() || this.continousBtn.isFocusControl()) {
            return;
        }
        this.currentSelection = (ContextInstanceType)eObject;
        this.isDisplaying = true;
        this.descriptionText.setText(this.currentSelection.getDescription() == null ? "" : this.currentSelection.getDescription());
        this.uniqueId.setText(this.currentSelection.getUniqueID() == null ? "" : this.currentSelection.getUniqueID());
        this.idleText.setText(this.currentSelection.getMaximumIdleTime() == null ? "" : this.currentSelection.getMaximumIdleTime());
        this.pauseText.setText(this.currentSelection.getPauseInterval() == null ? "" : this.currentSelection.getPauseInterval());
        this.continousBtn.setSelection(this.currentSelection.isContinuousOperation());
        this.isDisplaying = false;
    }

    public boolean updateCurrentSelection(EObject eObject) {
        this.currentSelection = (ContextInstanceType)eObject;
        this.currentSelection.setDescription(this.descriptionText.getText());
        this.currentSelection.setUniqueID(this.uniqueId.getText());
        this.currentSelection.setMaximumIdleTime(this.idleText.getText());
        this.currentSelection.setPauseInterval(this.pauseText.getText());
        this.currentSelection.setContinuousOperation(this.continousBtn.getSelection());
        return false;
    }

    public void setFocusToText() {
        this.descriptionText.setFocus();
        this.descriptionText.selectAll();
    }

    public void modifyText(ModifyEvent modifyEvent) {
        String string;
        if (this.isDisplaying || this.currentSelection == null) {
            return;
        }
        if (modifyEvent.getSource() == this.descriptionText) {
            String string2 = this.descriptionText.getText();
            if (!string2.equals(this.currentSelection.getDescription())) {
                if (string2.length() == 0 && this.currentSelection.getDescription() == null) {
                    return;
                }
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextInstanceTypeItemProvider.DESCRIPTION);
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string2);
                }
            }
        } else if (modifyEvent.getSource() == this.uniqueId) {
            String string3 = this.uniqueId.getText();
            if (!string3.equals(this.currentSelection.getUniqueID())) {
                if (string3.length() == 0 && this.currentSelection.getUniqueID() == null) {
                    return;
                }
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextInstanceTypeItemProvider.UNIQUE_ID);
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string3);
                }
            }
        } else if (modifyEvent.getSource() == this.idleText) {
            String string4 = this.idleText.getText();
            if (!string4.equals(this.currentSelection.getMaximumIdleTime())) {
                if (string4.length() == 0 && this.currentSelection.getMaximumIdleTime() == null) {
                    return;
                }
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextInstanceTypeItemProvider.MAXIMUM_IDLE);
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string4);
                }
            }
        } else if (modifyEvent.getSource() == this.pauseText && !(string = this.pauseText.getText()).equals(this.currentSelection.getPauseInterval())) {
            if (string.length() == 0 && this.currentSelection.getPauseInterval() == null) {
                return;
            }
            IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextInstanceTypeItemProvider.PAUSE_INTERVAL);
            if (iItemPropertyDescriptor != null) {
                iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string);
            }
        }
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
    }

    public void notifyChanged(Notification notification) {
        Object object = notification.getNotifier();
        if (object == null || object != this.currentSelection) {
            return;
        }
        this.display((EObject)this.currentSelection);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        boolean bl;
        if (selectionEvent.getSource() == this.continousBtn && (bl = this.continousBtn.getSelection()) != this.currentSelection.isContinuousOperation()) {
            IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextInstanceTypeItemProvider.DESCRIPTION);
            String string = this.currentSelection.getDescription();
            if (iItemPropertyDescriptor != null) {
                iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string);
            }
            this.currentSelection.setContinuousOperation(bl);
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }
}

