/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class LogSelectionDialog
extends SelectionDialog {
    protected Object selection;

    public LogSelectionDialog(Shell shell) {
        super(shell);
        this.setTitle(AcadEditorPlugin.getPlugin().getString("STR_SEL_DLG_TITLE"));
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridData gridData = GridUtil.createFill();
        gridData.widthHint = 300;
        gridData.heightHint = 400;
        composite2.setLayoutData((Object)gridData);
        composite2.setLayout((Layout)new GridLayout());
        Tree tree = new Tree(composite2, 2052);
        tree.setLayoutData((Object)GridUtil.createFill());
        final TreeViewer treeViewer = new TreeViewer(tree);
        treeViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        treeViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
                LogSelectionDialog.this.setSelection(iStructuredSelection.getFirstElement());
            }
        });
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                ISelection iSelection = doubleClickEvent.getSelection();
                if (iSelection instanceof IStructuredSelection) {
                    Object object = ((IStructuredSelection)iSelection).getFirstElement();
                    if (treeViewer.getExpandedState(object)) {
                        treeViewer.collapseToLevel(object, 1);
                    } else {
                        treeViewer.expandToLevel(object, 1);
                    }
                }
            }
        });
        return composite2;
    }

    public Object getSelection() {
        return this.selection;
    }

    public void setSelection(Object object) {
        this.selection = object;
    }
}

