/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserConfigType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.parser.ParserConfigTypeItemProvider;
import org.eclipse.hyades.logging.adapter.ui.internal.parser.ParserItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.hyades.logging.adapter.ui.internal.util.IDetails;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleBuilderWidgetFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ParserSection
extends Composite
implements IDetails,
ModifyListener,
INotifyChangedListener {
    protected Text nameText;
    protected Label uniqueId;
    protected Text indexText;
    protected Text designationText;
    protected ParserConfigType currentSelection;
    protected boolean isDisplaying = false;
    protected ParserConfigTypeItemProvider itemProvider;
    protected ParserItemProviderAdapterFactory itemFactory = new ParserItemProviderAdapterFactory();

    public ParserSection(RuleBuilderWidgetFactory ruleBuilderWidgetFactory, Composite composite, int n) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 5;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(GridUtil.createFill());
        Label label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_PARSER_DESCR"), 0);
        this.nameText = ruleBuilderWidgetFactory.createText(this, "", 0);
        this.nameText.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_PARSER_ID"), 0);
        this.uniqueId = ruleBuilderWidgetFactory.createLabel(this, "");
        this.uniqueId.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, "", 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_PARSER_SEPTOKEN"), 0);
        this.indexText = ruleBuilderWidgetFactory.createText(this, "");
        this.indexText.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_PARSER_DESTOKEN"), 0);
        this.designationText = ruleBuilderWidgetFactory.createText(this, "");
        this.designationText.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, "", 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.nameText.addModifyListener((ModifyListener)this);
        this.indexText.addModifyListener((ModifyListener)this);
        this.designationText.addModifyListener((ModifyListener)this);
        this.itemProvider = (ParserConfigTypeItemProvider)this.itemFactory.createParserConfigTypeAdapter();
        this.itemProvider.addListener(this);
    }

    public void setFocusToText() {
        this.nameText.setFocus();
        this.nameText.selectAll();
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
        this.currentSelection = null;
    }

    public void notifyChanged(Notification notification) {
        Object object = notification.getNotifier();
        if (object == null || object != this.currentSelection) {
            return;
        }
        this.display((EObject)this.currentSelection);
    }

    public void display(EObject eObject) {
        if (this.nameText.isFocusControl() || this.uniqueId.isFocusControl() || this.indexText.isFocusControl() || this.designationText.isFocusControl()) {
            return;
        }
        this.currentSelection = (ParserConfigType)eObject;
        this.isDisplaying = true;
        this.nameText.setText(this.currentSelection.getDescription() == null ? "" : this.currentSelection.getDescription());
        this.uniqueId.setText(this.currentSelection.getUniqueID() == null ? "" : this.currentSelection.getUniqueID());
        this.indexText.setText(this.currentSelection.getSeparatorToken() == null ? "" : this.currentSelection.getSeparatorToken());
        this.designationText.setText(this.currentSelection.getDesignationToken() == null ? "" : this.currentSelection.getDesignationToken());
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                AcadGuiModelManager.setCurrentModel((ContextInstanceType)ParserSection.this.currentSelection.eContainer());
            }
        });
        this.isDisplaying = false;
    }

    public boolean updateCurrentSelection(EObject eObject) {
        this.currentSelection = (ParserConfigType)eObject;
        this.currentSelection.setDescription(this.nameText.getText());
        this.currentSelection.setSeparatorToken(this.indexText.getText());
        this.currentSelection.setDesignationToken(this.designationText.getText());
        return false;
    }

    public void modifyText(ModifyEvent modifyEvent) {
        String string;
        if (this.isDisplaying || this.currentSelection == null) {
            return;
        }
        if (modifyEvent.getSource() == this.indexText) {
            String string2 = this.indexText.getText();
            if (!string2.equals(this.currentSelection.getSeparatorToken())) {
                if (string2.length() == 0 && this.currentSelection.getSeparatorToken() == null) {
                    return;
                }
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ParserConfigTypeItemProvider.SEPARATOR);
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string2);
                }
            }
        } else if (modifyEvent.getSource() == this.nameText) {
            String string3 = this.nameText.getText();
            if (!string3.equals(this.currentSelection.getDescription())) {
                if (string3.length() == 0 && this.currentSelection.getDescription() == null) {
                    return;
                }
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ParserConfigTypeItemProvider.DESCRIPTION);
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string3);
                }
            }
        } else if (modifyEvent.getSource() == this.designationText && !(string = this.designationText.getText()).equals(this.currentSelection.getDesignationToken())) {
            if (string.length() == 0 && this.currentSelection.getDesignationToken() == null) {
                return;
            }
            IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ParserConfigTypeItemProvider.DESIGNATION);
            if (iItemPropertyDescriptor != null) {
                iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string);
            }
        }
    }
}

