/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import java.io.File;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.SingleFileOutputterType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.outputter.OutputterItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.outputter.SingleFileOutputterTypeItemProvider;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.hyades.logging.adapter.ui.internal.util.IDetails;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleBuilderWidgetFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SingleFileOutputterSection
extends Composite
implements IDetails,
ModifyListener,
SelectionListener,
INotifyChangedListener {
    protected Text directoryText;
    protected Button browseDirectory;
    protected Text fileIdText;
    protected Button browseFile;
    protected boolean isDisplaying;
    protected SingleFileOutputterType currentSelection;
    protected SingleFileOutputterTypeItemProvider itemProvider;
    protected OutputterItemProviderAdapterFactory itemFactory = new OutputterItemProviderAdapterFactory();

    public SingleFileOutputterSection(RuleBuilderWidgetFactory ruleBuilderWidgetFactory, Composite composite, int n) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 5;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(GridUtil.createFill());
        Label label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_SFILEOUT_DIR"), 0);
        this.directoryText = ruleBuilderWidgetFactory.createText(this, "", 2);
        this.directoryText.setLayoutData((Object)new GridData(768));
        this.browseDirectory = ruleBuilderWidgetFactory.createButton(this, AcadEditorPlugin.getPlugin().getString("BROWSE"), 8);
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_SFILEOUT_FILE"), 0);
        this.fileIdText = ruleBuilderWidgetFactory.createText(this, "", 0);
        this.fileIdText.setLayoutData((Object)new GridData(768));
        this.browseFile = ruleBuilderWidgetFactory.createButton(this, AcadEditorPlugin.getPlugin().getString("BROWSE2"), 8);
        this.directoryText.addModifyListener((ModifyListener)this);
        this.fileIdText.addModifyListener((ModifyListener)this);
        this.browseDirectory.addSelectionListener((SelectionListener)this);
        this.browseFile.addSelectionListener((SelectionListener)this);
        this.itemProvider = (SingleFileOutputterTypeItemProvider)this.itemFactory.createSingleFileOutputterTypeAdapter();
        this.itemProvider.addListener(this);
    }

    public void display(EObject eObject) {
        if (eObject != null) {
            AcadGuiModelManager.setCurrentModel((ContextInstanceType)((SingleFileOutputterType)eObject).eContainer().eContainer());
        }
        if (this.currentSelection == eObject) {
            return;
        }
        if (this.directoryText.isFocusControl() || this.fileIdText.isFocusControl()) {
            return;
        }
        this.currentSelection = (SingleFileOutputterType)eObject;
        this.isDisplaying = true;
        this.directoryText.setText(this.currentSelection.getDirectory() == null ? "" : this.currentSelection.getDirectory());
        this.fileIdText.setText(this.currentSelection.getFileName() == null ? "" : this.currentSelection.getFileName());
        this.isDisplaying = false;
    }

    public boolean updateCurrentSelection(EObject eObject) {
        this.currentSelection = (SingleFileOutputterType)eObject;
        this.currentSelection.setDirectory(this.directoryText.getText());
        this.currentSelection.setFileName(this.fileIdText.getText());
        return false;
    }

    public void setFocusToText() {
        this.directoryText.setFocus();
        this.directoryText.selectAll();
    }

    public void modifyText(ModifyEvent modifyEvent) {
        String string;
        if (this.isDisplaying || this.currentSelection == null) {
            return;
        }
        if (modifyEvent.getSource() == this.directoryText) {
            String string2 = this.directoryText.getText();
            if (!string2.equals(this.currentSelection.getDirectory())) {
                if (string2.length() == 0 && this.currentSelection.getDirectory() == null) {
                    return;
                }
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, SingleFileOutputterTypeItemProvider.DIRECTORY);
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string2);
                }
            }
        } else if (modifyEvent.getSource() == this.fileIdText && !(string = this.fileIdText.getText()).equals(this.currentSelection.getFileName())) {
            if (string.length() == 0 && this.currentSelection.getFileName() == null) {
                return;
            }
            IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, SingleFileOutputterTypeItemProvider.FILE_NAME);
            if (iItemPropertyDescriptor != null) {
                iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string);
            }
        }
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
    }

    public void notifyChanged(Notification notification) {
        Object object = notification.getNotifier();
        if (object == null || object != this.currentSelection) {
            return;
        }
        this.display((EObject)this.currentSelection);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.getSource() == this.browseDirectory) {
            String string;
            DirectoryDialog directoryDialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
            directoryDialog.setMessage("Select a directory");
            String string2 = this.directoryText.getText();
            if (string2.length() > 0) {
                directoryDialog.setFilterPath(string2);
            }
            if ((string = directoryDialog.open()) != null) {
                this.directoryText.setText(string);
            }
        } else if (selectionEvent.getSource() == this.browseFile) {
            File file;
            String string;
            FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell());
            String string3 = this.directoryText.getText();
            if (string3.length() > 0 && new File(string3).exists()) {
                fileDialog.setFileName(string3.concat(File.separator).concat("*"));
            }
            if ((string = fileDialog.open()) != null && (file = new File(string)).exists()) {
                this.directoryText.setText(file.getParent());
                this.fileIdText.setText(file.getName());
            }
        }
    }
}

