/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class SaveManager
extends TimerTask {
    public static final Map RESOURCE_OPTIONS = new HashMap();
    private static SaveManager instance;
    private Timer timer;
    private List resources;
    private boolean running;

    private SaveManager() {
        RESOURCE_OPTIONS.put("DECLARE_XML", Boolean.TRUE);
        RESOURCE_OPTIONS.put("SKIP_ESCAPE", Boolean.FALSE);
        this.running = false;
    }

    public synchronized void dispose() {
        this.stop();
        if (this.resources != null) {
            this.resources.clear();
        }
        instance = null;
    }

    public static SaveManager getInstance() {
        if (instance == null) {
            instance = new SaveManager();
        }
        return instance;
    }

    public static void saveResource(EObject eObject) {
        if (eObject != null) {
            SaveManager.saveResource(eObject.eResource());
        }
    }

    public static void saveResource(Resource resource) {
        if (resource != null) {
            try {
                resource.save(RESOURCE_OPTIONS);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void addResource(Resource resource) {
        if (resource == null) {
            return;
        }
        resource.setTrackingModification(true);
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        this.resources.add(resource);
    }

    public void removeResource(Resource resource) {
        if (this.resources != null) {
            this.resources.remove(resource);
        }
    }

    public void removeAllResources() {
        if (this.resources != null) {
            this.resources.clear();
        }
    }

    public Resource[] getResources() {
        if (this.resources == null) {
            return new Resource[0];
        }
        return this.resources.toArray(new Resource[this.resources.size()]);
    }

    public void saveResources() {
        if (this.resources == null || this.resources.isEmpty()) {
            return;
        }
        Resource[] resourceArray = this.getResources();
        int n = 0;
        int n2 = resourceArray.length;
        while (n < n2) {
            if (resourceArray[n].isModified()) {
                SaveManager.saveResource(resourceArray[n]);
            }
            ++n;
        }
    }

    public synchronized void start(long l) {
        if (!this.isRunning() && l > 0L) {
            this.timer = new Timer(true);
            this.timer.schedule((TimerTask)this, l, l);
            this.running = true;
        }
    }

    public synchronized void stop() {
        this.running = false;
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void run() {
        if (this.resources == null || this.resources.isEmpty()) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                if (SaveManager.this.isRunning()) {
                    SaveManager.this.saveResources();
                }
            }
        };
        thread.setName(this.getClass().getName());
        thread.start();
    }
}

