/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.correlation;

import org.eclipse.hyades.collection.correlation.IApplication;
import org.eclipse.hyades.collection.correlation.ICorrelatorData;
import org.eclipse.hyades.collection.correlation.exceptions.InsufficientBufferLengthException;

public class BaseCorrelatorDataImpl
implements ICorrelatorData {
    private long applicationCounter = 0L;
    private long operationCounter = 0L;
    protected IApplication application = null;

    public void invalidate() {
        this.operationCounter = 0L;
        this.applicationCounter = 0L;
        this.application = null;
    }

    public void setApplicationCounter(long l) {
        this.applicationCounter = l;
    }

    public long getApplicationCounter() {
        return this.applicationCounter;
    }

    public void setOperationCounter(long l) {
        this.operationCounter = l;
    }

    public long getOperationCounter() {
        return this.operationCounter;
    }

    public long convertBytesToInteger(byte[] byArray, int n) {
        return ((long)byArray[n] & 0xFFL) << 24 | ((long)byArray[n + 1] & 0xFFL) << 16 | ((long)byArray[n + 2] & 0xFFL) << 8 | (long)byArray[n + 3] & 0xFFL;
    }

    public void convertIntegerToBytes(long l, byte[] byArray, int n) {
        byArray[n] = (byte)(l >> 24);
        byArray[n + 1] = (byte)(l >> 16);
        byArray[n + 2] = (byte)(l >> 8);
        byArray[n + 3] = (byte)l;
    }

    public int readBinary(byte[] byArray, int n, int n2) throws InsufficientBufferLengthException {
        if (n2 - n < 8) {
            throw new InsufficientBufferLengthException(n + 8);
        }
        this.applicationCounter = this.convertBytesToInteger(byArray, n);
        this.operationCounter = this.convertBytesToInteger(byArray, n + 4);
        return n + 8;
    }

    public int writeBinary(byte[] byArray, int n, int n2) throws InsufficientBufferLengthException {
        if (n2 - n < 8) {
            throw new InsufficientBufferLengthException(n + 8);
        }
        this.convertIntegerToBytes(this.applicationCounter, byArray, n);
        this.convertIntegerToBytes(this.operationCounter, byArray, n + 4);
        return n + 8;
    }

    public int readXML(StringBuffer stringBuffer, int n, int n2) {
        String string = new String(stringBuffer);
        int n3 = string.indexOf("<CorrelationData applicationCounter=\"") + 37;
        int n4 = string.indexOf("\" operationCounter=\"", n3);
        this.applicationCounter = Long.parseLong(string.substring(n3, n4));
        n3 = string.indexOf("\"/>", n4 += 20);
        this.operationCounter = Long.parseLong(stringBuffer.substring(n4, n3));
        return n3 + 3;
    }

    public StringBuffer writeXML(StringBuffer stringBuffer) {
        stringBuffer.append("<CorrelatorData applicationCounter=\"" + this.applicationCounter + "\" " + "operationCounter=\"" + this.operationCounter + "\"/>");
        return stringBuffer;
    }

    void setApplication(IApplication iApplication) {
        this.application = iApplication;
    }

    public IApplication getApplication() {
        return this.application;
    }
}

