/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.internal.sdb.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.internal.sdb.SDBDirective;
import org.eclipse.hyades.models.internal.sdb.SDBFactory;
import org.eclipse.hyades.models.internal.sdb.SDBMatchPattern;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.models.internal.sdb.SDBSolution;
import org.eclipse.hyades.models.internal.sdb.SDBSymptom;
import org.eclipse.hyades.models.internal.sdb.impl.SDBFactoryImpl;
import org.eclipse.hyades.models.internal.sdb.impl.SDBPackageImpl;
import org.eclipse.hyades.models.internal.sdb.impl.SDBResourceFactoryImpl;
import org.eclipse.hyades.models.internal.sdb.impl.SDBResourceSetImpl;
import org.eclipse.hyades.models.internal.sdb.loader.IConstants;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SDBLoader
extends DefaultHandler
implements IConstants {
    private HashMap _directives = new HashMap();
    private HashMap _references = new HashMap();
    private HashMap _solutions = new HashMap();
    private IProgressMonitor _monitor;
    private SDBFactory _factory;
    private SDBResourceSetImpl _resourceSet;
    private SDBRuntime _symptomDB;
    private SDBSymptom _symptom;
    private String errMsg;
    private StringBuffer buffer = new StringBuffer();
    private int counter;

    public SDBLoader() {
        SDBPackageImpl.init();
        this._factory = new SDBFactoryImpl();
        this._resourceSet = new SDBResourceSetImpl();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("trcdbxmi", new SDBResourceFactoryImpl());
    }

    public String getErrorMessage() {
        return this.errMsg;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.buffer.append(cArray, n, n2);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("matchsymptomv")) {
            this.createMatchPattern();
        } else if (string3.equals("symptominfov")) {
            this.createSolution();
        }
        this.buffer.setLength(0);
    }

    public void error(SAXParseException sAXParseException) {
        this.errMsg = sAXParseException.getMessage();
        sAXParseException.printStackTrace();
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.errMsg = sAXParseException.getMessage();
        sAXParseException.printStackTrace();
    }

    public void loadDatabase(String string, String string2, IProgressMonitor iProgressMonitor) throws Exception {
        block6: {
            try {
                this._monitor = iProgressMonitor;
                File file = new File(string);
                int n = (int)file.length();
                this._monitor.beginTask(string, n / 1000);
                this.createRuntime(string2);
                if (this._symptomDB != null) {
                    this._symptomDB.setLocalExternalFileLocation(string);
                }
                this.parse(string);
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                    hashMap.put("DECLARE_XML", Boolean.TRUE);
                    this._symptomDB.eResource().save(hashMap);
                }
                catch (Exception exception) {
                    this.errMsg = exception.toString();
                    this._monitor.done();
                    exception.printStackTrace();
                }
                this._monitor.done();
                throw throwable;
            }
            try {
                HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                hashMap.put("DECLARE_XML", Boolean.TRUE);
                this._symptomDB.eResource().save(hashMap);
                break block6;
            }
            catch (Exception exception) {
                this.errMsg = exception.toString();
                this._monitor.done();
                exception.printStackTrace();
            }
            {
            }
        }
        this._monitor.done();
    }

    public void loadDatabase(InputStream inputStream, String string, String string2, IProgressMonitor iProgressMonitor) throws Exception {
        block6: {
            try {
                this._monitor = iProgressMonitor;
                this._monitor.beginTask(string, 100);
                this.createRuntime(string2);
                if (this._symptomDB != null) {
                    this._symptomDB.setSymptomUrl(string);
                    this._symptomDB.setName(string2);
                }
                this.parse(inputStream);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                    hashMap.put("DECLARE_XML", Boolean.TRUE);
                    this._symptomDB.eResource().save(hashMap);
                }
                catch (Exception exception) {
                    this.errMsg = exception.toString();
                    this._monitor.done();
                    exception.printStackTrace();
                }
                this._monitor.done();
                throw throwable;
            }
            try {
                HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                hashMap.put("DECLARE_XML", Boolean.TRUE);
                this._symptomDB.eResource().save(hashMap);
                break block6;
            }
            catch (Exception exception) {
                this.errMsg = exception.toString();
                this._monitor.done();
                exception.printStackTrace();
            }
            {
            }
        }
        this._monitor.done();
    }

    public void parse(String string) throws Exception {
        this.errMsg = null;
        FileInputStream fileInputStream = new FileInputStream(string);
        if (fileInputStream == null) {
            return;
        }
        this.parse(fileInputStream);
    }

    protected SAXParser makeParser() throws ParserConfigurationException, SAXException {
        SAXParserFactoryImpl sAXParserFactoryImpl = new SAXParserFactoryImpl();
        sAXParserFactoryImpl.setValidating(false);
        return sAXParserFactoryImpl.newSAXParser();
    }

    public void parse(InputStream inputStream) throws Exception {
        this.errMsg = null;
        if (inputStream == null) {
            return;
        }
        InputSource inputSource = new InputSource(inputStream);
        try {
            SAXParser sAXParser = this.makeParser();
            sAXParser.parse(inputSource, (DefaultHandler)this);
            inputStream.close();
        }
        catch (SAXException sAXException) {
            this.errMsg = sAXException.getMessage();
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            this.errMsg = iOException.getMessage();
            iOException.printStackTrace();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals("runtime")) {
            this.createRuntime(attributes);
        } else if (string3.equals("matchPattern")) {
            this.createMatchPattern(attributes);
        } else if (string3.equals("solution")) {
            this.createSolution(attributes);
        } else if (string3.equals("symptom")) {
            this.createSymptom(attributes);
        } else if (string3.equals("directive")) {
            this.createDirective(attributes);
        } else if (string3.equals("symrec")) {
            this.createV4Symptom(attributes);
        }
    }

    public void warning(SAXParseException sAXParseException) {
        this.errMsg = sAXParseException.getMessage();
        sAXParseException.printStackTrace();
    }

    private void addReference(String string, Object object) {
        Object v = this._references.get(string);
        if (v != null) {
            ((ArrayList)v).add(object);
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(object);
            this._references.put(string, arrayList);
        }
    }

    private void createDirective(Attributes attributes) {
        SDBDirective sDBDirective = this._factory.createSDBDirective();
        this._symptomDB.getDirectives().add(sDBDirective);
        sDBDirective.setId(attributes.getValue("id"));
        sDBDirective.setDescription(attributes.getValue("description"));
        sDBDirective.setDirectiveString(attributes.getValue("directiveString"));
        Object v = this._references.get(sDBDirective.getId());
        if (v != null) {
            ArrayList arrayList = (ArrayList)v;
            int n = 0;
            while (n < arrayList.size()) {
                SDBSolution sDBSolution = (SDBSolution)arrayList.get(n);
                sDBSolution.getDirectives().add(sDBDirective);
                sDBDirective.getSolutions().add(sDBSolution);
                ++n;
            }
            this._references.remove(sDBDirective.getId());
        }
        this._directives.put(sDBDirective.getId(), sDBDirective);
    }

    private void createMatchPattern(Attributes attributes) {
        SDBMatchPattern sDBMatchPattern = this._factory.createSDBMatchPattern();
        this._symptom.getPatterns().add(sDBMatchPattern);
        sDBMatchPattern.setName(attributes.getValue("name"));
        sDBMatchPattern.setValue(attributes.getValue("value"));
        String string = this._symptom.getDescription();
        if (string == null || string.equals("")) {
            this._symptom.setDescription(sDBMatchPattern.getValue());
        }
        this._monitor.worked(1);
        if (this._monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void createMatchPattern() {
        String string = this.buffer.toString();
        while (string.startsWith("\n") || string.startsWith(" ")) {
            string = string.substring(1);
        }
        int n = string.indexOf("\n");
        if (n != -1) {
            String string2 = string.substring(0, n);
            if (string2.length() > 0) {
                this._symptom.setDescription(string2);
            }
        } else if (string.length() > 0) {
            this._symptom.setDescription(string);
        }
        int n2 = 0;
        while (n != -1) {
            if (string.substring(0, n).length() > 0) {
                SDBMatchPattern sDBMatchPattern = this._factory.createSDBMatchPattern();
                sDBMatchPattern.setName(String.valueOf(n2));
                sDBMatchPattern.setValue(string.substring(0, n));
                this._symptom.getPatterns().add(sDBMatchPattern);
                ++n2;
            }
            string = string.substring(n + 1);
            n = string.indexOf("\n");
        }
        this._monitor.worked(1);
        if (this._monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void createRuntime(String string) {
        Resource resource = null;
        URI uRI = null;
        uRI = string.startsWith("platform:/resource/") ? URI.createURI((String)string) : URI.createFileURI((String)string);
        resource = Resource.Factory.Registry.INSTANCE.getFactory(uRI).createResource(uRI);
        EList eList = resource.getContents();
        this._resourceSet.getResources().add(resource);
        this._symptomDB = this._factory.createSDBRuntime();
        eList.add(this._symptomDB);
        this._symptomDB.setId("");
        this._symptomDB.setName(string);
        this._symptomDB.setSymptomUrl("");
        this._symptomDB.setLocalExternalFileLocation("");
        this._symptomDB.setDescription("");
    }

    private void createRuntime(Attributes attributes) {
        if (this._symptomDB == null) {
            return;
        }
        this._symptomDB.setId(attributes.getValue("id"));
        this._symptomDB.setName(attributes.getValue("name"));
        this._symptomDB.setSymptomUrl(attributes.getValue("symptomUrl"));
        this._symptomDB.setLocalExternalFileLocation(attributes.getValue("localExternalFileLocation"));
    }

    private void createSolution(Attributes attributes) {
        Object v;
        Object object;
        SDBSolution sDBSolution = this._factory.createSDBSolution();
        this._symptomDB.getSolutions().add(sDBSolution);
        sDBSolution.setId(attributes.getValue("id"));
        sDBSolution.setDescription(attributes.getValue("description"));
        String string = attributes.getValue("directives");
        if (string != null) {
            int n = string.indexOf(" ");
            while (n != -1) {
                object = string.substring(0, n);
                this.resolveRefDirective((String)object, sDBSolution);
                string = string.substring(n + 1);
                n = string.indexOf(" ");
            }
            if (!string.equals("")) {
                this.resolveRefDirective(string, sDBSolution);
            }
        }
        if ((v = this._references.get(sDBSolution.getId())) != null) {
            object = (ArrayList)v;
            int n = 0;
            while (n < ((ArrayList)object).size()) {
                SDBSymptom sDBSymptom = (SDBSymptom)((ArrayList)object).get(n);
                sDBSymptom.getSolutions().add(sDBSolution);
                sDBSolution.getSymptoms().add(sDBSymptom);
                ++n;
            }
            this._references.remove(sDBSolution.getId());
        }
        this._solutions.put(sDBSolution.getId(), sDBSolution);
        this._monitor.worked(1);
        if (this._monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void createSolution() {
        SDBSolution sDBSolution = this._factory.createSDBSolution();
        this._symptomDB.getSolutions().add(sDBSolution);
        sDBSolution.getSymptoms().add(this._symptom);
        this._symptom.getSolutions().add(sDBSolution);
        String string = this.buffer.toString();
        while (string.startsWith("\n") || string.startsWith(" ")) {
            string = string.substring(1);
        }
        int n = string.indexOf("\n");
        if (n != -1) {
            sDBSolution.setDescription(string.substring(0, n));
            string = string.substring(n);
            string = string.trim();
            if (string.length() > 0) {
                SDBDirective sDBDirective = this._factory.createSDBDirective();
                this._symptomDB.getDirectives().add(sDBDirective);
                sDBDirective.setDescription(string);
                sDBDirective.setId("Directive_" + this.counter++);
                sDBDirective.setDirectiveString("");
                sDBSolution.getDirectives().add(sDBDirective);
                sDBDirective.getSolutions().add(sDBSolution);
            }
        } else {
            sDBSolution.setDescription(string);
        }
        sDBSolution.setId("Solution_" + this.counter);
        this._monitor.worked(1);
        if (this._monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void createSymptom(Attributes attributes) {
        this._symptom = this._factory.createSDBSymptom();
        this._symptomDB.getSymptoms().add(this._symptom);
        this._symptom.setId(attributes.getValue("id"));
        this._symptom.setDescription(attributes.getValue("description"));
        String string = attributes.getValue("solutions");
        if (string != null) {
            int n = string.indexOf(" ");
            while (n != -1) {
                String string2 = string.substring(0, n);
                this.resolveRefSolution(string2, this._symptom);
                string = string.substring(n + 1);
                n = string.indexOf(" ");
            }
            if (!string.equals("")) {
                this.resolveRefSolution(string, this._symptom);
            }
        }
        this._monitor.worked(1);
        if (this._monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void createV4Symptom(Attributes attributes) {
        this._symptom = this._factory.createSDBSymptom();
        this._symptom.setId(attributes.getValue("recordid"));
        this._symptom.setDescription(attributes.getValue("recordid"));
        this._symptomDB.getSymptoms().add(this._symptom);
        this._monitor.worked(1);
        if (this._monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void resolveRefDirective(String string, SDBSolution sDBSolution) {
        Object v = this._directives.get(string);
        if (v != null) {
            SDBDirective sDBDirective = (SDBDirective)v;
            sDBDirective.getSolutions().add(sDBSolution);
            sDBSolution.getDirectives().add(sDBDirective);
        } else {
            this.addReference(string, sDBSolution);
        }
    }

    private void resolveRefSolution(String string, SDBSymptom sDBSymptom) {
        Object v = this._solutions.get(string);
        if (v != null) {
            SDBSolution sDBSolution = (SDBSolution)v;
            sDBSolution.getSymptoms().add(sDBSymptom);
            sDBSymptom.getSolutions().add(sDBSolution);
        } else {
            this.addReference(string, sDBSymptom);
        }
    }
}

