/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.preference;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.AssociationDescriptorLabelProvider;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.internal.util.ChooseElementDialog;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public abstract class AssociationMappingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
Listener {
    private IWorkbench workbench;
    private IAssociationMapping selectionMapping;
    private Table selectionTable;
    private TabFolder detailTabFolder;
    private Map mappingByTable = new HashMap();
    private Button addAssociationButton;
    private Button removeAssociationButton;
    private Button defaultAssociationButton;

    public AssociationMappingPreferencePage() {
        this.noDefaultAndApplyButton();
    }

    public void init(IWorkbench iWorkbench) {
        this.workbench = iWorkbench;
    }

    protected IWorkbench getWorkbench() {
        return this.workbench;
    }

    public abstract IAssociationMapping[] getDetailMappings();

    protected abstract IAssociationMapping getSelectionAssociationMapping();

    protected abstract String getLabel(IAssociationMapping var1);

    public abstract boolean performCancel();

    public abstract boolean performOk();

    public void dispose() {
        if (this.mappingByTable != null) {
            this.mappingByTable.clear();
        }
        this.selectionMapping = null;
        super.dispose();
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        this.beforeIsPresented();
    }

    protected void beforeIsPresented() {
    }

    protected Control createContents(Composite composite) {
        GridData gridData;
        Label label;
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)GridDataUtil.createFill());
        IAssociationMapping iAssociationMapping = this.getSelectionAssociationMapping();
        if (iAssociationMapping != null && iAssociationMapping.associationDescriptors().length > 0) {
            this.selectionMapping = iAssociationMapping;
            label = new Label(composite2, 16384);
            label.setText(this.getLabel(this.selectionMapping));
            this.selectionTable = new Table(composite2, 67588);
            this.selectionTable.addListener(13, (Listener)this);
            this.selectionTable.addListener(14, (Listener)this);
        }
        if (((IAssociationMapping[])(label = this.getDetailMappings())).length > 0) {
            if (this.selectionTable != null) {
                gridData = new GridData(768);
                gridData.heightHint = this.selectionTable.getItemHeight() * (UIUtil.availableRows(composite) / 16);
                this.selectionTable.setLayoutData((Object)gridData);
                Label label2 = new Label(composite2, 16384);
                GridData gridData2 = new GridData();
                gridData2.heightHint = 1;
                label2.setLayoutData((Object)gridData2);
            }
            this.createDetailControl(composite2, (IAssociationMapping[])label);
        } else if (this.selectionTable != null) {
            this.selectionTable.setLayoutData((Object)GridDataUtil.createFill());
        }
        if (this.populateSelection()) {
            this.selectionTable.select(0);
            gridData = new Event();
            gridData.widget = this.selectionTable;
            gridData.type = 13;
            this.selectionTable.notifyListeners(13, (Event)gridData);
        } else {
            this.populateDetails();
        }
        WorkbenchHelp.setHelp((Control)composite, (String)(HyadesUIPlugin.getID() + ".asst0001"));
        WorkbenchHelp.setHelp((Control)this.selectionTable, (String)(HyadesUIPlugin.getID() + ".asst0001"));
        WorkbenchHelp.setHelp((Control)this.defaultAssociationButton, (String)(HyadesUIPlugin.getID() + ".asst0003"));
        WorkbenchHelp.setHelp((Control)this.addAssociationButton, (String)(HyadesUIPlugin.getID() + ".asst0002"));
        WorkbenchHelp.setHelp((Control)this.removeAssociationButton, (String)(HyadesUIPlugin.getID() + ".asst0004"));
        WorkbenchHelp.setHelp((Control)this.detailTabFolder, (String)(HyadesUIPlugin.getID() + ".asst0005"));
        return composite2;
    }

    protected void createSelectionControl(Composite composite) {
        Label label = new Label(composite, 16384);
        label.setText(this.getLabel(this.selectionMapping));
        this.selectionTable = new Table(composite, 67588);
        this.selectionTable.addListener(13, (Listener)this);
        this.selectionTable.addListener(14, (Listener)this);
        GridData gridData = new GridData(768);
        gridData.heightHint = this.selectionTable.getItemHeight() * (UIUtil.availableRows(composite) / 16);
        this.selectionTable.setLayoutData((Object)gridData);
    }

    protected void createDetailControl(Composite composite, IAssociationMapping[] iAssociationMappingArray) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)GridDataUtil.createFill());
        this.detailTabFolder = new TabFolder(composite2, 128);
        this.detailTabFolder.setLayoutData((Object)GridDataUtil.createFill());
        int n = 0;
        int n2 = iAssociationMappingArray.length;
        while (n < n2) {
            String string = this.getLabel(iAssociationMappingArray[n]);
            if (string == null) {
                string = "";
            }
            Table table = this.createDetailTable((Composite)this.detailTabFolder, iAssociationMappingArray[n]);
            this.mappingByTable.put(table, iAssociationMappingArray[n]);
            TabItem tabItem = new TabItem(this.detailTabFolder, 0);
            tabItem.setText(string);
            tabItem.setControl((Control)table);
            ++n;
        }
        this.detailTabFolder.setSelection(0);
        this.createDetailButtonsControl(composite2);
    }

    protected Table createDetailTable(Composite composite, IAssociationMapping iAssociationMapping) {
        Table table = new Table(composite, 67588);
        table.addListener(13, (Listener)this);
        table.addListener(14, (Listener)this);
        table.setLayoutData((Object)GridDataUtil.createFill());
        return table;
    }

    protected void createDetailButtonsControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        composite2.setLayoutData((Object)gridData);
        new Label(composite2, 16384);
        if (this.selectionTable != null) {
            this.addAssociationButton = new Button(composite2, 8);
            this.addAssociationButton.setText(HyadesUIPlugin.getString("BTN_ADD"));
            this.addAssociationButton.addListener(13, (Listener)this);
            this.setButtonLayoutData(this.addAssociationButton);
            this.removeAssociationButton = new Button(composite2, 8);
            this.removeAssociationButton.setText(HyadesUIPlugin.getString("BTN_REMOVE"));
            this.removeAssociationButton.addListener(13, (Listener)this);
            this.setButtonLayoutData(this.removeAssociationButton);
        }
        this.defaultAssociationButton = new Button(composite2, 8);
        this.defaultAssociationButton.setText(HyadesUIPlugin.getString("BTN_DEFAULT"));
        this.defaultAssociationButton.addListener(13, (Listener)this);
        this.setButtonLayoutData(this.defaultAssociationButton);
    }

    protected boolean populateSelection() {
        if (this.selectionMapping == null) {
            return false;
        }
        this.populate(this.selectionTable, this.selectionMapping.associationDescriptors(), null);
        return true;
    }

    protected boolean populateDetails() {
        if (this.mappingByTable == null) {
            return false;
        }
        IAssociationDescriptor iAssociationDescriptor = this.getAssociationDescriptor(this.selectionTable);
        Iterator iterator = this.mappingByTable.keySet().iterator();
        while (iterator.hasNext()) {
            this.populateDetail(iAssociationDescriptor, (Table)iterator.next());
        }
        return true;
    }

    protected void populateDetail(IAssociationDescriptor iAssociationDescriptor, Table table) {
        String[] stringArray = null;
        if (iAssociationDescriptor != null) {
            stringArray = iAssociationDescriptor.types();
        }
        IAssociationMapping iAssociationMapping = (IAssociationMapping)this.mappingByTable.get(table);
        IAssociationDescriptor[] iAssociationDescriptorArray = null;
        IAssociationDescriptor iAssociationDescriptor2 = null;
        if (stringArray == null || stringArray.length == 0) {
            iAssociationDescriptorArray = iAssociationMapping.getAssociationDescriptors();
            iAssociationDescriptor2 = iAssociationMapping.getDefaultAssociationDescriptor();
        } else {
            HashSet<IAssociationDescriptor> hashSet = new HashSet<IAssociationDescriptor>();
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                hashSet.addAll(Arrays.asList(iAssociationMapping.getAssociationDescriptors(stringArray[n])));
                ++n;
            }
            iAssociationDescriptorArray = hashSet.toArray(new IAssociationDescriptor[hashSet.size()]);
            iAssociationDescriptor2 = iAssociationMapping.getDefaultAssociationDescriptor(stringArray[0]);
        }
        this.populate(table, iAssociationDescriptorArray, iAssociationDescriptor2);
    }

    protected void populate(Table table, IAssociationDescriptor[] iAssociationDescriptorArray, IAssociationDescriptor iAssociationDescriptor) {
        table.removeAll();
        TableItem tableItem = null;
        if (iAssociationDescriptor != null) {
            tableItem = new TableItem(table, 0);
        }
        int n = 0;
        int n2 = iAssociationDescriptorArray.length;
        while (n < n2) {
            TableItem tableItem2 = null;
            tableItem2 = iAssociationDescriptorArray[n] == iAssociationDescriptor ? tableItem : new TableItem(table, 0);
            tableItem2.setData((Object)iAssociationDescriptorArray[n]);
            Image image = iAssociationDescriptorArray[n].getImage();
            if (image != null) {
                tableItem2.setImage(image);
            }
            String string = this.getLabel(iAssociationDescriptorArray[n]);
            if (tableItem2 == tableItem) {
                string = HyadesUIPlugin.getString("DEFAULT_ASSOC", string);
            }
            tableItem2.setText(string);
            ++n;
        }
    }

    protected IAssociationDescriptor getAssociationDescriptor(Table table) {
        if (table == null || table.getSelectionCount() != 1) {
            return null;
        }
        return (IAssociationDescriptor)table.getSelection()[0].getData();
    }

    protected String getLabel(IAssociationDescriptor iAssociationDescriptor) {
        if (iAssociationDescriptor != null) {
            String string = iAssociationDescriptor.getName();
            if (string != null) {
                return string;
            }
            string = iAssociationDescriptor.getId();
            if (string != null) {
                return string;
            }
            String[] stringArray = iAssociationDescriptor.types();
            if (stringArray.length == 1) {
                return stringArray[0];
            }
        }
        return "";
    }

    public void handleEvent(Event event) {
        if (event.widget == this.selectionTable) {
            this.populateDetails();
        } else if (event.widget == this.addAssociationButton) {
            this.addAssociation((Table)this.detailTabFolder.getSelection()[0].getControl());
        } else if (event.widget == this.removeAssociationButton) {
            this.removeAssociation((Table)this.detailTabFolder.getSelection()[0].getControl());
        } else if (event.widget == this.defaultAssociationButton) {
            this.setDefaultAssociation((Table)this.detailTabFolder.getSelection()[0].getControl());
        }
        this.updateEnabledState();
    }

    protected void addAssociation(Table table) {
        IAssociationDescriptor iAssociationDescriptor = this.getAssociationDescriptor(this.selectionTable);
        if (iAssociationDescriptor == null) {
            return;
        }
        HashSet<IAssociationDescriptor> hashSet = new HashSet<IAssociationDescriptor>();
        IAssociationMapping iAssociationMapping = (IAssociationMapping)this.mappingByTable.get(table);
        String[] stringArray = iAssociationDescriptor.types();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            hashSet.addAll(Arrays.asList(iAssociationMapping.getAvoidedAssociationDescriptors(stringArray[n])));
            ++n;
        }
        IAssociationDescriptor iAssociationDescriptor2 = (IAssociationDescriptor)ChooseElementDialog.open(this.getShell(), HyadesUIPlugin.getString("DLG_ADD"), hashSet.toArray(), new AssociationDescriptorLabelProvider());
        if (iAssociationDescriptor2 != null) {
            int n3 = 0;
            int n4 = stringArray.length;
            while (n3 < n4) {
                iAssociationMapping.removeFromAvoidedSet(stringArray[n3], iAssociationDescriptor2);
                ++n3;
            }
        }
        this.populateDetail(iAssociationDescriptor, table);
    }

    protected void removeAssociation(Table table) {
        IAssociationDescriptor iAssociationDescriptor = this.getAssociationDescriptor(table);
        if (iAssociationDescriptor == null) {
            return;
        }
        IAssociationDescriptor iAssociationDescriptor2 = this.getAssociationDescriptor(this.selectionTable);
        if (iAssociationDescriptor2 == null) {
            return;
        }
        int n = table.getSelectionIndex();
        IAssociationMapping iAssociationMapping = (IAssociationMapping)this.mappingByTable.get(table);
        String[] stringArray = iAssociationDescriptor2.types();
        int n2 = 0;
        int n3 = stringArray.length;
        while (n2 < n3) {
            iAssociationMapping.addToAvoidedSet(stringArray[n2], iAssociationDescriptor);
            ++n2;
        }
        this.populateDetail(iAssociationDescriptor2, table);
        if (n == table.getItemCount()) {
            --n;
        }
        table.select(n);
    }

    protected void setDefaultAssociation(Table table) {
        IAssociationDescriptor iAssociationDescriptor = this.getAssociationDescriptor(table);
        if (iAssociationDescriptor == null) {
            return;
        }
        IAssociationMapping iAssociationMapping = (IAssociationMapping)this.mappingByTable.get(table);
        IAssociationDescriptor iAssociationDescriptor2 = this.getAssociationDescriptor(this.selectionTable);
        IAssociationDescriptor[] iAssociationDescriptorArray = null;
        if (iAssociationDescriptor2 == null || iAssociationDescriptor2.types().length == 0) {
            iAssociationMapping.setDefaultAssociationDescriptor(iAssociationDescriptor);
            iAssociationDescriptorArray = iAssociationMapping.getAssociationDescriptors();
        } else {
            String[] stringArray = iAssociationDescriptor2.types();
            HashSet<IAssociationDescriptor> hashSet = new HashSet<IAssociationDescriptor>();
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                iAssociationMapping.setDefaultAssociationDescriptor(stringArray[n], iAssociationDescriptor);
                hashSet.addAll(Arrays.asList(iAssociationMapping.getAssociationDescriptors(stringArray[n])));
                ++n;
            }
            iAssociationDescriptorArray = hashSet.toArray(new IAssociationDescriptor[hashSet.size()]);
        }
        this.populate(table, iAssociationDescriptorArray, iAssociationDescriptor);
        table.select(0);
    }

    protected void updateEnabledState() {
        IAssociationDescriptor iAssociationDescriptor = this.getAssociationDescriptor(this.selectionTable);
        IAssociationDescriptor iAssociationDescriptor2 = null;
        Table table = null;
        if (this.detailTabFolder != null && this.detailTabFolder.getSelection() != null) {
            table = (Table)this.detailTabFolder.getSelection()[0].getControl();
            iAssociationDescriptor2 = this.getAssociationDescriptor(table);
        }
        if (this.addAssociationButton != null) {
            this.addAssociationButton.setEnabled(this.selectionMapping == null || iAssociationDescriptor != null);
        }
        if (this.removeAssociationButton != null) {
            this.removeAssociationButton.setEnabled(iAssociationDescriptor2 != null && table.getItemCount() > 1);
        }
        if (this.defaultAssociationButton != null) {
            this.defaultAssociationButton.setEnabled(iAssociationDescriptor2 != null && table.getSelectionIndex() != 0);
        }
    }
}

