/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.provider;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.provider.IResourceChangeUpdater;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.swt.widgets.Display;

public class ResourceChangeUpdaterProvider
implements IResourceChangeListener,
IDisposable {
    private IResourceChangeUpdater resourceChangeUpdater;

    public void dispose() {
        this.resourceChangeUpdater = null;
    }

    public void setResourceChangeUpdater(IResourceChangeUpdater iResourceChangeUpdater) {
        this.resourceChangeUpdater = iResourceChangeUpdater;
    }

    public IResourceChangeUpdater getResourceChangeUpdater() {
        return this.resourceChangeUpdater;
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        if (this.getResourceChangeUpdater() == null || !this.getResourceChangeUpdater().isActive()) {
            return;
        }
        this.doProcessDelta(iResourceChangeEvent.getDelta());
    }

    protected void doProcessDelta(IResourceDelta iResourceDelta) {
        this.getResourceChangeUpdater().started();
        try {
            try {
                this.processDelta(iResourceDelta);
            }
            catch (Exception exception) {
                HyadesUIPlugin.logError(exception);
                Object var4_3 = null;
                this.getResourceChangeUpdater().ended();
            }
            Object var4_2 = null;
            this.getResourceChangeUpdater().ended();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.getResourceChangeUpdater().ended();
            throw throwable;
        }
    }

    protected void processDelta(IResourceDelta iResourceDelta) {
        int n;
        IResource[] iResourceArray;
        int n2;
        IResourceChangeUpdater iResourceChangeUpdater = this.getResourceChangeUpdater();
        if (iResourceChangeUpdater == null || !this.getResourceChangeUpdater().isActive()) {
            return;
        }
        IResource iResource = iResourceDelta.getResource();
        IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren(4);
        int n3 = 0;
        while (n3 < iResourceDeltaArray.length) {
            n2 = iResourceDeltaArray[n3].getFlags();
            if ((n2 & 0x8000) != 0 ? iResourceChangeUpdater.updateChildrenType(iResource) : (n2 & 0x100) != 0 && iResourceChangeUpdater.updateContent(iResource, iResourceDeltaArray[n3].getResource())) {
                return;
            }
            ++n3;
        }
        n2 = iResourceDelta.getFlags();
        if ((n2 & 0x14000) != 0 && iResourceChangeUpdater.updateProperties(iResource)) {
            return;
        }
        if ((n2 & 0x40000) != 0 && iResourceChangeUpdater.replaced(iResource)) {
            return;
        }
        int n4 = 0;
        while (n4 < iResourceDeltaArray.length) {
            this.processDelta(iResourceDeltaArray[n4]);
            ++n4;
        }
        iResourceDeltaArray = iResourceDelta.getAffectedChildren(2);
        if (iResourceDeltaArray.length > 0) {
            iResourceArray = new IResource[iResourceDeltaArray.length];
            n = 0;
            while (n < iResourceDeltaArray.length) {
                iResourceArray[n] = iResourceDeltaArray[n].getResource();
                ++n;
            }
            if (iResourceChangeUpdater.remove(iResource, iResourceArray)) {
                return;
            }
        }
        if ((iResourceDeltaArray = iResourceDelta.getAffectedChildren(1)).length > 0) {
            iResourceArray = new IResource[iResourceDeltaArray.length];
            n = 0;
            while (n < iResourceDeltaArray.length) {
                iResourceArray[n] = iResourceDeltaArray[n].getResource();
                ++n;
            }
            if (iResourceChangeUpdater.add(iResource, iResourceArray)) {
                return;
            }
        }
        int n5 = 0;
        while (n5 < iResourceDeltaArray.length) {
            this.processDelta(iResourceDeltaArray[n5]);
            ++n5;
        }
    }

    public static class UIUpdaterProvider
    extends ResourceChangeUpdaterProvider
    implements Runnable {
        private IResourceDelta delta;

        public void run() {
            super.doProcessDelta(this.delta);
            this.delta = null;
        }

        protected void doProcessDelta(IResourceDelta iResourceDelta) {
            this.delta = iResourceDelta;
            Display.getDefault().syncExec((Runnable)this);
        }
    }
}

