/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public abstract class ImageManager {
    public static final String T_LCL = "lcl16";
    public static final String T_TOOL = "tool16";
    public static final String T_VIEW = "view16";
    public static final String T_OBJ = "obj16";
    public static final String T_WIZBAN = "wizban";
    private URL iconBaseURL;
    private ImageRegistry imageRegistry;
    private boolean imagesWereLoaded = false;

    public void initialize(URL uRL, ImageRegistry imageRegistry) {
        this.iconBaseURL = uRL;
        this.imageRegistry = imageRegistry;
    }

    protected void checkImages() {
        if (this.imagesWereLoaded) {
            return;
        }
        this.addImages();
        this.imagesWereLoaded = true;
    }

    protected abstract void addImages();

    protected ImageDescriptor add(String string, String string2) {
        ImageDescriptor imageDescriptor = this.createImageDescriptor(string, string2);
        if (imageDescriptor != null) {
            this.imageRegistry.put(string2, imageDescriptor);
        }
        return imageDescriptor;
    }

    protected ImageDescriptor add(String string, String string2, String string3) {
        ImageDescriptor imageDescriptor = this.createImageDescriptor(string + string2, string3);
        if (imageDescriptor != null) {
            this.imageRegistry.put(string + string3, imageDescriptor);
        }
        return imageDescriptor;
    }

    protected boolean add(String string, ImageDescriptor imageDescriptor) throws IllegalArgumentException {
        if (string == null || imageDescriptor == null) {
            return false;
        }
        this.imageRegistry.put(string, imageDescriptor);
        return true;
    }

    protected ImageDescriptor createImageDescriptor(String string, String string2) {
        try {
            return ImageDescriptor.createFromURL((URL)this.makeIconFileURL(string, string2));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    protected URL makeIconFileURL(String string, String string2) throws MalformedURLException {
        if (this.iconBaseURL == null) {
            throw new MalformedURLException();
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('/');
        stringBuffer.append(string2);
        return new URL(this.iconBaseURL, stringBuffer.toString());
    }

    public ImageDescriptor getImageDescriptor(String string) {
        this.checkImages();
        return this.imageRegistry.getDescriptor(string);
    }

    public Image getImage(String string) {
        this.checkImages();
        return this.imageRegistry.get(string);
    }

    public ImageDescriptor getImageDescriptor(String string, String string2) {
        return this.getImageDescriptor(string + string2);
    }

    public Image getImage(String string, String string2) {
        return this.getImage(string + string2);
    }

    public void setImageDescriptors(IAction iAction, String string) {
        ImageDescriptor imageDescriptor = this.getImageDescriptor("d", string);
        if (imageDescriptor != null) {
            iAction.setDisabledImageDescriptor(imageDescriptor);
        }
        if ((imageDescriptor = this.getImageDescriptor("c", string)) != null) {
            iAction.setHoverImageDescriptor(imageDescriptor);
        }
        if ((imageDescriptor = this.getImageDescriptor("e", string)) != null) {
            iAction.setImageDescriptor(imageDescriptor);
        }
    }
}

