/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.util;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;

public class JavaSearchScope
implements IJavaSearchScope,
IDisposable {
    private Collection elements = new HashSet();
    private Collection resourcePaths = new HashSet();
    private Collection projectAndJarPaths = new HashSet();
    private boolean includesBinaries = true;
    private boolean includesClasspaths = true;
    private IJavaSearchScope workspaceScope = SearchEngine.createWorkspaceScope();

    public void dispose() {
        this.elements.clear();
        this.resourcePaths.clear();
        this.projectAndJarPaths.clear();
        this.workspaceScope = null;
    }

    public boolean addJavaElement(IJavaElement iJavaElement) {
        if (iJavaElement == null) {
            return false;
        }
        return this.elements.add(iJavaElement);
    }

    public boolean addResource(IResource iResource) {
        return this.addResource(iResource.getFullPath().toString());
    }

    public boolean addResource(String string) {
        if (string == null) {
            return false;
        }
        return this.resourcePaths.add(string);
    }

    public boolean addProjectAndJarPath(IPath iPath) {
        if (iPath == null) {
            return false;
        }
        return this.projectAndJarPaths.add(iPath);
    }

    public boolean encloses(IJavaElement iJavaElement) {
        if (this.elements.isEmpty()) {
            return this.workspaceScope.encloses(iJavaElement);
        }
        return this.elements.contains(iJavaElement);
    }

    public boolean encloses(String string) {
        if (this.resourcePaths.isEmpty()) {
            return this.workspaceScope.encloses(string);
        }
        return this.resourcePaths.contains(string);
    }

    public IPath[] enclosingProjectsAndJars() {
        if (this.projectAndJarPaths.isEmpty()) {
            return this.workspaceScope.enclosingProjectsAndJars();
        }
        return this.projectAndJarPaths.toArray(new IPath[this.projectAndJarPaths.size()]);
    }

    public boolean includesBinaries() {
        return this.includesBinaries;
    }

    public boolean includesClasspaths() {
        return this.includesClasspaths;
    }

    public void setIncludesBinaries(boolean bl) {
        this.includesBinaries = bl;
    }

    public void setIncludesClasspaths(boolean bl) {
        this.includesClasspaths = bl;
    }
}

