/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.wizard.selection;

import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.internal.wizard.selection.IWizardElement;
import org.eclipse.hyades.ui.internal.wizard.selection.WizardElementWorkbenchAdapter;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerSorter;

public class SelectionPage
extends WizardSelectionPage
implements ISelectionChangedListener,
IDoubleClickListener {
    private static final String SET_SELECTED_WIZARD_ID = "SelectionPage.STORE_SELECTED_WIZARD_ID";
    private static final int SIZING_LISTS_HEIGHT = 200;
    private IWorkbench workbench;
    private IStructuredSelection structuredSelection;
    private IWizardElement[] wizardElements;
    private String message;
    private TableViewer wizardSelectionViewer;
    static /* synthetic */ Class class$org$eclipse$jface$wizard$IWizardNode;

    public SelectionPage(String string, IWorkbench iWorkbench, IStructuredSelection iStructuredSelection, IWizardElement[] iWizardElementArray, String string2) {
        super(string);
        this.workbench = iWorkbench;
        this.structuredSelection = iStructuredSelection;
        this.wizardElements = iWizardElementArray;
        this.message = string2;
        this.setTitle(HyadesUIPlugin.getString("W_SELECT"));
        this.setMessage(HyadesUIPlugin.getString("WIZ_SEL_PG_DSC"));
    }

    public void dispose() {
        this.workbench = null;
        this.structuredSelection = null;
        this.wizardElements = null;
        super.dispose();
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getStructuredSelection() {
        return this.structuredSelection;
    }

    public void createControl(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(272));
        composite2.setFont(font);
        Label label = new Label(composite2, 0);
        label.setText(this.message);
        label.setFont(font);
        Table table = new Table(composite2, 2048);
        GridData gridData = new GridData(1808);
        int n = UIUtil.availableRows(composite);
        gridData.heightHint = n > 50 ? 200 : n * 3;
        table.setLayoutData((Object)gridData);
        table.setFont(font);
        this.wizardSelectionViewer = new TableViewer(table);
        this.wizardSelectionViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.wizardSelectionViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.wizardSelectionViewer.setSorter((ViewerSorter)new WorkbenchViewerSorter());
        this.wizardSelectionViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.wizardSelectionViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.wizardSelectionViewer.setInput((Object)new WizardElementWorkbenchAdapter(this.wizardElements));
        this.restoreWidgetValues();
        table.setFocus();
        this.setControl((Control)composite2);
        WorkbenchHelp.setHelp((Control)this.wizardSelectionViewer.getControl(), (String)(HyadesUIPlugin.getID() + ".swip0001"));
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.setErrorMessage(null);
        IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
        IWizardElement iWizardElement = (IWizardElement)iStructuredSelection.getFirstElement();
        if (iWizardElement == null) {
            this.setMessage(null);
            this.setSelectedNode(null);
            return;
        }
        this.setSelectedNode(this.createWizardNode(iWizardElement));
        this.setMessage(iWizardElement.getDescription());
    }

    public void doubleClick(DoubleClickEvent doubleClickEvent) {
        this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.wizardSelectionViewer, this.wizardSelectionViewer.getSelection()));
        this.getContainer().showPage(this.getNextPage());
    }

    public void saveWidgetValues() {
        IWizardElement iWizardElement;
        if (this.getDialogSettings() == null) {
            return;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.wizardSelectionViewer.getSelection();
        if (!iStructuredSelection.isEmpty() && (iWizardElement = (IWizardElement)iStructuredSelection.getFirstElement()).getId() != null) {
            this.getDialogSettings().put(SET_SELECTED_WIZARD_ID, iWizardElement.getId());
        }
    }

    private void restoreWidgetValues() {
        if (this.getDialogSettings() == null) {
            return;
        }
        String string = this.getDialogSettings().get(SET_SELECTED_WIZARD_ID);
        if (string == null) {
            return;
        }
        IWizardElement iWizardElement = this.findWizardElement(string);
        if (iWizardElement == null) {
            return;
        }
        StructuredSelection structuredSelection = new StructuredSelection((Object)iWizardElement);
        this.wizardSelectionViewer.setSelection((ISelection)structuredSelection);
        this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.wizardSelectionViewer, (ISelection)structuredSelection));
    }

    protected IWizardElement findWizardElement(String string) {
        int n = 0;
        while (n < this.wizardElements.length) {
            if (string.equals(this.wizardElements[n].getId())) {
                return this.wizardElements[n];
            }
            ++n;
        }
        return null;
    }

    protected IWizardNode createWizardNode(IWizardElement iWizardElement) {
        IWizard iWizard;
        IWizardNode iWizardNode = (IWizardNode)iWizardElement.getAdapter(class$org$eclipse$jface$wizard$IWizardNode == null ? (class$org$eclipse$jface$wizard$IWizardNode = SelectionPage.class$("org.eclipse.jface.wizard.IWizardNode")) : class$org$eclipse$jface$wizard$IWizardNode);
        if (iWizardNode != null && !iWizardNode.isContentCreated() && (iWizard = iWizardNode.getWizard()) instanceof IWorkbenchWizard) {
            ((IWorkbenchWizard)iWizard).init(this.getWorkbench(), this.getStructuredSelection());
            iWizard.addPages();
        }
        return iWizardNode;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

