/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.logc.internal.loader;

import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.cbe.CBEUtils;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.logc.extensions.ILogRecordCorrelationEngine;
import org.eclipse.hyades.logc.extensions.ILogRecordFilter;
import org.eclipse.hyades.logs.correlators.RecordList;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.hierarchy.CorrelationContainer;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.CorrelationEngine;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.impl.CorrelationEntryImpl;
import org.eclipse.hyades.sd.ui.internal.loader.IModelLoader;
import org.eclipse.hyades.sd.ui.internal.model.Graph;
import org.eclipse.hyades.sd.ui.internal.model.GraphNode;
import org.eclipse.hyades.sd.ui.internal.model.NodeConnection;
import org.eclipse.hyades.sd.ui.internal.model.NodeContainer;
import org.eclipse.hyades.sd.ui.internal.util.LogCDrawUtils;

public class LogLoader
implements IModelLoader {
    private EObject mofObject;
    protected Graph graph;
    protected Hashtable agents = new Hashtable();
    protected TRCAgentProxy[] agentList = new TRCAgentProxy[3];
    protected int nextAgent = 0;
    protected int selectedIndex = -1;
    private CorrelationContainerProxy correlationContainerProxy;

    public LogLoader() {
    }

    public LogLoader(Object object, Graph graph) {
        this.setObjectAndGraph(object, graph);
    }

    public void setObjectAndGraph(Object object, Graph graph) {
        this.mofObject = (EObject)object;
        this.graph = graph;
    }

    public void load() {
        this.loadAgents();
        IConfigurationElement iConfigurationElement = LogCDrawUtils.getCurrentPage().getCorrelationType();
        if (iConfigurationElement != null) {
            BasicEList basicEList = new BasicEList();
            String string = null;
            if (this.correlationContainerProxy == null) {
                ILogRecordCorrelationEngine iLogRecordCorrelationEngine = null;
                IConfigurationElement[] iConfigurationElementArray = this.addNodes(iConfigurationElement, basicEList);
                int n = 0;
                while (n < iConfigurationElementArray.length) {
                    if (iConfigurationElementArray[n].getName().equals("LogRecordCorrelationEngine")) {
                        try {
                            iLogRecordCorrelationEngine = (ILogRecordCorrelationEngine)iConfigurationElementArray[n].createExecutableExtension("class");
                            string = iConfigurationElement.getAttribute("name");
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                    }
                    ++n;
                }
                if (iLogRecordCorrelationEngine != null && this.agentList.length > 0) {
                    this.correlationContainerProxy = LoadersUtils.getCorrelationContainerProxy((TRCAgentProxy)this.agentList[0], string, (String)iConfigurationElement.getAttribute("name"));
                    CorrelationEngine correlationEngine = HierarchyFactory.eINSTANCE.createCorrelationEngine();
                    correlationEngine.setId(string);
                    correlationEngine.setType(iConfigurationElement.getAttribute("log_types"));
                    correlationEngine.setName(iConfigurationElement.getAttribute("name"));
                    this.correlationContainerProxy.setCorrelationEngine(correlationEngine);
                    int n2 = 1;
                    while (n2 < this.agentList.length) {
                        if (this.agentList[n2] != null) {
                            this.correlationContainerProxy.getCorrelatedAgents().add(this.agentList[n2]);
                        }
                        ++n2;
                    }
                    LogCDrawUtils.getCurrentPage().setCorrelationContainerProxy(this.correlationContainerProxy);
                    iLogRecordCorrelationEngine.correlate(this.correlationContainerProxy, (EList)basicEList);
                }
            }
            this.createCorrelation();
            basicEList.clear();
        } else if (this.correlationContainerProxy != null) {
            this.createCorrelation();
        } else {
            int n = 0;
            while (n < this.agentList.length) {
                if (this.agentList[n] != null) {
                    this.loadLog(this.agentList[n], null);
                }
                ++n;
            }
        }
    }

    private IConfigurationElement[] addNodes(IConfigurationElement iConfigurationElement, BasicEList basicEList) {
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren();
        ILogRecordFilter iLogRecordFilter = null;
        boolean bl = true;
        int n = 0;
        while (n < this.agentList.length) {
            if (this.agentList[n] != null) {
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    if (iConfigurationElementArray[n2].getName().equals("LogRecordFilter") && this.agentList[n].getName().equals(iConfigurationElementArray[n2].getAttribute("log_type"))) {
                        try {
                            iLogRecordFilter = (ILogRecordFilter)iConfigurationElementArray[n2].createExecutableExtension("class");
                            basicEList.add((Object)this.loadLog(this.agentList[n], iLogRecordFilter));
                            bl = false;
                        }
                        catch (CoreException coreException) {
                            basicEList.add((Object)this.loadLog(this.agentList[n], null));
                            bl = false;
                        }
                    } else if (this.agentList[n].getName().equals(iConfigurationElementArray[n2].getAttribute("log_type"))) {
                        basicEList.add((Object)this.loadLog(this.agentList[n], null));
                        bl = false;
                    }
                    ++n2;
                }
                if (bl) {
                    basicEList.add((Object)this.loadLog(this.agentList[n], null));
                }
            }
            bl = true;
            ++n;
        }
        return iConfigurationElementArray;
    }

    protected RecordList loadLog(TRCAgentProxy tRCAgentProxy, ILogRecordFilter iLogRecordFilter) {
        NodeContainer nodeContainer = this.addLog(tRCAgentProxy);
        RecordList recordList = null;
        recordList = iLogRecordFilter != null ? new RecordList(this.cbeEventFilter(iLogRecordFilter.filter(tRCAgentProxy.getAgent().getDefaultEvents())), tRCAgentProxy.getName()) : new RecordList(this.cbeEventFilter(tRCAgentProxy.getAgent().getDefaultEvents()), tRCAgentProxy.getName());
        nodeContainer.setName(this.addRecords(nodeContainer, recordList.getList()));
        return recordList;
    }

    public EList cbeEventFilter(EList eList) {
        BasicEList basicEList = new BasicEList();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof CBECommonBaseEvent)) continue;
            basicEList.add(e);
        }
        return basicEList;
    }

    private void createCorrelation() {
        Object var1_1 = null;
        Object var2_2 = null;
        Object var3_3 = null;
        CorrelationContainer correlationContainer = this.correlationContainerProxy.getCorrelationContainer();
        Iterator iterator = correlationContainer.getCorrelations().iterator();
        while (iterator.hasNext()) {
            Object object;
            CorrelationEntryImpl correlationEntryImpl = (CorrelationEntryImpl)iterator.next();
            if (correlationEntryImpl == null || correlationEntryImpl.getKey() == null || correlationEntryImpl.getValue() == null || !((object = correlationEntryImpl.getKey()) instanceof CBECommonBaseEvent)) continue;
            this.addConnections((CBECommonBaseEvent)correlationEntryImpl.getKey(), (EList)correlationEntryImpl.getValue());
        }
    }

    public void setSelectedIndex(int n) {
        this.selectedIndex = n;
    }

    protected void loadAgents() {
        if (this.mofObject instanceof CorrelationContainerProxy) {
            TRCAgentProxy tRCAgentProxy;
            this.correlationContainerProxy = (CorrelationContainerProxy)this.mofObject;
            Iterator iterator = ((CorrelationContainerProxy)this.mofObject).getCorrelatedAgents().iterator();
            while (iterator.hasNext()) {
                tRCAgentProxy = (TRCAgentProxy)iterator.next();
                if (tRCAgentProxy == null || tRCAgentProxy.eIsProxy()) continue;
                this.addAgent(tRCAgentProxy);
            }
            tRCAgentProxy = this.getCorrelation(this.correlationContainerProxy.getCorrelationEngine());
            if (tRCAgentProxy != null) {
                this.addNodes((IConfigurationElement)tRCAgentProxy, new BasicEList());
            } else if (this.isInternalCorrelation(this.correlationContainerProxy)) {
                this.addAllNodes();
            }
        } else if (this.mofObject instanceof TRCMonitor) {
            this.loadAllAgents((TRCMonitor)this.mofObject);
        } else if (this.mofObject instanceof TRCNode) {
            this.loadAllAgents((TRCNode)this.mofObject);
        } else if (this.mofObject instanceof TRCProcessProxy) {
            this.loadAllAgents((TRCProcessProxy)this.mofObject);
        } else if (this.mofObject instanceof TRCAgentProxy) {
            this.addAgent((TRCAgentProxy)this.mofObject);
        }
    }

    private boolean isInternalCorrelation(CorrelationContainerProxy correlationContainerProxy) {
        Iterator iterator = correlationContainerProxy.getCorrelatedAgents().iterator();
        while (iterator.hasNext()) {
            TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)iterator.next();
            if (!tRCAgentProxy.getInternalCorrelations().contains(correlationContainerProxy)) continue;
            return true;
        }
        return false;
    }

    private void addAllNodes() {
        int n = 0;
        while (n < this.agentList.length) {
            if (this.agentList[n] != null) {
                this.loadLog(this.agentList[n], null);
            }
            ++n;
        }
    }

    protected IConfigurationElement getCorrelation(CorrelationEngine correlationEngine) {
        String string = correlationEngine.getName();
        IPluginRegistry iPluginRegistry = Platform.getPluginRegistry();
        IExtensionPoint iExtensionPoint = iPluginRegistry.getExtensionPoint("org.eclipse.hyades.logc.logInteractionView");
        if (iExtensionPoint != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            int n = 0;
            while (n < iExtensionArray.length) {
                IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                    if ("view".equals(iConfigurationElementArray[n2].getName()) && iConfigurationElementArray[n2].getAttribute("name").equals(string)) {
                        return iConfigurationElement;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return null;
    }

    protected void loadAllAgents(TRCMonitor tRCMonitor) {
        if (tRCMonitor != null) {
            Iterator iterator = tRCMonitor.getNodes().iterator();
            while (iterator.hasNext()) {
                TRCNode tRCNode = (TRCNode)iterator.next();
                if (tRCNode == null) continue;
                this.loadAllAgents(tRCNode);
            }
        }
    }

    protected void loadAllAgents(TRCNode tRCNode) {
        Iterator iterator = tRCNode.getProcessProxies().iterator();
        while (iterator.hasNext()) {
            TRCProcessProxy tRCProcessProxy = (TRCProcessProxy)iterator.next();
            if (tRCProcessProxy == null) continue;
            this.loadAllAgents(tRCProcessProxy);
        }
    }

    protected void loadAllAgents(TRCProcessProxy tRCProcessProxy) {
        Iterator iterator = tRCProcessProxy.getAgentProxies().iterator();
        while (iterator.hasNext()) {
            TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)iterator.next();
            if (tRCAgentProxy == null || tRCAgentProxy.eIsProxy()) continue;
            this.addAgent(tRCAgentProxy);
        }
    }

    protected void addAgent(TRCAgentProxy tRCAgentProxy) {
        if (this.agents.containsKey(tRCAgentProxy)) {
            return;
        }
        this.agents.put(tRCAgentProxy, new Double(0.0));
        try {
            this.agentList[this.nextAgent] = tRCAgentProxy;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            TRCAgentProxy[] tRCAgentProxyArray = new TRCAgentProxy[this.agentList.length + 16];
            System.arraycopy(this.agentList, 0, tRCAgentProxyArray, 0, this.agentList.length);
            this.agentList = tRCAgentProxyArray;
            this.agentList[this.nextAgent] = tRCAgentProxy;
        }
        ++this.nextAgent;
    }

    protected NodeContainer addLog(Object object) {
        if (object instanceof TRCAgentProxy) {
            NodeContainer nodeContainer = this.graph.createNodeContainer();
            nodeContainer.setShortName(((TRCAgentProxy)object).getName());
            this.graph.addTopNode((GraphNode)nodeContainer);
            nodeContainer.setGraph(this.graph);
            nodeContainer.setType(11);
            return nodeContainer;
        }
        return null;
    }

    protected String addRecords(NodeContainer nodeContainer, EList eList) {
        String string = "";
        double d = 0.0;
        int n = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = 0;
        while (n2 < eList.size()) {
            if (eList.get(n2) != null && eList.get(n2) instanceof CBECommonBaseEvent) {
                GraphNode graphNode = this.graph.createGraphNode();
                graphNode.setName(((CBECommonBaseEvent)eList.get(n2)).getMsg());
                d = CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)eList.get(n2)));
                if (n2 == 0) {
                    string = ((CBECommonBaseEvent)eList.get(n2)).getSourceComponentId().getLocation();
                }
                if ((d3 = d - d2) == 0.0) {
                    if (this.graph.getIncrementList()[n2 + n] == null) {
                        this.graph.addIncrementAppendDup(0.0);
                    }
                    graphNode.setStartIncrement(this.graph.getIncrementList()[n2 + n]);
                    if (this.graph.getIncrementList()[n2 + 1 + n] == null) {
                        this.graph.addIncrementAppendDup(0.0);
                    }
                    graphNode.setEndIncrement(this.graph.getIncrementList()[n2 + 1 + n]);
                } else if (d3 > 0.0) {
                    if (this.graph.getIncrementList()[n2 + n] == null) {
                        this.graph.addIncrementAppendDup(0.0);
                    }
                    if (this.graph.getIncrementList()[n2 + 1 + n] == null) {
                        this.graph.addIncrementAppendDup(d3);
                    }
                    graphNode.setStartIncrement(this.graph.getIncrementList()[n2 + 1 + n]);
                    if (this.graph.getIncrementList()[n2 + 2 + n] == null) {
                        this.graph.addIncrementAppendDup(0.0);
                    }
                    graphNode.setEndIncrement(this.graph.getIncrementList()[n2 + 2 + n]);
                    d2 = d;
                    ++n;
                }
                graphNode.setContainer(nodeContainer);
                graphNode.setUserArea(eList.get(n2));
                nodeContainer.addInternalNode(graphNode);
                graphNode.setStartTime(d);
                graphNode.setEndTime(d);
                graphNode.setType(10);
            }
            ++n2;
        }
        return string;
    }

    private void addConnections(CBECommonBaseEvent cBECommonBaseEvent, EList eList) {
        Object var3_3 = null;
        GraphNode graphNode = null;
        GraphNode graphNode2 = null;
        graphNode = this.getGraphNodeFromArtifact(cBECommonBaseEvent);
        int n = 0;
        while (n < eList.size()) {
            Object e = eList.get(n);
            if (e instanceof CBECommonBaseEvent) {
                graphNode2 = this.getGraphNodeFromArtifact((CBECommonBaseEvent)eList.get(n));
                if (graphNode2 != null) {
                    this.createConnection(graphNode, graphNode2);
                }
                graphNode2 = null;
            }
            ++n;
        }
    }

    private GraphNode getGraphNodeFromArtifact(CBECommonBaseEvent cBECommonBaseEvent) {
        GraphNode graphNode = null;
        GraphNode graphNode2 = null;
        int n = 0;
        while (n < this.graph.getTopNodeCount()) {
            int n2 = 0;
            while (n2 < ((NodeContainer)this.graph.getTopNodes()[n]).getInternalNodeCount()) {
                graphNode = ((NodeContainer)this.graph.getTopNodes()[n]).getInternalNodes()[n2];
                if (graphNode != null && cBECommonBaseEvent == graphNode.getUserArea()) {
                    graphNode2 = graphNode;
                    break;
                }
                ++n2;
            }
            ++n;
        }
        return graphNode2;
    }

    private NodeConnection createConnection(GraphNode graphNode, GraphNode graphNode2) {
        NodeConnection nodeConnection = this.graph.createNodeConnection();
        nodeConnection.setName(graphNode2.getName());
        nodeConnection.setShortName(graphNode2.getShortName());
        nodeConnection.setSecondaryName(graphNode2.getSecondaryName());
        nodeConnection.setTarget(graphNode2);
        nodeConnection.setSource(graphNode);
        nodeConnection.setType(5);
        nodeConnection.setEndIncrement(graphNode2.getStartIncrement());
        nodeConnection.setStartIncrement(nodeConnection.getEndIncrement());
        if (nodeConnection.getStartTime() > graphNode.getEndTime()) {
            graphNode.setEndIncrement(nodeConnection.getStartIncrement());
        }
        graphNode2.addTargetConnection(nodeConnection);
        graphNode.addSourceConnection(nodeConnection);
        return nodeConnection;
    }
}

