/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.parsers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Util;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IParser;
import org.eclipse.hyades.logging.adapter.MessageString;
import org.eclipse.hyades.logging.adapter.impl.ProcessUnit;
import org.eclipse.hyades.logging.adapter.parsers.AttributeStatement;
import org.eclipse.hyades.logging.adapter.parsers.GroupStatement;
import org.eclipse.hyades.logging.adapter.parsers.IStatement;
import org.eclipse.hyades.logging.adapter.parsers.PreparationException;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Parser
extends ProcessUnit
implements IParser {
    private static PatternCompiler compiler = new Perl5Compiler();
    private static PatternMatcher matcher = new Perl5Matcher();
    private List ruleSets;
    private String separator;
    private String hashing;
    private Pattern separatorPattern;

    public static final PatternCompiler getCompiler() {
        return compiler;
    }

    public static PatternMatcher getPatternMatcher() {
        return matcher;
    }

    public void update() throws AdapterInvalidConfig {
        int n;
        super.update();
        Element element = this.getConfiguration();
        if (!element.getNodeName().equals(Messages.getString("HyadesGAParserTagName"))) {
            throw new AdapterInvalidConfig("cc:Parser expected to contain parsing rules");
        }
        NodeList nodeList = element.getChildNodes();
        this.separator = element.getAttribute(Messages.getString("HyadesGASeparatorTokenAttributeName"));
        this.hashing = element.getAttribute(Messages.getString("HyadesGADesignationTokenName"));
        if (this.separator != null && !this.separator.equals("")) {
            try {
                this.separatorPattern = compiler.compile(this.separator);
            }
            catch (MalformedPatternException malformedPatternException) {
                throw new PreparationException(malformedPatternException);
            }
        }
        if ((n = nodeList.getLength()) > 0) {
            this.ruleSets = new ArrayList();
            int n2 = 0;
            while (n2 < n) {
                block15: {
                    Element element2 = null;
                    try {
                        element2 = (Element)nodeList.item(n2);
                    }
                    catch (ClassCastException classCastException) {
                        break block15;
                    }
                    if (element2 != null) {
                        IStatement iStatement = null;
                        if (element2.getNodeName().endsWith(Messages.getString("HyadesGARuleElementTagName"))) {
                            iStatement = new GroupStatement();
                        } else if (element2.getNodeName().endsWith(Messages.getString("HyadesRuleAttributeTagName"))) {
                            iStatement = new AttributeStatement();
                        } else {
                            throw new AdapterInvalidConfig();
                        }
                        try {
                            iStatement.prepare(element2, null);
                            this.ruleSets.add(iStatement);
                        }
                        catch (PreparationException preparationException) {
                            this.log(Messages.getString("HyadesGAMalformedParserExpression") + " " + preparationException.getDetails() + ". ", (short)50);
                            this.log(Messages.getString("HyadesGAMalformedParserExpressionIgnored") + " " + preparationException.getDigraph(), (short)50);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    public Object[] processEventItems(Object[] objectArray) {
        if (this.ruleSets != null) {
            ArrayList arrayList = new ArrayList();
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] != null) {
                    HashMap hashMap = this.prepareEnvData(((MessageString)objectArray[n]).getValue());
                    ListIterator listIterator = this.ruleSets.listIterator();
                    ArrayList arrayList2 = new ArrayList();
                    while (listIterator.hasNext()) {
                        IStatement iStatement = (IStatement)listIterator.next();
                        iStatement.run(((MessageString)objectArray[n]).getValue(), hashMap, arrayList2);
                    }
                    arrayList.add(arrayList2);
                }
                ++n;
            }
            return arrayList.toArray();
        }
        return null;
    }

    public Object[] testProcessEventItems(Object[] objectArray) throws AdapterInvalidConfig {
        if (!(objectArray instanceof MessageString[])) {
            throw new AdapterInvalidConfig("This parser will only accept arrays of MessageString");
        }
        return objectArray;
    }

    private HashMap prepareEnvData(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList arrayList = new ArrayList();
        if (this.separator == null || this.separator.equals("")) {
            return hashMap;
        }
        Util.split(arrayList, (PatternMatcher)matcher, (Pattern)this.separatorPattern, (String)string);
        ListIterator listIterator = arrayList.listIterator();
        boolean bl = false;
        boolean bl2 = false;
        int n = -1;
        int n2 = 0;
        int n3 = string.length();
        while (listIterator.hasNext()) {
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = "";
            String string3 = "";
            String string4 = (String)listIterator.next();
            n = string4.indexOf(this.hashing);
            if (n < 0 && !bl2) continue;
            if (n < string4.length() - 1) {
                if (!bl2 && n >= 0) {
                    string2 = string4.substring(0, n);
                    string3 = string4.substring(n + 1);
                }
                if (!bl2 && (string3.startsWith("\"") || string3.startsWith("\\'"))) {
                    bl2 = true;
                    if ((string3 = string3.substring(1)).startsWith("\"") || string3.startsWith("\\'")) {
                        bl = true;
                    }
                }
            }
            if (bl) {
                if (string3.endsWith("\"") || string3.endsWith("\\'")) {
                    stringBuffer.append(string3.substring(0, string3.length() - 1));
                    bl2 = false;
                    hashMap.put(string2.trim(), stringBuffer.toString().trim());
                    bl = false;
                    continue;
                }
                stringBuffer.append(string3);
                if (n2 + 1 >= n3) continue;
                stringBuffer.append(string.substring(n2, n2 + 1));
                continue;
            }
            bl2 = false;
            hashMap.put(string2.trim(), string3.trim());
        }
        return hashMap;
    }

    static {
        ((Perl5Matcher)matcher).setMultiline(true);
    }
}

