/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.wizard;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.models.internal.sdb.impl.SDBResourceFactoryImpl;
import org.eclipse.hyades.models.internal.sdb.impl.SDBResourceSetImpl;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.SDbPluginImages;
import org.eclipse.hyades.sdb.internal.help.ContextIds;
import org.eclipse.hyades.sdb.internal.util.GridUtil;
import org.eclipse.hyades.sdb.internal.util.SymptomDBExportToV4Util;
import org.eclipse.hyades.sdb.internal.util.SymptomDBExportUtil;
import org.eclipse.hyades.sdb.internal.util.SymptomDBSelectionDialog;
import org.eclipse.hyades.sdb.internal.util.TString;
import org.eclipse.hyades.sdb.internal.wizard.ExportSymptomDBWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class ExportSymptomDBWizardPage
extends WizardDataTransferPage
implements Listener,
ModifyListener,
IRunnableWithProgress {
    private Text txtSourceFileName;
    private Text txtTargetFileName;
    private Button btnSourceBrowse;
    private Button btnTargetBrowse;
    private Button btnOldVersion;
    private Button btnNewVersion;
    private Button btnOverwriteCheckbox;
    private Button btnCreateFolderCheckbox;
    private SDBRuntime root = null;
    private boolean exception = false;
    private File output = null;
    private Writer writer = null;
    private String lastTargetFolder = "";
    private boolean v5 = true;
    private String extension = "trcdbxmi";
    private String sourceName = "";

    protected ExportSymptomDBWizardPage(String string) {
        super(string);
        this.setTitle(SDbPlugin.getResourceString("STR_EXPORT_SYMPTOM_DB_PTITLE"));
        this.setDescription(SDbPlugin.getResourceString("STR_EXPORT_SYMPTOM_DB_PDESC"));
        this.setImageDescriptor(SDbPluginImages.getImageDescriptor("export_symptomdb_wiz.gif"));
    }

    public void handleEvent(Event event) {
        this.setErrorMessage(null);
        if (event.widget == this.btnTargetBrowse) {
            this.showTargetDialog();
        }
        if (event.widget == this.btnSourceBrowse) {
            this.showFileDialog();
        }
    }

    protected boolean allowNewContainerName() {
        return true;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        GridData gridData = GridUtil.createFill();
        gridData.widthHint = 300;
        composite2.setLayoutData((Object)gridData);
        composite2.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 10;
        gridLayout.horizontalSpacing = 4;
        gridData = GridUtil.createHorizontalFill();
        gridData.widthHint = 300;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)gridData);
        Label label = new Label(composite3, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setText(SDbPlugin.getResourceString("STR_SYMPTOM_DB_SOURCE"));
        this.txtSourceFileName = new Text(composite3, 2048);
        gridData = GridUtil.createHorizontalFill();
        this.txtSourceFileName.setLayoutData((Object)gridData);
        this.btnSourceBrowse = new Button(composite3, 8);
        this.btnSourceBrowse.setText(SDbPlugin.getResourceString("STR_IMPORT_LOG_FILE_BROWSE1"));
        Composite composite4 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 10;
        gridLayout.horizontalSpacing = 4;
        gridData = GridUtil.createHorizontalFill();
        gridData.widthHint = 300;
        composite4.setLayout((Layout)gridLayout);
        composite4.setLayoutData((Object)gridData);
        Label label2 = new Label(composite4, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        label2.setLayoutData((Object)gridData);
        label2.setText(SDbPlugin.getResourceString("STR_EXPORT_DESTINATION"));
        Label label3 = new Label(composite4, 0);
        gridData = new GridData();
        label3.setLayoutData((Object)gridData);
        label3.setText(SDbPlugin.getResourceString("STR_EXPORT_DEST_LABEL"));
        this.txtTargetFileName = new Text(composite4, 2048);
        this.txtTargetFileName.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.btnTargetBrowse = new Button(composite4, 8);
        this.btnTargetBrowse.setText(SDbPlugin.getResourceString("STR_IMPORT_XMLLOG_BROWSE"));
        this.createSpacer(composite2);
        this.createVersionGroup(composite2);
        this.createSpacer(composite2);
        this.createPlainLabel(composite2, SDbPlugin.getResourceString("ExportDBWizardPage.options"));
        this.createOptionsGroup(composite2);
        this.initControls();
        this.setControl((Control)composite2);
        this.btnSourceBrowse.addListener(13, (Listener)this);
        this.btnTargetBrowse.addListener(13, (Listener)this);
        this.txtTargetFileName.addModifyListener((ModifyListener)this);
        this.txtSourceFileName.addModifyListener((ModifyListener)this);
        WorkbenchHelp.setHelp((Control)this.txtSourceFileName, (String)ContextIds.EXPORT_SYMDB_RESOURCE);
        WorkbenchHelp.setHelp((Control)this.txtTargetFileName, (String)ContextIds.EXPORT_SYMDB_DESTINATION);
        this.setPageComplete(this.determinePageCompletion());
    }

    protected void createVersionGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(SDbPlugin.getResourceString("STR_EXPORT_TO_VERSION"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        GridData gridData = new GridData();
        gridData.horizontalIndent = 15;
        gridData.widthHint = -1;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData);
        this.btnNewVersion = new Button((Composite)group, 16);
        this.btnNewVersion.setText(SDbPlugin.getResourceString("STR_EXPORT_NEW_VERSION"));
        this.btnNewVersion.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.btnOldVersion = new Button((Composite)group, 16);
        this.btnOldVersion.setText(SDbPlugin.getResourceString("STR_EXPORT_OLD_VERSION"));
        this.btnOldVersion.setLayoutData((Object)GridUtil.createHorizontalFill());
        WorkbenchHelp.setHelp((Control)group, (String)ContextIds.EXPORT_SYMDB_XML_FORMAT);
    }

    protected void createOptionsGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.btnOverwriteCheckbox = new Button(composite2, 16416);
        this.btnOverwriteCheckbox.setText(SDbPlugin.getResourceString("ExportDBWizardPage.override.text"));
        this.btnOverwriteCheckbox.addListener(13, (Listener)this);
        WorkbenchHelp.setHelp((Control)this.btnOverwriteCheckbox, (String)ContextIds.EXPORT_SYMDB_OVERWRITE_FILE);
    }

    public void modifyText(ModifyEvent modifyEvent) {
        this.setErrorMessage(null);
        this.setPageComplete(this.determinePageCompletion());
    }

    private void showFileDialog() {
        Object[] objectArray;
        String string = "";
        SymptomDBSelectionDialog symptomDBSelectionDialog = new SymptomDBSelectionDialog(this.getShell(), SDbPlugin.getResourceString("STR_RES_DLG_MSG"));
        if (symptomDBSelectionDialog.open() == 0 && (objectArray = symptomDBSelectionDialog.getResult()) != null && objectArray.length == 1 && objectArray[0] != null) {
            IPath iPath = (IPath)objectArray[0];
            string = iPath.toOSString();
            this.sourceName = iPath.toString();
        }
        if (string != null && !string.equals("")) {
            this.txtSourceFileName.setText(string);
        }
        this.setPageComplete(this.determinePageCompletion());
    }

    private void showTargetDialog() {
        String string = this.txtSourceFileName.getText();
        string = this.getTargetFileNameFromSourceName(string);
        FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
        if (this.lastTargetFolder.length() > 0) {
            fileDialog.setFilterPath(this.lastTargetFolder);
        }
        fileDialog.setFileName(string);
        fileDialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
        String string2 = fileDialog.open();
        if (string2 != null) {
            this.txtTargetFileName.setText(string2);
            this.lastTargetFolder = this.getDirectoryName(string2);
        }
        this.setPageComplete(this.determinePageCompletion());
    }

    private String getTargetFileNameFromSourceName(String string) {
        int n = string.indexOf("trcdbxmi");
        if (n > -1) {
            string = string.substring(0, n) + "xml";
        }
        if ((n = string.lastIndexOf(File.separatorChar)) > -1) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public void run(IProgressMonitor iProgressMonitor) {
        try {
            String string = SDbPlugin.getResourceString("STR_EXPORT_GEN_XML_MSG");
            string = TString.change(string, "%1", this.output.getName());
            iProgressMonitor.beginTask(string, 10000);
            if (this.root == null) {
                this.loadModel(iProgressMonitor);
            }
            if (this.v5) {
                SymptomDBExportUtil symptomDBExportUtil = new SymptomDBExportUtil();
                this.writer.write(symptomDBExportUtil.generate(this.root, iProgressMonitor));
            } else {
                SymptomDBExportToV4Util symptomDBExportToV4Util = new SymptomDBExportToV4Util();
                this.writer.write(symptomDBExportToV4Util.generate(this.root, iProgressMonitor));
            }
            this.writer.flush();
            this.writer.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            iProgressMonitor.done();
            this.exception = true;
        }
        iProgressMonitor.done();
    }

    protected boolean determinePageCompletion() {
        boolean bl;
        boolean bl2 = bl = this.validateSourceGroup() && this.validateDestinationGroup();
        if (bl) {
            this.setErrorMessage(null);
        }
        return bl;
    }

    protected boolean validateSourceGroup() {
        boolean bl;
        String string = this.txtSourceFileName.getText().trim();
        if (string.equals("")) {
            return false;
        }
        if (!string.startsWith(new String(new char[]{File.separatorChar}))) {
            string = File.separatorChar + string;
        }
        if (!(bl = this.resourceExists(string))) {
            this.setErrorMessage(SDbPlugin.getResourceString("STR_INVALID_SOURCE_MSG"));
        }
        return bl;
    }

    protected boolean validateDestinationGroup() {
        return !this.txtTargetFileName.getText().trim().equals("");
    }

    protected boolean performFinish() {
        Object object;
        String string = this.txtTargetFileName.getText();
        String string2 = this.getDirectoryName(string);
        this.exception = false;
        if (!this.targetFolderExists(new File(string2))) {
            return false;
        }
        this.output = new File(string);
        if (this.output.exists() && !this.btnOverwriteCheckbox.getSelection() && (((String)(object = this.queryOverwrite(string))).equals("NO") || ((String)object).equals("NOALL") || ((String)object).equals("CANCEL"))) {
            return false;
        }
        try {
            object = new FileOutputStream(this.output.toString(), false);
            this.writer = new OutputStreamWriter((OutputStream)object, "UTF-8");
        }
        catch (IOException iOException) {
            String string3 = SDbPlugin.getResourceString("STR_CREATE_FILE_ERROR_");
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"), (String)string3);
            return false;
        }
        this.v5 = this.btnNewVersion.getSelection();
        try {
            this.getWizard().getContainer().run(true, true, (IRunnableWithProgress)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.exception = true;
        }
        if (this.exception) {
            object = SDbPlugin.getResourceString("STR_EXPORT_SYMPTOMDB_ERROR_");
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"), (String)object);
            return false;
        }
        return true;
    }

    private boolean targetFolderExists(File file) {
        if (!file.exists()) {
            if (!this.queryYesNoQuestion(SDbPlugin.getResourceString("STR_FOLDER_CREATION_MSG"))) {
                return false;
            }
            if (!file.mkdirs()) {
                String string = SDbPlugin.getResourceString("STR_FOLDER_CREATION_ERROR_");
                MessageDialog.openError((Shell)this.getContainer().getShell(), (String)SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"), (String)string);
                return false;
            }
        }
        return true;
    }

    private void initControls() {
        IFile iFile = ((ExportSymptomDBWizard)this.getWizard()).getFile();
        if (iFile != null) {
            String string = iFile.getFullPath().toOSString();
            this.sourceName = iFile.getFullPath().toString();
            this.txtSourceFileName.setText(string);
        }
        this.btnNewVersion.setSelection(true);
    }

    private void loadModel(IProgressMonitor iProgressMonitor) throws Exception {
        try {
            SDBResourceSetImpl sDBResourceSetImpl = new SDBResourceSetImpl();
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("trcdbxmi", new SDBResourceFactoryImpl());
            iProgressMonitor.worked(500);
            Resource resource = sDBResourceSetImpl.getResource(URI.createURI((String)("platform:/resource" + this.sourceName)), true);
            iProgressMonitor.worked(1000);
            Iterator iterator = resource.getContents().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof SDBRuntime)) continue;
                this.root = (SDBRuntime)e;
                iProgressMonitor.worked(500);
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    private String getDirectoryName(String string) {
        int n = string.lastIndexOf(File.separatorChar);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    private boolean resourceExists(String string) {
        IStatus iStatus = ResourcesPlugin.getWorkspace().validatePath(string, 1);
        if (iStatus.getSeverity() != 0) {
            return false;
        }
        Path path = new Path(string);
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        return iFile != null && iFile.exists();
    }
}

