/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.hyades.model.statistical.impl.StatisticalPackageImpl;
import org.eclipse.hyades.statistical.ui.Debugger;
import org.eclipse.hyades.statistical.ui.ImageManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class EditorPlugin
extends AbstractUIPlugin {
    public static final String PACKAGE_DEBUGGER = "org.eclipse.hyades.statistical.ui";
    public static final String PACKAGE_STATCON_MODULE = "org.eclipse.hyades.statistical.ui.StatConModule";
    public static final String PACKAGE_STATCON_FILE = "org.eclipse.hyades.statistical.ui.StatConFile";
    private static EditorPlugin plugin;
    public static Debugger DBG;
    private static ResourceBundle resourceBundle;
    public static ImageManager img;

    public static void disposeObject(Object object) throws Throwable {
        Class<?> clazz = object.getClass();
        Throwable throwable = null;
        while (clazz != null) {
            try {
                Method method = clazz.getDeclaredMethod("dispose", new Class[0]);
                ((AccessibleObject)method).setAccessible(true);
                method.invoke(object, new Object[0]);
                throwable = null;
                break;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                clazz = clazz.getSuperclass();
            }
        }
        if (throwable != null) {
            throw throwable;
        }
    }

    public EditorPlugin(IPluginDescriptor iPluginDescriptor) {
        super(iPluginDescriptor);
        plugin = this;
        DBG.setPlugin(this);
        DBG.info("StatCon Plugin Constructor");
        try {
            DBG.info("initializing images");
            img.initialize(new URL(this.getDescriptor().getInstallURL(), "icons/full/"), this.getImageRegistry());
            img.addImages();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        resourceBundle = this.getDescriptor().getResourceBundle();
        plugin = this;
        resourceBundle = this.getResourceBundle();
    }

    public void startup() throws CoreException {
        super.startup();
        DBG.info("calling StatisticalPackageImpl.init() to fix bugs");
        StatisticalPackageImpl.init();
    }

    public static EditorPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getString(String string) {
        try {
            return resourceBundle.getString(string);
        }
        catch (NullPointerException nullPointerException) {
            return string;
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public ResourceBundle getResourceBundle() {
        return resourceBundle;
    }

    public static Shell getActiveWorkbenchShell() {
        return EditorPlugin.getActiveWorkbenchWindow().getShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return EditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    static {
        DBG = new Debugger(PACKAGE_DEBUGGER);
        img = new ImageManager();
    }
}

