/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.widgets.internal.GData;
import org.eclipse.hyades.statistical.ui.widgets.spinner.internal.DateSpinner;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExportTimeDialog
extends Dialog {
    boolean DEBUG = true;
    Shell shell;
    Composite main_panel;
    Text avg_panel;
    DateSpinner start_panel;
    DateSpinner finish_panel;
    Composite button_panel;
    Button cancel_button;
    Button ok_button;
    long avg_period_ms;
    long start_t;
    long finish_t;
    public static final int OK = 0;
    public static final int CANCEL = 1;
    boolean ok = false;

    public ExportTimeDialog(Shell shell, long l, long l2, long l3) {
        super(shell);
        this.avg_period_ms = l;
        this.start_t = l2;
        this.finish_t = l3;
        this.setText(EditorPlugin.getString("EXPORT_TITLE"));
    }

    public int open() {
        Shell shell = this.getParent();
        this.shell = new Shell(shell, 67680);
        this.shell.setText(this.getText());
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.setSize(500, 220);
        this.initGraphics();
        this.shell.open();
        Display display = shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (this.ok) {
            return 0;
        }
        return 1;
    }

    public long getAveragePeriodMS() {
        return this.avg_period_ms;
    }

    public long getStartTime() {
        return this.start_t;
    }

    public long getMaxTime() {
        return this.finish_t;
    }

    private void initGraphics() {
        this.main_panel = new Composite((Composite)this.shell, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.main_panel.setLayout((Layout)gridLayout);
        new Label(this.main_panel, 0).setText(EditorPlugin.getString("EXPORT_AVERAGE_OVER"));
        this.avg_panel = new Text(this.main_panel, 2048);
        this.avg_panel.setLayoutData((Object)GData.getGridData(true, false, -1, -1, 1, 1, 4, 4));
        new Label(this.main_panel, 0).setText(EditorPlugin.getString("EXPORT_START_AT"));
        this.start_panel = new DateSpinner(this.main_panel, 0, false);
        this.start_panel.setLayoutData(GData.getGridData(true, false, -1, -1, 1, 1, 4, 4));
        new Label(this.main_panel, 0).setText(EditorPlugin.getString("EXPORT_FINISH_AT"));
        this.finish_panel = new DateSpinner(this.main_panel, 0, false);
        this.finish_panel.setLayoutData(GData.getGridData(true, false, -1, -1, 1, 1, 4, 4));
        this.button_panel = new Composite(this.main_panel, 0);
        this.button_panel.setLayoutData((Object)GData.getGridData(false, false, -1, -1, 2, 1, 2, 3));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.button_panel.setLayout((Layout)gridLayout);
        this.ok_button = new Button(this.button_panel, 0);
        this.ok_button.setLayoutData((Object)GData.getGridData(false, false, -1, -1, 1, 1, 2, 3));
        this.ok_button.setText(EditorPlugin.getString("OK"));
        this.cancel_button = new Button(this.button_panel, 0);
        this.cancel_button.setLayoutData((Object)GData.getGridData(false, false, -1, -1, 1, 1, 2, 3));
        this.cancel_button.setText(EditorPlugin.getString("CANCEL"));
        ButtonListener buttonListener = new ButtonListener();
        this.ok_button.addSelectionListener((SelectionListener)buttonListener);
        this.cancel_button.addSelectionListener((SelectionListener)buttonListener);
        this.avg_panel.setText("" + this.avg_period_ms / 1000L);
        this.start_panel.setDate(this.start_t);
        this.finish_panel.setDate(this.finish_t);
    }

    class ButtonListener
    implements SelectionListener {
        ButtonListener() {
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            this.widgetSelected(selectionEvent);
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (selectionEvent.getSource() == ExportTimeDialog.this.cancel_button) {
                ExportTimeDialog.this.ok = false;
                ExportTimeDialog.this.shell.dispose();
            } else if (selectionEvent.getSource() == ExportTimeDialog.this.ok_button) {
                ExportTimeDialog.this.ok = true;
                try {
                    ExportTimeDialog.this.avg_period_ms = 1000L * Long.parseLong(ExportTimeDialog.this.avg_panel.getText());
                    ExportTimeDialog.this.start_t = ExportTimeDialog.this.start_panel.getDate();
                    ExportTimeDialog.this.finish_t = ExportTimeDialog.this.finish_panel.getDate();
                    ExportTimeDialog.this.shell.dispose();
                }
                catch (NumberFormatException numberFormatException) {
                    MessageBox messageBox = new MessageBox(ExportTimeDialog.this.shell, 33);
                    messageBox.setText(EditorPlugin.getString("EXPORT_INVALID_PERIOD"));
                    messageBox.setMessage(ExportTimeDialog.this.avg_panel.getText() + " " + EditorPlugin.getString("EXPORT_INVALID_PERIOD_MSG"));
                }
            }
        }
    }
}

