/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.grapher.internal;

import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.BasicGraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.EnumerationGraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.IndicatorSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.TextGraph;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.TimeZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class EnumerationGraph
implements TextGraph {
    TimeZoomSlider xslider;
    ZoomSlider yslider;
    Color fg_col;
    int line_width = 1;
    int line_style = 1;
    EnumerationGraphSource source;

    public void setIndicatorSource(IndicatorSource indicatorSource) {
    }

    public EnumerationGraph(TimeZoomSlider timeZoomSlider, ZoomSlider zoomSlider, Color color, EnumerationGraphSource enumerationGraphSource) {
        this.xslider = timeZoomSlider;
        this.yslider = zoomSlider;
        this.fg_col = color;
        this.source = enumerationGraphSource;
    }

    public BasicGraphSource getGraphSource() {
        return this.source;
    }

    public double getXMin() {
        return this.source.getMin();
    }

    public double getXMax() {
        return this.source.getMax();
    }

    public double getYMin() {
        return Double.NEGATIVE_INFINITY;
    }

    public double getYMax() {
        return Double.POSITIVE_INFINITY;
    }

    public TimeZoomSlider getXSlider() {
        return this.xslider;
    }

    public ZoomSlider getYSlider() {
        return this.yslider;
    }

    public void setXSlider(TimeZoomSlider timeZoomSlider) {
        this.xslider = timeZoomSlider;
    }

    public void setYSlider(ZoomSlider zoomSlider) {
        this.yslider = zoomSlider;
    }

    public void setForeground(Color color) {
        this.fg_col = color;
    }

    public Color getForeground() {
        return this.fg_col;
    }

    public void setLineWidth(int n) {
        this.line_width = n;
    }

    public int getLineWidth() {
        return this.line_width;
    }

    public void setLineStyle(int n) {
        this.line_style = n;
    }

    public int getLineStyle() {
        return this.line_style;
    }

    public void setUseIndicator(boolean bl) {
    }

    public void paintGraph(GC gC, int n, int n2, int n3, int n4) {
        this.paintGraph(gC, n, n2, n3, n4, 0);
    }

    public int paintGraph(GC gC, int n, int n2, int n3, int n4, int n5) {
        int n6 = n5;
        int n7 = gC.getFontMetrics().getHeight();
        gC.setForeground(this.fg_col);
        gC.setLineWidth(this.line_width);
        gC.setLineStyle(this.line_style);
        Object object = null;
        int n8 = n;
        while (n8 < n + n3) {
            double d = this.xslider.pixel2Value(n8);
            if (d >= this.source.getMin() && d <= this.source.getMax()) {
                Object object2 = this.source.getValueAt(d);
                if (object2 != object && !object2.equals(object)) {
                    gC.setForeground(this.fg_col);
                    gC.drawLine(n8, n2, n8, n2 + n4);
                    gC.drawString(object2.toString(), n8 + 2, n6 + n2 + 1, true);
                    gC.setForeground(this.yslider.getDisplay().getSystemColor(2));
                    gC.drawString(object2.toString(), n8 + 1, n6 + n2, true);
                    if ((n6 += n7) + n7 > n4) {
                        n6 = 0;
                    }
                }
                object = object2;
            }
            ++n8;
        }
        return n6;
    }

    public void setStaticScaling(double d) {
    }

    public double getStaticScaling() {
        return 1.0;
    }
}

