/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.grapher.internal;

import java.util.AbstractCollection;
import java.util.ArrayList;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.Graph;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.GraphHighlighter;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.GraphSelectionSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.TextGraph;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class GraphCanvas
extends Canvas
implements PaintListener {
    ArrayList graphs = new ArrayList();
    private static final boolean PAINT_BUFFERED = true;
    int buffer_w = -1;
    int buffer_h = -1;
    Image buffer = null;
    GC buffer_gc = null;
    Color bgcol;
    GraphHighlighter highlighter = null;
    GraphSelectionSource selection_source = null;

    public GraphCanvas(Composite composite, int n) {
        super(composite, n | 0x40000);
        this.addPaintListener(this);
        this.setBackground(this.getDisplay().getSystemColor(25));
    }

    public void addGraph(Graph graph) {
        this.graphs.add(graph);
    }

    public void removeGraph(Graph graph) {
        ((AbstractCollection)this.graphs).remove(graph);
    }

    public void removeAllGraphs() {
        this.graphs.clear();
    }

    public void dispose() {
        super.dispose();
        if (this.buffer != null) {
            this.buffer.dispose();
            this.buffer_gc.dispose();
            if (this.bgcol != null) {
                this.bgcol.dispose();
            }
        }
    }

    public void setBackground(RGB rGB) {
        if (this.bgcol != null) {
            this.bgcol.dispose();
        }
        this.bgcol = new Color((Device)this.getDisplay(), rGB);
        super.setBackground(this.bgcol);
    }

    public void setGraphHighlighter(GraphHighlighter graphHighlighter) {
        this.highlighter = graphHighlighter;
    }

    public void setGraphSelectionSource(GraphSelectionSource graphSelectionSource) {
        this.selection_source = graphSelectionSource;
    }

    public void paintControl(PaintEvent paintEvent) {
        GC gC = paintEvent.gc;
        int n = paintEvent.x;
        int n2 = paintEvent.y;
        int n3 = paintEvent.width;
        int n4 = paintEvent.height;
        if (n3 < 1 || n4 < 1) {
            return;
        }
        if ((this.buffer_w < n3 || this.buffer_h < n4) && this.buffer != null) {
            this.buffer.dispose();
            this.buffer_gc.dispose();
            this.buffer = null;
            this.buffer_gc = null;
        }
        if (this.buffer == null) {
            if (this.getDisplay() == null) {
                return;
            }
            this.buffer_w = Math.max(this.buffer_w, n3);
            this.buffer_h = Math.max(this.buffer_h, n4);
            this.buffer = new Image((Device)this.getDisplay(), this.buffer_w, this.buffer_h);
            this.buffer_gc = new GC((Drawable)this.buffer);
        }
        this.paintUnbuffered(this.buffer_gc, n, n2, n3, n4);
        gC.drawImage(this.buffer, 0, 0);
    }

    public void paintUnbuffered(GC gC, int n, int n2, int n3, int n4) {
        Graph graph = null;
        if (this.highlighter != null && this.selection_source != null) {
            graph = this.selection_source.getSelectedGraph();
        }
        Color color = this.getBackground();
        gC.setBackground(color);
        gC.fillRectangle(n, n2, n3, n4);
        int n5 = 0;
        int n6 = 0;
        while (n6 < this.graphs.size()) {
            Graph graph2 = (Graph)this.graphs.get(n6);
            if (graph2 == graph) {
                this.highlighter.setHighlight(graph2);
            }
            if (graph2 instanceof TextGraph) {
                n5 = ((TextGraph)graph2).paintGraph(gC, n, n2, n3, n4, n5);
            } else {
                graph2.paintGraph(gC, n, n2, n3, n4);
            }
            if (graph2 == graph) {
                this.highlighter.unsetHighlight(graph2);
            }
            ++n6;
        }
    }
}

