/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.grapher.internal;

import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.BasicGraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.Graph;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.GraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.IndicatorSource;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.TimeZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomIndicator;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSliderTick;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class LineGraph
implements Graph {
    public static final int TYPE_NEAREST = 0;
    public static final int TYPE_AVERAGE = 1;
    public static final int TYPE_SUM = 2;
    private static final boolean DRAW_ONLY_IF_DATA = true;
    GraphSource source;
    ZoomSlider yslider;
    TimeZoomSlider xslider;
    Color fg_col;
    int line_width = 1;
    int line_style = 1;
    int type;
    double scaling = 1.0;
    double last_drawn_value = 0.0;
    boolean pixel_perfect = false;
    boolean use_indicators = true;
    ZoomIndicator indicator;
    IndicatorSource isource;

    public LineGraph(int n, GraphSource graphSource, TimeZoomSlider timeZoomSlider, ZoomSlider zoomSlider, Color color) {
        this.type = n;
        this.source = graphSource;
        this.fg_col = color;
        this.xslider = timeZoomSlider;
        this.yslider = zoomSlider;
        this.init();
    }

    public LineGraph(int n, GraphSource graphSource, TimeZoomSlider timeZoomSlider, ZoomSlider zoomSlider, Color color, boolean bl, boolean bl2) {
        this.type = n;
        this.source = graphSource;
        this.fg_col = color;
        this.xslider = timeZoomSlider;
        this.yslider = zoomSlider;
        this.pixel_perfect = bl;
        this.use_indicators = bl2;
        this.init();
    }

    public BasicGraphSource getGraphSource() {
        return this.source;
    }

    private void init() {
        if (this.use_indicators) {
            this.indicator = new ZoomIndicator(this.yslider, this.last_drawn_value, this.fg_col);
            this.yslider.addZoomIndicator(this.indicator);
        }
    }

    public void setIndicatorSource(IndicatorSource indicatorSource) {
        this.isource = indicatorSource;
    }

    public void setUseIndicator(boolean bl) {
        if (this.use_indicators && !bl) {
            this.yslider.removeIndicator(this.indicator);
            this.indicator.dispose();
        } else if (!this.use_indicators && bl) {
            this.indicator = new ZoomIndicator(this.yslider, this.last_drawn_value, this.fg_col);
            this.yslider.addZoomIndicator(this.indicator);
        }
        this.use_indicators = bl;
    }

    public double getXMin() {
        return this.source.getMin();
    }

    public double getXMax() {
        return this.source.getMax();
    }

    public double getYMin() {
        return this.source.getValueMin();
    }

    public double getYMax() {
        return this.source.getValueMax();
    }

    public void setForeground(Color color) {
        this.fg_col = color;
        if (this.use_indicators) {
            this.indicator.setColor(color);
        }
    }

    public Color getForeground() {
        return this.fg_col;
    }

    public void setLineWidth(int n) {
        this.line_width = n;
    }

    public int getLineWidth() {
        return this.line_width;
    }

    public void setLineStyle(int n) {
        this.line_style = n;
    }

    public int getLineStyle() {
        return this.line_style;
    }

    public void paintGraph(GC gC, int n, int n2, int n3, int n4) {
        gC.setForeground(this.fg_col);
        gC.setLineWidth(this.line_width);
        gC.setLineStyle(this.line_style);
        ZoomSliderTick zoomSliderTick = this.xslider.getFirstTick();
        ZoomSliderTick zoomSliderTick2 = this.xslider.getLastTick();
        if (zoomSliderTick == null || zoomSliderTick2 == null) {
            return;
        }
        double d = this.xslider.getIncrement();
        double d2 = zoomSliderTick.value - d;
        double d3 = zoomSliderTick2.value;
        if (this.pixel_perfect) {
            d = this.xslider.getUnitIncrement();
        }
        boolean bl = false;
        double d4 = this.isource.getIndicatorLocation();
        double d5 = this.last_drawn_value;
        int n5 = this.isource.getSourceType();
        boolean bl2 = true;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = d2;
        while (d9 <= d3) {
            double d10 = d9;
            if (!(d9 > this.source.getMax() + d) && !(d9 < this.source.getMin() - d)) {
                double d11;
                double d12;
                double d13;
                if (bl2) {
                    bl2 = false;
                    d13 = this.source.getValueAt(d10);
                    d8 = d13 *= this.scaling;
                    d12 = this.xslider.value2Pixel(d10);
                    d11 = this.yslider.value2Pixel(d13);
                    gC.drawLine((int)d12, (int)d11, (int)d12, (int)d11);
                } else {
                    d13 = 0.0;
                    d13 = this.type == 0 ? this.source.getValueAt(d10) : (this.type == 1 ? this.source.getAverageBetween(d10 - d, d10) : (this.type == 2 ? this.source.getSumBetween(d10 - d, d10) : this.source.getAverageBetween(d10 - d, d10)));
                    d13 *= this.scaling;
                    if (n5 == 0 && d4 > d10 - d && d4 < d10) {
                        bl = true;
                        d5 = d13;
                    }
                    d8 = d13;
                    d12 = this.xslider.value2Pixel(d10);
                    d11 = this.yslider.value2Pixel(d13);
                    if (n5 == 1 && d4 > d6 && d4 < d12) {
                        bl = true;
                        d5 = d13;
                    }
                    gC.drawLine((int)d6, (int)d7, (int)d12, (int)d11);
                }
                d6 = d12;
                d7 = d11;
            }
            d9 += d;
        }
        this.last_drawn_value = d8;
        if (this.isource == null || !bl) {
            this.indicator.setValue(this.last_drawn_value);
        } else {
            this.indicator.setValue(d5);
        }
        this.yslider.updateIndicators();
    }

    public void paintGraphNearest(GC gC, int n, int n2, int n3, int n4) {
    }

    public TimeZoomSlider getXSlider() {
        return this.xslider;
    }

    public ZoomSlider getYSlider() {
        return this.yslider;
    }

    public void setXSlider(TimeZoomSlider timeZoomSlider) {
        this.xslider = timeZoomSlider;
    }

    public void setYSlider(ZoomSlider zoomSlider) {
        if (this.use_indicators) {
            this.yslider.removeIndicator(this.indicator);
            this.indicator.dispose();
        }
        this.yslider = zoomSlider;
        if (this.use_indicators) {
            this.indicator = new ZoomIndicator(this.yslider, this.last_drawn_value, this.fg_col);
            this.yslider.addZoomIndicator(this.indicator);
        }
    }

    public void setStaticScaling(double d) {
        this.scaling = d;
    }

    public double getStaticScaling() {
        return this.scaling;
    }
}

