/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal;

import java.util.Vector;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomControlBar;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSliderUtilities;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public class ZoomControlBarsCollection {
    ZoomSlider slider;
    double max;
    double min;
    Vector bars = new Vector();
    boolean selected;
    boolean primed;
    boolean moved;

    public ZoomControlBarsCollection(ZoomSlider zoomSlider) {
        this.slider = zoomSlider;
    }

    public void add(ZoomControlBar zoomControlBar) {
        if (zoomControlBar != null && !this.bars.contains(zoomControlBar)) {
            this.bars.addElement(zoomControlBar);
        }
    }

    public void remove(ZoomControlBar zoomControlBar) {
        if (zoomControlBar != null && this.bars.contains(zoomControlBar)) {
            this.bars.removeElement(zoomControlBar);
        }
        this.selected = false;
    }

    public boolean hasBars() {
        return !this.bars.isEmpty();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isPrimed() {
        return this.primed;
    }

    public void paint(Image image, GC gC, GC gC2, boolean bl) {
        if (!this.selected) {
            int n = 0;
            while (n < this.bars.size()) {
                ((ZoomControlBar)this.bars.elementAt(n)).paint(gC);
                ++n;
            }
            gC2.drawImage(image, 0, 0);
        } else {
            if (!this.primed || bl) {
                int n = 0;
                while (n < this.bars.size() - 1) {
                    ((ZoomControlBar)this.bars.elementAt(n)).paint(gC);
                    ++n;
                }
                this.primed = true;
            }
            ((ZoomControlBar)this.bars.elementAt(this.bars.size() - 1)).hide(image, gC);
            gC2.drawImage(image, 0, 0);
            ((ZoomControlBar)this.bars.elementAt(this.bars.size() - 1)).paint(gC2);
        }
    }

    public boolean mouseDown(MouseEvent mouseEvent) {
        this.selected = false;
        this.primed = false;
        this.moved = false;
        ZoomControlBar zoomControlBar = this.getZoomControlBarContaining(mouseEvent.x, mouseEvent.y);
        if (zoomControlBar != null) {
            this.selected = true;
            this.bars.removeElement(zoomControlBar);
            this.bars.addElement(zoomControlBar);
            if (mouseEvent.button == 1) {
                this.slider.updateScale();
                this.slider.redraw();
                this.primed = false;
            }
            return true;
        }
        return false;
    }

    public boolean mouseUp(MouseEvent mouseEvent) {
        if (this.selected) {
            ZoomControlBar zoomControlBar = (ZoomControlBar)this.bars.elementAt(this.bars.size() - 1);
            zoomControlBar.sprayZoomControlBarEvent(true);
            this.selected = false;
            this.primed = false;
            if (!this.moved) {
                int n = (int)this.slider.value2Pixel(zoomControlBar.getValue());
                int n2 = this.bars.size() - 2;
                while (n2 >= 0) {
                    ZoomControlBar zoomControlBar2 = (ZoomControlBar)this.bars.elementAt(n2);
                    int n3 = (int)this.slider.value2Pixel(zoomControlBar2.getValue());
                    if (n3 > n - 3 && n3 < n + 3) {
                        this.bars.removeElement(zoomControlBar);
                        this.bars.insertElementAt(zoomControlBar, 0);
                        this.bars.removeElement(zoomControlBar2);
                        this.bars.addElement(zoomControlBar2);
                        break;
                    }
                    --n2;
                }
            }
            this.moved = false;
            this.slider.redraw();
            return true;
        }
        return false;
    }

    public boolean mouseMove(MouseEvent mouseEvent) {
        if (this.primed) {
            this.moved = true;
            ZoomControlBar zoomControlBar = (ZoomControlBar)this.bars.elementAt(this.bars.size() - 1);
            double d = zoomControlBar.getValue();
            if (this.slider.getOrientation() == 0) {
                zoomControlBar.setValue(ZoomSliderUtilities.round(this.slider.pixel2Value(mouseEvent.y), this.slider.getUnitIncrement()));
            } else {
                zoomControlBar.setValue(ZoomSliderUtilities.round(this.slider.pixel2Value(mouseEvent.x), this.slider.getUnitIncrement()));
            }
            this.slider.redraw();
            if (d != zoomControlBar.getValue()) {
                zoomControlBar.sprayZoomControlBarEvent(false);
            }
        }
        return false;
    }

    public ZoomControlBar getZoomControlBarContaining(int n, int n2) {
        if (this.bars.size() > 0) {
            int n3 = this.bars.size() - 1;
            while (n3 >= 0 && !((ZoomControlBar)this.bars.elementAt(n3)).inside(n, n2)) {
                --n3;
            }
            if (n3 >= 0) {
                return (ZoomControlBar)this.bars.elementAt(n3);
            }
        }
        return null;
    }

    public Vector getZoomControlBars() {
        return this.bars;
    }

    public void dispose() {
        int n = 0;
        while (n < this.bars.size() - 1) {
            ((ZoomControlBar)this.bars.elementAt(n)).dispose();
            ++n;
        }
    }
}

