/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.io.Serializable;
import org.eclipse.hyades.trace.views.internal.CategoricalClassification;
import org.eclipse.hyades.trace.views.internal.Classification;
import org.eclipse.hyades.trace.views.internal.ColorScheme;
import org.eclipse.hyades.trace.views.internal.QuantitativeClassification;
import org.eclipse.swt.graphics.Color;

public class Mapping
implements Serializable {
    public static final int SHAPE_RECTANGLE = 0;
    public static final int SHAPE_LINE = 1;
    private String _title;
    private String _description;
    private ColorScheme _colorScheme;
    private Classification _classification;
    private int _shape;
    private boolean _isLongValue = true;

    public Mapping(Classification classification, ColorScheme colorScheme, String string, int n) {
        this.setClassification(classification);
        this.setColorScheme(colorScheme);
        this.setTitle(string);
        this.setShape(n);
    }

    public Classification classification() {
        return this._classification;
    }

    public Color color(long l) {
        QuantitativeClassification quantitativeClassification = (QuantitativeClassification)this._classification;
        int n = quantitativeClassification.bucket(l);
        return this._colorScheme.color(n, quantitativeClassification.numBuckets());
    }

    public Color color(Object object) {
        CategoricalClassification categoricalClassification = (CategoricalClassification)this._classification;
        int n = categoricalClassification.bucket(object);
        return this._colorScheme.color(n, categoricalClassification.numBuckets());
    }

    public ColorScheme colorScheme() {
        return this._colorScheme;
    }

    public String description() {
        return this._description;
    }

    public boolean isLongValue() {
        return this._isLongValue;
    }

    public void isLongValue(boolean bl) {
        this._isLongValue = bl;
    }

    public static Mapping load(String string) {
        return null;
    }

    public void save(String string) {
    }

    public void setClassification(Classification classification) {
        this._classification = classification;
    }

    public void setColorScheme(ColorScheme colorScheme) {
        this._colorScheme = colorScheme;
    }

    public void setDescription(String string) {
        this._description = string;
    }

    public void setShape(int n) {
        this._shape = n;
    }

    public void setTitle(String string) {
        this._title = string;
    }

    public int shape() {
        return this._shape;
    }

    public String title() {
        return this._title;
    }
}

