/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.ColumnData;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class StatisticTableColumnInfo {
    private boolean _isSortColumn = false;
    private boolean _isDeltaColumn = false;
    private int _mapColumn;
    private ColumnData _columnData;

    public ColumnData getColumnData() {
        return this._columnData;
    }

    public boolean isSortColumn() {
        return this._isSortColumn;
    }

    public boolean isDeltaColumn() {
        return this._isDeltaColumn;
    }

    public void setSortColumn(boolean bl) {
        this._isSortColumn = bl;
    }

    public void setDeltaColumn(boolean bl) {
        this._isDeltaColumn = bl;
    }

    public static StatisticTableColumnInfo getStatisticTableColumnInfo(TableColumn tableColumn) {
        if (tableColumn.getData() != null && tableColumn.getData() instanceof StatisticTableColumnInfo) {
            return (StatisticTableColumnInfo)tableColumn.getData();
        }
        return null;
    }

    private StatisticTableColumnInfo(StatisticView statisticView, ColumnData columnData) {
        TableColumn tableColumn = new TableColumn(statisticView.getTable(), 0x40000 | columnData.getAlignment());
        tableColumn.setData((Object)this);
        this.initializeTableColumn(statisticView, tableColumn, columnData, true);
    }

    public StatisticTableColumnInfo(StatisticView statisticView, ColumnData columnData, boolean bl) {
        TableColumn tableColumn = new TableColumn(statisticView.getTable(), 0x40000 | columnData.getAlignment());
        tableColumn.setData((Object)this);
        this.initializeTableColumn(statisticView, tableColumn, columnData, false);
        if (bl && columnData.supportsDelta()) {
            new StatisticTableColumnInfo(statisticView, columnData);
        }
    }

    private void initializeTableColumn(StatisticView statisticView, TableColumn tableColumn, ColumnData columnData, boolean bl) {
        Table table = statisticView.getTable();
        this._columnData = columnData;
        this._isDeltaColumn = bl;
        tableColumn.setResizable(columnData.isResizable());
        if (bl) {
            tableColumn.setText(TraceUIPlugin.getString("STR_ST_DELTA") + ":" + columnData.name());
        } else {
            tableColumn.setText(columnData.name());
        }
        tableColumn.setWidth(columnData.width());
        tableColumn.addSelectionListener((SelectionListener)statisticView);
        tableColumn.addControlListener((ControlListener)statisticView);
    }
}

