/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.hyades.statistical.ui.editor.internal.ZipStringBuffer;

public class ColumnPrinter {
    private int header_rowcount = 1;
    private int column_count = 0;
    private String[][] headers = new String[this.column_count][this.header_rowcount];
    private ZipStringBuffer[] columns = new ZipStringBuffer[this.column_count];
    private String cell_prefix = "";
    private String cell_postfix = "";
    private String cell_empty = "";

    private int getHeaderRowCount() {
        return this.header_rowcount;
    }

    private int getColumnCount() {
        return this.column_count;
    }

    private void addHeaderRow() {
        int n = 0;
        while (n < this.column_count) {
            String[] stringArray = new String[this.header_rowcount + 1];
            if (this.headers[n].length > 0) {
                System.arraycopy(this.headers[n], 0, stringArray, 1, this.header_rowcount);
            }
            this.headers[n] = stringArray;
            ++n;
        }
        ++this.header_rowcount;
    }

    public void setHeaderText(int n, int n2, String string) {
        while (this.getHeaderRowCount() <= n2) {
            this.addHeaderRow();
        }
        while (this.getColumnCount() <= n) {
            this.addColumn();
        }
        this.headers[n][this.header_rowcount - ++n2] = string;
    }

    private void addColumn() {
        String[][] stringArray = new String[this.column_count + 1][this.header_rowcount];
        System.arraycopy(this.headers, 0, stringArray, 0, this.column_count);
        this.headers = stringArray;
        ZipStringBuffer[] zipStringBufferArray = new ZipStringBuffer[this.column_count + 1];
        System.arraycopy(this.columns, 0, zipStringBufferArray, 0, this.column_count);
        this.columns = zipStringBufferArray;
        ++this.column_count;
    }

    public void setColumnText(int n, String string) {
        while (this.getColumnCount() <= n) {
            this.addColumn();
        }
        this.columns[n] = new ZipStringBuffer(string);
    }

    public void appendColumnText(int n, String string) {
        while (this.getColumnCount() <= n) {
            this.addColumn();
        }
        if (this.columns[n] == null) {
            this.setColumnText(n, string);
        } else {
            this.columns[n].append(string);
        }
    }

    public void setCellPrefix(String string) {
        this.cell_prefix = string;
    }

    public void setCellPostfix(String string) {
        this.cell_postfix = string;
    }

    public void setCellEmpty(String string) {
        this.cell_empty = string;
    }

    public void printTo(OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = this.cell_prefix.getBytes();
        byte[] byArray2 = this.cell_postfix.getBytes();
        byte[] byArray3 = this.cell_empty.getBytes();
        int n2 = 0;
        while (n2 < this.header_rowcount) {
            n = 0;
            while (n < this.column_count) {
                outputStream.write(byArray);
                if (this.headers[n][n2] != null) {
                    outputStream.write(this.headers[n][n2].getBytes());
                } else {
                    outputStream.write(byArray3);
                }
                outputStream.write(byArray2);
                ++n;
            }
            outputStream.write(13);
            outputStream.write(10);
            ++n2;
        }
        n = 1;
        int[] nArray = new int[this.column_count];
        Arrays.fill(nArray, 0);
        StringBuffer stringBuffer = new StringBuffer();
        while (n != 0) {
            n = 0;
            stringBuffer.setLength(0);
            int n3 = 0;
            while (n3 < this.column_count) {
                stringBuffer.append(this.cell_prefix);
                if (nArray[n3] != -1) {
                    if (this.columns[n3] != null) {
                        int n4 = this.indexOf(this.columns[n3], '\n', nArray[n3]);
                        if (n4 == -1) {
                            stringBuffer.append(this.columns[n3].substring(nArray[n3]));
                            nArray[n3] = -1;
                        } else {
                            stringBuffer.append(this.columns[n3].substring(nArray[n3], n4));
                            nArray[n3] = n4 + 1;
                        }
                        n = 1;
                    }
                } else {
                    stringBuffer.append(this.cell_empty);
                }
                stringBuffer.append(this.cell_postfix);
                ++n3;
            }
            if (n == 0) continue;
            outputStream.write(stringBuffer.toString().getBytes());
            outputStream.write(13);
            outputStream.write(10);
        }
    }

    public int indexOf(ZipStringBuffer zipStringBuffer, char c, int n) {
        while (n < zipStringBuffer.length()) {
            if (zipStringBuffer.charAt(n) == c) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.printTo(byteArrayOutputStream);
            return new String(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            return iOException.toString();
        }
    }

    private byte[] compress(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gZIPOutputStream.write(byArray, 0, byArray.length);
        gZIPOutputStream.finish();
        gZIPOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] decompress(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[1024];
        int n = 0;
        while (n != -1) {
            n = gZIPInputStream.read(byArray2, 0, 1024);
            if (n <= 0) continue;
            byteArrayOutputStream.write(byArray2, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

