/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.hyades.model.statistical.SDContiguousObservation;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDDiscreteObservation;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDRepresentation;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.model.statistical.SDTextObservation;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.CBEComponentIdentification;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.ImageManager;
import org.eclipse.hyades.statistical.ui.editor.internal.AgentChangeListener;
import org.eclipse.hyades.statistical.ui.editor.internal.EntityExistsException;
import org.eclipse.hyades.statistical.ui.editor.internal.GraphWindow;
import org.eclipse.hyades.statistical.ui.editor.internal.HexData;
import org.eclipse.hyades.statistical.ui.editor.internal.ModelChangeListener;
import org.eclipse.hyades.statistical.ui.editor.internal.ModifiableVariableBar;
import org.eclipse.hyades.statistical.ui.editor.internal.ModuleNodeChangeListener;
import org.eclipse.hyades.statistical.ui.editor.internal.SDSnapshotObservationGraphSource;
import org.eclipse.hyades.statistical.ui.editor.internal.SDTextObservationGraphSource;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConDropListener;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConInterface;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConModule;
import org.eclipse.hyades.statistical.ui.editor.internal.XMLConfigUtil;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDModifiableVariableRepresentation;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.BasicGraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.Dirtiable;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.EnumerationGraph;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.EnumerationGraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.Graph;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.GraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.HistogramGraph;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.LineGraph;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.TestGraphSource;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.TimeZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomControlBar;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomImageBar;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.eclipse.ui.part.ResourceTransfer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CopyOfStatisticalModelGraphViewer
implements DisposeListener,
SelectionListener,
DropTargetListener,
MouseListener,
StatConInterface {
    private static final boolean DEBUG_LOADING = true;
    protected ArrayList disposables = new ArrayList();
    protected HashMap module_refs = new HashMap();
    protected ArrayList modules = new ArrayList();
    protected int next = 0;
    protected int[] colours = new int[]{3, 5, 9, 7, 2, 13, 11};
    protected TabFolder tabfolder;
    protected SashForm sashfolder;
    protected Composite leftsash;
    protected Composite rightsash;
    protected GraphWindow graph_window;
    protected Tree chooser_tree;
    protected Menu chooser_menu;
    protected ArrayList chooser_disposables;
    protected MenuItem chooser_add;
    protected ImageManager img;
    protected HashMap reverse_map = new HashMap();
    protected HashMap trcagent_map = new HashMap();
    protected HashMap msglist_map = new HashMap();
    protected HashMap sddescriptor_map = new HashMap();
    protected HashMap counter_map = new HashMap();
    protected HashMap modifiable_map = new HashMap();
    protected HashMap graph_map = new HashMap();
    protected HashMap bar_map = new HashMap();
    protected HashMap bar_slider_map = new HashMap();
    protected HashMap source_map = new HashMap();
    protected HashMap source_graph_map = new HashMap();
    protected Dirtiable dirtiable;
    protected ArrayList agents = new ArrayList();
    protected ArrayList global_actions = new ArrayList();
    protected ArrayList drop_listeners = new ArrayList();
    protected ArrayList root_nodes = new ArrayList();
    protected ArrayList model_change_listeners = new ArrayList();
    protected ArrayList agent_change_listeners = new ArrayList();
    protected ArrayList node_change_listeners = new ArrayList();
    protected URI current_project;
    SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
    protected HashMap updates = new HashMap();
    protected SDDescriptor selected_descriptor = null;
    protected long prev_used = 0L;

    public void setCurrentProjectURI(URI uRI) {
        this.current_project = uRI;
    }

    public URI getCurrentProjectURI() {
        return this.current_project;
    }

    public void showTab(int n) {
        this.graph_window.showTab(n);
    }

    public CopyOfStatisticalModelGraphViewer(Composite composite, int n, boolean bl) {
        EditorPlugin.DBG.info("constructor");
        this.initAsSash(composite);
    }

    public CopyOfStatisticalModelGraphViewer(Composite composite, int n, boolean bl, Dirtiable dirtiable, URI uRI) {
        EditorPlugin.DBG.info("constructor");
        this.dirtiable = dirtiable;
        this.current_project = uRI;
        this.initAsSash(composite);
        this.loadModules();
    }

    public void addModuleNodeChangeListener(ModuleNodeChangeListener moduleNodeChangeListener) {
        this.node_change_listeners.add(moduleNodeChangeListener);
    }

    public void removeModuleNodeChangeListener(ModuleNodeChangeListener moduleNodeChangeListener) {
        ((AbstractCollection)this.node_change_listeners).remove(moduleNodeChangeListener);
    }

    public void addModelChangeListener(ModelChangeListener modelChangeListener) {
        this.model_change_listeners.add(modelChangeListener);
    }

    public void removeModelChangeListener(ModelChangeListener modelChangeListener) {
        ((AbstractCollection)this.model_change_listeners).remove(modelChangeListener);
    }

    public void addAgentChangeListener(AgentChangeListener agentChangeListener) {
        this.agent_change_listeners.add(agentChangeListener);
    }

    public void removeAgentChangeListener(AgentChangeListener agentChangeListener) {
        ((AbstractCollection)this.agent_change_listeners).remove(agentChangeListener);
    }

    public String[] getModuleRefs() {
        String[] stringArray = new String[this.modules.size()];
        int n = 0;
        while (n < this.modules.size()) {
            stringArray[n] = ((StatConModule)this.modules.get(n)).getModuleRef();
            ++n;
        }
        return stringArray;
    }

    public StatConModule getModuleByRef(String string) {
        return (StatConModule)this.module_refs.get(string);
    }

    public void unloadModules() {
        EditorPlugin.DBG.info("unloading modules");
        int n = 0;
        while (n < this.modules.size()) {
            try {
                StatConModule statConModule = (StatConModule)this.modules.get(n);
                EditorPlugin.DBG.info("unloading module " + n);
                statConModule.unload();
            }
            catch (Throwable throwable) {
                EditorPlugin.DBG.error("failed to unload module", throwable);
            }
            ++n;
        }
        this.modules.clear();
        this.module_refs.clear();
    }

    public void loadModules() {
        EditorPlugin.DBG.info("loading modules");
        IPluginRegistry iPluginRegistry = Platform.getPluginRegistry();
        IExtensionPoint iExtensionPoint = iPluginRegistry.getExtensionPoint("org.eclipse.hyades.statistical.ui.StatConModule");
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        EditorPlugin.DBG.info("found " + iExtensionArray.length + " modules");
        int n = 0;
        while (n < iExtensionArray.length) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
            IPluginDescriptor iPluginDescriptor = iExtensionArray[n].getDeclaringPluginDescriptor();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                String string = iConfigurationElementArray[n2].getAttribute("class");
                StatConModule statConModule = null;
                try {
                    EditorPlugin.DBG.info("loading module " + n);
                    ClassLoader classLoader = iPluginDescriptor.getPluginClassLoader();
                    Class<?> clazz = classLoader.loadClass(string);
                    statConModule = (StatConModule)clazz.newInstance();
                    statConModule.load(this);
                    this.module_refs.put(statConModule.getModuleRef(), statConModule);
                    this.modules.add(statConModule);
                    EditorPlugin.DBG.info("loaded OK");
                }
                catch (Throwable throwable) {
                    try {
                        ((AbstractCollection)this.modules).remove(statConModule);
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    try {
                        this.module_refs.remove(statConModule);
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                    EditorPlugin.DBG.logVisibleError(throwable, "Failed to load StatCon Module \"" + string + "\" from plugin \"" + iPluginDescriptor + "\" ", false);
                    EditorPlugin.DBG.error("failed to load module", throwable);
                }
                ++n2;
            }
            ++n;
        }
        EditorPlugin.DBG.info("finished loading modules");
    }

    private BasicAction findAction(String string, ArrayList arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            BasicAction basicAction = (BasicAction)arrayList.get(n);
            if (basicAction.id.equals(string)) {
                return basicAction;
            }
            ++n;
        }
        return null;
    }

    private RootNode getRootNodeName(String string) {
        int n = 0;
        while (n < this.root_nodes.size()) {
            RootNode rootNode = (RootNode)this.root_nodes.get(n);
            if (rootNode.name.equals(string)) {
                return rootNode;
            }
            ++n;
        }
        return null;
    }

    private RootNode getRootNodeID(String string) {
        int n = 0;
        while (n < this.root_nodes.size()) {
            RootNode rootNode = (RootNode)this.root_nodes.get(n);
            if (rootNode.id.equals(string)) {
                return rootNode;
            }
            ++n;
        }
        return null;
    }

    private StatAgent getStatAgent(TRCAgent tRCAgent) {
        int n = 0;
        while (n < this.agents.size()) {
            StatAgent statAgent = (StatAgent)this.agents.get(n);
            if (statAgent.agent == tRCAgent) {
                return statAgent;
            }
            ++n;
        }
        return null;
    }

    private StatAgent getStatAgent(EList eList) {
        int n = 0;
        while (n < this.agents.size()) {
            StatAgent statAgent = (StatAgent)this.agents.get(n);
            if (statAgent.agent.getDefaultEvents() == eList) {
                return statAgent;
            }
            ++n;
        }
        return null;
    }

    public void addGlobalAction(String string, String string2, Image image, Runnable runnable) {
        BasicAction basicAction = this.findAction(string, this.global_actions);
        if (basicAction == null) {
            basicAction = new BasicAction();
            this.global_actions.add(basicAction);
        }
        basicAction.id = string;
        basicAction.name = string2;
        basicAction.image = image;
        basicAction.runnable = runnable;
        basicAction.menuitem = new MenuItem(this.chooser_menu, 0);
        basicAction.menuitem.setText(string2);
        basicAction.menuitem.setImage(image);
        basicAction.menuitem.addSelectionListener((SelectionListener)basicAction);
    }

    public void removeGlobalAction(String string) {
        BasicAction basicAction = this.findAction(string, this.global_actions);
        if (basicAction != null) {
            basicAction.dispose();
            ((AbstractCollection)this.global_actions).remove(basicAction);
        }
    }

    public void addDropTargetListener(String string, StatConDropListener statConDropListener) {
        DropListener dropListener = new DropListener();
        dropListener.extension = string;
        dropListener.listener = statConDropListener;
        this.drop_listeners.add(dropListener);
    }

    public void removeDropTargetListener(String string) {
        int n = 0;
        while (n < this.drop_listeners.size()) {
            DropListener dropListener = (DropListener)this.drop_listeners.get(n);
            if (dropListener.extension.equals(string)) {
                ((AbstractCollection)this.drop_listeners).remove(dropListener);
            }
            ++n;
        }
    }

    public void addModuleNode(String string, String string2, Image image) throws EntityExistsException {
        if (this.getRootNodeID(string2) != null) {
            throw new EntityExistsException(EditorPlugin.getString("ROOT_NODE_EXISTS") + " " + string + " " + EditorPlugin.getString("ROOT_NODE_EXISTS_2"));
        }
        RootNode rootNode = new RootNode();
        rootNode.name = string;
        rootNode.image = image;
        rootNode.id = string2;
        rootNode.item = new TreeItem(this.chooser_tree, 0, 0);
        rootNode.item.setText(string);
        rootNode.item.setImage(image);
        rootNode.item.setGrayed(true);
        this.root_nodes.add(rootNode);
        int n = 0;
        while (n < this.node_change_listeners.size()) {
            ModuleNodeChangeListener moduleNodeChangeListener = (ModuleNodeChangeListener)this.node_change_listeners.get(n);
            moduleNodeChangeListener.nodeAdded(string2);
            ++n;
        }
    }

    public void addModuleNode(String string, String string2, String string3, Image image) throws EntityExistsException, NullPointerException {
        if (this.getRootNodeID(string2) != null) {
            throw new EntityExistsException(EditorPlugin.getString("ROOT_NODE_EXISTS") + " " + string + " " + EditorPlugin.getString("ROOT_NODE_EXISTS_2"));
        }
        RootNode rootNode = this.getRootNodeID(string3);
        if (rootNode == null) {
            throw new NullPointerException("");
        }
        RootNode rootNode2 = new RootNode();
        rootNode2.name = string;
        rootNode2.image = image;
        rootNode2.id = string2;
        rootNode2.parent_id = string3;
        rootNode2.item = new TreeItem(rootNode.item, 0, 0);
        rootNode2.item.setText(string);
        rootNode2.item.setImage(image);
        rootNode2.item.setGrayed(true);
        rootNode.node_children.add(rootNode2);
        this.root_nodes.add(rootNode2);
        int n = 0;
        while (n < this.node_change_listeners.size()) {
            ModuleNodeChangeListener moduleNodeChangeListener = (ModuleNodeChangeListener)this.node_change_listeners.get(n);
            moduleNodeChangeListener.nodeAdded(string2);
            ++n;
        }
    }

    public void removeModuleNode(String string) {
        Object object;
        int n;
        RootNode rootNode = this.getRootNodeID(string);
        if (rootNode != null) {
            if (rootNode.parent_id != null) {
                RootNode rootNode2 = this.getRootNodeID(rootNode.parent_id);
                ((AbstractCollection)rootNode2.node_children).remove(rootNode);
            }
            n = 0;
            while (n < rootNode.node_children.size()) {
                object = (RootNode)rootNode.node_children.get(n);
                this.removeModuleNode(((RootNode)object).id);
                ++n;
            }
            rootNode.dispose();
            ((AbstractCollection)this.root_nodes).remove(rootNode);
        }
        n = 0;
        while (n < this.node_change_listeners.size()) {
            object = (ModuleNodeChangeListener)this.node_change_listeners.get(n);
            object.nodeRemoved(string);
            ++n;
        }
    }

    public void addModuleNodeAction(String string, String string2, String string3, Image image, Runnable runnable) {
        RootNode rootNode = this.getRootNodeID(string);
        if (rootNode != null) {
            BasicAction basicAction = this.findAction(string2, rootNode.actions);
            if (basicAction == null) {
                basicAction = new BasicAction();
                rootNode.actions.add(basicAction);
            }
            basicAction.id = string2;
            basicAction.name = string3;
            basicAction.image = image;
            basicAction.runnable = runnable;
        }
    }

    public void removeModuleNodeAction(String string, String string2) {
        RootNode rootNode = this.getRootNodeID(string);
        if (rootNode != null) {
            int n = 0;
            while (n < rootNode.actions.size()) {
                BasicAction basicAction = (BasicAction)rootNode.actions.get(n);
                if (basicAction.id.equals(string2)) {
                    rootNode.actions.remove(n);
                    break;
                }
                ++n;
            }
        }
    }

    public SDDescriptor[] addAgent(IFile iFile) throws IOException {
        return this.addAgent(iFile.getProjectRelativePath());
    }

    private Resource createResource(URI uRI) {
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        Resource resource = resourceSetImpl.getResource(uRI, false);
        if (resource == null) {
            return resourceSetImpl.createResource(uRI);
        }
        return resource;
    }

    public SDDescriptor[] addAgent(IPath iPath) throws IOException {
        XMLResource xMLResource;
        EditorPlugin.DBG.info("add trace agent");
        URI uRI = URI.createPlatformResourceURI((String)iPath.toString());
        EditorPlugin.DBG.info("agent URI:" + uRI);
        if (uRI == null) {
            throw new IOException(EditorPlugin.getString("NULL_URI_WHILE_LOADING") + " " + iPath);
        }
        Resource resource = this.createResource(uRI);
        if (resource == null) {
            throw new IOException(EditorPlugin.getString("NULL_RESOURCE_WHILE_LOADING") + " " + iPath);
        }
        if (resource instanceof XMLResource) {
            EditorPlugin.DBG.info("found XML resource for agent");
            xMLResource = (XMLResource)resource;
            String string = "";
            try {
                EditorPlugin.DBG.info("trying to load resource as an unzipped file");
                xMLResource.setUseZip(false);
                xMLResource.load(Collections.EMPTY_MAP);
                EditorPlugin.DBG.info("loaded resource OK as an unzipped file");
            }
            catch (Throwable throwable) {
                EditorPlugin.DBG.info("load failed as an unzipped file");
                string = string + throwable.toString() + " / ";
                resource = this.createResource(uRI);
                xMLResource = (XMLResource)resource;
                try {
                    EditorPlugin.DBG.info("trying to load resource as a zipped file");
                    xMLResource.setUseZip(true);
                    xMLResource.load(Collections.EMPTY_MAP);
                    EditorPlugin.DBG.info("loaded resource OK as a zipped file");
                }
                catch (Throwable throwable2) {
                    string = string + throwable2.toString();
                    throw new IOException(string);
                }
            }
        } else {
            EditorPlugin.DBG.info("found a non-XML resource for agent - trying to load anyway");
            if (!resource.isLoaded()) {
                resource.load(Collections.EMPTY_MAP);
            }
        }
        xMLResource = resource.getContents();
        EditorPlugin.DBG.info("got contents of agent resource (size " + xMLResource.size() + ")");
        return this.addAgentFromTree((EList)xMLResource, uRI);
    }

    private SDDescriptor[] addAgentFromTree(EList eList, URI uRI) {
        SDDescriptor[] sDDescriptorArray;
        EditorPlugin.DBG.info("Searching Resource Contents (" + eList.size() + ")");
        int n = 0;
        while (n < eList.size()) {
            sDDescriptorArray = (SDDescriptor[])eList.get(n);
            EditorPlugin.DBG.info("resource content " + n + " = " + sDDescriptorArray.getClass());
            if (sDDescriptorArray instanceof TRCAgentProxy) {
                TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)sDDescriptorArray;
                return this.addAgent(tRCAgentProxy.getAgent(), uRI);
            }
            if (sDDescriptorArray instanceof TRCAgent) {
                return this.addAgent((TRCAgent)sDDescriptorArray, uRI);
            }
            ++n;
        }
        sDDescriptorArray = null;
        int n2 = 0;
        while (n2 < eList.size()) {
            EObject eObject = (EObject)eList.get(n2);
            if (eObject instanceof TRCProcessProxy) {
                EditorPlugin.DBG.info("resource subcontent ProcessProxy");
                sDDescriptorArray = this.addAgentFromTree(((TRCProcessProxy)eObject).getAgentProxies(), uRI);
            } else if (eObject instanceof TRCNode) {
                EditorPlugin.DBG.info("resource subcontent Node");
                sDDescriptorArray = this.addAgentFromTree(((TRCNode)eObject).getProcessProxies(), uRI);
            } else if (eObject instanceof TRCMonitor) {
                EditorPlugin.DBG.info("resource subcontent Monitor");
                sDDescriptorArray = this.addAgentFromTree(((TRCMonitor)eObject).getNodes(), uRI);
            } else {
                EditorPlugin.DBG.info("resource subcontent " + n2 + " = " + eObject.getClass());
                sDDescriptorArray = this.addAgentFromTree(eObject.eContents(), uRI);
            }
            if (sDDescriptorArray != null) {
                return sDDescriptorArray;
            }
            ++n2;
        }
        return null;
    }

    public SDDescriptor[] addAgent(TRCAgent tRCAgent) {
        return this.addAgent(tRCAgent, null);
    }

    private StringBuffer cbeToString(CBECommonBaseEvent cBECommonBaseEvent, StringBuffer stringBuffer) {
        Date date = new Date((long)cBECommonBaseEvent.getCreationTime());
        this.sdf.format(date, stringBuffer, new FieldPosition(0));
        stringBuffer.append(" ");
        short s = cBECommonBaseEvent.getSeverity();
        if (s <= 10) {
            stringBuffer.append("(info)");
        } else if (s <= 30) {
            stringBuffer.append("(warning)");
        } else if (s <= 40) {
            stringBuffer.append("(error)");
        } else if (s <= 60) {
            stringBuffer.append("(critical)");
        }
        stringBuffer.append(" ");
        if (cBECommonBaseEvent.getRepeatCount() > 0) {
            stringBuffer.append("(x");
            stringBuffer.append(cBECommonBaseEvent.getRepeatCount());
            stringBuffer.append(") ");
        }
        stringBuffer.append(cBECommonBaseEvent.getSourceComponentId().getComponent());
        if (cBECommonBaseEvent.getSourceComponentId().getSubComponent() != null) {
            stringBuffer.append(" / ");
            stringBuffer.append(cBECommonBaseEvent.getSourceComponentId().getSubComponent());
        }
        stringBuffer.append(" - ");
        stringBuffer.append(cBECommonBaseEvent.getMsg());
        stringBuffer.append("\n");
        return stringBuffer;
    }

    private boolean filterCBE(CBECommonBaseEvent cBECommonBaseEvent) {
        Object object;
        TRCAgent tRCAgent = cBECommonBaseEvent.getAgent();
        if (tRCAgent == null) {
            return false;
        }
        StatAgent statAgent = this.getStatAgent(tRCAgent);
        if (statAgent == null) {
            return false;
        }
        if (statAgent.msg_info_item == null) {
            return false;
        }
        if (!statAgent.msg_item.getChecked()) {
            return false;
        }
        short s = cBECommonBaseEvent.getSeverity();
        if (s <= 10 ? !statAgent.msg_info_item.getChecked() : (s <= 30 ? !statAgent.msg_warn_item.getChecked() : !statAgent.msg_error_item.getChecked())) {
            return false;
        }
        CBEComponentIdentification cBEComponentIdentification = cBECommonBaseEvent.getSourceComponentId();
        String string = cBEComponentIdentification.getComponent();
        String string2 = cBEComponentIdentification.getSubComponent();
        TreeItem treeItem = (TreeItem)statAgent.msg_locations.get(string);
        if (treeItem == null) {
            treeItem = new TreeItem(statAgent.msg_loc_item, 0);
            treeItem.setImage(this.img.getImage("smodel_cbesource.gif"));
            treeItem.setText(string);
            treeItem.setChecked(true);
            statAgent.msg_locations.put(string, treeItem);
        }
        if (!treeItem.getChecked()) {
            return false;
        }
        if (string2 != null) {
            object = string + "<%$%~%>" + string2;
            TreeItem treeItem2 = (TreeItem)statAgent.msg_locations.get(object);
            if (treeItem2 == null) {
                treeItem2 = new TreeItem(treeItem, 0);
                treeItem2.setImage(this.img.getImage("smodel_cbesource.gif"));
                treeItem2.setText(string2);
                treeItem2.setChecked(true);
                statAgent.msg_locations.put(object, treeItem2);
            }
            if (!treeItem2.getChecked()) {
                return false;
            }
        }
        object = statAgent.msg_loc_item.getItems();
        return true;
    }

    private int appendCBEs(List list, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n;
        while (n2 < list.size()) {
            CBECommonBaseEvent cBECommonBaseEvent = (CBECommonBaseEvent)list.get(n2);
            if (this.filterCBE(cBECommonBaseEvent)) {
                this.cbeToString(cBECommonBaseEvent, stringBuffer);
            }
            ++n2;
        }
        this.graph_window.appendCBEText(stringBuffer.toString());
        return list.size();
    }

    private int setCBEs(List list, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n;
        while (n2 < list.size()) {
            CBECommonBaseEvent cBECommonBaseEvent = (CBECommonBaseEvent)list.get(n2);
            if (this.filterCBE(cBECommonBaseEvent)) {
                this.cbeToString(cBECommonBaseEvent, stringBuffer);
            }
            ++n2;
        }
        this.graph_window.setCBEText(stringBuffer.toString());
        return list.size();
    }

    private void sortCBEs(List list) {
        Collections.sort(list, new CBEComparator());
    }

    private void appendCBEs(StatAgent statAgent) {
        if (statAgent.show_messages) {
            statAgent.msgindex = this.appendCBEs((List)statAgent.agent.getDefaultEvents(), statAgent.msgindex);
        }
    }

    private void appendAllCBEs() {
        int n = 0;
        while (n < this.agents.size()) {
            StatAgent statAgent = (StatAgent)this.agents.get(n);
            statAgent.msgindex = this.appendCBEs((List)statAgent.agent.getDefaultEvents(), statAgent.msgindex);
            ++n;
        }
    }

    private void redoAllCBEs() {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this.agents.size()) {
            StatAgent statAgent = (StatAgent)this.agents.get(n);
            if (statAgent.show_messages) {
                statAgent.msgindex = statAgent.agent.getDefaultEvents().size();
                arrayList.addAll(statAgent.agent.getDefaultEvents());
            }
            ++n;
        }
        this.sortCBEs(arrayList);
        this.setCBEs(arrayList, 0);
    }

    public void updateCBELog() {
        this.appendAllCBEs();
    }

    public void reloadCBELog() {
        this.redoAllCBEs();
    }

    public SDDescriptor[] updateAgent(TRCAgent tRCAgent) {
        Object object;
        StatAgent statAgent;
        int n = 0;
        while (n < this.agents.size()) {
            statAgent = (StatAgent)this.agents.get(n);
            EditorPlugin.DBG.info("agent " + n + " = " + statAgent.agent.getName());
            ++n;
        }
        statAgent = this.getStatAgent(tRCAgent);
        if (statAgent == null) {
            EditorPlugin.DBG.info("update requested on non-existent agent " + tRCAgent.getName());
            return null;
        }
        EList eList = tRCAgent.eContents();
        EditorPlugin.DBG.info("checking agent's " + eList.size() + " children for Statistical Models");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = 0;
        while (n2 < eList.size()) {
            object = eList.get(n2);
            EditorPlugin.DBG.info("agent child " + n2 + " = " + object.getClass());
            if (object instanceof SDDescriptor) {
                EditorPlugin.DBG.info("adding agent SDDescriptor (statistical model)");
                if (statAgent.model_roots.contains(object)) {
                    this.updateModel((SDDescriptor)object, statAgent);
                    arrayList.add(object);
                } else {
                    this.addModel((SDDescriptor)object, statAgent);
                    arrayList.add(object);
                }
            }
            ++n2;
        }
        object = new SDDescriptor[arrayList.size()];
        int n3 = 0;
        while (n3 < ((SDDescriptor[])object).length) {
            object[n3] = (SDDescriptor)arrayList.get(n3);
            ++n3;
        }
        this.updateTreeItems();
        return object;
    }

    public SDDescriptor[] addAgent(TRCAgent tRCAgent, URI uRI) {
        Object object;
        URI uRI2;
        StatAgent statAgent;
        StatAgent statAgent2;
        if (tRCAgent == null) {
            EditorPlugin.DBG.logVisibleError(new Exception("Null Agent"), "Null Agent " + uRI, false);
            return null;
        }
        if (tRCAgent.getName() == null) {
            EditorPlugin.DBG.logVisibleError(new Exception("Null Agent Name"), "Null Agent Name " + uRI, false);
            return null;
        }
        EditorPlugin.DBG.info("add valid agent " + tRCAgent.getName() + " / " + uRI);
        int n = 0;
        while (n < this.agents.size()) {
            statAgent2 = (StatAgent)this.agents.get(n);
            EditorPlugin.DBG.info("agent " + n + " = " + statAgent2.agent.getName());
            ++n;
        }
        if (uRI != null) {
            int n2 = 0;
            while (n2 < this.agents.size()) {
                statAgent = (StatAgent)this.agents.get(n2);
                uRI2 = statAgent.uri;
                if (uRI2 != null && uRI2.equals((Object)uRI)) {
                    EditorPlugin.DBG.info("URI matched to an existing agent - returning without adding");
                    return null;
                }
                ++n2;
            }
        }
        EditorPlugin.DBG.info("creating new agent");
        statAgent2 = this.getStatAgent(tRCAgent);
        if (statAgent2 == null) {
            statAgent2 = new StatAgent();
            this.agents.add(statAgent2);
        }
        statAgent2.agent = tRCAgent;
        statAgent2.uri = uRI;
        statAgent = new TreeItem(this.chooser_tree, 0);
        statAgent.setText(tRCAgent.getName());
        statAgent.setChecked(true);
        statAgent.setGrayed(false);
        this.trcagent_map.put(statAgent, tRCAgent);
        this.reverse_map.put(tRCAgent, statAgent);
        this.addAgentAction(statAgent2.agent, "AGENT_REMOVE", EditorPlugin.getString("AGENT_REMOVE"), this.img.getImage("smodel_remove.gif"), new AgentRemoveAction(statAgent2.agent));
        uRI2 = tRCAgent.getDefaultEvents();
        TreeItem treeItem = new TreeItem((TreeItem)statAgent, 0);
        treeItem.setImage(this.img.getImage("smodel_cbemessage.gif"));
        treeItem.setText("Messages");
        treeItem.setChecked(true);
        treeItem.setGrayed(false);
        TreeItem treeItem2 = new TreeItem(treeItem, 0);
        treeItem2.setImage(this.img.getImage("smodel_cbeseverity.gif"));
        treeItem2.setText("Severity");
        treeItem2.setChecked(true);
        treeItem2.setGrayed(true);
        TreeItem treeItem3 = new TreeItem(treeItem, 0);
        treeItem3.setImage(this.img.getImage("smodel_cbesource.gif"));
        treeItem3.setText("Source Locations");
        treeItem3.setChecked(true);
        treeItem3.setGrayed(true);
        TreeItem treeItem4 = new TreeItem(treeItem2, 0);
        treeItem4.setImage(this.img.getImage("smodel_cbeinfo.gif"));
        treeItem4.setText("Info");
        treeItem4.setChecked(true);
        treeItem4.setGrayed(false);
        TreeItem treeItem5 = new TreeItem(treeItem2, 0);
        treeItem5.setImage(this.img.getImage("smodel_cbewarning.gif"));
        treeItem5.setText("Warning");
        treeItem5.setChecked(true);
        treeItem5.setGrayed(false);
        TreeItem treeItem6 = new TreeItem(treeItem2, 0);
        treeItem6.setImage(this.img.getImage("smodel_cbeerror.gif"));
        treeItem6.setText("Error");
        treeItem6.setChecked(true);
        treeItem6.setGrayed(false);
        this.msglist_map.put(treeItem, uRI2);
        this.reverse_map.put(uRI2, treeItem);
        statAgent2.msg_item = treeItem;
        statAgent2.msg_info_item = treeItem4;
        statAgent2.msg_warn_item = treeItem5;
        statAgent2.msg_error_item = treeItem6;
        statAgent2.msg_loc_item = treeItem3;
        EditorPlugin.DBG.info("interleaving all agent CBE messages");
        this.redoAllCBEs();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        EList eList = tRCAgent.eContents();
        EditorPlugin.DBG.info("checking agent's " + eList.size() + " children for Statistical Models");
        int n3 = 0;
        while (n3 < eList.size()) {
            object = eList.get(n3);
            EditorPlugin.DBG.info("agent child " + n3 + " = " + object.getClass());
            if (object instanceof SDDescriptor) {
                EditorPlugin.DBG.info("adding agent SDDescriptor (statistical model)");
                if (!statAgent2.model_roots.contains(object)) {
                    this.addModel((SDDescriptor)object, statAgent2);
                    arrayList.add(object);
                }
            }
            ++n3;
        }
        object = new SDDescriptor[arrayList.size()];
        int n4 = 0;
        while (n4 < ((SDDescriptor[])object).length) {
            object[n4] = (SDDescriptor)arrayList.get(n4);
            ++n4;
        }
        EditorPlugin.DBG.info("agent added ok");
        int n5 = 0;
        while (n5 < this.agents.size()) {
            StatAgent statAgent3 = (StatAgent)this.agents.get(n5);
            EditorPlugin.DBG.info("agent " + n5 + " = " + statAgent3.agent.getName());
            ++n5;
        }
        EditorPlugin.DBG.info("notifying agent listeners");
        int n6 = 0;
        while (n6 < this.agent_change_listeners.size()) {
            AgentChangeListener agentChangeListener = (AgentChangeListener)this.agent_change_listeners.get(n6);
            EditorPlugin.DBG.info("notifying agent listener " + agentChangeListener.getClass().getName());
            try {
                agentChangeListener.agentAdded(tRCAgent);
            }
            catch (Throwable throwable) {
                EditorPlugin.DBG.logVisibleError(throwable, "problem notifying listener of Agent Add", false);
            }
            ++n6;
        }
        this.updateTreeItems();
        return object;
    }

    public void updateModel(SDDescriptor sDDescriptor) {
        SDDescriptor sDDescriptor2 = sDDescriptor.getParent();
        TreeItem treeItem = null;
        if (sDDescriptor2 == null) {
            TRCAgent tRCAgent = sDDescriptor.getAgent();
            treeItem = (TreeItem)this.reverse_map.get(tRCAgent);
        } else {
            treeItem = (TreeItem)this.reverse_map.get(sDDescriptor2);
        }
        if (treeItem != null) {
            this.addModelToChooser(sDDescriptor, treeItem, true);
            EditorPlugin.DBG.info("model node updated - " + sDDescriptor.getName());
            this.treeItemSelected(treeItem);
        }
    }

    private void updateModel(SDDescriptor sDDescriptor, StatAgent statAgent) {
        EditorPlugin.DBG.mark("updating model - " + sDDescriptor.getName());
        this.addModelToChooser(sDDescriptor, statAgent.agent, true);
        EditorPlugin.DBG.mark("model updated - " + sDDescriptor.getName());
        this.updateAgentImages();
    }

    private void addModel(SDDescriptor sDDescriptor, StatAgent statAgent) {
        this.addModelToChooser(sDDescriptor, statAgent.agent, false);
        statAgent.model_roots.add(sDDescriptor);
        EditorPlugin.DBG.info("model added - " + sDDescriptor.getName());
        int n = 0;
        while (n < this.model_change_listeners.size()) {
            ModelChangeListener modelChangeListener = (ModelChangeListener)this.model_change_listeners.get(n);
            modelChangeListener.modelAdded(sDDescriptor);
            ++n;
        }
        EditorPlugin.DBG.info("notified listeners");
        this.updateAgentImages();
    }

    public void setAgentFile(TRCAgent tRCAgent, IFile iFile) {
        URI uRI = URI.createPlatformResourceURI((String)iFile.getProjectRelativePath().toString());
        this.setAgentFile(tRCAgent, uRI);
    }

    public void setAgentFile(TRCAgent tRCAgent, URI uRI) {
        StatAgent statAgent = this.getStatAgent(tRCAgent);
        EditorPlugin.DBG.info("set agent file " + tRCAgent.getName() + " / " + uRI);
        if (statAgent != null) {
            URI uRI2 = statAgent.uri;
            if (uRI2 != null) {
                if (!uRI2.equals((Object)uRI)) {
                    this.setDirty(true);
                }
            } else if (uRI != null) {
                this.setDirty(true);
            }
            statAgent.uri = uRI;
        }
    }

    public void setAgentImage(TRCAgent tRCAgent, Image image) {
        EditorPlugin.DBG.info("set agent " + tRCAgent.getName() + " image");
        StatAgent statAgent = this.getStatAgent(tRCAgent);
        if (statAgent != null) {
            statAgent.image = image;
        }
        this.updateAgentImages();
    }

    private void updateAgentImages() {
        int n = 0;
        while (n < this.agents.size()) {
            TreeItem treeItem;
            StatAgent statAgent = (StatAgent)this.agents.get(n);
            if (statAgent.agent != null && (treeItem = (TreeItem)this.reverse_map.get(statAgent.agent)) != null) {
                if (statAgent.image == null) {
                    treeItem.setImage(this.img.getImage("smodel_trcagent.gif"));
                } else {
                    treeItem.setImage(statAgent.image);
                }
            }
            ++n;
        }
    }

    public void addModelAction(TRCAgent tRCAgent, String string, String string2, Image image, Runnable runnable) {
        BasicAction basicAction;
        StatAgent statAgent = this.getStatAgent(tRCAgent);
        if (statAgent == null) {
            statAgent = new StatAgent();
            statAgent.agent = tRCAgent;
            this.agents.add(statAgent);
        }
        if ((basicAction = this.findAction(string, statAgent.modelactions)) == null) {
            basicAction = new BasicAction();
            statAgent.modelactions.add(basicAction);
        }
        basicAction.id = string;
        basicAction.name = string2;
        basicAction.image = image;
        basicAction.runnable = runnable;
    }

    public void removeModelAction(TRCAgent tRCAgent, String string) {
        StatAgent statAgent = this.getStatAgent(tRCAgent);
        if (statAgent != null) {
            int n = 0;
            while (n < statAgent.modelactions.size()) {
                BasicAction basicAction = (BasicAction)statAgent.modelactions.get(n);
                if (basicAction.id.equals(string)) {
                    statAgent.modelactions.remove(n);
                    break;
                }
                ++n;
            }
        }
    }

    public void addAgentAction(TRCAgent tRCAgent, String string, String string2, Image image, Runnable runnable) {
        BasicAction basicAction;
        StatAgent statAgent = this.getStatAgent(tRCAgent);
        if (statAgent == null) {
            statAgent = new StatAgent();
            statAgent.agent = tRCAgent;
            this.agents.add(statAgent);
        }
        if ((basicAction = this.findAction(string, statAgent.actions)) == null) {
            basicAction = new BasicAction();
            statAgent.actions.add(basicAction);
        }
        basicAction.id = string;
        basicAction.name = string2;
        basicAction.image = image;
        basicAction.runnable = runnable;
    }

    public void removeAgentAction(TRCAgent tRCAgent, String string) {
        StatAgent statAgent = this.getStatAgent(tRCAgent);
        if (statAgent != null) {
            int n = 0;
            while (n < statAgent.actions.size()) {
                BasicAction basicAction = (BasicAction)statAgent.actions.get(n);
                if (basicAction.id.equals(string)) {
                    statAgent.actions.remove(n);
                    break;
                }
                ++n;
            }
        }
    }

    public void setDirty(boolean bl) {
        if (this.dirtiable != null) {
            this.dirtiable.setDirty(bl);
        }
    }

    public Color parseColor(String string, Color color) {
        try {
            if (!string.startsWith("#")) {
                throw new Exception();
            }
            if (string.length() != 7) {
                throw new Exception();
            }
            String string2 = string.substring(1, 3);
            String string3 = string.substring(3, 5);
            String string4 = string.substring(5, 7);
            int n = Integer.parseInt(string2, 16);
            int n2 = Integer.parseInt(string3, 16);
            int n3 = Integer.parseInt(string4, 16);
            RGB rGB = XMLConfigUtil.parseColor(string, color.getRGB());
            Color color2 = new Color((Device)this.graph_window.getDisplay(), rGB);
            this.disposables.add(color2);
            return color2;
        }
        catch (Throwable throwable) {
            return color;
        }
    }

    public void applyConfig(InputStream inputStream) throws Exception {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[4096];
            int n = 0;
            while (n != -1) {
                n = inputStream.read(byArray, 0, byArray.length);
                if (n <= 0) continue;
                byteArrayOutputStream.write(byArray, 0, n);
            }
            String string = new String(byteArrayOutputStream.toByteArray());
            this.applyConfig(string);
        }
        catch (Exception exception) {
            EditorPlugin.DBG.warning("error applying configuration", exception);
            throw exception;
        }
    }

    public void applyConfig(String string) throws Exception {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            Document document = XMLConfigUtil.getDocumentBuilder().parse(byteArrayInputStream);
            EditorPlugin.DBG.info("applying configuration");
            this.applyConfig(document);
            EditorPlugin.DBG.info("applying configuration to all modules");
            int n = 0;
            while (n < this.modules.size()) {
                StatConModule statConModule = (StatConModule)this.modules.get(n);
                statConModule.applyConfig(string);
                ++n;
            }
        }
        catch (Exception exception) {
            EditorPlugin.DBG.warning("error applying configuration", exception);
            throw exception;
        }
    }

    private void applyConfig(Document document) throws Exception {
        try {
            int n;
            Object object;
            Object object2;
            IWorkspaceRoot iWorkspaceRoot;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Element element = document.getDocumentElement();
            if (!element.getTagName().equals("smgconfig")) {
                EditorPlugin.DBG.error("bad configuration - no valid root <smgconfig> element");
                throw new Exception(EditorPlugin.getString("BAD_ROOT_XML_NODE"));
            }
            EditorPlugin.DBG.info("loading all module data");
            ArrayList arrayList = XMLConfigUtil.getAllElements(element.getChildNodes(), "module_data");
            int n2 = 0;
            while (n2 < arrayList.size()) {
                try {
                    object6 = (Element)arrayList.get(n2);
                    String string = object6.getAttribute("ref");
                    object5 = object6.getAttribute("data");
                    object4 = (StatConModule)this.module_refs.get(string);
                    if (object4 != null) {
                        object4.loadModuleData(HexData.hexStringToByteArray((String)object5));
                    } else {
                        EditorPlugin.DBG.warning("Found data for missing module " + string);
                    }
                }
                catch (Exception exception) {
                    EditorPlugin.DBG.error("Error loading data for module " + n2, exception);
                }
                ++n2;
            }
            object6 = XMLConfigUtil.getAllElements(element.getChildNodes(), "model");
            EditorPlugin.DBG.info("found " + ((ArrayList)object6).size() + " agent references");
            int n3 = 0;
            while (n3 < ((ArrayList)object6).size()) {
                try {
                    object5 = (Element)((ArrayList)object6).get(n3);
                    object4 = object5.getAttribute("file");
                    EditorPlugin.DBG.info("trying to load agent " + (String)object4);
                    object3 = new Path((String)object4);
                    iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    object2 = iWorkspaceRoot.getFile((IPath)object3);
                    this.addAgent((IFile)object2);
                }
                catch (Throwable throwable) {
                    EditorPlugin.DBG.logVisibleError(throwable, "Error loading agent from configuration", true);
                }
                ++n3;
            }
            object5 = XMLConfigUtil.getAllElements(element.getChildNodes(), "graph");
            EditorPlugin.DBG.info("found " + ((ArrayList)object5).size() + " graph configurations");
            int n4 = 0;
            while (n4 < ((ArrayList)object5).size()) {
                try {
                    boolean bl;
                    Object object7;
                    object3 = (Element)((ArrayList)object5).get(n4);
                    if (EditorPlugin.DBG.check("configuration")) {
                        EditorPlugin.DBG.info("applying graph configuration");
                    }
                    iWorkspaceRoot = this.parseColor(object3.getAttribute("color"), this.graph_window.getDisplay().getSystemColor(25));
                    boolean bl2 = XMLConfigUtil.parseBoolean(object3.getAttribute("match_colors"), false);
                    this.graph_window.setSlidersMatchGraph(bl2);
                    this.graph_window.setGraphBackground((Color)iWorkspaceRoot);
                    object = XMLConfigUtil.getAllElements(object3.getChildNodes(), "yslider");
                    ArrayList arrayList2 = XMLConfigUtil.getAllElements(object3.getChildNodes(), "xslider");
                    EditorPlugin.DBG.info("X slider count of " + arrayList2.size());
                    EditorPlugin.DBG.info("Y slider count of " + ((ArrayList)object).size());
                    while (this.graph_window.getYSliderCount() > ((ArrayList)object).size()) {
                        this.graph_window.removeYSlider(0);
                    }
                    while (this.graph_window.getYSliderCount() < Math.max(1, ((ArrayList)object).size())) {
                        this.graph_window.addYSlider();
                    }
                    while (this.graph_window.getXSliderCount() > arrayList2.size()) {
                        this.graph_window.removeXSlider(0);
                    }
                    while (this.graph_window.getXSliderCount() < Math.max(1, arrayList2.size())) {
                        this.graph_window.addXSlider();
                    }
                    n = 0;
                    while (n < ((ArrayList)object).size()) {
                        Element element2 = (Element)((ArrayList)object).get(n);
                        object7 = element2.getAttribute("title");
                        double d = XMLConfigUtil.parseDouble(element2.getAttribute("min_limit"), -1.0E8);
                        double d2 = XMLConfigUtil.parseDouble(element2.getAttribute("max_limit"), 1.0E8);
                        double d3 = XMLConfigUtil.parseDouble(element2.getAttribute("min_vis"), 0.0);
                        double d4 = XMLConfigUtil.parseDouble(element2.getAttribute("max_vis"), 5000.0);
                        double d5 = XMLConfigUtil.parseDouble(element2.getAttribute("resolution"), 0.01);
                        boolean bl3 = XMLConfigUtil.parseBoolean(element2.getAttribute("min_locked"), false);
                        bl = XMLConfigUtil.parseBoolean(element2.getAttribute("max_locked"), false);
                        EditorPlugin.DBG.info("Configuring Y slider " + n + " " + (String)object7);
                        ZoomSlider zoomSlider = this.graph_window.getYSlider(n);
                        zoomSlider.setTitle((String)object7);
                        zoomSlider.lock(0, bl3);
                        zoomSlider.lock(1, bl);
                        zoomSlider.configure(d, d2, d3, d4, d5);
                        ++n;
                    }
                    int n5 = 0;
                    while (n5 < arrayList2.size()) {
                        object7 = (Element)arrayList2.get(n5);
                        String string = object7.getAttribute("title");
                        double d = XMLConfigUtil.parseDouble(object7.getAttribute("min_limit"), 0.0);
                        double d6 = XMLConfigUtil.parseDouble(object7.getAttribute("max_limit"), 7200000.0);
                        double d7 = XMLConfigUtil.parseDouble(object7.getAttribute("min_vis"), 0.0);
                        double d8 = XMLConfigUtil.parseDouble(object7.getAttribute("max_vis"), 180000.0);
                        double d9 = XMLConfigUtil.parseDouble(object7.getAttribute("resolution"), 0.01);
                        bl = XMLConfigUtil.parseBoolean(object7.getAttribute("min_locked"), false);
                        boolean bl4 = XMLConfigUtil.parseBoolean(object7.getAttribute("max_locked"), false);
                        boolean bl5 = XMLConfigUtil.parseBoolean(object7.getAttribute("following"), false);
                        EditorPlugin.DBG.info("Configuring X slider " + n5);
                        TimeZoomSlider timeZoomSlider = this.graph_window.getXSlider(n5);
                        timeZoomSlider.setTitle(string);
                        timeZoomSlider.lock(0, bl);
                        timeZoomSlider.lock(1, bl4);
                        timeZoomSlider.configure(d, d6, d7, d8, d9);
                        this.graph_window.setTimeSliderFollowing(timeZoomSlider, bl5);
                        ++n5;
                    }
                }
                catch (Throwable throwable) {
                    EditorPlugin.DBG.logVisibleError(throwable, "Error applying graph configuration", true);
                }
                ++n4;
            }
            object3 = XMLConfigUtil.getAllElements(element.getChildNodes(), "agent");
            EditorPlugin.DBG.info("found " + ((ArrayList)object3).size() + " agent/model configurations");
            int n6 = 0;
            while (n6 < ((ArrayList)object3).size()) {
                try {
                    object2 = (Element)((ArrayList)object3).get(n6);
                    object = object2.getAttribute("name");
                    boolean bl = false;
                    n = 0;
                    while (n < this.agents.size()) {
                        StatAgent statAgent = (StatAgent)this.agents.get(n);
                        if (statAgent.agent != null && statAgent.agent.getName().equals(object)) {
                            EditorPlugin.DBG.info("Applying configuration to agent " + (String)object + "");
                            bl = true;
                            this.applyAgentConfig(statAgent, (Element)object2);
                        }
                        ++n;
                    }
                    if (!bl) {
                        EditorPlugin.DBG.warning("Could not find agent " + (String)object + " - unable to apply this config");
                    }
                }
                catch (Throwable throwable) {
                    EditorPlugin.DBG.logVisibleError(throwable, "Error applying agent/model configuration", true);
                }
                ++n6;
            }
            object2 = this.chooser_tree.getItems();
            int n7 = 0;
            while (n7 < ((Object)object2).length) {
                try {
                    this.treeItemSelected((TreeItem)object2[n7]);
                }
                catch (Throwable throwable) {
                    EditorPlugin.DBG.logVisibleError(throwable, "Error updating agent/model configuration", true);
                }
                ++n7;
            }
            this.graph_window.updateTables();
        }
        catch (Exception exception) {
            EditorPlugin.DBG.warning("error applying configuration", exception);
            throw exception;
        }
    }

    private HashMap mapChildrenByName(StatAgent statAgent) {
        HashMap<String, SDDescriptor> hashMap = new HashMap<String, SDDescriptor>(128, 0.75f);
        ArrayList arrayList = statAgent.model_roots;
        int n = 0;
        while (n < arrayList.size()) {
            SDDescriptor sDDescriptor = (SDDescriptor)arrayList.get(n);
            hashMap.put(sDDescriptor.getName(), sDDescriptor);
            ++n;
        }
        return hashMap;
    }

    private HashMap mapChildrenByName(TRCAgent tRCAgent) {
        HashMap<String, SDDescriptor> hashMap = new HashMap<String, SDDescriptor>(128, 0.75f);
        EList eList = tRCAgent.getDescriptor();
        int n = 0;
        while (n < eList.size()) {
            SDDescriptor sDDescriptor = (SDDescriptor)eList.get(n);
            hashMap.put(sDDescriptor.getName(), sDDescriptor);
            ++n;
        }
        return hashMap;
    }

    private HashMap mapChildrenByName(SDDescriptor sDDescriptor) {
        HashMap<String, SDDescriptor> hashMap = new HashMap<String, SDDescriptor>(128, 0.75f);
        EList eList = sDDescriptor.getChildren();
        int n = 0;
        while (n < eList.size()) {
            SDDescriptor sDDescriptor2 = (SDDescriptor)eList.get(n);
            hashMap.put(sDDescriptor2.getName(), sDDescriptor2);
            ++n;
        }
        return hashMap;
    }

    private void applyCBEConfig(TreeItem treeItem, Element element, boolean bl) throws Exception {
        if (element == null) {
            return;
        }
        boolean bl2 = XMLConfigUtil.parseBoolean(element.getAttribute("ticked"), true);
        boolean bl3 = XMLConfigUtil.parseBoolean(element.getAttribute("expanded"), false);
        treeItem.setChecked(bl2);
        treeItem.setExpanded(bl3);
        if (bl) {
            treeItem.setGrayed(false);
        } else {
            treeItem.setGrayed(true);
        }
        TreeItem[] treeItemArray = treeItem.getItems();
        HashMap<String, TreeItem> hashMap = new HashMap<String, TreeItem>();
        int n = 0;
        while (n < treeItemArray.length) {
            hashMap.put(treeItemArray[n].getText(), treeItemArray[n]);
            ++n;
        }
        ArrayList arrayList = XMLConfigUtil.getAllElements(element.getChildNodes(), "cbelog");
        int n2 = 0;
        while (n2 < arrayList.size()) {
            TreeItem treeItem2;
            Element element2 = (Element)arrayList.get(n2);
            String string = element2.getAttribute("name");
            if (string != null && (treeItem2 = (TreeItem)hashMap.get(string)) != null) {
                this.applyCBEConfig(treeItem2, element2, bl && bl2);
            }
            ++n2;
        }
    }

    private void applyAgentConfig(StatAgent statAgent, Element element) throws Exception {
        boolean bl = XMLConfigUtil.parseBoolean(element.getAttribute("ticked"), true);
        boolean bl2 = XMLConfigUtil.parseBoolean(element.getAttribute("expanded"), false);
        TreeItem treeItem = (TreeItem)this.reverse_map.get(statAgent.agent);
        treeItem.setChecked(bl);
        treeItem.setExpanded(bl2);
        Element element2 = XMLConfigUtil.getFirstElement(element.getChildNodes(), "cbelog");
        if (element2 != null) {
            this.applyCBEConfig(statAgent.msg_item, element2, bl);
        }
        ArrayList arrayList = XMLConfigUtil.getAllElements(element.getChildNodes(), "descriptor");
        EditorPlugin.DBG.info("found " + arrayList.size() + " model configurations");
        HashMap hashMap = this.mapChildrenByName(statAgent);
        int n = 0;
        while (n < arrayList.size()) {
            Element element3 = (Element)arrayList.get(n);
            String string = element3.getAttribute("name");
            boolean bl3 = false;
            SDDescriptor sDDescriptor = (SDDescriptor)hashMap.get(string);
            if (sDDescriptor != null) {
                if (EditorPlugin.DBG.check("configuration")) {
                    EditorPlugin.DBG.info("Applying configuration to model " + string);
                }
                try {
                    this.applyModelConfig(sDDescriptor, element3, bl);
                }
                catch (Throwable throwable) {
                    EditorPlugin.DBG.error("problem applying model configuration", throwable);
                }
            } else {
                EditorPlugin.DBG.warning("Could not find model " + string + " - unable to apply this model configuration");
            }
            ++n;
        }
    }

    private void applyModelConfig(SDDescriptor sDDescriptor, Element element, boolean bl) throws Exception {
        Element element2;
        int n;
        int n2;
        int n3;
        Object object;
        boolean bl2 = XMLConfigUtil.parseBoolean(element.getAttribute("ticked"), true);
        boolean bl3 = XMLConfigUtil.parseBoolean(element.getAttribute("expanded"), false);
        TreeItem treeItem = (TreeItem)this.reverse_map.get(sDDescriptor);
        treeItem.setChecked(bl2);
        treeItem.setExpanded(bl3);
        if (bl) {
            treeItem.setGrayed(false);
        } else {
            treeItem.setGrayed(true);
        }
        ArrayList arrayList = XMLConfigUtil.getAllElements(element.getChildNodes(), "obs_graph");
        int n4 = 0;
        while (n4 < arrayList.size()) {
            object = (Element)arrayList.get(n4);
            n3 = XMLConfigUtil.parseBoolean(object.getAttribute("ticked"), true);
            int n5 = (int)XMLConfigUtil.parseDouble(object.getAttribute("obs_index"), 0.0);
            n2 = (int)XMLConfigUtil.parseDouble(object.getAttribute("x_slider"), 0.0);
            n = (int)XMLConfigUtil.parseDouble(object.getAttribute("y_slider"), 0.0);
            element2 = this.parseColor(object.getAttribute("color"), this.graph_window.getDisplay().getSystemColor(this.colours[this.next++]));
            if (this.next >= this.colours.length) {
                this.next = 0;
            }
            int n6 = (int)XMLConfigUtil.parseDouble(object.getAttribute("line_width"), 1.0);
            int n7 = XMLConfigUtil.parseLineStyle(object.getAttribute("line_style"), 1);
            double d = XMLConfigUtil.parseDouble(object.getAttribute("multiplier"), 1.0);
            if (EditorPlugin.DBG.check("configuration")) {
                EditorPlugin.DBG.info("Applying graph configuration for " + sDDescriptor.getName() + " " + (n3 != 0) + " " + element2);
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 > this.graph_window.getXSliderCount()) {
                n2 = 0;
            }
            if (n < 0) {
                n = 0;
            }
            if (n > this.graph_window.getYSliderCount()) {
                n = 0;
            }
            if (sDDescriptor instanceof SDMemberDescriptor) {
                SDMemberDescriptor sDMemberDescriptor = (SDMemberDescriptor)sDDescriptor;
                EList eList = sDMemberDescriptor.getSnapshotObservation();
                if (n5 >= 0 && n5 < eList.size()) {
                    SDSnapshotObservation sDSnapshotObservation = (SDSnapshotObservation)eList.get(n5);
                    TreeItem treeItem2 = (TreeItem)this.reverse_map.get(sDSnapshotObservation);
                    treeItem2.setChecked(n3 != 0);
                    treeItem2.setGrayed(!bl2 || !bl);
                    this.treeItemSelected(treeItem2);
                    BasicGraphSource basicGraphSource = (BasicGraphSource)this.source_map.get(treeItem2);
                    if (basicGraphSource != null) {
                        Graph graph = (Graph)this.source_graph_map.get(basicGraphSource);
                        if (graph != null) {
                            graph.setXSlider(this.graph_window.getXSlider(n2));
                            graph.setYSlider(this.graph_window.getYSlider(n));
                            graph.setForeground((Color)element2);
                            graph.setLineWidth(n6);
                            graph.setLineStyle(n7);
                            graph.setStaticScaling(d);
                        } else {
                            EditorPlugin.DBG.warning("Could not find graph - no graph found for " + treeItem2.getText());
                        }
                    } else {
                        EditorPlugin.DBG.warning("Could not find graph - no graph source found for " + treeItem2.getText());
                    }
                } else {
                    EditorPlugin.DBG.warning("Could not find graph - observation index out of range " + n5 + " / " + eList.size());
                }
            } else {
                EditorPlugin.DBG.warning("Could not find graph - descriptor is not a member descriptor");
            }
            ++n4;
        }
        object = XMLConfigUtil.getAllElements(element.getChildNodes(), "control");
        n3 = 0;
        while (n3 < ((ArrayList)object).size()) {
            Element element3 = (Element)((ArrayList)object).get(n3);
            n2 = XMLConfigUtil.parseBoolean(element3.getAttribute("ticked"), true);
            n = (int)XMLConfigUtil.parseDouble(element3.getAttribute("y_slider"), 0.0);
            if (EditorPlugin.DBG.check("configuration")) {
                EditorPlugin.DBG.info("Applying control configuration for " + sDDescriptor.getName() + " (yslider:" + n + ")");
            }
            if (sDDescriptor instanceof SDMemberDescriptor) {
                element2 = (SDMemberDescriptor)sDDescriptor;
                SDRepresentation sDRepresentation = element2.getRepresentation();
                if (sDRepresentation instanceof SDModifiableVariableRepresentation) {
                    SDModifiableVariableRepresentation sDModifiableVariableRepresentation = (SDModifiableVariableRepresentation)sDRepresentation;
                    try {
                        TreeItem treeItem3 = (TreeItem)this.reverse_map.get(sDModifiableVariableRepresentation);
                        treeItem3.setChecked(n2 != 0);
                        treeItem3.setGrayed(!bl2 || !bl);
                        if (n >= 0 && n < this.graph_window.getYSliderCount()) {
                            this.bar_slider_map.put(treeItem3, this.graph_window.getYSlider(n));
                        }
                        this.treeItemSelected(treeItem3);
                        ModifiableVariableBar modifiableVariableBar = (ModifiableVariableBar)this.bar_map.get(treeItem3);
                        if (modifiableVariableBar != null) {
                            if (modifiableVariableBar.bar != null) {
                                this.graph_window.barMoved(modifiableVariableBar.bar, n);
                            }
                        } else {
                            EditorPlugin.DBG.warning("Could not find bar for representation " + treeItem3.getText());
                        }
                        if (n >= 0 && n < this.graph_window.getYSliderCount()) {
                            this.bar_slider_map.put(treeItem3, this.graph_window.getYSlider(n));
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        EditorPlugin.DBG.warning("Could not find rep item", nullPointerException);
                    }
                } else {
                    EditorPlugin.DBG.warning("Could not find control - representation is not a modifiable variable representation");
                }
            } else {
                EditorPlugin.DBG.warning("Could not find control - descriptor is not a member descriptor");
            }
            n3 += 1;
        }
        ArrayList arrayList2 = XMLConfigUtil.getAllElements(element.getChildNodes(), "descriptor");
        HashMap hashMap = this.mapChildrenByName(sDDescriptor);
        n = 0;
        while (n < arrayList2.size()) {
            element2 = (Element)arrayList2.get(n);
            String string = element2.getAttribute("name");
            SDDescriptor sDDescriptor2 = (SDDescriptor)hashMap.get(string);
            if (sDDescriptor2 != null) {
                if (EditorPlugin.DBG.check("configuration")) {
                    EditorPlugin.DBG.info("Applying configuration to descriptor " + string);
                }
                this.applyModelConfig(sDDescriptor2, element2, bl2 && bl);
            } else {
                EditorPlugin.DBG.warning("Could not find descriptor - descriptor of name " + string + " was not found under descriptor " + sDDescriptor.getName());
            }
            ++n;
        }
    }

    public String generateConfig() {
        return this.generateConfig("");
    }

    public String generateConfig(String string) {
        Object object;
        Object object2;
        Object object3;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        stringBuffer.append("<!-- Statistical Model Graph Viewer configuration file -->\n");
        stringBuffer.append("<!-- Not intended to be human editable - edit at your own risk -->\n");
        stringBuffer.append("<smgconfig>\n");
        stringBuffer.append(string);
        int n = 0;
        while (n < this.modules.size()) {
            StatConModule statConModule = (StatConModule)this.modules.get(n);
            object3 = statConModule.getModuleRef();
            try {
                object2 = statConModule.saveModuleData();
                object = HexData.byteArrayToHexString((byte[])object2);
                stringBuffer.append("<module_data ref=\"" + (String)object3 + "\" data=\"" + (String)object + "\" />\n");
            }
            catch (Exception exception) {
                EditorPlugin.DBG.logVisibleError(exception, "Error saving module data for " + (String)object3, false);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.agents.size()) {
            object3 = (StatAgent)this.agents.get(n2);
            object2 = ((StatAgent)object3).uri;
            if (object2 != null) {
                stringBuffer.append("<model file=\"").append(object2).append("\" />\n");
            }
            ++n2;
        }
        stringBuffer.append("<graph color=\"").append(XMLConfigUtil.colorToString(this.graph_window.getGraphBackground())).append("\" match_colors=\"").append(this.graph_window.getSlidersMatchGraph()).append("\" >\n");
        int n3 = 0;
        while (n3 < this.graph_window.getYSliderCount()) {
            object2 = (Object)this.graph_window.getYSlider(n3);
            stringBuffer.append("  <yslider ");
            stringBuffer.append("title=\"").append(((ZoomSlider)((Object)object2)).getTitle()).append("\" ");
            stringBuffer.append("min_limit=\"").append(((ZoomSlider)((Object)object2)).getMinLimit()).append("\" ");
            stringBuffer.append("max_limit=\"").append(((ZoomSlider)((Object)object2)).getMaxLimit()).append("\" ");
            stringBuffer.append("min_vis=\"").append(((ZoomSlider)((Object)object2)).getMinVisible()).append("\" ");
            stringBuffer.append("max_vis=\"").append(((ZoomSlider)((Object)object2)).getMaxVisible()).append("\" ");
            stringBuffer.append("resolution=\"").append(((ZoomSlider)((Object)object2)).getResolution()).append("\" ");
            stringBuffer.append("min_locked=\"").append(((ZoomSlider)((Object)object2)).isLocked(0)).append("\" ");
            stringBuffer.append("max_locked=\"").append(((ZoomSlider)((Object)object2)).isLocked(1)).append("\" ");
            stringBuffer.append("/>\n");
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.graph_window.getXSliderCount()) {
            object = this.graph_window.getXSlider(n4);
            stringBuffer.append("  <xslider ");
            stringBuffer.append("title=\"").append(((ZoomSlider)((Object)object)).getTitle()).append("\" ");
            stringBuffer.append("min_limit=\"").append(((ZoomSlider)((Object)object)).getMinLimit()).append("\" ");
            stringBuffer.append("max_limit=\"").append(((ZoomSlider)((Object)object)).getMaxLimit()).append("\" ");
            stringBuffer.append("min_vis=\"").append(((ZoomSlider)((Object)object)).getMinVisible()).append("\" ");
            stringBuffer.append("max_vis=\"").append(((ZoomSlider)((Object)object)).getMaxVisible()).append("\" ");
            stringBuffer.append("resolution=\"").append(((ZoomSlider)((Object)object)).getResolution()).append("\" ");
            stringBuffer.append("min_locked=\"").append(((ZoomSlider)((Object)object)).isLocked(0)).append("\" ");
            stringBuffer.append("max_locked=\"").append(((ZoomSlider)((Object)object)).isLocked(1)).append("\" ");
            stringBuffer.append("following=\"").append(this.graph_window.getTimeSliderFollowing((TimeZoomSlider)((Object)object))).append("\" ");
            stringBuffer.append("/>\n");
            ++n4;
        }
        stringBuffer.append("</graph>\n");
        int n5 = 0;
        while (n5 < this.agents.size()) {
            StatAgent statAgent = (StatAgent)this.agents.get(n5);
            this.generateConfig(stringBuffer, statAgent, 0);
            ++n5;
        }
        stringBuffer.append("</smgconfig>\n");
        return stringBuffer.toString();
    }

    public String generateConfig(TRCAgent tRCAgent) {
        StringBuffer stringBuffer = new StringBuffer();
        StatAgent statAgent = this.getStatAgent(tRCAgent);
        this.generateConfig(stringBuffer, statAgent, 0);
        return stringBuffer.toString();
    }

    private void generateConfig(StringBuffer stringBuffer, StatAgent statAgent, int n) {
        TreeItem treeItem = (TreeItem)this.reverse_map.get(statAgent.agent);
        if (treeItem == null) {
            return;
        }
        stringBuffer.append("<agent ");
        stringBuffer.append("name=\"").append(statAgent.agent.getName()).append("\" ");
        stringBuffer.append("ticked=\"").append(treeItem.getChecked()).append("\" ");
        stringBuffer.append("expanded=\"").append(treeItem.getExpanded()).append("\" ");
        stringBuffer.append(">\n");
        this.generateCBEConfig(stringBuffer, statAgent.msg_item, n + 1);
        int n2 = 0;
        while (n2 < statAgent.model_roots.size()) {
            SDDescriptor sDDescriptor = (SDDescriptor)statAgent.model_roots.get(n2);
            this.generateConfig(stringBuffer, sDDescriptor, n + 1);
            ++n2;
        }
        stringBuffer.append("</agent>");
    }

    private void generateCBEConfig(StringBuffer stringBuffer, TreeItem treeItem, int n) {
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("  ");
            ++n2;
        }
        stringBuffer.append("<cbelog ");
        stringBuffer.append("name=\"").append(treeItem.getText()).append("\" ");
        stringBuffer.append("ticked=\"").append(treeItem.getChecked()).append("\" ");
        stringBuffer.append("expanded=\"").append(treeItem.getExpanded()).append("\" ");
        stringBuffer.append(">\n");
        TreeItem[] treeItemArray = treeItem.getItems();
        int n3 = 0;
        while (n3 < treeItemArray.length) {
            this.generateCBEConfig(stringBuffer, treeItemArray[n3], n + 1);
            ++n3;
        }
        int n4 = 0;
        while (n4 < n) {
            stringBuffer.append("  ");
            ++n4;
        }
        stringBuffer.append("</cbelog>\n");
    }

    public String generateConfig(SDDescriptor sDDescriptor) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            EditorPlugin.DBG.info("generating StatCon configuration");
            this.generateConfig(stringBuffer, sDDescriptor, 0);
            return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            EditorPlugin.DBG.error("problem generating StatCon configuration", throwable);
            return null;
        }
    }

    private void generateConfig(StringBuffer stringBuffer, SDDescriptor sDDescriptor, int n) {
        TreeItem treeItem;
        Object object;
        EList eList;
        SDMemberDescriptor sDMemberDescriptor;
        TreeItem treeItem2 = (TreeItem)this.reverse_map.get(sDDescriptor);
        if (sDDescriptor == null) {
            return;
        }
        if (treeItem2 == null) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("  ");
            ++n2;
        }
        stringBuffer.append("<descriptor ");
        stringBuffer.append("name=\"").append(sDDescriptor.getName()).append("\" ");
        stringBuffer.append("ticked=\"").append(treeItem2.getChecked()).append("\" ");
        stringBuffer.append("expanded=\"").append(treeItem2.getExpanded()).append("\" ");
        stringBuffer.append(">\n");
        if (sDDescriptor instanceof SDMemberDescriptor) {
            sDMemberDescriptor = (SDMemberDescriptor)sDDescriptor;
            eList = sDMemberDescriptor.getSnapshotObservation();
            int n3 = 0;
            while (n3 < eList.size()) {
                TreeItem treeItem3;
                BasicGraphSource basicGraphSource;
                Graph graph;
                object = eList.get(n3);
                if ((object instanceof SDContiguousObservation || object instanceof SDTextObservation) && (graph = (Graph)this.source_graph_map.get(basicGraphSource = (BasicGraphSource)this.source_map.get(treeItem3 = (TreeItem)this.reverse_map.get(object)))) != null) {
                    int n4 = 0;
                    while (n4 < n) {
                        stringBuffer.append("  ");
                        ++n4;
                    }
                    stringBuffer.append("<obs_graph ");
                    stringBuffer.append("ticked=\"").append(treeItem3.getChecked()).append("\" ");
                    stringBuffer.append("obs_index=\"").append(n3).append("\" ");
                    stringBuffer.append("x_slider=\"").append(this.graph_window.getXSlider(graph.getXSlider())).append("\" ");
                    stringBuffer.append("y_slider=\"").append(this.graph_window.getYSlider(graph.getYSlider())).append("\" ");
                    stringBuffer.append("color=\"").append(XMLConfigUtil.colorToString(graph.getForeground())).append("\" ");
                    stringBuffer.append("line_width=\"").append(graph.getLineWidth()).append("\" ");
                    stringBuffer.append("line_style=\"").append(XMLConfigUtil.lineStyleToString(graph.getLineStyle())).append("\" ");
                    stringBuffer.append("multiplier=\"").append(graph.getStaticScaling()).append("\" ");
                    stringBuffer.append("/>\n");
                }
                ++n3;
            }
        }
        if (sDDescriptor instanceof SDMemberDescriptor && (eList = (sDMemberDescriptor = (SDMemberDescriptor)sDDescriptor).getRepresentation()) instanceof SDModifiableVariableRepresentation && (object = (ZoomSlider)((Object)this.bar_slider_map.get(treeItem = (TreeItem)this.reverse_map.get(eList)))) != null) {
            int n5 = 0;
            while (n5 < n) {
                stringBuffer.append("  ");
                ++n5;
            }
            stringBuffer.append("<control ");
            stringBuffer.append("ticked=\"").append(treeItem.getChecked()).append("\" ");
            stringBuffer.append("y_slider=\"").append(this.graph_window.getYSlider((ZoomSlider)((Object)object))).append("\" ");
            stringBuffer.append("/>\n");
        }
        sDMemberDescriptor = sDDescriptor.getChildren();
        int n6 = 0;
        while (n6 < sDMemberDescriptor.size()) {
            SDDescriptor sDDescriptor2 = (SDDescriptor)sDMemberDescriptor.get(n6);
            this.generateConfig(stringBuffer, sDDescriptor2, n + 1);
            ++n6;
        }
        int n7 = 0;
        while (n7 < n) {
            stringBuffer.append("  ");
            ++n7;
        }
        stringBuffer.append("</descriptor>\n");
    }

    public GraphWindow getGraphWindow() {
        return this.graph_window;
    }

    public void setConstantUpdate(String string, boolean bl, long l) {
        Boolean bl2 = new Boolean(bl);
        this.updates.put(string, bl2);
        boolean bl3 = false;
        Iterator iterator = this.updates.values().iterator();
        while (iterator.hasNext()) {
            Boolean bl4 = (Boolean)iterator.next();
            if (!bl4.booleanValue()) continue;
            bl3 = true;
            break;
        }
        if (bl) {
            this.graph_window.setConstantUpdate(bl3, l);
        } else {
            this.graph_window.setConstantUpdate(bl3);
        }
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        this.dispose();
    }

    public void dispose() {
        int n = 0;
        while (n < this.disposables.size()) {
            try {
                Object e = this.disposables.get(n);
                if (e != null) {
                    if (e instanceof Widget) {
                        ((Widget)e).dispose();
                    } else if (e instanceof Color) {
                        ((Color)e).dispose();
                    } else if (e instanceof Image) {
                        ((Image)e).dispose();
                    } else {
                        try {
                            EditorPlugin.disposeObject(e);
                        }
                        catch (Throwable throwable) {
                            EditorPlugin.DBG.warning("dispose object failed ", throwable);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            ++n;
        }
    }

    private void initAsSash(Composite composite) {
        this.sashfolder = new SashForm(composite, 0);
        this.sashfolder.setOrientation(256);
        this.leftsash = new Group((Composite)this.sashfolder, 0);
        this.rightsash = new Composite((Composite)this.sashfolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.leftsash.setLayout((Layout)gridLayout);
        this.rightsash.setLayout((Layout)new FillLayout());
        composite.addDisposeListener((DisposeListener)this);
        this.img = EditorPlugin.img;
        this.initChooser(this.leftsash);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.chooser_tree.setLayoutData((Object)gridData);
        this.initAggregateGraph(this.rightsash);
        this.sashfolder.setWeights(new int[]{30, 70});
        this.disposables.add(this.sashfolder);
        this.disposables.add(this.leftsash);
        this.disposables.add(this.rightsash);
    }

    private void initChooser(Composite composite) {
        this.chooser_tree = new Tree(composite, 32);
        this.disposables.add(this.chooser_tree);
        this.chooser_menu = new Menu((Control)this.chooser_tree);
        this.chooser_add = new MenuItem(this.chooser_menu, 0);
        this.chooser_add.setText(EditorPlugin.getString("ADD_NEW_TRACE"));
        this.chooser_add.setImage(this.img.getImage("smodel_trcagent.gif"));
        this.disposables.add(this.chooser_menu);
        this.disposables.add(this.chooser_add);
        this.chooser_tree.addMouseListener((MouseListener)this);
        this.chooser_add.addSelectionListener((SelectionListener)this);
        this.chooser_tree.addSelectionListener((SelectionListener)this);
        DropTarget dropTarget = new DropTarget((Control)this.chooser_tree, 7);
        dropTarget.addDropListener((DropTargetListener)this);
        Transfer[] transferArray = new Transfer[]{ResourceTransfer.getInstance()};
        dropTarget.setTransfer(transferArray);
        int n = 0;
        while (n < this.agents.size()) {
            StatAgent statAgent = (StatAgent)this.agents.get(n);
            int n2 = 0;
            while (n2 < statAgent.model_roots.size()) {
                SDDescriptor sDDescriptor = (SDDescriptor)statAgent.model_roots.get(n2);
                this.addModelToChooser(sDDescriptor, statAgent.agent, false);
                ++n2;
            }
            ++n;
        }
        this.updateAgentImages();
    }

    private void addModelToChooser(SDDescriptor sDDescriptor, TRCAgent tRCAgent, boolean bl) {
        TreeItem treeItem = (TreeItem)this.reverse_map.get(tRCAgent);
        this.addModelToChooser(sDDescriptor, treeItem, bl);
    }

    private void updateTreeItems() {
        TreeItem[] treeItemArray = this.chooser_tree.getItems();
        int n = 0;
        while (n < treeItemArray.length) {
            this.treeItemSelected(treeItemArray[n]);
            ++n;
        }
    }

    private String getTreeName(SDDescriptor sDDescriptor) {
        String string = null;
        string = sDDescriptor.getDescription() != null ? sDDescriptor.getName() + " (" + sDDescriptor.getDescription() + ")" : sDDescriptor.getName();
        if (string == null) {
            string = "";
        }
        if (string.length() == 0) {
            string = "(unknown)";
        }
        return string;
    }

    private void addObservations(SDDescriptor sDDescriptor, TreeItem treeItem, boolean bl) {
        SDMemberDescriptor sDMemberDescriptor;
        EList eList = null;
        Image image = null;
        if (sDDescriptor instanceof SDMemberDescriptor && (eList = (sDMemberDescriptor = (SDMemberDescriptor)sDDescriptor).getSnapshotObservation()) != null) {
            if (eList.size() > 0) {
                image = this.img.getImage("smodel_counter.gif");
            } else {
                eList = null;
            }
        }
        if (eList != null) {
            int n = 0;
            while (n < eList.size()) {
                SDSnapshotObservation sDSnapshotObservation = (SDSnapshotObservation)eList.get(n);
                if (sDSnapshotObservation instanceof SDContiguousObservation || sDSnapshotObservation instanceof SDDiscreteObservation || sDSnapshotObservation instanceof SDTextObservation) {
                    TreeItem treeItem2 = (TreeItem)this.reverse_map.get(sDSnapshotObservation);
                    if (!bl || treeItem2 == null) {
                        treeItem2 = new TreeItem(treeItem, 0, 0);
                        treeItem2.setText(sDDescriptor.getName() + " (Graph " + (n + 1) + ")");
                        treeItem2.setImage(image);
                        treeItem2.setGrayed(false);
                        treeItem2.setChecked(true);
                        this.counter_map.put(treeItem2, sDSnapshotObservation);
                        this.reverse_map.put(sDSnapshotObservation, treeItem2);
                        this.sddescriptor_map.put(treeItem2, sDDescriptor);
                    }
                }
                ++n;
            }
        }
    }

    private void addRepresentation(SDDescriptor sDDescriptor, TreeItem treeItem, boolean bl) {
        SDMemberDescriptor sDMemberDescriptor;
        SDRepresentation sDRepresentation;
        SDModifiableVariableRepresentation sDModifiableVariableRepresentation = null;
        Image image = null;
        if (sDDescriptor instanceof SDMemberDescriptor && (sDRepresentation = (sDMemberDescriptor = (SDMemberDescriptor)sDDescriptor).getRepresentation()) instanceof SDModifiableVariableRepresentation) {
            sDModifiableVariableRepresentation = (SDModifiableVariableRepresentation)sDRepresentation;
            image = sDModifiableVariableRepresentation.getImage();
        }
        if (sDModifiableVariableRepresentation != null) {
            sDMemberDescriptor = (TreeItem)this.reverse_map.get(sDModifiableVariableRepresentation);
            if (!bl || sDMemberDescriptor == null) {
                sDMemberDescriptor = new TreeItem(treeItem, 0, 0);
                sDMemberDescriptor.setText(sDDescriptor.getName() + " (Control)");
                sDMemberDescriptor.setImage(image);
                if (image == null) {
                    sDMemberDescriptor.setImage(this.img.getImage("smodel_modifiablerep.gif"));
                }
                sDMemberDescriptor.setGrayed(false);
                sDMemberDescriptor.setChecked(true);
                this.modifiable_map.put(sDMemberDescriptor, sDModifiableVariableRepresentation);
                this.reverse_map.put(sDModifiableVariableRepresentation, sDMemberDescriptor);
                this.sddescriptor_map.put(sDMemberDescriptor, sDDescriptor);
            }
        }
    }

    private void addModelToChooser(SDDescriptor sDDescriptor, TreeItem treeItem, boolean bl) {
        String string;
        if (sDDescriptor == null) {
            return;
        }
        TreeItem treeItem2 = (TreeItem)this.reverse_map.get(sDDescriptor);
        if (bl && treeItem2 != null) {
            string = this.getTreeName(sDDescriptor);
            if (!string.equals(treeItem2.getText())) {
                treeItem2.setText(string);
            }
        } else {
            treeItem2 = treeItem == null ? new TreeItem(this.chooser_tree, 0) : new TreeItem(treeItem, 0);
            treeItem2.setText(this.getTreeName(sDDescriptor));
            treeItem2.setImage(this.img.getImage("smodel_descriptor2.gif"));
            treeItem2.setChecked(true);
            treeItem2.setGrayed(false);
            this.reverse_map.put(sDDescriptor, treeItem2);
            this.sddescriptor_map.put(treeItem2, sDDescriptor);
        }
        this.addObservations(sDDescriptor, treeItem2, bl);
        this.addRepresentation(sDDescriptor, treeItem2, bl);
        string = sDDescriptor.getChildren();
        if (string == null) {
            return;
        }
        int n = 0;
        while (n < string.size()) {
            SDDescriptor sDDescriptor2 = (SDDescriptor)string.get(n);
            this.addModelToChooser(sDDescriptor2, treeItem2, bl);
            ++n;
        }
    }

    public void initAggregateGraph(Composite composite) {
        this.graph_window = new GraphWindow(composite, 0, this.dirtiable);
        this.graph_window.addUpdateRunnable(new CBEUpdate());
        this.disposables.add(this.graph_window);
    }

    public Control initTestGraph(Composite composite) {
        Color color = composite.getShell().getDisplay().getSystemColor(2);
        Color color2 = composite.getShell().getDisplay().getSystemColor(13);
        Color color3 = composite.getShell().getDisplay().getSystemColor(11);
        GraphWindow graphWindow = new GraphWindow(composite, 0);
        this.disposables.add(graphWindow);
        graphWindow.addXSlider();
        graphWindow.addYSlider();
        TestGraphSource testGraphSource = new TestGraphSource(-1000000.0, 1000000.0, 0);
        LineGraph lineGraph = new LineGraph(1, testGraphSource, graphWindow.getXSlider(0), graphWindow.getYSlider(0), color2);
        lineGraph.setLineWidth(2);
        TestGraphSource testGraphSource2 = new TestGraphSource(-1000000.0, 1000000.0, 1);
        HistogramGraph histogramGraph = new HistogramGraph(testGraphSource2, graphWindow.getXSlider(1), graphWindow.getYSlider(1), color3);
        histogramGraph.setLineWidth(2);
        this.graph_window.addGraph("Test Sine", "A test sine wave graph", lineGraph, null);
        this.graph_window.addGraph("Test Cosine", "A test cosine wave graph", histogramGraph, null);
        return graphWindow;
    }

    public SDDescriptor getSelectedDescriptor() {
        return this.selected_descriptor;
    }

    public void setDescriptorImage(SDDescriptor sDDescriptor, Image image) {
        TreeItem treeItem = (TreeItem)this.reverse_map.get(sDDescriptor);
        if (treeItem == null) {
            return;
        }
        treeItem.setImage(image);
    }

    public void dragEnter(DropTargetEvent dropTargetEvent) {
        dropTargetEvent.detail = 1;
    }

    public void dragLeave(DropTargetEvent dropTargetEvent) {
        dropTargetEvent.detail = 1;
    }

    public void dragOperationChanged(DropTargetEvent dropTargetEvent) {
        dropTargetEvent.detail = 1;
    }

    public void dragOver(DropTargetEvent dropTargetEvent) {
        dropTargetEvent.detail = 1;
    }

    public void dropAccept(DropTargetEvent dropTargetEvent) {
        dropTargetEvent.detail = 1;
    }

    public void drop(DropTargetEvent dropTargetEvent) {
        MessageBox messageBox;
        dropTargetEvent.detail = 1;
        if (dropTargetEvent.data == null) {
            dropTargetEvent.detail = 0;
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            messageBox = (MessageBox)dropTargetEvent.data;
            int n = 0;
            while (n < ((IResource[])messageBox).length) {
                String string = messageBox[n].getFullPath().toString();
                String string2 = string.substring(string.lastIndexOf(".") + 1);
                EditorPlugin.DBG.info("got dragged resource " + string);
                if (string2.equalsIgnoreCase("trcmxmi") || string2.equalsIgnoreCase("trcnxmi") || string2.equalsIgnoreCase("trcpxmi") || string2.equalsIgnoreCase("trcaxmi")) {
                    try {
                        this.addAgent(messageBox[n].getFullPath());
                        this.setDirty(true);
                    }
                    catch (Throwable throwable) {
                        stringBuffer.append(EditorPlugin.getString("INVALID_TRACE_FILE") + ":" + messageBox[n].getFullPath() + "\n");
                        EditorPlugin.DBG.warning("bad trace/model file drop ", throwable);
                    }
                } else {
                    try {
                        boolean bl = false;
                        int n2 = 0;
                        while (n2 < this.drop_listeners.size()) {
                            DropListener dropListener = (DropListener)this.drop_listeners.get(n2);
                            if (dropListener.extension.equalsIgnoreCase(string2) && dropListener.listener.drop(this, (IResource)messageBox[n])) {
                                bl = true;
                            }
                            ++n2;
                        }
                        if (!bl) {
                            dropTargetEvent.detail = 0;
                            throw new Exception(EditorPlugin.getString("NO_MODULE_ACCEPTED_DROP"));
                        }
                    }
                    catch (Throwable throwable) {
                        String string3 = throwable.getMessage();
                        if (string3 == null) {
                            string3 = "";
                        }
                        if (string3.length() > 0) {
                            stringBuffer.append(EditorPlugin.getString("INVALID_FILE") + ":" + messageBox[n].getFullPath() + " (" + throwable.getMessage() + ")\n");
                        } else {
                            stringBuffer.append(EditorPlugin.getString("INVALID_FILE") + ":" + messageBox[n].getFullPath() + " (no further information)\n");
                        }
                        EditorPlugin.DBG.warning("bad module file drop " + messageBox[n].getFullPath(), throwable);
                    }
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            stringBuffer.append(EditorPlugin.getString("INVALID_FILE_DROP") + ":" + throwable + "\n");
            EditorPlugin.DBG.error("bad file drop", throwable);
            dropTargetEvent.detail = 0;
            return;
        }
        if (stringBuffer.length() > 0) {
            messageBox = new MessageBox(this.graph_window.getShell(), 40);
            messageBox.setText(EditorPlugin.getString("INVALID_FILE_DROP_TITLE"));
            messageBox.setMessage(stringBuffer.toString());
            messageBox.open();
        }
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
    }

    public void mouseDown(MouseEvent mouseEvent) {
    }

    public void mouseUp(MouseEvent mouseEvent) {
        Object object;
        int n;
        StatAgent statAgent;
        TRCAgent tRCAgent;
        Point point = new Point(mouseEvent.x, mouseEvent.y);
        TreeItem treeItem = this.chooser_tree.getItem(point);
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        if (treeItem != null) {
            tRCAgent = (TRCAgent)this.trcagent_map.get(treeItem);
            statAgent = this.getStatAgent(tRCAgent);
            if (statAgent != null) {
                arrayList = statAgent.actions;
            } else {
                n = 0;
                while (n < this.root_nodes.size()) {
                    object = (RootNode)this.root_nodes.get(n);
                    if (((RootNode)object).item == treeItem) {
                        arrayList = ((RootNode)object).actions;
                        bl = true;
                    }
                    ++n;
                }
            }
        }
        tRCAgent = new ArrayList();
        if (treeItem != null && !bl) {
            int n2 = 0;
            while (n2 < this.graph_window.getYSliderCount()) {
                ZoomSlider zoomSlider = this.graph_window.getYSlider(n2);
                object = new BasicAction();
                ((BasicAction)object).name = EditorPlugin.getString("SET_ALL_VERTICAL_TO") + " " + zoomSlider.getTitle();
                ((BasicAction)object).image = this.img.getImage("slider_v.gif");
                ((BasicAction)object).runnable = new SetSliderAction(false, zoomSlider, treeItem);
                tRCAgent.add(object);
                ++n2;
            }
            n = 0;
            while (n < this.graph_window.getXSliderCount()) {
                object = this.graph_window.getXSlider(n);
                BasicAction basicAction = new BasicAction();
                basicAction.name = EditorPlugin.getString("SET_ALL_HORIZONTAL_TO") + " " + ((ZoomSlider)((Object)object)).getTitle();
                basicAction.image = this.img.getImage("slider_h.gif");
                basicAction.runnable = new SetSliderAction(true, (ZoomSlider)((Object)object), treeItem);
                tRCAgent.add(basicAction);
                ++n;
            }
        }
        if (treeItem != null) {
            statAgent = (SDDescriptor)this.sddescriptor_map.get(treeItem);
            this.selected_descriptor = statAgent;
            if (statAgent != null) {
                while (statAgent.getParent() != null) {
                    statAgent = statAgent.getParent();
                }
                n = 0;
                while (n < this.agents.size()) {
                    object = (StatAgent)this.agents.get(n);
                    if (((StatAgent)object).model_roots.contains(statAgent)) {
                        arrayList.addAll(((StatAgent)object).modelactions);
                        break;
                    }
                    ++n;
                }
            }
        }
        if (this.chooser_disposables != null) {
            int n3 = 0;
            while (n3 < this.chooser_disposables.size()) {
                MenuItem menuItem = (MenuItem)this.chooser_disposables.get(n3);
                menuItem.dispose();
                ++n3;
            }
        }
        this.chooser_disposables = new ArrayList();
        if (arrayList.size() > 0) {
            MenuItem menuItem = new MenuItem(this.chooser_menu, 2);
            this.chooser_disposables.add(menuItem);
            int n4 = 0;
            while (n4 < arrayList.size()) {
                object = (BasicAction)arrayList.get(n4);
                ((BasicAction)object).menuitem = new MenuItem(this.chooser_menu, 0);
                ((BasicAction)object).menuitem.setText(((BasicAction)object).name);
                ((BasicAction)object).menuitem.setImage(((BasicAction)object).image);
                ((BasicAction)object).menuitem.addSelectionListener((SelectionListener)object);
                this.chooser_disposables.add(((BasicAction)object).menuitem);
                ++n4;
            }
        }
        if (tRCAgent.size() > 0) {
            MenuItem menuItem = new MenuItem(this.chooser_menu, 2);
            this.chooser_disposables.add(menuItem);
            int n5 = 0;
            while (n5 < tRCAgent.size()) {
                object = (BasicAction)tRCAgent.get(n5);
                ((BasicAction)object).menuitem = new MenuItem(this.chooser_menu, 0);
                ((BasicAction)object).menuitem.setText(((BasicAction)object).name);
                ((BasicAction)object).menuitem.setImage(((BasicAction)object).image);
                ((BasicAction)object).menuitem.addSelectionListener((SelectionListener)object);
                this.chooser_disposables.add(((BasicAction)object).menuitem);
                ++n5;
            }
        }
        if (mouseEvent.button > 1) {
            this.chooser_menu.setVisible(true);
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.widgetSelected(selectionEvent);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        Object object = selectionEvent.getSource();
        this.widgetSelected(selectionEvent.item, object);
    }

    public void widgetSelected(Widget widget, Object object) {
        if (object == this.chooser_tree) {
            if (widget == null) {
                return;
            }
            if (widget instanceof TreeItem) {
                TreeItem treeItem = (TreeItem)widget;
                boolean bl = treeItem.getChecked();
                this.treeItemSelected(treeItem);
            }
        } else if (object == this.chooser_add) {
            EditorPlugin.DBG.info("add agent file - opening ResourceSelectionDialog");
            ResourceSelectionDialog resourceSelectionDialog = new ResourceSelectionDialog(this.graph_window.getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), "Please choose one or more statistical models");
            resourceSelectionDialog.open();
            Object[] objectArray = resourceSelectionDialog.getResult();
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    EditorPlugin.DBG.info("" + objectArray[n].getClass());
                    if (objectArray[n] instanceof IFile) {
                        try {
                            IFile iFile = (IFile)objectArray[n];
                            EditorPlugin.DBG.info("trying to add " + iFile);
                            this.addAgent(iFile.getFullPath());
                            this.setDirty(true);
                            this.chooser_tree.redraw();
                        }
                        catch (Throwable throwable) {
                            EditorPlugin.DBG.error("model add failed", throwable);
                        }
                    }
                    ++n;
                }
            }
        }
    }

    public void removeAgent(TRCAgent tRCAgent) {
        TreeItem treeItem;
        StatAgent statAgent = this.getStatAgent(tRCAgent);
        ((AbstractCollection)this.agents).remove(statAgent);
        if (statAgent == null) {
            return;
        }
        int n = 0;
        while (n < this.agent_change_listeners.size()) {
            AgentChangeListener agentChangeListener = (AgentChangeListener)this.agent_change_listeners.get(n);
            agentChangeListener.agentRemoved(tRCAgent);
            ++n;
        }
        int n2 = 0;
        while (n2 < statAgent.model_roots.size()) {
            treeItem = (SDDescriptor)statAgent.model_roots.get(n2);
            int n3 = 0;
            while (n3 < this.model_change_listeners.size()) {
                ModelChangeListener modelChangeListener = (ModelChangeListener)this.model_change_listeners.get(n3);
                modelChangeListener.modelRemoved((SDDescriptor)treeItem);
                ++n3;
            }
            ++n2;
        }
        treeItem = (TreeItem)this.reverse_map.get(tRCAgent);
        this.removeTreeItemRef(treeItem);
        this.graph_window.updateTables();
        if (treeItem != null) {
            treeItem.dispose();
            ((AbstractCollection)this.disposables).remove(treeItem);
        }
        this.setDirty(true);
        EditorPlugin.DBG.info("Reverse Map Items = " + this.reverse_map.values().size());
        EditorPlugin.DBG.info("SDDescriptor Map Items = " + this.sddescriptor_map.values().size());
        EditorPlugin.DBG.info("Counter Map Items = " + this.counter_map.values().size());
        EditorPlugin.DBG.info("Modifiable Map Items = " + this.modifiable_map.values().size());
        EditorPlugin.DBG.info("Graph Map Items = " + this.graph_map.values().size());
        EditorPlugin.DBG.info("Bar Map Items = " + this.bar_map.values().size());
        EditorPlugin.DBG.info("Bar Slider Map Items = " + this.bar_slider_map.values().size());
        EditorPlugin.DBG.info("Source Map Items = " + this.source_map.values().size());
        EditorPlugin.DBG.info("Source Graph Map Items = " + this.source_graph_map.values().size());
        EditorPlugin.DBG.info("Disposables Items = " + this.disposables.size());
        EditorPlugin.DBG.info("Model Items = " + this.agents.size());
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        long l = runtime.totalMemory() - runtime.freeMemory();
        EditorPlugin.DBG.info("USED MEMORY = " + l / 1024L + "k (+" + (l - this.prev_used) + ")");
        this.prev_used = l;
    }

    private void removeTreeItemRef(TreeItem treeItem) {
        TreeItem[] treeItemArray;
        if (treeItem == null) {
            return;
        }
        Object v = this.trcagent_map.remove(treeItem);
        TreeItem treeItem2 = (TreeItem)this.reverse_map.remove(v);
        Object v2 = this.sddescriptor_map.remove(treeItem);
        TreeItem treeItem3 = (TreeItem)this.reverse_map.remove(v2);
        TreeItem treeItem4 = null;
        TreeItem treeItem5 = null;
        if (v2 instanceof SDMemberDescriptor) {
            treeItemArray = (TreeItem[])v2;
            SDRepresentation sDRepresentation = treeItemArray.getRepresentation();
            treeItem4 = (TreeItem)this.reverse_map.remove(sDRepresentation);
            SDModifiableVariableRepresentation sDModifiableVariableRepresentation = (SDModifiableVariableRepresentation)this.modifiable_map.remove(treeItem4);
            try {
                if (sDModifiableVariableRepresentation != null) {
                    this.graph_window.removeControl(sDModifiableVariableRepresentation);
                }
            }
            catch (Throwable throwable) {
                EditorPlugin.DBG.error("problem removing control from graph window", throwable);
            }
            ZoomSlider zoomSlider = (ZoomSlider)((Object)this.bar_slider_map.remove(treeItem4));
            ModifiableVariableBar modifiableVariableBar = (ModifiableVariableBar)this.bar_map.remove(treeItem4);
            if (modifiableVariableBar != null) {
                try {
                    if (modifiableVariableBar.bar.getZoomSlider() != null) {
                        modifiableVariableBar.bar.getZoomSlider().removeZoomControlBar(modifiableVariableBar.bar);
                        modifiableVariableBar.bar.dispose();
                        ((AbstractCollection)this.disposables).remove(modifiableVariableBar.bar);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    EditorPlugin.DBG.warning("bar zoomslider not found", nullPointerException);
                }
            }
            EList eList = treeItemArray.getSnapshotObservation();
            int n = 0;
            while (n < eList.size()) {
                Object e = eList.get(n);
                treeItem5 = (TreeItem)this.reverse_map.remove(e);
                SDSnapshotObservation sDSnapshotObservation = (SDSnapshotObservation)this.counter_map.remove(treeItem5);
                Graph graph = (Graph)this.graph_map.remove(treeItem5);
                try {
                    if (graph != null) {
                        graph.setUseIndicator(false);
                        this.graph_window.removeGraph(graph);
                    }
                }
                catch (Throwable throwable) {
                    EditorPlugin.DBG.error("problem removing graph from graph window", throwable);
                }
                BasicGraphSource basicGraphSource = (BasicGraphSource)this.source_map.remove(treeItem5);
                if (basicGraphSource != null) {
                    this.source_graph_map.remove(basicGraphSource);
                }
                ++n;
            }
        }
        treeItemArray = treeItem.getItems();
        int n = 0;
        while (n < treeItemArray.length) {
            this.removeTreeItemRef(treeItemArray[n]);
            ++n;
        }
        treeItem.dispose();
        if (treeItem4 != null) {
            treeItem4.dispose();
        }
        if (treeItem5 != null) {
            treeItem5.dispose();
        }
    }

    public void treeItemSelected(TreeItem treeItem) {
        try {
            TreeItem treeItem2 = treeItem;
            while (treeItem2 != null) {
                if (treeItem2.getText().equals("Messages")) {
                    this.redoAllCBEs();
                    break;
                }
                treeItem2 = treeItem2.getParentItem();
            }
            boolean bl = true;
            TreeItem treeItem3 = treeItem.getParentItem();
            while (treeItem3 != null) {
                if (!treeItem3.getChecked()) {
                    bl = false;
                    break;
                }
                treeItem3 = treeItem3.getParentItem();
            }
            if (treeItem.getParentItem() == null) {
                boolean bl2 = treeItem.getGrayed();
                this.treeItemSelected(treeItem, bl);
                treeItem.setGrayed(bl2);
            } else {
                this.treeItemSelected(treeItem, bl);
            }
            this.graph_window.redraw();
        }
        catch (Throwable throwable) {
            EditorPlugin.DBG.logVisibleError(throwable, "Error updating StatCon tree", false);
        }
    }

    public void treeItemSelected(TreeItem treeItem, boolean bl) {
        StatAgent statAgent;
        boolean bl2 = treeItem.getChecked();
        if (!bl) {
            bl2 = false;
            if (!treeItem.getGrayed()) {
                this.setDirty(true);
            }
            treeItem.setGrayed(true);
        } else {
            if (treeItem.getGrayed()) {
                this.setDirty(true);
            }
            treeItem.setGrayed(false);
        }
        EList eList = (EList)this.msglist_map.get(treeItem);
        if (eList != null) {
            statAgent = this.getStatAgent(eList);
            if (bl2 && !statAgent.show_messages) {
                statAgent.show_messages = true;
                this.redoAllCBEs();
                this.setDirty(true);
            } else if (!bl2 && statAgent.show_messages) {
                statAgent.show_messages = false;
                this.redoAllCBEs();
                this.setDirty(true);
            }
        }
        if ((statAgent = (SDSnapshotObservation)this.counter_map.get(treeItem)) != null) {
            Graph graph = (Graph)this.graph_map.get(treeItem);
            BasicGraphSource basicGraphSource = (BasicGraphSource)this.source_map.get(treeItem);
            if (basicGraphSource == null) {
                if (statAgent instanceof SDContiguousObservation) {
                    basicGraphSource = new SDSnapshotObservationGraphSource((SDContiguousObservation)statAgent);
                } else if (statAgent instanceof SDDiscreteObservation) {
                    basicGraphSource = new SDSnapshotObservationGraphSource((SDDiscreteObservation)statAgent);
                } else if (statAgent instanceof SDTextObservation) {
                    basicGraphSource = new SDTextObservationGraphSource((SDTextObservation)statAgent);
                } else {
                    EditorPlugin.DBG.info("SnapshotObservation neither Contiguous nor Discrete!");
                    return;
                }
                this.source_map.put(treeItem, basicGraphSource);
            }
            if (graph == null && bl2) {
                Color color;
                this.setDirty(true);
                graph = (Graph)this.source_graph_map.get(basicGraphSource);
                if (graph == null) {
                    color = treeItem.getDisplay().getSystemColor(this.colours[this.next++]);
                    if (this.next >= this.colours.length) {
                        this.next = 0;
                    }
                    if (basicGraphSource instanceof GraphSource) {
                        graph = new LineGraph(1, (SDSnapshotObservationGraphSource)basicGraphSource, this.graph_window.getXSlider(0), this.graph_window.getYSlider(0), color);
                    } else if (basicGraphSource instanceof EnumerationGraphSource) {
                        graph = new EnumerationGraph(this.graph_window.getXSlider(0), this.graph_window.getYSlider(0), color, (SDTextObservationGraphSource)basicGraphSource);
                    }
                    this.source_graph_map.put(basicGraphSource, graph);
                }
                if (graph.getXSlider().isDisposed()) {
                    graph.setXSlider(this.graph_window.getXSlider(0));
                }
                if (graph.getYSlider().isDisposed()) {
                    graph.setYSlider(this.graph_window.getYSlider(0));
                }
                color = (SDDescriptor)this.sddescriptor_map.get(treeItem);
                graph.setUseIndicator(true);
                this.graph_window.addGraph(treeItem.getText(), color.getDescription(), graph, (SDDescriptor)color);
            } else if (graph != null && !bl2) {
                this.setDirty(true);
                graph.setUseIndicator(false);
                this.graph_window.removeGraph(graph);
            }
            if (bl2) {
                this.graph_map.put(treeItem, graph);
            } else {
                this.graph_map.remove(treeItem);
            }
            return;
        }
        SDModifiableVariableRepresentation sDModifiableVariableRepresentation = (SDModifiableVariableRepresentation)this.modifiable_map.get(treeItem);
        if (sDModifiableVariableRepresentation != null) {
            ModifiableVariableBar modifiableVariableBar = (ModifiableVariableBar)this.bar_map.get(treeItem);
            if (modifiableVariableBar == null && bl2) {
                this.setDirty(true);
                ZoomSlider zoomSlider = (ZoomSlider)((Object)this.bar_slider_map.get(treeItem));
                if (zoomSlider == null) {
                    zoomSlider = this.graph_window.getYSlider(0);
                }
                if (zoomSlider.isDisposed()) {
                    zoomSlider = this.graph_window.getYSlider(0);
                }
                Image image = sDModifiableVariableRepresentation.getImage();
                ZoomImageBar zoomImageBar = null;
                if (sDModifiableVariableRepresentation.getModifierType() != 4 && image != null && sDModifiableVariableRepresentation.hasBar()) {
                    zoomImageBar = new ZoomImageBar(zoomSlider, ((Number)sDModifiableVariableRepresentation.getLastRequestedValue()).doubleValue(), image, image, image.getBounds().height + 6);
                    zoomImageBar.setToolTipText(treeItem.getText());
                    modifiableVariableBar = new ModifiableVariableBar(this, zoomImageBar, sDModifiableVariableRepresentation, this.dirtiable);
                    zoomImageBar.addZoomControlBarListener(modifiableVariableBar);
                } else {
                    modifiableVariableBar = new ModifiableVariableBar(this, zoomImageBar, sDModifiableVariableRepresentation, this.dirtiable);
                }
                SDDescriptor sDDescriptor = (SDDescriptor)this.sddescriptor_map.get(treeItem);
                this.graph_window.addControl(treeItem.getText(), sDDescriptor.getDescription(), image, zoomImageBar, sDModifiableVariableRepresentation);
                if (zoomImageBar != null) {
                    this.disposables.add(zoomImageBar);
                }
                if (sDModifiableVariableRepresentation.getModifierType() != 4 && image != null && sDModifiableVariableRepresentation.hasBar()) {
                    modifiableVariableBar.bar.getZoomSlider().addZoomControlBar(modifiableVariableBar.bar);
                }
            } else if (modifiableVariableBar != null && !bl2) {
                this.setDirty(true);
                ZoomControlBar zoomControlBar = modifiableVariableBar.bar;
                try {
                    this.bar_slider_map.put(treeItem, zoomControlBar.getZoomSlider());
                    zoomControlBar.dispose();
                    zoomControlBar.getZoomSlider().removeZoomControlBar(zoomControlBar);
                    ((AbstractCollection)this.disposables).remove(zoomControlBar);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.graph_window.removeControl(sDModifiableVariableRepresentation);
            }
            if (bl2) {
                this.bar_map.put(treeItem, modifiableVariableBar);
            } else {
                this.bar_map.remove(treeItem);
            }
            return;
        }
        TreeItem[] treeItemArray = treeItem.getItems();
        int n = 0;
        while (n < treeItemArray.length) {
            this.treeItemSelected(treeItemArray[n], bl2);
            ++n;
        }
    }

    private void setTreeItemSlider(TreeItem treeItem, boolean bl, ZoomSlider zoomSlider) {
        Graph graph;
        ModifiableVariableBar modifiableVariableBar = this.getVariableBar(treeItem);
        if (!bl) {
            this.bar_slider_map.put(treeItem, zoomSlider);
            try {
                if (modifiableVariableBar.bar.getZoomSlider() != null) {
                    modifiableVariableBar.bar.getZoomSlider().removeZoomControlBar(modifiableVariableBar.bar);
                    modifiableVariableBar.bar.setZoomSlider(zoomSlider);
                    modifiableVariableBar.bar.getZoomSlider().addZoomControlBar(modifiableVariableBar.bar);
                }
            }
            catch (NullPointerException nullPointerException) {
                EditorPlugin.DBG.warning("bar zoomslider not found", nullPointerException);
            }
        }
        if ((graph = this.getGraph(treeItem)) != null) {
            if (bl) {
                graph.setXSlider((TimeZoomSlider)zoomSlider);
            } else {
                graph.setYSlider(zoomSlider);
            }
        }
        TreeItem[] treeItemArray = treeItem.getItems();
        int n = 0;
        while (n < treeItemArray.length) {
            this.setTreeItemSlider(treeItemArray[n], bl, zoomSlider);
            ++n;
        }
    }

    private SDDescriptor getDescriptor(TreeItem treeItem) {
        SDDescriptor sDDescriptor = (SDDescriptor)this.sddescriptor_map.get(treeItem);
        return sDDescriptor;
    }

    private SDMemberDescriptor getMemberDescriptor(TreeItem treeItem) {
        SDDescriptor sDDescriptor = (SDDescriptor)this.sddescriptor_map.get(treeItem);
        if (sDDescriptor instanceof SDMemberDescriptor) {
            return (SDMemberDescriptor)sDDescriptor;
        }
        return null;
    }

    private SDModifiableVariableRepresentation getRepresentation(TreeItem treeItem) {
        SDModifiableVariableRepresentation sDModifiableVariableRepresentation = (SDModifiableVariableRepresentation)this.modifiable_map.get(treeItem);
        return sDModifiableVariableRepresentation;
    }

    private ModifiableVariableBar getVariableBar(TreeItem treeItem) {
        ModifiableVariableBar modifiableVariableBar = (ModifiableVariableBar)this.bar_map.get(treeItem);
        return modifiableVariableBar;
    }

    private SDSnapshotObservation getObservation(TreeItem treeItem) {
        SDSnapshotObservation sDSnapshotObservation = (SDSnapshotObservation)this.counter_map.get(treeItem);
        return sDSnapshotObservation;
    }

    private BasicGraphSource getGraphSource(TreeItem treeItem) {
        BasicGraphSource basicGraphSource = (BasicGraphSource)this.source_map.get(treeItem);
        return basicGraphSource;
    }

    private Graph getGraph(TreeItem treeItem) {
        BasicGraphSource basicGraphSource = this.getGraphSource(treeItem);
        if (basicGraphSource == null) {
            return null;
        }
        Graph graph = (Graph)this.source_graph_map.get(basicGraphSource);
        return graph;
    }

    class StatAgent {
        TRCAgent agent = null;
        Image image = null;
        ArrayList actions = new ArrayList();
        ArrayList modelactions = new ArrayList();
        ArrayList model_roots = new ArrayList();
        URI uri;
        int msgindex = 0;
        boolean show_messages = true;
        TreeItem msg_item = null;
        TreeItem msg_info_item = null;
        TreeItem msg_warn_item = null;
        TreeItem msg_error_item = null;
        TreeItem msg_loc_item = null;
        HashMap msg_locations = new HashMap();

        StatAgent() {
        }
    }

    class RootNode {
        String name;
        Image image;
        ArrayList actions = new ArrayList();
        TreeItem item;
        String id;
        String parent_id;
        ArrayList node_children = new ArrayList();

        RootNode() {
        }

        public void dispose() {
            this.item.dispose();
        }
    }

    class CBEUpdate
    implements Runnable {
        CBEUpdate() {
        }

        public void run() {
            CopyOfStatisticalModelGraphViewer.this.appendAllCBEs();
        }
    }

    class CBEComparator
    implements Comparator {
        CBEComparator() {
        }

        public int compare(Object object, Object object2) {
            CBECommonBaseEvent cBECommonBaseEvent = (CBECommonBaseEvent)object;
            CBECommonBaseEvent cBECommonBaseEvent2 = (CBECommonBaseEvent)object2;
            return (int)(cBECommonBaseEvent.getCreationTime() - cBECommonBaseEvent2.getCreationTime());
        }
    }

    class SetSliderAction
    implements Runnable {
        boolean horizontal;
        ZoomSlider slider;
        TreeItem item;

        public SetSliderAction(boolean bl, ZoomSlider zoomSlider, TreeItem treeItem) {
            this.horizontal = bl;
            this.slider = zoomSlider;
            this.item = treeItem;
        }

        public void run() {
            CopyOfStatisticalModelGraphViewer.this.setTreeItemSlider(this.item, this.horizontal, this.slider);
            CopyOfStatisticalModelGraphViewer.this.graph_window.redraw();
            CopyOfStatisticalModelGraphViewer.this.graph_window.updateTables();
        }
    }

    class BasicAction
    implements SelectionListener {
        String id = "unknown";
        String name;
        Runnable runnable;
        MenuItem menuitem;
        Image image;

        BasicAction() {
        }

        public void dispose() {
            if (this.menuitem != null) {
                this.menuitem.dispose();
            }
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            this.runnable.run();
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            this.runnable.run();
        }
    }

    class DropListener {
        String extension;
        StatConDropListener listener;

        DropListener() {
        }
    }

    abstract class TreeAction {
        TreeAction() {
        }

        public abstract void run(TreeItem var1);
    }

    class AgentRemoveAction
    implements Runnable {
        TRCAgent ragent;

        public AgentRemoveAction(TRCAgent tRCAgent) {
            this.ragent = tRCAgent;
        }

        public void run() {
            CopyOfStatisticalModelGraphViewer.this.removeAgent(this.ragent);
            CopyOfStatisticalModelGraphViewer.this.redoAllCBEs();
        }
    }
}

