/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.model.statistical.SDContiguousObservation;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDDiscreteObservation;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDRepresentation;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.model.statistical.SDTextObservation;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.ImageManager;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConModelOp;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConOpState;
import org.eclipse.hyades.statistical.ui.editor.internal.StatisticalModelGraphViewer;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDModifiableVariableRepresentation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TreeItem;

public class OpAddToTree
implements StatConModelOp {
    public static OpAddToTree INSTANCE = new OpAddToTree();
    static ImageManager img = EditorPlugin.img;

    public static void launch(StatisticalModelGraphViewer statisticalModelGraphViewer, SDDescriptor sDDescriptor, SDDescriptor sDDescriptor2, boolean bl) {
        StatConOpState statConOpState = new StatConOpState(new Boolean(bl));
        statisticalModelGraphViewer.applyStatConModelOp(new OpAddToTree(), statConOpState, sDDescriptor, sDDescriptor2);
    }

    private String getTreeName(SDDescriptor sDDescriptor) {
        String string = null;
        string = sDDescriptor.getDescription() != null ? sDDescriptor.getName() + " (" + sDDescriptor.getDescription() + ")" : sDDescriptor.getName();
        if (string == null) {
            string = "";
        }
        if (string.length() == 0) {
            string = "(unknown)";
        }
        return string;
    }

    public void postapply(StatConOpState statConOpState, StatisticalModelGraphViewer statisticalModelGraphViewer, SDDescriptor sDDescriptor, SDDescriptor sDDescriptor2, boolean bl, boolean bl2) {
    }

    public StatConOpState preapply(StatConOpState statConOpState, StatisticalModelGraphViewer statisticalModelGraphViewer, SDDescriptor sDDescriptor, SDDescriptor sDDescriptor2, boolean bl, boolean bl2) {
        if (sDDescriptor == null) {
            return statConOpState;
        }
        if (sDDescriptor.getName() == null) {
            return statConOpState;
        }
        boolean bl3 = (Boolean)statConOpState.state;
        TreeItem treeItem = statisticalModelGraphViewer.mapDescriptorToItem(sDDescriptor);
        TreeItem treeItem2 = statisticalModelGraphViewer.mapDescriptorToItem(sDDescriptor.getParent());
        if (bl3 && treeItem != null) {
            String string = this.getTreeName(sDDescriptor);
            if (!string.equals(treeItem.getText())) {
                treeItem.setText(string);
            }
        } else {
            if (treeItem2 == null) {
                TRCAgent tRCAgent = sDDescriptor.getAgent();
                if (tRCAgent == null) {
                    return statConOpState;
                }
                treeItem = new TreeItem(statisticalModelGraphViewer.mapAgentToItem(tRCAgent), 0);
            } else {
                treeItem = new TreeItem(treeItem2, 0);
            }
            treeItem.setText(this.getTreeName(sDDescriptor));
            treeItem.setImage(img.getImage("smodel_descriptor2.gif"));
            treeItem.setChecked(true);
            treeItem.setGrayed(false);
            statisticalModelGraphViewer.mapDescriptorToItem(sDDescriptor, treeItem);
        }
        this.addObservations(statisticalModelGraphViewer, sDDescriptor, treeItem, bl3);
        this.addRepresentation(statisticalModelGraphViewer, sDDescriptor, treeItem, bl3);
        return statConOpState;
    }

    private void addObservations(StatisticalModelGraphViewer statisticalModelGraphViewer, SDDescriptor sDDescriptor, TreeItem treeItem, boolean bl) {
        SDMemberDescriptor sDMemberDescriptor;
        EList eList = null;
        Image image = null;
        if (sDDescriptor instanceof SDMemberDescriptor && (eList = (sDMemberDescriptor = (SDMemberDescriptor)sDDescriptor).getSnapshotObservation()) != null) {
            if (eList.size() > 0) {
                image = img.getImage("smodel_counter.gif");
            } else {
                eList = null;
            }
        }
        if (eList != null) {
            int n = 0;
            while (n < eList.size()) {
                SDSnapshotObservation sDSnapshotObservation = (SDSnapshotObservation)eList.get(n);
                if (sDSnapshotObservation instanceof SDContiguousObservation || sDSnapshotObservation instanceof SDDiscreteObservation || sDSnapshotObservation instanceof SDTextObservation) {
                    TreeItem treeItem2 = statisticalModelGraphViewer.mapObservationToItem(sDSnapshotObservation);
                    if (!bl || treeItem2 == null) {
                        treeItem2 = new TreeItem(treeItem, 0, 0);
                        treeItem2.setText(sDDescriptor.getName() + " (Graph " + (n + 1) + ")");
                        treeItem2.setImage(image);
                        treeItem2.setGrayed(false);
                        treeItem2.setChecked(true);
                        statisticalModelGraphViewer.mapObservationToItem(sDSnapshotObservation, treeItem2);
                    }
                }
                ++n;
            }
        }
    }

    private void addRepresentation(StatisticalModelGraphViewer statisticalModelGraphViewer, SDDescriptor sDDescriptor, TreeItem treeItem, boolean bl) {
        SDMemberDescriptor sDMemberDescriptor;
        SDRepresentation sDRepresentation;
        SDModifiableVariableRepresentation sDModifiableVariableRepresentation = null;
        Image image = null;
        if (sDDescriptor instanceof SDMemberDescriptor && (sDRepresentation = (sDMemberDescriptor = (SDMemberDescriptor)sDDescriptor).getRepresentation()) instanceof SDModifiableVariableRepresentation) {
            sDModifiableVariableRepresentation = (SDModifiableVariableRepresentation)sDRepresentation;
            image = sDModifiableVariableRepresentation.getImage();
        }
        if (sDModifiableVariableRepresentation != null) {
            sDMemberDescriptor = statisticalModelGraphViewer.mapRepresentationToItem(sDModifiableVariableRepresentation);
            if (!bl || sDMemberDescriptor == null) {
                sDMemberDescriptor = new TreeItem(treeItem, 0, 0);
                sDMemberDescriptor.setText(sDDescriptor.getName() + " (Control)");
                sDMemberDescriptor.setImage(image);
                if (image == null) {
                    sDMemberDescriptor.setImage(img.getImage("smodel_modifiablerep.gif"));
                }
                sDMemberDescriptor.setGrayed(false);
                sDMemberDescriptor.setChecked(true);
                statisticalModelGraphViewer.mapRepresentationToItem(sDModifiableVariableRepresentation, (TreeItem)sDMemberDescriptor);
            }
        }
    }
}

