/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.model.statistical.SDContiguousObservation;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDRepresentation;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.model.statistical.SDTextObservation;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.ImageManager;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConModelOp;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConOpState;
import org.eclipse.hyades.statistical.ui.editor.internal.StatisticalModelGraphViewer;
import org.eclipse.hyades.statistical.ui.editor.internal.XMLConfigUtil;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDModifiableVariableRepresentation;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.BasicGraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.Graph;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.swt.widgets.TreeItem;

public class OpGenerateDescriptorConfig
implements StatConModelOp {
    public static OpGenerateDescriptorConfig INSTANCE = new OpGenerateDescriptorConfig();
    static ImageManager img = EditorPlugin.img;

    public static void launch(StatisticalModelGraphViewer statisticalModelGraphViewer, SDDescriptor sDDescriptor, SDDescriptor sDDescriptor2, StringBuffer stringBuffer, int n) {
        StatConOpState statConOpState = new StatConOpState(new State(n, stringBuffer));
        statisticalModelGraphViewer.applyStatConModelOp(new OpGenerateDescriptorConfig(), statConOpState, sDDescriptor, sDDescriptor2);
    }

    public StatConOpState preapply(StatConOpState statConOpState, StatisticalModelGraphViewer statisticalModelGraphViewer, SDDescriptor sDDescriptor, SDDescriptor sDDescriptor2, boolean bl, boolean bl2) {
        State state = (State)statConOpState.state;
        StringBuffer stringBuffer = state.xml;
        int n = state.depth;
        this.generatePreChildConfig(statisticalModelGraphViewer, stringBuffer, sDDescriptor, n);
        return new StatConOpState(new State(n + 1, stringBuffer));
    }

    public void postapply(StatConOpState statConOpState, StatisticalModelGraphViewer statisticalModelGraphViewer, SDDescriptor sDDescriptor, SDDescriptor sDDescriptor2, boolean bl, boolean bl2) {
        State state = (State)statConOpState.state;
        StringBuffer stringBuffer = state.xml;
        int n = state.depth;
        this.generatePostChildConfig(statisticalModelGraphViewer, stringBuffer, sDDescriptor, n);
    }

    private void generatePostChildConfig(StatisticalModelGraphViewer statisticalModelGraphViewer, StringBuffer stringBuffer, SDDescriptor sDDescriptor, int n) {
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("  ");
            ++n2;
        }
        stringBuffer.append("</descriptor>\n");
    }

    private void generatePreChildConfig(StatisticalModelGraphViewer statisticalModelGraphViewer, StringBuffer stringBuffer, SDDescriptor sDDescriptor, int n) {
        Object object;
        EList eList;
        SDMemberDescriptor sDMemberDescriptor;
        TreeItem treeItem = statisticalModelGraphViewer.mapDescriptorToItem(sDDescriptor);
        if (sDDescriptor == null) {
            return;
        }
        if (treeItem == null) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("  ");
            ++n2;
        }
        stringBuffer.append("<descriptor ");
        stringBuffer.append("name=\"").append(sDDescriptor.getName()).append("\" ");
        stringBuffer.append("ticked=\"").append(treeItem.getChecked()).append("\" ");
        stringBuffer.append("expanded=\"").append(treeItem.getExpanded()).append("\" ");
        stringBuffer.append(">\n");
        if (sDDescriptor instanceof SDMemberDescriptor) {
            sDMemberDescriptor = (SDMemberDescriptor)sDDescriptor;
            eList = sDMemberDescriptor.getSnapshotObservation();
            int n3 = 0;
            while (n3 < eList.size()) {
                TreeItem treeItem2;
                BasicGraphSource basicGraphSource;
                Graph graph;
                object = eList.get(n3);
                if ((object instanceof SDContiguousObservation || object instanceof SDTextObservation) && (graph = statisticalModelGraphViewer.mapSourceToGraph(basicGraphSource = statisticalModelGraphViewer.mapItemToGraphSource(treeItem2 = statisticalModelGraphViewer.mapObservationToItem((SDSnapshotObservation)object)))) != null) {
                    int n4 = 0;
                    while (n4 < n) {
                        stringBuffer.append("  ");
                        ++n4;
                    }
                    stringBuffer.append("<obs_graph ");
                    stringBuffer.append("ticked=\"").append(treeItem2.getChecked()).append("\" ");
                    stringBuffer.append("obs_index=\"").append(n3).append("\" ");
                    stringBuffer.append("x_slider=\"").append(statisticalModelGraphViewer.getGraphWindow().getXSlider(graph.getXSlider())).append("\" ");
                    stringBuffer.append("y_slider=\"").append(statisticalModelGraphViewer.getGraphWindow().getYSlider(graph.getYSlider())).append("\" ");
                    stringBuffer.append("color=\"").append(XMLConfigUtil.colorToString(graph.getForeground())).append("\" ");
                    stringBuffer.append("line_width=\"").append(graph.getLineWidth()).append("\" ");
                    stringBuffer.append("line_style=\"").append(XMLConfigUtil.lineStyleToString(graph.getLineStyle())).append("\" ");
                    stringBuffer.append("multiplier=\"").append(graph.getStaticScaling()).append("\" ");
                    stringBuffer.append("/>\n");
                }
                ++n3;
            }
        }
        if (sDDescriptor instanceof SDMemberDescriptor && (eList = (sDMemberDescriptor = (SDMemberDescriptor)sDDescriptor).getRepresentation()) instanceof SDModifiableVariableRepresentation) {
            TreeItem treeItem3 = statisticalModelGraphViewer.mapRepresentationToItem((SDRepresentation)eList);
            object = statisticalModelGraphViewer.mapItemToSlider(treeItem3);
            int n5 = 0;
            while (n5 < n) {
                stringBuffer.append("  ");
                ++n5;
            }
            if (object != null) {
                stringBuffer.append("<control ");
                stringBuffer.append("ticked=\"").append(treeItem3.getChecked()).append("\" ");
                stringBuffer.append("y_slider=\"").append(statisticalModelGraphViewer.getGraphWindow().getYSlider((ZoomSlider)((Object)object))).append("\" ");
                stringBuffer.append("/>\n");
            } else {
                stringBuffer.append("<control ");
                stringBuffer.append("ticked=\"").append(treeItem3.getChecked()).append("\" ");
                stringBuffer.append("y_slider=\"0\" ");
                stringBuffer.append("/>\n");
            }
        }
    }

    static class State {
        int depth = 0;
        StringBuffer xml;

        public State(int n, StringBuffer stringBuffer) {
            this.depth = n;
            this.xml = stringBuffer;
        }
    }
}

