/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.table.internal;

import org.eclipse.hyades.statistical.ui.widgets.table.internal.DoubleVerifyListener;
import org.eclipse.hyades.statistical.ui.widgets.table.internal.FloatVerifyListener;
import org.eclipse.hyades.statistical.ui.widgets.table.internal.InvalidTableValueException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public abstract class TableAdapter
extends Composite
implements IStructuredContentProvider,
ITableLabelProvider,
ICellModifier {
    public static final int LABEL = 0;
    public static final int TEXT = 1;
    public static final int CHOICE = 2;
    public static final int INTEGER = 3;
    public static final int BOOLEAN = 4;
    public static final int FLOAT = 5;
    public static final int DOUBLE = 6;
    public static int EXTRA_COLUMN_WIDTH = 23;
    int[] columnWidths = new int[0];
    protected boolean[] autoSizeOnContents = new boolean[0];
    protected boolean[] enforceMinWidths = new boolean[0];
    protected boolean[] columnExpands = new boolean[0];
    protected int[] columnTypes = new int[0];
    protected TableViewer viewer;
    boolean resized = false;
    TableAdapterControlListener controlListener = new TableAdapterControlListener();

    public TableAdapter(Composite composite) {
        super(composite, 2048);
        this.setLayout((Layout)new FillLayout());
        this.setBackground(composite.getBackground());
        this.viewer = new TableViewer(new Table((Composite)this, 98308));
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)this);
        this.viewer.setLabelProvider((IBaseLabelProvider)this);
        this.viewer.setCellModifier((ICellModifier)this);
        this.addControlListener((ControlListener)this.controlListener);
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public void configure() {
        this.viewer.setInput((Object)"");
        GC gC = new GC((Drawable)this);
        int n = 0;
        while (n < this.viewer.getTable().getColumnCount()) {
            int n2 = gC.stringExtent((String)this.viewer.getTable().getColumn((int)n).getText()).x + EXTRA_COLUMN_WIDTH;
            if (n2 > this.columnWidths[n]) {
                this.columnWidths[n] = n2;
            }
            if (this.autoSizeOnContents[n] && (n2 = gC.stringExtent((String)this.getLongestText((int)n)).x + this.getMaxImageWidth(n) + EXTRA_COLUMN_WIDTH) > this.columnWidths[n]) {
                this.columnWidths[n] = n2;
            }
            this.viewer.getTable().getColumn(n).setWidth(this.columnWidths[n]);
            ++n;
        }
        gC.dispose();
        this.resized = false;
    }

    protected String getLongestText(int n) {
        String string = "";
        int n2 = 0;
        Object[] objectArray = this.getElements(null);
        int n3 = 0;
        while (n3 < objectArray.length) {
            String string2 = this.getColumnText(objectArray[n3], n);
            if (string2.length() > n2) {
                n2 = string2.length();
                string = string2;
            }
            ++n3;
        }
        return string;
    }

    protected int getMaxImageWidth(int n) {
        int n2 = 0;
        Object[] objectArray = this.getElements(null);
        int n3 = 0;
        while (n3 < objectArray.length) {
            Image image = this.getColumnImage(objectArray[n3], n);
            if (image != null && image.getImageData().width > n2) {
                n2 = image.getImageData().width;
            }
            ++n3;
        }
        return n2;
    }

    public void setColumnNames(String[] stringArray) {
        this.viewer.setColumnProperties(stringArray);
        TableColumn[] tableColumnArray = new TableColumn[stringArray.length];
        this.autoSizeOnContents = new boolean[stringArray.length];
        this.enforceMinWidths = new boolean[stringArray.length];
        this.columnWidths = new int[stringArray.length];
        this.columnExpands = new boolean[stringArray.length];
        this.columnTypes = new int[stringArray.length];
        int n = 0;
        while (n < tableColumnArray.length) {
            tableColumnArray[n] = new TableColumn(this.viewer.getTable(), 16384);
            tableColumnArray[n].setText(stringArray[n]);
            this.columnWidths[n] = 23;
            this.enforceMinWidths[n] = true;
            this.columnExpands[n] = true;
            this.autoSizeOnContents[n] = false;
            this.columnTypes[n] = 0;
            tableColumnArray[n].addControlListener((ControlListener)this.controlListener);
            ++n;
        }
        this.resized = false;
    }

    public String[] getColumnNames() {
        String[] stringArray = new String[this.viewer.getColumnProperties().length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)this.viewer.getColumnProperties()[n];
            ++n;
        }
        return stringArray;
    }

    public void setColumnTypes(int[] nArray) {
        this.columnTypes = nArray;
        CellEditor[] cellEditorArray = new CellEditor[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            switch (nArray[n]) {
                case 0: {
                    cellEditorArray[n] = new TextCellEditor((Composite)this.viewer.getTable());
                    break;
                }
                case 1: {
                    cellEditorArray[n] = new TextCellEditor((Composite)this.viewer.getTable());
                    break;
                }
                case 2: {
                    cellEditorArray[n] = new ComboBoxCellEditor((Composite)this.viewer.getTable(), this.getComboChoices(null, n));
                    int n2 = cellEditorArray[n].getControl().computeSize((int)-1, (int)-1).x;
                    if (n2 <= this.columnWidths[n]) break;
                    this.columnWidths[n] = n2;
                    break;
                }
                case 3: {
                    cellEditorArray[n] = new TextCellEditor((Composite)this.viewer.getTable());
                    ((Text)cellEditorArray[n].getControl()).addVerifyListener(new VerifyListener(){

                        public void verifyText(VerifyEvent verifyEvent) {
                            if (verifyEvent.text.length() == 0) {
                                verifyEvent.doit = true;
                            } else {
                                try {
                                    Integer.parseInt(verifyEvent.text);
                                    verifyEvent.doit = true;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    verifyEvent.doit = false;
                                }
                            }
                        }
                    });
                    break;
                }
                case 5: {
                    cellEditorArray[n] = new TextCellEditor((Composite)this.viewer.getTable());
                    ((Text)cellEditorArray[n].getControl()).addVerifyListener((VerifyListener)new FloatVerifyListener((Text)cellEditorArray[n].getControl()));
                    break;
                }
                case 6: {
                    cellEditorArray[n] = new TextCellEditor((Composite)this.viewer.getTable());
                    ((Text)cellEditorArray[n].getControl()).addVerifyListener((VerifyListener)new DoubleVerifyListener((Text)cellEditorArray[n].getControl()));
                    break;
                }
                case 4: {
                    cellEditorArray[n] = new CheckboxCellEditor((Composite)this.viewer.getTable());
                }
            }
            ++n;
        }
        this.viewer.setCellEditors(cellEditorArray);
    }

    public String[] getComboChoices(Object object, int n) {
        return new String[0];
    }

    public abstract Object[] getElements(Object var1);

    public int getRow(Object object) {
        Object[] objectArray = this.getElements(null);
        int n = 0;
        while (n < objectArray.length) {
            if (object == objectArray[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getColumn(String string) {
        int n = 0;
        while (n < this.viewer.getColumnProperties().length) {
            if (string.equals(this.viewer.getColumnProperties()[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
    }

    public Image getColumnImage(Object object, int n) {
        return null;
    }

    public String getColumnText(Object object, int n) {
        return object.toString() + "[" + n + "]";
    }

    public String appendFloat(String string) {
        if (string.charAt(string.length() - 1) == '.') {
            string = string + "0";
        }
        return string;
    }

    public Object getValue(Object object, String string) {
        int n = this.getColumn(string);
        switch (this.columnTypes[n]) {
            case 0: 
            case 1: 
            case 3: {
                return this.getColumnText(object, n);
            }
            case 5: 
            case 6: {
                return this.appendFloat(this.getColumnText(object, n));
            }
            case 2: {
                String[] stringArray = this.getComboChoices(object, n);
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (this.getColumnText(object, n).equals(stringArray[n2])) {
                        return new Integer(n2);
                    }
                    ++n2;
                }
                return new Integer(0);
            }
            case 4: {
                return new Boolean(this.viewer.getTable().getItem(this.getRow(object)).getChecked());
            }
        }
        return null;
    }

    public boolean canModify(Object object, String string) {
        int n = this.getColumn(string);
        int n2 = this.getColumnType(object, n);
        if (n2 != this.columnTypes[n]) {
            this.columnTypes[n] = n2;
            this.setColumnTypes(this.columnTypes);
        }
        switch (this.columnTypes[n]) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 3: {
                return true;
            }
            case 2: {
                ((ComboBoxCellEditor)this.viewer.getCellEditors()[n]).setItems(this.getComboChoices(object, n));
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
            case 6: {
                return true;
            }
        }
        return false;
    }

    protected int getColumnType(Object object, int n) {
        return this.columnTypes[n];
    }

    public void modify(Object object, String string, Object object2) {
        int n = this.getColumn(string);
        try {
            switch (this.columnTypes[n]) {
                case 0: 
                case 1: {
                    this.valueChanged(((TableItem)object).getData(), n, (String)object2);
                    break;
                }
                case 3: {
                    if (((String)object2).equals("")) break;
                    this.valueChanged(((TableItem)object).getData(), n, new Integer((String)object2));
                    break;
                }
                case 2: {
                    this.valueChanged(((TableItem)object).getData(), n, (Integer)object2);
                    break;
                }
                case 4: {
                    this.valueChanged(((TableItem)object).getData(), n, (Boolean)object2);
                    break;
                }
                case 5: {
                    if (((String)object2).equals("")) break;
                    this.valueChanged(((TableItem)object).getData(), n, new Float((String)object2));
                    break;
                }
                case 6: {
                    if (((String)object2).equals("")) break;
                    this.valueChanged(((TableItem)object).getData(), n, new Double((String)object2));
                    break;
                }
            }
            this.viewer.update(((TableItem)object).getData(), null);
        }
        catch (InvalidTableValueException invalidTableValueException) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Cannot Update Value", (String)("Could not change " + string + " value.\n\n" + invalidTableValueException.getClass().getName() + "\n" + invalidTableValueException.getMessage()));
        }
    }

    public void valueChanged(Object object, int n, String string) throws InvalidTableValueException {
    }

    public void valueChanged(Object object, int n, Float f) throws InvalidTableValueException {
    }

    public void valueChanged(Object object, int n, Double d) throws InvalidTableValueException {
    }

    public void valueChanged(Object object, int n, Boolean bl) throws InvalidTableValueException {
    }

    public void valueChanged(Object object, int n, Integer n2) throws InvalidTableValueException {
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
    }

    public boolean isLabelProperty(Object object, String string) {
        return false;
    }

    public void dispose() {
    }

    public void expandColumns() {
        int n;
        int n2 = 0;
        while (n2 < this.viewer.getTable().getColumnCount()) {
            this.viewer.getTable().getColumn(n2).removeControlListener((ControlListener)this.controlListener);
            ++n2;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < this.viewer.getTable().getColumnCount()) {
            if (this.columnExpands[n6]) {
                n4 += this.viewer.getTable().getColumn(n6).getWidth();
                ++n5;
            } else {
                n3 += this.viewer.getTable().getColumn(n6).getWidth();
            }
            ++n6;
        }
        int n7 = this.getSize().x - 4 - (n4 + n3);
        if (!(n7 <= 0 && this.resized || n5 <= 0)) {
            n = 0;
            while (n < this.viewer.getTable().getColumnCount()) {
                int n8 = n7;
                if (n5 > 0) {
                    n8 = n7 / n5;
                }
                if (this.columnExpands[n]) {
                    int n9 = this.viewer.getTable().getColumn(n).getWidth() + n8;
                    if (this.enforceMinWidths[n] && n9 < this.columnWidths[n]) {
                        --n5;
                        n7 -= this.columnWidths[n] - n9;
                        n9 = this.columnWidths[n];
                    }
                    this.viewer.getTable().getColumn(n).setWidth(n9);
                }
                ++n;
            }
        }
        n = 0;
        while (n < this.viewer.getTable().getColumnCount()) {
            this.viewer.getTable().getColumn(n).addControlListener((ControlListener)this.controlListener);
            ++n;
        }
    }

    class TableAdapterControlListener
    extends ControlAdapter {
        TableAdapterControlListener() {
        }

        public void controlResized(ControlEvent controlEvent) {
            Object object = controlEvent.getSource();
            if (object == TableAdapter.this) {
                TableAdapter.this.expandColumns();
            } else {
                int n = 0;
                while (n < TableAdapter.this.viewer.getTable().getColumnCount()) {
                    if (object == TableAdapter.this.viewer.getTable().getColumn(n)) {
                        TableAdapter.this.resized = true;
                        TableAdapter.this.columnWidths[n] = TableAdapter.this.viewer.getTable().getColumn(n).getWidth();
                        break;
                    }
                    ++n;
                }
            }
        }
    }
}

