/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal;

import java.util.Vector;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomControlBarEvent;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomControlBarListener;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class ZoomControlBar {
    protected ZoomSlider slider;
    protected double value;
    protected Rectangle area;
    protected Color color;
    protected int size = 11;
    protected boolean enabled = true;
    protected Image image;
    int indent = 3;
    double oldValue;
    Vector listeners = new Vector();
    String tooltip = null;

    public ZoomControlBar(ZoomSlider zoomSlider) {
        this.slider = zoomSlider;
        this.setColor(zoomSlider.getDisplay().getSystemColor(22));
        this.value = zoomSlider.getMinVisible();
        zoomSlider.addZoomControlBar(this);
    }

    public ZoomControlBar(ZoomSlider zoomSlider, double d) {
        this(zoomSlider);
        this.setValue(d);
        zoomSlider.updateScale();
    }

    public ZoomControlBar(ZoomSlider zoomSlider, Color color) {
        this(zoomSlider);
        this.setColor(color);
        zoomSlider.updateScale();
    }

    public ZoomControlBar(ZoomSlider zoomSlider, double d, Color color) {
        this(zoomSlider, d);
        this.setColor(color);
        zoomSlider.updateScale();
    }

    public ZoomControlBar(ZoomSlider zoomSlider, int n) {
        this(zoomSlider);
        this.setSize(n);
        zoomSlider.updateScale();
    }

    public ZoomControlBar(ZoomSlider zoomSlider, double d, int n) {
        this(zoomSlider, d);
        this.setSize(n);
        zoomSlider.updateScale();
    }

    public ZoomControlBar(ZoomSlider zoomSlider, Color color, int n) {
        this(zoomSlider, color);
        this.setSize(n);
        zoomSlider.updateScale();
    }

    public ZoomControlBar(ZoomSlider zoomSlider, double d, Color color, int n) {
        this(zoomSlider, d, color);
        this.setSize(n);
        zoomSlider.updateScale();
    }

    public void setZoomSlider(ZoomSlider zoomSlider) {
        this.slider = zoomSlider;
    }

    public ZoomSlider getZoomSlider() {
        return this.slider;
    }

    public void setToolTipText(String string) {
        this.tooltip = string;
    }

    public String getToolTipText() {
        return this.tooltip;
    }

    public void setValue(double d) {
        this.oldValue = this.value;
        if (d > this.slider.getMaxLimit()) {
            d = this.slider.getMaxLimit();
        }
        if (d < this.slider.getMinLimit()) {
            d = this.slider.getMinLimit();
        }
        this.value = d;
    }

    public double getValue() {
        return this.value;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public int getSize() {
        return this.size;
    }

    public void hide(Image image, GC gC) {
        gC.setClipping(this.getDrawingArea(this.oldValue));
        gC.drawImage(image, 0, 0);
        gC.setClipping(0, 0, this.slider.getBounds().width, this.slider.getBounds().height);
    }

    public void paint(GC gC) {
        this.area = this.getDrawingArea(this.value);
        if (this.image == null) {
            Image image = new Image((Device)this.slider.getDisplay(), this.area.width, this.area.height);
            this.draw3DBox(new GC((Drawable)image), 0, 0, this.area.width, this.area.height, this.color);
            ImageData imageData = image.getImageData();
            image.dispose();
            int n = 0;
            while (n < this.area.width) {
                int n2 = 0;
                while (n2 < this.area.height) {
                    imageData.setAlpha(n, n2, 180);
                    ++n2;
                }
                ++n;
            }
            this.image = new Image((Device)this.slider.getDisplay(), imageData);
        }
        gC.drawImage(this.image, this.area.x, this.area.y);
        gC.setForeground(this.slider.getForeground());
        if (this.slider.getOrientation() == 1) {
            gC.drawLine(this.area.x + this.area.width / 2, 1, this.area.x + this.area.width / 2, this.indent);
            gC.drawLine(this.area.x + this.area.width / 2, this.slider.getBounds().height - this.indent, this.area.x + this.area.width / 2, this.slider.getBounds().height - 1);
        } else {
            gC.drawLine(1, this.area.y + this.area.height / 2, this.indent, this.area.y + this.area.height / 2);
            gC.drawLine(this.slider.getBounds().width - this.indent, this.area.y + this.area.height / 2, this.slider.getBounds().width - 1, this.area.y + this.area.height / 2);
        }
    }

    protected Rectangle getDrawingArea(double d) {
        if (this.slider.getOrientation() == 0) {
            return new Rectangle(this.indent, (int)this.slider.value2Pixel(d) - this.size / 2, this.slider.getBounds().width - this.indent * 2, this.size);
        }
        return new Rectangle((int)this.slider.value2Pixel(d) - this.size / 2, this.indent, this.size, this.slider.getBounds().height - this.indent * 2);
    }

    public boolean inside(int n, int n2) {
        if (this.area == null) {
            return false;
        }
        return this.area.contains(n, n2) && this.enabled;
    }

    public void sprayZoomControlBarEvent(boolean bl) {
        int n = 0;
        while (n < this.listeners.size()) {
            ((ZoomControlBarListener)this.listeners.elementAt(n)).zoomControlBarChanged(new ZoomControlBarEvent(this, this.value, bl));
            ++n;
        }
    }

    public void addZoomControlBarListener(ZoomControlBarListener zoomControlBarListener) {
        this.listeners.addElement(zoomControlBarListener);
    }

    public void removeZoomControlBarListener(ZoomControlBarListener zoomControlBarListener) {
        this.listeners.removeElement(zoomControlBarListener);
    }

    protected void draw3DBox(GC gC, int n, int n2, int n3, int n4, Color color) {
        Color color2 = null;
        Color color3 = null;
        Color color4 = null;
        double d = 0.5;
        double d2 = 0.1;
        double d3 = 3.0;
        if (color == null) {
            EditorPlugin.DBG.warning("3d box colour is null!");
        }
        RGB rGB = color.getRGB();
        rGB.red = (int)((double)rGB.red * d);
        rGB.blue = (int)((double)rGB.blue * d);
        rGB.green = (int)((double)rGB.green * d);
        color2 = new Color((Device)this.slider.getDisplay(), rGB);
        rGB = color.getRGB();
        rGB.red = (int)((double)rGB.red * d2);
        rGB.blue = (int)((double)rGB.blue * d2);
        rGB.green = (int)((double)rGB.green * d2);
        color3 = new Color((Device)this.slider.getDisplay(), rGB);
        rGB = color.getRGB();
        rGB.red = (int)((double)rGB.red * d3);
        rGB.blue = (int)((double)rGB.blue * d3);
        rGB.green = (int)((double)rGB.green * d3);
        if (rGB.red > 255) {
            rGB.red = 255;
        }
        if (rGB.blue > 255) {
            rGB.blue = 255;
        }
        if (rGB.green > 255) {
            rGB.green = 255;
        }
        color4 = new Color((Device)this.slider.getDisplay(), rGB);
        gC.setBackground(color3);
        gC.fillRectangle(n, n2, n3, n4);
        gC.setBackground(color);
        gC.fillRectangle(n, n2, n3 - 1, n4 - 1);
        gC.setBackground(color2);
        gC.fillRectangle(n + 1, n2 + 1, n3 - 2, n4 - 2);
        gC.setBackground(color4);
        gC.fillRectangle(n + 1, n2 + 1, n3 - 3, n4 - 3);
        gC.setBackground(color);
        gC.fillRectangle(n + 2, n2 + 2, n3 - 4, n4 - 4);
        color2.dispose();
        color3.dispose();
        color4.dispose();
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
        }
        if (this.color != null) {
            this.color.dispose();
        }
    }
}

