/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal;

import java.util.TimeZone;
import java.util.Vector;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomControlBar;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomControlBarsCollection;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomIndicator;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomIndicatorsCollection;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSliderConfigurationException;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSliderEvent;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSliderListener;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSliderTick;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSliderUtilities;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class ZoomSlider
extends Canvas {
    public static final int MIN = 0;
    public static final int MAX = 1;
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int MIN_TICKWIDTH = 10;
    public static final int MAX_TICKWIDTH = 25;
    public static final int NORTH = 0;
    public static final int SOUTH = 1;
    public static final int EAST = 2;
    public static final int WEST = 3;
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    public static final int INCREASING = 1;
    public static final int DECREASING = -1;
    private static final double[] LINEAR_PROGRESSION = new double[]{1.0, 2.0, 5.0};
    protected Vector tickVector = new Vector();
    Vector listeners = new Vector();
    ZoomControlBarsCollection barsCollection = new ZoomControlBarsCollection(this);
    ZoomIndicatorsCollection indicatorsCollection = new ZoomIndicatorsCollection(this);
    transient ZoomSliderTick lastVisible;
    protected double[] limit = new double[]{0.0, 100.0};
    protected double[] visible = new double[]{0.0, 50.0};
    protected boolean[] locked = new boolean[]{false, false};
    protected int orientation = 0;
    protected int direction = 1;
    protected double resolution = 1.0;
    protected int indent = 10;
    protected Image image;
    protected GC gImage;
    protected Image plainScale;
    protected GC gPlain;
    protected Image titleImage;
    protected GC gTitle;
    int titWidth;
    int titHeight;
    Color backgroundColor;
    Color foregroundColor;
    Color titleColor;
    Font titleFont;
    protected boolean zoomable = true;
    protected boolean transposable = true;
    transient double increment = 1.0;
    transient int incrementOOM;
    transient double unitIncrement;
    transient int decimalPointPosition;
    transient boolean scaleChanged = true;
    transient boolean indicatorsChanged;
    transient boolean zoomPrimed;
    transient boolean zoomConfigured;
    transient int zoomStart;
    transient double zoomValue;
    transient int zoomFixed;
    transient boolean zoomed;
    transient boolean transposePrimed;
    transient boolean transposeConfigured;
    transient int transposeStart;
    transient double transposeValue;
    transient double transposeRange;
    transient boolean transposed;
    String title;
    public int rawOffset;
    int fontHeight;

    public ZoomSlider(Composite composite) {
        super(composite, 262144);
        FontData fontData = this.getFont().getFontData()[0];
        this.indent = (fontData.getHeight() + 4) / 2;
        this.fontHeight = fontData.getHeight();
        this.backgroundColor = composite.getBackground();
        this.foregroundColor = composite.getForeground();
        if (this.backgroundColor == null) {
            this.backgroundColor = this.getDisplay().getSystemColor(25);
        }
        if (this.foregroundColor == null) {
            this.foregroundColor = this.getDisplay().getSystemColor(24);
        }
        this.titleColor = this.foregroundColor;
        this.rawOffset = TimeZone.getDefault().getRawOffset();
        if (this.rawOffset < 0) {
            this.rawOffset += 86400000;
        }
        SliderMouseListener sliderMouseListener = new SliderMouseListener();
        this.addMouseListener(sliderMouseListener);
        SliderMouseMoveListener sliderMouseMoveListener = new SliderMouseMoveListener();
        this.addMouseMoveListener(sliderMouseMoveListener);
        SliderPaintListener sliderPaintListener = new SliderPaintListener();
        this.addPaintListener(sliderPaintListener);
        SliderControlListener sliderControlListener = new SliderControlListener();
        this.addControlListener((ControlListener)sliderControlListener);
        SliderDisposeListener sliderDisposeListener = new SliderDisposeListener();
        this.addDisposeListener(sliderDisposeListener);
    }

    public ZoomSlider(Composite composite, double d, double d2, double d3, double d4, double d5) throws ZoomSliderConfigurationException {
        this(composite);
        this.configure(d, d2, d3, d4, d5);
    }

    public void addZoomControlBar(double d) {
        new ZoomControlBar(this, d);
        this.updateScale();
    }

    public void addZoomControlBar(ZoomControlBar zoomControlBar) {
        this.barsCollection.add(zoomControlBar);
        this.updateScale();
    }

    public void removeZoomControlBar(ZoomControlBar zoomControlBar) {
        this.barsCollection.remove(zoomControlBar);
        this.updateScale();
    }

    public boolean hasBars() {
        return this.barsCollection.hasBars();
    }

    public ZoomControlBarsCollection getZoomControlBarsCollection() {
        return this.barsCollection;
    }

    public void addZoomIndicator(ZoomIndicator zoomIndicator) {
        this.indicatorsCollection.add(zoomIndicator);
        this.updateScale();
    }

    public void removeIndicator(ZoomIndicator zoomIndicator) {
        this.indicatorsCollection.remove(zoomIndicator);
        this.updateScale();
    }

    public ZoomIndicatorsCollection getZoomIndicatorsCollection() {
        return this.indicatorsCollection;
    }

    public Vector getTickVector() {
        return this.tickVector;
    }

    public ZoomSliderTick getFirstTick() {
        if (this.tickVector.size() == 0) {
            return null;
        }
        return (ZoomSliderTick)this.tickVector.get(0);
    }

    public ZoomSliderTick getLastTick() {
        if (this.tickVector.size() == 0) {
            return null;
        }
        return (ZoomSliderTick)this.tickVector.get(this.tickVector.size() - 1);
    }

    public void reinitialiseGraphics() {
        if (this.image != null) {
            this.image.dispose();
        }
        if (this.gImage != null) {
            this.gImage.dispose();
        }
        if (this.plainScale != null) {
            this.plainScale.dispose();
        }
        if (this.gPlain != null) {
            this.gPlain.dispose();
        }
        if (this.getDisplay() == null) {
            return;
        }
        if (this.getBounds().width < 1) {
            return;
        }
        if (this.getBounds().height < 1) {
            return;
        }
        this.image = new Image((Device)this.getDisplay(), this.getBounds().width, this.getBounds().height);
        this.gImage = new GC((Drawable)this.image);
        this.plainScale = new Image((Device)this.getDisplay(), this.getBounds().width, this.getBounds().height);
        this.gPlain = new GC((Drawable)this.plainScale);
        this.findDecimalPointPosition();
        this.createTicks();
    }

    public void paint(PaintEvent paintEvent) {
        if (this.isDisposed()) {
            return;
        }
        if (this.gImage == null) {
            this.reinitialiseGraphics();
        }
        if (this.scaleChanged) {
            this.paintTicks(this.gImage);
            this.paintTicks(this.gPlain);
            this.scaleChanged = false;
            this.indicatorsCollection.paint(this.gImage, null);
        }
        if (this.indicatorsChanged) {
            this.indicatorsCollection.paint(this.gImage, this.plainScale);
        }
        this.barsCollection.paint(this.image, this.gImage, paintEvent.gc, this.indicatorsChanged);
        this.indicatorsChanged = false;
    }

    public void updateScale() {
        this.scaleChanged = true;
        this.redraw();
    }

    public void recreateScale() {
        this.createTicks();
        this.updateScale();
    }

    public void updateIndicators() {
        this.indicatorsChanged = true;
        this.redraw();
    }

    public void externalRepaint() {
        this.scaleChanged = true;
        this.redraw();
    }

    public void resizeScale() {
        this.reinitialiseGraphics();
        this.indicatorsCollection.calculatePositions();
        this.recreateScale();
    }

    public void layout() {
        super.layout();
        this.indicatorsCollection.calculatePositions();
        if (this.isMaxTickWidthExceeded()) {
            this.visible[1] = this.visible[0] + (double)(this.getPixelRange() / 25) * this.resolution;
            if (this.visible[1] > this.limit[1]) {
                this.visible[1] = this.limit[1];
                this.visible[0] = this.visible[1] - (double)(this.getPixelRange() / 25) * this.resolution;
            }
            this.updateScale();
        }
    }

    public void setFont(Font font) {
        FontData fontData = font.getFontData()[0];
        this.indent = (fontData.getHeight() + 4) / 2;
        this.fontHeight = fontData.getHeight();
        super.setFont(font);
    }

    protected int getPixelRange() {
        if (this.orientation == 1) {
            return this.getBounds().width - this.indent * 2;
        }
        return this.getBounds().height - this.indent * 2;
    }

    protected double getZeroPixelValue() {
        if (this.direction == -1) {
            return this.visible[0];
        }
        return this.visible[1];
    }

    protected double getVisibleValueRange() {
        return Math.abs(this.visible[1] - this.visible[0]);
    }

    protected double getSinglePixelRange() {
        return this.getVisibleValueRange() / (double)this.getPixelRange();
    }

    public double pixel2Value(double d) {
        return this.getZeroPixelValue() - (double)this.direction * ((d - (double)this.indent) * this.getSinglePixelRange());
    }

    public double value2Pixel(double d) {
        return (this.getZeroPixelValue() - d) / (double)this.direction / this.getSinglePixelRange() + (double)this.indent;
    }

    public double getIncrement() {
        return this.increment;
    }

    public int getIncrementOOM() {
        return this.incrementOOM;
    }

    public double getUnitIncrement() {
        return this.unitIncrement;
    }

    public int getDecimalPointPosition() {
        return this.decimalPointPosition;
    }

    public Image getScaleImage() {
        return this.image;
    }

    public int getIndent() {
        return this.indent;
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public boolean isChanging() {
        if (this.zoomConfigured) {
            return true;
        }
        return this.transposeConfigured;
    }

    protected void findDecimalPointPosition() {
        if (this.orientation == 0) {
            int n = 0;
            if (this.increment < 1.0) {
                GC gC = new GC((Drawable)this);
                n = Math.abs(this.incrementOOM) * gC.stringExtent((String)"0").x + gC.stringExtent((String)".").x;
            }
            this.decimalPointPosition = this.getBounds().width - n - 5;
        }
    }

    protected void calculateIncrement() {
        TickValueRange tickValueRange = new TickValueRange();
        if (tickValueRange.outside()) {
            int n = this.getPixelRange() / 10;
            this.increment = this.getVisibleValueRange() / (double)n;
            int n2 = ZoomSliderUtilities.calculateOOM(this.increment);
            this.increment = LINEAR_PROGRESSION[0] * Math.pow(10.0, n2);
            while (this.increment < tickValueRange.min) {
                int n3 = 0;
                while (n3 < 3) {
                    this.increment = LINEAR_PROGRESSION[n3] * Math.pow(10.0, n2);
                    if (this.increment >= tickValueRange.min) break;
                    ++n3;
                }
                ++n2;
            }
            this.incrementOOM = ZoomSliderUtilities.calculateOOM(this.increment);
            this.findDecimalPointPosition();
        }
    }

    protected void createTicks() {
        this.calculateIncrement();
        this.tickVector.removeAllElements();
        double d = ZoomSliderUtilities.round(this.visible[0] - this.increment, this.increment);
        int n = 0;
        while (d <= this.visible[1] + this.increment) {
            double d2 = d;
            this.tickVector.addElement(new ZoomSliderTick(this, d));
            d += this.increment;
            d = ZoomSliderUtilities.round(d, this.increment);
            if (++n > 500) break;
        }
        int n2 = 10;
        int n3 = (int)((double)this.getPixelRange() / (this.getVisibleValueRange() / this.increment));
        if (n3 < 20) {
            n2 = 5;
        }
        this.unitIncrement = this.increment / (double)n2;
        if (this.unitIncrement < this.resolution) {
            this.unitIncrement = this.resolution;
        }
    }

    private void paintTicks(GC gC) {
        gC.setBackground(this.backgroundColor);
        gC.fillRectangle(0, 0, this.getBounds().width, this.getBounds().height);
        gC.setForeground(this.foregroundColor);
        this.lastVisible = null;
        this.paintTitle(gC);
        try {
            int n = 0;
            while (n < this.tickVector.size()) {
                ((ZoomSliderTick)this.tickVector.elementAt(n)).paintLine(gC);
                ++n;
            }
            int n2 = 0;
            while (n2 < this.tickVector.size()) {
                ((ZoomSliderTick)this.tickVector.elementAt(n2)).paintText(gC);
                ++n2;
            }
        }
        catch (NullPointerException nullPointerException) {
            EditorPlugin.DBG.warning("tickVector elements null");
            return;
        }
        switch (this.orientation) {
            case 0: {
                gC.drawLine(this.getBounds().width - 8, this.indent, this.getBounds().width, this.indent);
                gC.drawLine(this.getBounds().width - 8, this.getBounds().height - this.indent, this.getBounds().width, this.getBounds().height - this.indent);
                gC.drawLine(0, this.indent, 8, this.indent);
                gC.drawLine(0, this.getBounds().height - this.indent, 8, this.getBounds().height - this.indent);
                break;
            }
            case 1: {
                gC.drawLine(this.indent, 0, this.indent, 8);
                gC.drawLine(this.getBounds().width - this.indent, 0, this.getBounds().width - this.indent, 8);
                gC.drawLine(this.getBounds().width - this.indent, this.getBounds().height - 8, this.getBounds().width - this.indent, this.getBounds().height);
                gC.drawLine(this.indent, this.getBounds().height - 8, this.indent, this.getBounds().height);
            }
        }
        gC.setForeground(this.foregroundColor);
        gC.drawRectangle(0, 0, this.getBounds().width - 1, this.getBounds().height - 1);
    }

    private void paintTitle(GC gC) {
        if (this.titleImage == null) {
            this.createTitle(gC);
        }
        if (this.titleImage != null) {
            if (this.orientation == 1) {
                gC.drawImage(this.titleImage, this.getBounds().width - this.titWidth - (this.indent + 5), this.getBounds().height - (this.titHeight + 2));
            } else {
                gC.drawImage(this.titleImage, 2, this.indent + 5);
            }
        }
    }

    private void createTitle(GC gC) {
        if (this.title != null && !this.title.equals("")) {
            gC.setFont(this.titleFont);
            this.titWidth = gC.stringExtent((String)this.title).x;
            this.titHeight = gC.stringExtent((String)this.title).y;
            gC.setFont(this.getFont());
            this.titleImage = new Image((Device)this.getDisplay(), this.titWidth, this.titHeight);
            this.gTitle = new GC((Drawable)this.titleImage);
            this.gTitle.setBackground(this.backgroundColor);
            this.gTitle.fillRectangle(0, 0, this.titWidth, this.titHeight);
            this.gTitle.setForeground(this.titleColor);
            this.gTitle.setFont(this.titleFont);
            this.gTitle.drawString(this.title, 0, 0);
            gC.setForeground(this.foregroundColor);
            if (this.orientation == 0) {
                this.titleImage = this.rotateImage();
            }
        }
    }

    Image rotateImage() {
        ImageData imageData = this.titleImage.getImageData();
        Image image = new Image((Device)this.getDisplay(), imageData.height, imageData.width);
        ImageData imageData2 = image.getImageData();
        int n = 0;
        while (n < imageData.height) {
            int n2 = 0;
            while (n2 < imageData.width) {
                imageData2.setPixel(n, imageData2.height - 1 - n2, imageData.getPixel(n2, n));
                ++n2;
            }
            ++n;
        }
        return new Image((Device)this.getDisplay(), imageData2);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        Point point = super.computeSize(n, n2, bl);
        Point point2 = new Point(point.x, point.y);
        GC gC = new GC((Drawable)this);
        if (this.orientation == 0) {
            if (n == -1) {
                String string = new ZoomSliderTick((ZoomSlider)this, (double)(this.limit[1] + this.resolution)).representation;
                String string2 = new ZoomSliderTick((ZoomSlider)this, (double)(this.limit[0] - this.resolution)).representation;
                int n3 = gC.stringExtent((String)string2).x;
                int n4 = gC.stringExtent((String)string).x;
                int n5 = n4;
                if (n3 > n5) {
                    n5 = n3;
                }
                point2.x = n5 + 20;
            } else {
                point2.x = n;
            }
            if (n2 != -1) {
                point2.y = n2;
            }
        } else {
            point2.y = n2 == -1 ? gC.getFontMetrics().getAscent() + 20 : n2;
            if (n != -1) {
                point2.x = n;
            }
        }
        gC.dispose();
        return point2;
    }

    public void configure(double d, double d2, double d3, double d4, double d5) throws ZoomSliderConfigurationException {
        this.checkConfiguration(d, d2, d3, d4, d5);
        this.limit[0] = d;
        this.limit[1] = d2;
        this.visible[0] = d3;
        this.visible[1] = d4;
        this.resolution = d5;
        try {
            this.recreateScale();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void checkConfiguration(double d, double d2, double d3, double d4, double d5) throws ZoomSliderConfigurationException {
        if (d >= d2) {
            throw new ZoomSliderConfigurationException(EditorPlugin.getString("ZOOMSLIDER_CONFIG_MAX_TOO_SMALL"));
        }
        if (d3 >= d4) {
            throw new ZoomSliderConfigurationException(EditorPlugin.getString("ZOOMSLIDER_CONFIG_MAXVIS_TOO_SMALL"));
        }
        if (d3 < d) {
            throw new ZoomSliderConfigurationException(EditorPlugin.getString("ZOOMSLIDER_CONFIG_MIN_TOO_LARGE"));
        }
        if (d4 > d2) {
            throw new ZoomSliderConfigurationException(EditorPlugin.getString("ZOOMSLIDER_CONFIG_MINVIS_TOO_LARGE"));
        }
        if (d5 > d2 - d) {
            throw new ZoomSliderConfigurationException(EditorPlugin.getString("ZOOMSLIDER_CONFIG_RES_TOO_LARGE"));
        }
        if (d5 <= 0.0) {
            throw new ZoomSliderConfigurationException(EditorPlugin.getString("ZOOMSLIDER_CONFIG_RES_NONPOS"));
        }
        double d6 = d5 * Math.pow(10.0, -1 * ZoomSliderUtilities.calculateOOM(d5));
        if (d6 != 1.0 && d6 != 2.0 && d6 != 5.0) {
            throw new ZoomSliderConfigurationException(EditorPlugin.getString("ZOOMSLIDER_CONFIG_RES_BADPOW"));
        }
    }

    public void setTitle(String string) {
        this.title = string;
        this.titleImage = null;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitleColor(Color color) {
        this.titleColor = color;
        this.titleImage = null;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public void setTitleFont(Font font) {
        this.titleFont = font;
        this.titleImage = null;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (color != null) {
            this.foregroundColor = color;
        }
        this.titleImage = null;
    }

    public Color getForeground() {
        return this.foregroundColor;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (color != null) {
            this.backgroundColor = color;
            this.indicatorsCollection.setXORColors();
        }
        this.titleImage = null;
    }

    public Color getBackground() {
        if (this.backgroundColor != null) {
            return this.backgroundColor;
        }
        return this.getDisplay().getSystemColor(25);
    }

    public void setMaxVisible(double d) throws ZoomSliderConfigurationException {
        this.checkConfiguration(this.limit[0], this.limit[1], this.visible[0], d, this.resolution);
        this.visible[1] = d;
        this.recreateScale();
    }

    public double getMaxVisible() {
        return this.visible[1];
    }

    public void setMinVisible(double d) throws ZoomSliderConfigurationException {
        this.checkConfiguration(this.limit[0], this.limit[1], d, this.visible[1], this.resolution);
        this.visible[0] = d;
        this.recreateScale();
    }

    public double getMinVisible() {
        return this.visible[0];
    }

    public void setMaxLimit(double d) throws ZoomSliderConfigurationException {
        this.checkConfiguration(this.limit[0], d, this.visible[0], this.visible[1], this.resolution);
        this.limit[1] = d;
        this.recreateScale();
    }

    public double getMaxLimit() {
        return this.limit[1];
    }

    public void setMinLimit(double d) throws ZoomSliderConfigurationException {
        this.checkConfiguration(d, this.limit[1], this.visible[0], this.visible[1], this.resolution);
        this.limit[0] = d;
        this.recreateScale();
    }

    public double getMinLimit() {
        return this.limit[0];
    }

    public void setResolution(double d) throws ZoomSliderConfigurationException {
        this.checkConfiguration(this.limit[0], this.limit[1], this.visible[0], this.visible[1], d);
        this.resolution = d;
        this.scaleChanged = true;
        this.findDecimalPointPosition();
        this.redraw();
    }

    public double getResolution() {
        return this.resolution;
    }

    public void setDirection(int n) throws ZoomSliderConfigurationException {
        if (n != 1 && n != -1) {
            throw new ZoomSliderConfigurationException(EditorPlugin.getString("ZOOMSLIDER_CONFIG_BADDIRECTION"));
        }
        this.direction = n;
        this.recreateScale();
    }

    public int getDirection() {
        return this.direction;
    }

    public void setOrientation(int n) throws ZoomSliderConfigurationException {
        if (n != 1 && n != 0) {
            throw new ZoomSliderConfigurationException(EditorPlugin.getString("ZOOMSLIDER_CONFIG_BADORIENTATION"));
        }
        this.orientation = n;
        this.recreateScale();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void lock(int n, boolean bl) {
        this.locked[n] = bl;
    }

    public boolean isLocked(int n) {
        return this.locked[n];
    }

    public void setZoomable(boolean bl) {
        this.zoomable = bl;
    }

    public boolean isZoomable() {
        return this.zoomable;
    }

    public void setTransposable(boolean bl) {
        this.transposable = bl;
    }

    public boolean isTransposable() {
        return this.transposable;
    }

    public void setLastVisible(ZoomSliderTick zoomSliderTick) {
        this.lastVisible = zoomSliderTick;
    }

    public ZoomSliderTick getLastVisible() {
        return this.lastVisible;
    }

    private boolean isMaxTickWidthExceeded() {
        return this.getVisibleValueRange() / this.resolution < (double)(this.getPixelRange() / 25);
    }

    public double getMinRange() {
        return (double)(this.getPixelRange() / 25) * this.resolution;
    }

    private int complement(int n) {
        if (n == 0) {
            return 1;
        }
        return 0;
    }

    private void primeZoom(MouseEvent mouseEvent) {
        this.zoomStart = this.orientation == 0 ? mouseEvent.y : mouseEvent.x;
        this.zoomValue = this.pixel2Value(this.zoomStart);
        this.zoomPrimed = true;
    }

    private void configureZoom(MouseEvent mouseEvent) {
        int n = 0;
        n = this.orientation == 0 ? mouseEvent.y : mouseEvent.x;
        if (Math.abs(n - this.zoomStart) > 2) {
            if (!this.locked[0] && !this.locked[1]) {
                this.zoomFixed = n > this.zoomStart ? (this.direction == 1 ? 1 : 0) : (this.direction == 1 ? 0 : 1);
                this.zoomPrimed = false;
                this.zoomConfigured = true;
            } else if (this.locked[1] && this.locked[0]) {
                this.zoomPrimed = false;
                this.zoomConfigured = false;
            } else {
                this.zoomFixed = this.locked[1] ? 1 : 0;
                this.zoomPrimed = false;
                this.zoomConfigured = true;
            }
        }
    }

    private void zoom(MouseEvent mouseEvent) {
        double d;
        int n = mouseEvent.y;
        if (this.orientation == 1) {
            n = mouseEvent.x;
        }
        if ((d = Math.abs((double)n - this.value2Pixel(this.visible[this.zoomFixed]))) > 0.0) {
            double d2 = (double)this.getPixelRange() / d;
            double d3 = this.visible[this.complement(this.zoomFixed)];
            if (this.zoomFixed == 0) {
                this.visible[this.complement((int)this.zoomFixed)] = this.visible[this.zoomFixed] + d2 * Math.abs(this.visible[this.zoomFixed] - this.zoomValue);
                if (this.visible[this.complement(this.zoomFixed)] > this.limit[this.complement(this.zoomFixed)]) {
                    this.visible[this.complement((int)this.zoomFixed)] = this.limit[this.complement(this.zoomFixed)];
                }
            } else {
                this.visible[this.complement((int)this.zoomFixed)] = this.visible[this.zoomFixed] - d2 * Math.abs(this.visible[this.zoomFixed] - this.zoomValue);
                if (this.visible[this.complement(this.zoomFixed)] < this.limit[this.complement(this.zoomFixed)]) {
                    this.visible[this.complement((int)this.zoomFixed)] = this.limit[this.complement(this.zoomFixed)];
                }
            }
            if (this.isMaxTickWidthExceeded()) {
                this.visible[this.complement((int)this.zoomFixed)] = d3;
            }
            if (this.visible[this.complement(this.zoomFixed)] != d3) {
                this.zoomed = true;
                this.recreateScale();
                int n2 = 0;
                while (n2 < this.listeners.size()) {
                    ((ZoomSliderListener)this.listeners.elementAt(n2)).zoomSliderChanged(new ZoomSliderEvent(mouseEvent.getSource(), ZoomSliderEvent.ZOOMED, false));
                    ++n2;
                }
            }
        }
    }

    private void primeTranspose(MouseEvent mouseEvent) {
        if (!this.locked[0] && !this.locked[1]) {
            this.transposeStart = this.orientation == 0 ? mouseEvent.y : mouseEvent.x;
            this.transposePrimed = true;
        }
    }

    private void configureTranspose(MouseEvent mouseEvent) {
        int n = 0;
        n = this.orientation == 0 ? mouseEvent.y : mouseEvent.x;
        if (Math.abs(n - this.transposeStart) > 2) {
            this.transposeValue = this.pixel2Value(n);
            this.transposeRange = this.getVisibleValueRange();
            this.transposePrimed = false;
            this.transposeConfigured = true;
        }
    }

    private void transpose(MouseEvent mouseEvent) {
        double d = this.visible[0];
        int n = mouseEvent.y;
        if (this.orientation == 1) {
            n = mouseEvent.x;
        }
        double d2 = Math.abs((double)n - this.value2Pixel(this.visible[0]));
        this.visible[0] = this.transposeValue - d2 * this.getSinglePixelRange();
        if (this.visible[0] < this.limit[0]) {
            this.visible[0] = this.limit[0];
        }
        this.visible[1] = this.visible[0] + this.transposeRange;
        if (this.visible[1] > this.limit[1]) {
            this.visible[1] = this.limit[1];
            this.visible[0] = this.visible[1] - this.transposeRange;
        }
        if (this.visible[0] != d) {
            this.transposed = true;
            this.recreateScale();
            int n2 = 0;
            while (n2 < this.listeners.size()) {
                ((ZoomSliderListener)this.listeners.elementAt(n2)).zoomSliderChanged(new ZoomSliderEvent(mouseEvent.getSource(), ZoomSliderEvent.TRANSPOSED, false));
                ++n2;
            }
        }
    }

    public void addZoomSliderListener(ZoomSliderListener zoomSliderListener) {
        this.listeners.add(zoomSliderListener);
    }

    public void removeZoomSliderListener(ZoomSliderListener zoomSliderListener) {
        this.listeners.remove(zoomSliderListener);
    }

    void Slider_MouseDown(MouseEvent mouseEvent) {
        if (!this.barsCollection.mouseDown(mouseEvent)) {
            if (mouseEvent.button > 1) {
                if (this.transposable) {
                    this.primeTranspose(mouseEvent);
                }
            } else if (this.zoomable) {
                this.primeZoom(mouseEvent);
            }
        }
    }

    void Slider_MouseUp(MouseEvent mouseEvent) {
        if (!this.barsCollection.mouseUp(mouseEvent)) {
            int n;
            if (this.zoomPrimed) {
                this.zoomPrimed = false;
            }
            if (this.zoomConfigured) {
                this.zoomConfigured = false;
            }
            if (this.transposePrimed) {
                this.transposePrimed = false;
            }
            if (this.transposeConfigured) {
                this.transposeConfigured = false;
            }
            if (this.zoomed) {
                n = 0;
                while (n < this.listeners.size()) {
                    ((ZoomSliderListener)this.listeners.elementAt(n)).zoomSliderChanged(new ZoomSliderEvent(mouseEvent.getSource(), ZoomSliderEvent.ZOOMED, true));
                    ++n;
                }
                this.zoomed = false;
            }
            if (this.transposed) {
                n = 0;
                while (n < this.listeners.size()) {
                    ((ZoomSliderListener)this.listeners.elementAt(n)).zoomSliderChanged(new ZoomSliderEvent(mouseEvent.getSource(), ZoomSliderEvent.TRANSPOSED, true));
                    ++n;
                }
                this.transposed = false;
            }
        }
    }

    void Slider_MouseMove(MouseEvent mouseEvent) {
        ZoomControlBar zoomControlBar = this.barsCollection.getZoomControlBarContaining(mouseEvent.x, mouseEvent.y);
        if (zoomControlBar != null) {
            String string = zoomControlBar.getToolTipText();
            if (this.getToolTipText() == null || !this.getToolTipText().equals(string)) {
                this.setToolTipText(string);
            }
        } else {
            String string = null;
            if (this.getToolTipText() != null) {
                this.setToolTipText(string);
            }
        }
        if (!this.barsCollection.mouseMove(mouseEvent)) {
            if (this.zoomPrimed) {
                this.configureZoom(mouseEvent);
            }
            if (this.zoomConfigured) {
                this.zoom(mouseEvent);
            }
            if (this.transposePrimed) {
                this.configureTranspose(mouseEvent);
            }
            if (this.transposeConfigured) {
                this.transpose(mouseEvent);
            }
        }
    }

    class SliderDisposeListener
    implements DisposeListener {
        SliderDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent disposeEvent) {
            if (ZoomSlider.this.image != null) {
                ZoomSlider.this.image.dispose();
            }
            if (ZoomSlider.this.gImage != null) {
                ZoomSlider.this.gImage.dispose();
            }
            if (ZoomSlider.this.plainScale != null) {
                ZoomSlider.this.plainScale.dispose();
            }
            if (ZoomSlider.this.gPlain != null) {
                ZoomSlider.this.gPlain.dispose();
            }
            if (ZoomSlider.this.titleImage != null) {
                ZoomSlider.this.titleImage.dispose();
            }
            if (ZoomSlider.this.gTitle != null) {
                ZoomSlider.this.gTitle.dispose();
            }
            if (ZoomSlider.this.titleFont != null) {
                ZoomSlider.this.titleFont.dispose();
            }
            ZoomSlider.this.barsCollection.dispose();
            ZoomSlider.this.indicatorsCollection.dispose();
        }
    }

    class SliderControlListener
    extends ControlAdapter {
        SliderControlListener() {
        }

        public void controlResized(ControlEvent controlEvent) {
            ZoomSlider.this.resizeScale();
        }
    }

    class SliderMouseMoveListener
    implements MouseMoveListener {
        SliderMouseMoveListener() {
        }

        public void mouseMove(MouseEvent mouseEvent) {
            ZoomSlider.this.Slider_MouseMove(mouseEvent);
        }
    }

    class SliderMouseListener
    implements MouseListener {
        SliderMouseListener() {
        }

        public void mouseDown(MouseEvent mouseEvent) {
            ZoomSlider.this.Slider_MouseDown(mouseEvent);
        }

        public void mouseUp(MouseEvent mouseEvent) {
            ZoomSlider.this.Slider_MouseUp(mouseEvent);
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
        }
    }

    class SliderPaintListener
    implements PaintListener {
        SliderPaintListener() {
        }

        public void paintControl(PaintEvent paintEvent) {
            ZoomSlider.this.paint(paintEvent);
        }
    }

    class TickValueRange {
        public double min;
        public double max;

        public TickValueRange() {
            this.min = ZoomSlider.this.getSinglePixelRange() * 10.0;
            if (this.min < ZoomSlider.this.resolution) {
                this.min = ZoomSlider.this.resolution;
            }
            this.max = ZoomSlider.this.getSinglePixelRange() * 25.0;
            if (this.max < ZoomSlider.this.resolution) {
                this.max = ZoomSlider.this.resolution;
            }
        }

        public boolean outside() {
            return ZoomSlider.this.increment < this.min || ZoomSlider.this.increment > this.max;
        }
    }
}

