/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.presentation;

import org.eclipse.hyades.logging.adapter.ui.AcadEditorPluginImages;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleBuilderWidgetFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class EditorPage
extends Viewer
implements PaintListener {
    private String title = "";
    private Font titleFont;
    private int TITLE_HMARGIN = 10;
    private int TITLE_VMARGIN = 5;
    private Composite control;
    protected RuleBuilderWidgetFactory factory;
    private int readOnly;
    private Color headingBackground;
    private Color headingForeground;
    private Image headingImage;
    private boolean headingVisible = true;

    public EditorPage(RuleBuilderWidgetFactory ruleBuilderWidgetFactory) {
        this.factory = ruleBuilderWidgetFactory;
        this.titleFont = JFaceResources.getHeaderFont();
    }

    public Control getContent(Composite composite) {
        if (this.isWhiteBackground()) {
            this.setHeadingImage(AcadEditorPluginImages.getImage("page_banner.gif"));
        }
        Canvas canvas = new Canvas(composite, 0);
        canvas.setBackground(this.factory.getBackgroundColor());
        canvas.setForeground(this.factory.getForegroundColor());
        canvas.addPaintListener((PaintListener)this);
        canvas.setLayout((Layout)new PageLayout());
        Composite composite2 = this.factory.createComposite((Composite)canvas);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        this.createContent(composite2);
        this.control = canvas;
        return canvas;
    }

    public Control getContent() {
        return this.control;
    }

    protected void createContent(Composite composite) {
    }

    public Color getHeadingBackground() {
        return this.headingBackground;
    }

    public Color getHeadingForeground() {
        return this.headingForeground;
    }

    public Image getHeadingImage() {
        return this.headingImage;
    }

    public boolean isHeadingVisible() {
        return this.headingVisible;
    }

    public final void paintControl(PaintEvent paintEvent) {
        if (!this.headingVisible) {
            return;
        }
        GC gC = paintEvent.gc;
        Control control = (Control)paintEvent.widget;
        this.paint(control, gC);
    }

    private void paint(Control control, GC gC) {
        Rectangle rectangle = control.getBounds();
        int n = this.getTitleHeight();
        if (this.headingImage != null) {
            Rectangle rectangle2 = this.headingImage.getBounds();
            if (this.headingBackground != null) {
                gC.setBackground(this.headingBackground);
                gC.fillRectangle(0, 0, rectangle.width, n);
            }
            if (!SWT.getPlatform().equals("motif")) {
                gC.drawImage(this.headingImage, 0, 0);
            }
            if (this.headingForeground != null) {
                gC.setForeground(this.headingForeground);
            } else {
                gC.setForeground(this.factory.getForegroundColor());
            }
            gC.setFont(this.titleFont);
            gC.drawText(this.getTitle(), this.TITLE_HMARGIN, this.TITLE_VMARGIN, true);
        } else {
            gC.setFont(this.titleFont);
            gC.setBackground(this.factory.getColor("__default__header__"));
            gC.setForeground(this.factory.getForegroundColor());
            gC.drawText(this.getTitle(), this.TITLE_HMARGIN, this.TITLE_VMARGIN, true);
        }
    }

    public void setHeadingBackground(Color color) {
        this.headingBackground = color;
    }

    public void setHeadingForeground(Color color) {
        this.headingForeground = color;
    }

    public void setHeadingImage(Image image) {
        this.headingImage = image;
    }

    public void setHeadingVisible(boolean bl) {
        if (bl != this.headingVisible) {
            this.headingVisible = bl;
            if (this.control != null) {
                this.control.layout(true);
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    private int getTitleHeight() {
        int n = 0;
        if (this.headingImage != null && !SWT.getPlatform().equals("motif")) {
            n = this.headingImage.getBounds().height;
        }
        GC gC = new GC((Drawable)this.control);
        gC.setFont(this.titleFont);
        FontMetrics fontMetrics = gC.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        gC.dispose();
        int n3 = n2 + this.TITLE_VMARGIN + this.TITLE_VMARGIN;
        return Math.max(n3, n);
    }

    private boolean isWhiteBackground() {
        Color color = this.factory.getBackgroundColor();
        return color.getRed() == 255 && color.getGreen() == 255 && color.getBlue() == 255;
    }

    public void setTitle(String string) {
        this.title = string;
        if (this.control != null) {
            this.control.redraw();
        }
    }

    class PageLayout
    extends Layout {
        PageLayout() {
        }

        protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
            if (n != -1 && n2 != -1) {
                return new Point(n, n2);
            }
            boolean bl2 = false;
            Control control = composite.getChildren()[0];
            Point point = control.computeSize(-1, -1, bl);
            if (EditorPage.this.headingVisible) {
                point.y += EditorPage.this.getTitleHeight();
            }
            return point;
        }

        protected void layout(Composite composite, boolean bl) {
            Rectangle rectangle = composite.getClientArea();
            Control control = composite.getChildren()[0];
            int n = EditorPage.this.headingVisible ? EditorPage.this.getTitleHeight() : 0;
            control.setBounds(rectangle.x, rectangle.y + n, rectangle.width, rectangle.height - n);
        }
    }
}

