/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.presentation;

import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.logging.adapter.model.internal.adapter.Adapter;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.LoggingAgentOutputterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.NotificationOutputterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterPackage;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.SingleFileOutputterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.StandardOutOutputterType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.AdapterCBESensorType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorFactory;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorPackage;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorPropertyType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SingleFileSensorType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.StaticParserSensorType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.ProcessUnit;
import org.eclipse.hyades.logging.adapter.model.internal.unit.ProcessUnitType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.PropertyType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.UnitFactory;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;

public class MigrationUtil {
    public static PropertyType getOrCreateProperty(ProcessUnitType processUnitType, String string) {
        PropertyType propertyType = MigrationUtil.getProperty(processUnitType.getProperty(), string);
        if (propertyType != null) {
            return propertyType;
        }
        propertyType = UnitFactory.eINSTANCE.createPropertyType();
        processUnitType.getProperty().add(propertyType);
        propertyType.setPropertyName(string);
        return propertyType;
    }

    public static Object migrateLoad(Adapter adapter) {
        if (adapter != null && adapter instanceof Adapter) {
            Adapter adapter2 = adapter;
            try {
                adapter2.getConfiguration().getContextInstance();
                Iterator iterator = adapter2.getConfiguration().getContextInstance().iterator();
                while (iterator.hasNext()) {
                    OutputterConfigType outputterConfigType;
                    ContextInstanceType contextInstanceType = (ContextInstanceType)iterator.next();
                    if (contextInstanceType == null) continue;
                    Iterator iterator2 = contextInstanceType.getOutputter().iterator();
                    while (iterator2.hasNext()) {
                        outputterConfigType = (OutputterConfigType)iterator2.next();
                        if (outputterConfigType.getSingleFileOutputterType() != null) {
                            MigrationUtil.migrateLoad(outputterConfigType.getSingleFileOutputterType());
                            continue;
                        }
                        if (outputterConfigType.getLoggingAgentOutputterType() != null) {
                            MigrationUtil.migrateLoad(outputterConfigType.getLoggingAgentOutputterType());
                            continue;
                        }
                        if (outputterConfigType.getNotificationOutputterType() == null) continue;
                        MigrationUtil.migrateLoad(outputterConfigType.getNotificationOutputterType());
                    }
                    if (contextInstanceType.getSensor() == null) continue;
                    outputterConfigType = contextInstanceType.getSensor();
                    if (outputterConfigType.getSingleFileSensor() != null) {
                        MigrationUtil.migrateLoad(outputterConfigType.getSingleFileSensor());
                        continue;
                    }
                    if (outputterConfigType.getStaticParserSensor() == null) continue;
                    MigrationUtil.migrateLoad(outputterConfigType.getStaticParserSensor());
                }
            }
            catch (Exception exception) {
                Status status = new Status(4, AcadEditorPlugin.getDefault().getPluginId(), 4, AcadEditorPlugin.getDefault().getString("MIGRATION_LOAD_ERROR"), (Throwable)exception);
                AcadEditorPlugin.getDefault().logMessage((IStatus)status);
            }
        }
        return adapter;
    }

    public static Object migrateSave(Adapter adapter) {
        if (adapter != null && adapter instanceof Adapter) {
            Adapter adapter2 = adapter;
            try {
                adapter2.getConfiguration().getContextInstance();
                Iterator iterator = adapter2.getConfiguration().getContextInstance().iterator();
                while (iterator.hasNext()) {
                    OutputterConfigType outputterConfigType;
                    ContextInstanceType contextInstanceType = (ContextInstanceType)iterator.next();
                    if (contextInstanceType == null) continue;
                    Iterator iterator2 = contextInstanceType.getOutputter().iterator();
                    while (iterator2.hasNext()) {
                        outputterConfigType = (OutputterConfigType)iterator2.next();
                        MigrationUtil.migrateSave(outputterConfigType);
                    }
                    if (contextInstanceType.getSensor() == null) continue;
                    outputterConfigType = contextInstanceType.getSensor();
                    MigrationUtil.migrateSave((SensorConfigType)outputterConfigType);
                }
            }
            catch (Exception exception) {
                Status status = new Status(4, AcadEditorPlugin.getDefault().getPluginId(), 4, AcadEditorPlugin.getDefault().getString("MIGRATION_SAVE_ERROR"), (Throwable)exception);
                AcadEditorPlugin.getDefault().logMessage((IStatus)status);
            }
        }
        return adapter;
    }

    public static void migrateSave(SensorConfigType sensorConfigType) {
        if (sensorConfigType.getType() == SensorType.SINGLE_FILE_SENSOR_LITERAL) {
            SingleFileSensorType singleFileSensorType = sensorConfigType.getSingleFileSensor();
            if (singleFileSensorType == null) {
                singleFileSensorType = SensorFactory.eINSTANCE.createSingleFileSensorType();
                sensorConfigType.setSingleFileSensor(singleFileSensorType);
            }
            sensorConfigType.setAdapterCBESensor(null);
            sensorConfigType.setStaticParserSensor(null);
            singleFileSensorType.setDirectory(MigrationUtil.getPropertyValue(sensorConfigType.getProperty(), SensorPackage.eINSTANCE.getSingleFileSensorType_Directory()));
            singleFileSensorType.setFileName(MigrationUtil.getPropertyValue(sensorConfigType.getProperty(), SensorPackage.eINSTANCE.getSingleFileSensorType_FileName()));
            singleFileSensorType.setConverter(MigrationUtil.getPropertyValue(sensorConfigType.getProperty(), SensorPackage.eINSTANCE.getSingleFileSensorType_Converter()));
            singleFileSensorType.setShell(MigrationUtil.getPropertyValue(sensorConfigType.getProperty(), SensorPackage.eINSTANCE.getSingleFileSensorType_Shell()));
        } else if (sensorConfigType.getType() == SensorType.STATIC_PARSER_SENSOR_LITERAL) {
            StaticParserSensorType staticParserSensorType = sensorConfigType.getStaticParserSensor();
            if (staticParserSensorType == null) {
                staticParserSensorType = SensorFactory.eINSTANCE.createStaticParserSensorType();
                sensorConfigType.setStaticParserSensor(staticParserSensorType);
            }
            sensorConfigType.setAdapterCBESensor(null);
            sensorConfigType.setSingleFileSensor(null);
            staticParserSensorType.setDirectory(MigrationUtil.getPropertyValue(sensorConfigType.getProperty(), SensorPackage.eINSTANCE.getStaticParserSensorType_Directory()));
            staticParserSensorType.setFileName(MigrationUtil.getPropertyValue(sensorConfigType.getProperty(), SensorPackage.eINSTANCE.getStaticParserSensorType_FileName()));
            staticParserSensorType.setParserClassName(MigrationUtil.getPropertyValue(sensorConfigType.getProperty(), SensorPackage.eINSTANCE.getStaticParserSensorType_ParserClassName()));
        } else if (sensorConfigType.getType() == SensorType.ADAPTER_CBE_SENSOR_LITERAL) {
            AdapterCBESensorType adapterCBESensorType = sensorConfigType.getAdapterCBESensor();
            if (adapterCBESensorType == null) {
                adapterCBESensorType = SensorFactory.eINSTANCE.createAdapterCBESensorType();
                sensorConfigType.setAdapterCBESensor(adapterCBESensorType);
            }
            sensorConfigType.setStaticParserSensor(null);
            sensorConfigType.setSingleFileSensor(null);
        } else {
            sensorConfigType.setStaticParserSensor(null);
            sensorConfigType.setSingleFileSensor(null);
            sensorConfigType.setAdapterCBESensor(null);
        }
    }

    public static PropertyType getProperty(EList eList, String string) {
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            PropertyType propertyType = (PropertyType)iterator.next();
            if (propertyType.getPropertyName() == null || !propertyType.getPropertyName().equals(string)) continue;
            return propertyType;
        }
        return null;
    }

    public static String getPropertyValue(EList eList, EAttribute eAttribute) {
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            PropertyType propertyType = (PropertyType)iterator.next();
            if (propertyType.getPropertyName() == null || !propertyType.getPropertyName().equals(eAttribute.getName())) continue;
            return propertyType.getPropertyValue();
        }
        return null;
    }

    public static void migrateSave(OutputterConfigType outputterConfigType) {
        if (outputterConfigType.getType() == OutputterType.SINGLE_FILE_OUTPUTTER_LITERAL) {
            SingleFileOutputterType singleFileOutputterType = outputterConfigType.getSingleFileOutputterType();
            if (singleFileOutputterType == null) {
                singleFileOutputterType = OutputterFactory.eINSTANCE.createSingleFileOutputterType();
                outputterConfigType.setSingleFileOutputterType(singleFileOutputterType);
            }
            outputterConfigType.setLoggingAgentOutputterType(null);
            outputterConfigType.setNotificationOutputterType(null);
            outputterConfigType.setStandardOutOutputterType(null);
            singleFileOutputterType.setDirectory(MigrationUtil.getPropertyValue(outputterConfigType.getProperty(), OutputterPackage.eINSTANCE.getSingleFileOutputterType_Directory()));
            singleFileOutputterType.setFileName(MigrationUtil.getPropertyValue(outputterConfigType.getProperty(), OutputterPackage.eINSTANCE.getSingleFileOutputterType_FileName()));
        } else if (outputterConfigType.getType() == OutputterType.LOGGING_AGENT_OUTPUTTER_LITERAL) {
            LoggingAgentOutputterType loggingAgentOutputterType = outputterConfigType.getLoggingAgentOutputterType();
            if (loggingAgentOutputterType == null) {
                loggingAgentOutputterType = OutputterFactory.eINSTANCE.createLoggingAgentOutputterType();
                outputterConfigType.setLoggingAgentOutputterType(loggingAgentOutputterType);
            }
            outputterConfigType.setSingleFileOutputterType(null);
            outputterConfigType.setNotificationOutputterType(null);
            outputterConfigType.setStandardOutOutputterType(null);
            loggingAgentOutputterType.setAgentName(MigrationUtil.getPropertyValue(outputterConfigType.getProperty(), OutputterPackage.eINSTANCE.getLoggingAgentOutputterType_AgentName()));
            loggingAgentOutputterType.setWaitUntilLoggingTime(MigrationUtil.getPropertyValue(outputterConfigType.getProperty(), OutputterPackage.eINSTANCE.getLoggingAgentOutputterType_WaitUntilLoggingTime()));
        } else if (outputterConfigType.getType() == OutputterType.NOTIFICATION_OUTPUTTER_LITERAL) {
            NotificationOutputterType notificationOutputterType = outputterConfigType.getNotificationOutputterType();
            if (notificationOutputterType == null) {
                notificationOutputterType = OutputterFactory.eINSTANCE.createNotificationOutputterType();
                outputterConfigType.setNotificationOutputterType(notificationOutputterType);
            }
            outputterConfigType.setSingleFileOutputterType(null);
            outputterConfigType.setLoggingAgentOutputterType(null);
            outputterConfigType.setStandardOutOutputterType(null);
            notificationOutputterType.setResourceURL(MigrationUtil.getPropertyValue(outputterConfigType.getProperty(), OutputterPackage.eINSTANCE.getNotificationOutputterType_ResourceURL()));
        } else if (outputterConfigType.getType() == OutputterType.SINGLE_FILE_OUTPUTTER_LITERAL) {
            StandardOutOutputterType standardOutOutputterType = outputterConfigType.getStandardOutOutputterType();
            if (standardOutOutputterType == null) {
                standardOutOutputterType = OutputterFactory.eINSTANCE.createStandardOutOutputterType();
                outputterConfigType.setStandardOutOutputterType(standardOutOutputterType);
            }
            outputterConfigType.setNotificationOutputterType(null);
            outputterConfigType.setSingleFileOutputterType(null);
            outputterConfigType.setLoggingAgentOutputterType(null);
        } else {
            outputterConfigType.setNotificationOutputterType(null);
            outputterConfigType.setSingleFileOutputterType(null);
            outputterConfigType.setLoggingAgentOutputterType(null);
            outputterConfigType.setStandardOutOutputterType(null);
        }
    }

    public static void migrateLoad(LoggingAgentOutputterType loggingAgentOutputterType) {
        MigrationUtil.addOrSetProperty(loggingAgentOutputterType.eContainer(), OutputterPackage.eINSTANCE.getLoggingAgentOutputterType_AgentName(), loggingAgentOutputterType.getAgentName());
        MigrationUtil.addOrSetProperty(loggingAgentOutputterType.eContainer(), OutputterPackage.eINSTANCE.getLoggingAgentOutputterType_WaitUntilLoggingTime(), loggingAgentOutputterType.getWaitUntilLoggingTime());
    }

    public static void migrateLoad(NotificationOutputterType notificationOutputterType) {
        MigrationUtil.addOrSetProperty(notificationOutputterType.eContainer(), OutputterPackage.eINSTANCE.getNotificationOutputterType_ResourceURL(), notificationOutputterType.getResourceURL());
    }

    public static void addOrSetProperty(EObject eObject, EAttribute eAttribute, String string) {
        MigrationUtil.addOrSetProperty(eObject, eAttribute.getName(), string);
    }

    public static void migrateLoad(SingleFileOutputterType singleFileOutputterType) {
        MigrationUtil.addOrSetProperty(singleFileOutputterType.eContainer(), OutputterPackage.eINSTANCE.getSingleFileOutputterType_Directory(), singleFileOutputterType.getDirectory());
        MigrationUtil.addOrSetProperty(singleFileOutputterType.eContainer(), OutputterPackage.eINSTANCE.getSingleFileOutputterType_FileName(), singleFileOutputterType.getFileName());
    }

    public static void addOrSetProperty(EObject eObject, String string, String string2) {
        if (string2 == null) {
            return;
        }
        PropertyType propertyType = MigrationUtil.getOrCreateProperty((ProcessUnitType)eObject, string);
        propertyType.setPropertyValue(string2);
    }

    public static void migrateLoad(SingleFileSensorType singleFileSensorType) {
        MigrationUtil.addOrSetProperty(singleFileSensorType.eContainer(), SensorPackage.eINSTANCE.getSingleFileSensorType_Directory(), singleFileSensorType.getDirectory());
        MigrationUtil.addOrSetProperty(singleFileSensorType.eContainer(), SensorPackage.eINSTANCE.getSingleFileSensorType_FileName(), singleFileSensorType.getFileName());
        MigrationUtil.addOrSetProperty(singleFileSensorType.eContainer(), SensorPackage.eINSTANCE.getSingleFileSensorType_Converter(), singleFileSensorType.getConverter());
        MigrationUtil.addOrSetProperty(singleFileSensorType.eContainer(), SensorPackage.eINSTANCE.getSingleFileSensorType_Shell(), singleFileSensorType.getShell());
    }

    public static void migrateLoad(StaticParserSensorType staticParserSensorType) {
        MigrationUtil.addOrSetProperty((EObject)((ProcessUnit)staticParserSensorType.eContainer()), SensorPackage.eINSTANCE.getStaticParserSensorType_Directory(), staticParserSensorType.getDirectory());
        MigrationUtil.addOrSetProperty((EObject)((ProcessUnit)staticParserSensorType.eContainer()), SensorPackage.eINSTANCE.getStaticParserSensorType_FileName(), staticParserSensorType.getFileName());
        MigrationUtil.addOrSetProperty((EObject)((ProcessUnit)staticParserSensorType.eContainer()), SensorPackage.eINSTANCE.getStaticParserSensorType_ParserClassName(), staticParserSensorType.getParserClassName());
        Iterator iterator = staticParserSensorType.getSensorProperty().iterator();
        while (iterator.hasNext()) {
            SensorPropertyType sensorPropertyType = (SensorPropertyType)iterator.next();
            MigrationUtil.addOrSetProperty(staticParserSensorType.eContainer(), sensorPropertyType.getPropertyName(), sensorPropertyType.getPropertyValue());
        }
    }
}

