/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.Extractor;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.provider.ExtractorItemProvider;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.provider.ExtractorItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.provider.ExtractorTypeItemProvider;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.hyades.logging.adapter.ui.internal.util.IDetails;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleBuilderWidgetFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ExtractorSection
extends Composite
implements IDetails,
ModifyListener,
SelectionListener,
INotifyChangedListener {
    protected Button isReplaceLineBreaks;
    protected Button hasStartEvent;
    protected Text eventStartText;
    protected Button hasEndEvent;
    protected Text eventEndText;
    protected Button isLineBreaks;
    protected Text lineBreaksText;
    protected Text descriptionText;
    protected Label uniqueIdText;
    protected Extractor currentSelection;
    protected boolean isDisplaying = false;
    protected ExtractorItemProvider itemProvider;
    protected ExtractorItemProviderAdapterFactory itemFactory = new ExtractorItemProviderAdapterFactory();

    public ExtractorSection(RuleBuilderWidgetFactory ruleBuilderWidgetFactory, Composite composite, int n) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 5;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(GridUtil.createFill());
        Label label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_EXTR_DESCR"), 0);
        this.descriptionText = ruleBuilderWidgetFactory.createText(this, "", 0);
        this.descriptionText.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_EXTR_ID"), 0);
        this.uniqueIdText = ruleBuilderWidgetFactory.createLabel(this, "");
        this.uniqueIdText.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, "", 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.isLineBreaks = ruleBuilderWidgetFactory.createButton(this, AcadEditorPlugin.getPlugin().getString("STR_EXTR_HAS_LINEB"), 32);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.isLineBreaks.setLayoutData((Object)gridData);
        this.isReplaceLineBreaks = ruleBuilderWidgetFactory.createButton(this, AcadEditorPlugin.INSTANCE.getString("REPLACE_LINE_BREAK"), 32);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.isReplaceLineBreaks.setLayoutData((Object)gridData);
        Composite composite2 = new Composite((Composite)this, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 10;
        composite2.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData);
        label = ruleBuilderWidgetFactory.createLabel(composite2, AcadEditorPlugin.getPlugin().getString("STR_EXTR_LINE_BSYMB"), 0);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.lineBreaksText = ruleBuilderWidgetFactory.createText(composite2, "", 0);
        this.lineBreaksText.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, "", 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        composite2 = new Composite((Composite)this, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 10;
        composite2.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData);
        label = ruleBuilderWidgetFactory.createLabel(composite2, AcadEditorPlugin.getPlugin().getString("STR_EXTR_STARTP"), 0);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.hasStartEvent = ruleBuilderWidgetFactory.createButton(this, AcadEditorPlugin.getPlugin().getString("STR_EXTR_INC_STARTP"), 32);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.hasStartEvent.setLayoutData((Object)gridData);
        this.eventStartText = ruleBuilderWidgetFactory.createText(composite2, "", 0);
        this.eventStartText.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, "", 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        composite2 = new Composite((Composite)this, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 10;
        composite2.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData);
        label = ruleBuilderWidgetFactory.createLabel(composite2, AcadEditorPlugin.getPlugin().getString("STR_EXTR_END_PATTERN"), 0);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.hasEndEvent = ruleBuilderWidgetFactory.createButton(this, AcadEditorPlugin.getPlugin().getString("STR_EXTR_INC_ENDP"), 32);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.hasEndEvent.setLayoutData((Object)gridData);
        this.eventEndText = ruleBuilderWidgetFactory.createText(composite2, "", 0);
        this.eventEndText.setLayoutData((Object)new GridData(768));
        this.eventEndText.addModifyListener((ModifyListener)this);
        this.eventStartText.addModifyListener((ModifyListener)this);
        this.descriptionText.addModifyListener((ModifyListener)this);
        this.lineBreaksText.addModifyListener((ModifyListener)this);
        this.isLineBreaks.addSelectionListener((SelectionListener)this);
        this.hasStartEvent.addSelectionListener((SelectionListener)this);
        this.hasEndEvent.addSelectionListener((SelectionListener)this);
        this.isReplaceLineBreaks.addSelectionListener((SelectionListener)this);
        this.itemProvider = (ExtractorItemProvider)this.itemFactory.createExtractorAdapter();
        this.itemProvider.addListener(this);
    }

    public void setFocusToText() {
        this.descriptionText.setFocus();
        this.descriptionText.selectAll();
    }

    public void modifyText(ModifyEvent modifyEvent) {
        String string;
        if (this.currentSelection == null || this.isDisplaying) {
            return;
        }
        if (modifyEvent.getSource() == this.eventStartText) {
            String string2 = this.eventStartText.getText();
            if (!string2.equals(this.currentSelection.getStartPattern())) {
                if (string2.length() == 0 && this.currentSelection.getStartPattern() == null) {
                    return;
                }
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ExtractorTypeItemProvider.START_PATTERN);
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string2);
                }
            }
        } else if (modifyEvent.getSource() == this.eventEndText) {
            String string3 = this.eventEndText.getText();
            if (!string3.equals(this.currentSelection.getEndPattern())) {
                if (string3.length() == 0 && this.currentSelection.getEndPattern() == null) {
                    return;
                }
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ExtractorTypeItemProvider.END_PATTERN);
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string3);
                }
            }
        } else if (modifyEvent.getSource() == this.descriptionText) {
            String string4 = this.descriptionText.getText();
            if (!string4.equals(this.currentSelection.getDescription())) {
                if (string4.length() == 0 && this.currentSelection.getDescription() == null) {
                    return;
                }
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ExtractorTypeItemProvider.DESCRIPTION);
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string4);
                }
            }
        } else if (modifyEvent.getSource() == this.lineBreaksText && !(string = this.lineBreaksText.getText()).equals(this.currentSelection.getLineBreakSymbol())) {
            if (string.length() == 0 && this.currentSelection.getLineBreakSymbol() == null) {
                return;
            }
            IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ExtractorTypeItemProvider.LINE_BREAK_SYMBOL);
            if (iItemPropertyDescriptor != null) {
                iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string);
            }
        }
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
        this.currentSelection = null;
    }

    protected void updateControls() {
        this.isDisplaying = true;
        if (this.currentSelection.getUniqueID() != null) {
            this.uniqueIdText.setText(this.currentSelection.getUniqueID());
        }
        if (this.currentSelection.getDescription() != null) {
            this.descriptionText.setText(this.currentSelection.getDescription());
        }
        if (this.currentSelection.getStartPattern() != null) {
            this.eventStartText.setText(this.currentSelection.getStartPattern());
        }
        if (this.currentSelection.getEndPattern() != null) {
            this.eventEndText.setText(this.currentSelection.getEndPattern());
        }
        if (this.currentSelection.getLineBreakSymbol() != null) {
            this.lineBreaksText.setText(this.currentSelection.getLineBreakSymbol());
        }
        this.isLineBreaks.setSelection(this.currentSelection.isContainsLineBreaks());
        this.hasStartEvent.setSelection(this.currentSelection.isIncludeStartPattern());
        this.hasEndEvent.setSelection(this.currentSelection.isIncludeEndPattern());
        this.isReplaceLineBreaks.setSelection(this.currentSelection.isReplaceLineBreaks());
        this.isDisplaying = false;
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        boolean bl;
        if (selectionEvent.getSource() == this.isReplaceLineBreaks) {
            boolean bl2 = this.isReplaceLineBreaks.getSelection();
            if (bl2 != this.currentSelection.isReplaceLineBreaks()) {
                this.currentSelection.setReplaceLineBreaks(bl2);
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ExtractorTypeItemProvider.START_PATTERN);
                String string = this.currentSelection.getStartPattern();
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string);
                }
            }
        } else if (selectionEvent.getSource() == this.isLineBreaks) {
            boolean bl3 = this.isLineBreaks.getSelection();
            if (bl3 != this.currentSelection.isContainsLineBreaks()) {
                this.currentSelection.setContainsLineBreaks(bl3);
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ExtractorTypeItemProvider.START_PATTERN);
                String string = this.currentSelection.getStartPattern();
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string);
                }
            }
        } else if (selectionEvent.getSource() == this.hasEndEvent) {
            boolean bl4 = this.hasEndEvent.getSelection();
            if (bl4 != this.currentSelection.isIncludeEndPattern()) {
                this.currentSelection.setIncludeEndPattern(bl4);
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ExtractorTypeItemProvider.START_PATTERN);
                String string = this.currentSelection.getStartPattern();
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string);
                }
            }
        } else if (selectionEvent.getSource() == this.hasStartEvent && (bl = this.hasStartEvent.getSelection()) != this.currentSelection.isIncludeStartPattern()) {
            this.currentSelection.setIncludeStartPattern(bl);
            IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ExtractorTypeItemProvider.START_PATTERN);
            String string = this.currentSelection.getStartPattern();
            if (iItemPropertyDescriptor != null) {
                iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void notifyChanged(Notification notification) {
        if (this.eventEndText.isFocusControl() || this.eventStartText.isFocusControl() || this.uniqueIdText.isFocusControl() || this.descriptionText.isFocusControl() || this.isLineBreaks.isFocusControl() || this.lineBreaksText.isFocusControl() || this.hasEndEvent.isFocusControl() || this.hasStartEvent.isFocusControl() || this.isReplaceLineBreaks.isFocusControl()) {
            return;
        }
        this.updateControls();
    }

    public void display(EObject eObject) {
        if (eObject != null) {
            AcadGuiModelManager.setCurrentModel((ContextInstanceType)eObject.eContainer());
        }
        if (this.currentSelection == eObject) {
            return;
        }
        if (this.eventEndText.isFocusControl() || this.eventStartText.isFocusControl() || this.uniqueIdText.isFocusControl() || this.descriptionText.isFocusControl() || this.isLineBreaks.isFocusControl() || this.lineBreaksText.isFocusControl() || this.hasEndEvent.isFocusControl() || this.hasStartEvent.isFocusControl() || this.isReplaceLineBreaks.isFocusControl()) {
            return;
        }
        this.currentSelection = (Extractor)eObject;
        this.isDisplaying = true;
        this.updateControls();
        this.isDisplaying = false;
    }

    public boolean updateCurrentSelection(EObject eObject) {
        this.currentSelection = (Extractor)eObject;
        this.currentSelection.setDescription(this.descriptionText.getText());
        this.currentSelection.setUniqueID(this.uniqueIdText.getText());
        this.currentSelection.setReplaceLineBreaks(this.isReplaceLineBreaks.getSelection());
        this.currentSelection.setContainsLineBreaks(this.isLineBreaks.getSelection());
        this.currentSelection.setLineBreakSymbol(this.lineBreaksText.getText());
        this.currentSelection.setIncludeStartPattern(this.hasStartEvent.getSelection());
        this.currentSelection.setStartPattern(this.eventStartText.getText());
        this.currentSelection.setIncludeEndPattern(this.hasEndEvent.getSelection());
        this.currentSelection.setEndPattern(this.eventEndText.getText());
        return false;
    }
}

