/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttributeType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.provider.ParserItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.parser.provider.RuleAttributeTypeItemProvider;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.hyades.logging.adapter.ui.internal.util.IDetails;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleBuilderWidgetFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RuleAttributeSection
extends Composite
implements IDetails,
SelectionListener,
INotifyChangedListener,
ModifyListener {
    protected Label nameText;
    protected Label uniqueId;
    protected Button usePreviuos;
    protected Label indexText;
    protected Text defaultValue;
    protected boolean isDisplaying;
    protected RuleAttributeType currentSelection;
    protected RuleAttributeTypeItemProvider itemProvider;
    protected ParserItemProviderAdapterFactory itemFactory = new ParserItemProviderAdapterFactory();

    public RuleAttributeSection(RuleBuilderWidgetFactory ruleBuilderWidgetFactory, Composite composite, int n) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 5;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(GridUtil.createFill());
        Label label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_ATTR_NAME"), 0);
        this.nameText = ruleBuilderWidgetFactory.createLabel(this, "");
        this.nameText.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_ATTR_ID"), 0);
        this.uniqueId = ruleBuilderWidgetFactory.createLabel(this, "unspecified");
        this.uniqueId.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, "", 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_ATTR_INDEX"), 0);
        this.indexText = ruleBuilderWidgetFactory.createLabel(this, "");
        this.indexText.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, "", 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.usePreviuos = ruleBuilderWidgetFactory.createButton(this, AcadEditorPlugin.getDefault().getString("STR_USE_PREV_ATTR"), 32);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.usePreviuos.setLayoutData((Object)gridData);
        label = ruleBuilderWidgetFactory.createLabel(this, "", 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_DEFAULT_VALUE"), 0);
        this.defaultValue = ruleBuilderWidgetFactory.createText(this, "");
        this.defaultValue.setLayoutData((Object)new GridData(768));
        this.defaultValue.setToolTipText(AcadEditorPlugin.getPlugin().getString("SINCE_1_3"));
        label = ruleBuilderWidgetFactory.createLabel(this, "", 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.itemProvider = (RuleAttributeTypeItemProvider)this.itemFactory.createRuleAttributeAdapter();
        this.itemProvider.addListener(this);
        this.usePreviuos.addSelectionListener((SelectionListener)this);
        this.defaultValue.addModifyListener((ModifyListener)this);
    }

    public void display(EObject eObject) {
        if (this.currentSelection == eObject) {
            return;
        }
        this.currentSelection = (RuleAttributeType)eObject;
        this.isDisplaying = true;
        this.nameText.setText(this.currentSelection.getName() == null ? "" : this.currentSelection.getName());
        this.uniqueId.setText(this.currentSelection.getId() == null ? "unspecified" : this.currentSelection.getId());
        this.indexText.setText(this.currentSelection.getIndex() == null ? "" : this.currentSelection.getIndex());
        this.defaultValue.setText(this.currentSelection.getDefaultValue() == null ? "" : this.currentSelection.getDefaultValue());
        this.usePreviuos.setSelection(this.currentSelection.isUsePreviousMatchSubstitutionAsDefault());
        this.isDisplaying = false;
    }

    public boolean updateCurrentSelection(EObject eObject) {
        this.currentSelection = (RuleAttributeType)eObject;
        this.currentSelection.setUsePreviousMatchSubstitutionAsDefault(this.usePreviuos.getSelection());
        this.currentSelection.setDefaultValue(this.defaultValue.getText());
        return false;
    }

    public void setFocusToText() {
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
    }

    public void notifyChanged(Notification notification) {
        Object object = notification.getNotifier();
        if (object == null || object != this.currentSelection) {
            return;
        }
        this.display((EObject)this.currentSelection);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, RuleAttributeTypeItemProvider.USE_PREVIOUS_MATCH_SUBSTITUTION_AS_DEFAULT);
        this.currentSelection.setUsePreviousMatchSubstitutionAsDefault(this.usePreviuos.getSelection());
        Boolean bl = new Boolean(this.currentSelection.isSetUsePreviousMatchSubstitutionAsDefault());
        if (iItemPropertyDescriptor != null) {
            iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)bl);
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void modifyText(ModifyEvent modifyEvent) {
        String string;
        if (this.isDisplaying || this.currentSelection == null) {
            return;
        }
        if (modifyEvent.getSource() == this.defaultValue && !(string = this.defaultValue.getText()).equals(this.currentSelection.getDefaultValue())) {
            if (string.length() == 0 && this.currentSelection.getDefaultValue() == null) {
                return;
            }
            IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, RuleAttributeTypeItemProvider.DEFAULT_VALUE);
            if (iItemPropertyDescriptor != null) {
                iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string);
            }
        }
    }
}

