/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.trace;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TraceSDPlugin
extends AbstractUIPlugin {
    private static TraceSDPlugin plugin;
    private ResourceBundle resourceBundle;
    private static URL BASIC_URL;
    private static Hashtable images;

    public TraceSDPlugin(IPluginDescriptor iPluginDescriptor) {
        super(iPluginDescriptor);
        plugin = this;
        try {
            this.resourceBundle = iPluginDescriptor.getResourceBundle();
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static TraceSDPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    protected void initializeDefaultPreferences(IPreferenceStore iPreferenceStore) {
        iPreferenceStore.setDefault("page_size", 131072);
    }

    public static String getResourceString(String string) {
        ResourceBundle resourceBundle = TraceSDPlugin.getDefault().getResourceBundle();
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static String getPluginId() {
        return TraceSDPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public static Image getResourceImage(String string) {
        URL uRL;
        Image image;
        if (TraceSDPlugin.getDefault() == null) {
            return null;
        }
        if (images != null && (image = (Image)images.get(string)) != null && !image.isDisposed()) {
            return image;
        }
        if (BASIC_URL == null) {
            try {
                BASIC_URL = new URL(TraceSDPlugin.getDefault().getDescriptor().getInstallURL(), "icons/");
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                return null;
            }
            images = new Hashtable();
        }
        try {
            uRL = new URL(BASIC_URL, string);
            image = ImageDescriptor.createFromURL((URL)uRL);
        }
        catch (MalformedURLException malformedURLException) {
            image = ImageDescriptor.getMissingImageDescriptor();
        }
        uRL = image.createImage();
        images.put(string, uRL);
        return uRL;
    }

    public void startup() throws CoreException {
        super.startup();
    }

    public void shutdown() throws CoreException {
        if (images == null) {
            return;
        }
        Iterator iterator = images.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (!(v instanceof Image) || ((Image)v).isDisposed()) continue;
            ((Image)v).dispose();
        }
        images.clear();
        images = null;
        super.shutdown();
    }

    static {
        BASIC_URL = null;
        images = null;
    }
}

