/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.trace.loaders;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.uml2sd.trace.TraceSDPlugin;
import org.eclipse.hyades.uml2sd.trace.loaders.BaseTraceInteractions;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.FoundInPage;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceCallStack;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceCollapsableSyncMessage;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceCollapsableSyncMessageReturn;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceCollapsedLifelines;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceCollapsedSyncMessage;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceCollapsedSyncMessageReturn;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceInteractionUpdate;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceInteractionUtils;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceLifeline;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceLifelineDraft;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceMessageAndCallAssociation;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TracePage;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceProcess;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceSyncMessage;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceSyncMessageReturn;
import org.eclipse.hyades.uml2sd.trace.preferences.ITraceInteractionPreferenceListener;
import org.eclipse.hyades.uml2sd.trace.selection.IDateSelection;
import org.eclipse.hyades.uml2sd.trace.selection.IEObjectSelection;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDFilterProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDInternalMesFilterProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDPagingProvider;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.Criteria;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.FilterCriteria;
import org.eclipse.hyades.uml2sd.ui.core.BaseMessage;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.LifelineCategories;
import org.eclipse.hyades.uml2sd.ui.drawings.IImage;
import org.eclipse.hyades.uml2sd.ui.drawings.impl.ImageImpl;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;

public abstract class TraceInteractions
extends BaseTraceInteractions
implements ISDFilterProvider,
ISDAdvancedPagingProvider,
ISDInternalMesFilterProvider,
ITraceInteractionPreferenceListener {
    public static final int CATEGORY_CLASSES = 0;
    public static final int CATEGORY_OBJECTS = 1;
    public static final int CATEGORY_COLLAPSED = 2;
    private static LifelineCategories[] traceCategories = new LifelineCategories[3];
    private boolean internalMessagesFiltered = false;
    private int maximumMessagesByPage = (int)TraceSDPlugin.getDefault().getPreferenceStore().getLong("page_size");
    private int nbMessages;
    private int nbMessagesInThisPage;
    private int pageNumber = 0;
    private boolean hasNextPage = false;
    private int totalNbMessages;
    private int pages;
    private ArrayList tracePages;
    private HashMap instancesMap;
    private double lastValidTime;
    private int currentMethodInvocationIndex;
    protected Timer dateSelectionTimer;
    private ArrayList currentFilters;
    private HashMap collapsedLifelines;
    private HashMap collapsedMessages;

    public void onSetViewer() {
        this.view.setSDFilterProvider((ISDFilterProvider)this);
        this.view.setSDPagingProvider((ISDPagingProvider)this);
        this.view.setInternalMessageFilterProvider((ISDInternalMesFilterProvider)this);
    }

    public void clearInternals() {
        super.clearInternals();
        this.pageNumber = 0;
        this.tracePages = null;
        this.collapsedLifelines = null;
        this.collapsedMessages = null;
        this.currentFilters = null;
    }

    protected synchronized void updateSD(TraceInteractionUpdate traceInteractionUpdate) {
        Object object;
        double d = 0.0;
        if (!(this.frame == null || traceInteractionUpdate.isDateSelectionChanged() || traceInteractionUpdate.isPageChanged() || traceInteractionUpdate.isFindRequired())) {
            this.currentProcesses.init();
            object = (TraceSyncMessage)this.frame.getSyncMessage(this.frame.getFirstVisibleSyncMessage());
            if (object != null) {
                d = ((TraceSyncMessage)object).getStartDate() + this.currentProcesses.getStartTime();
            } else {
                TraceSyncMessageReturn traceSyncMessageReturn = (TraceSyncMessageReturn)this.frame.getSyncMessageReturn(this.frame.getFirstVisibleSyncMessageReturn());
                if (traceSyncMessageReturn != null) {
                    d = traceSyncMessageReturn.getStartDate() + this.currentProcesses.getStartTime();
                }
            }
        }
        this.createFrame();
        if (this.currentProcesses == null) {
            return;
        }
        if (!traceInteractionUpdate.isPageChanged() && (traceInteractionUpdate.isInternalMessageFilteringChanged() || traceInteractionUpdate.isMaxMessagesByPageChanged() || traceInteractionUpdate.isFilteringChanged() || traceInteractionUpdate.isHorizontalCollapsingChanged() || traceInteractionUpdate.isVerticalCollapsingChanged())) {
            this.computeModel();
        }
        try {
            this.fillPage(traceInteractionUpdate);
        }
        catch (FoundInPage foundInPage) {
            if (traceInteractionUpdate.isDateSelectionChanged()) {
                traceInteractionUpdate.setPageChanged(true);
                this.pageNumber = foundInPage.getPage();
                this.updateSD(traceInteractionUpdate);
                return;
            }
            if (traceInteractionUpdate.isFindRequired()) {
                traceInteractionUpdate.setPageChanged(true);
                this.pageNumber = foundInPage.getPage();
                this.updateSD(traceInteractionUpdate);
                this.ensureSelectedAndMoveToFirst(traceInteractionUpdate.getFindResults());
                return;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (traceInteractionUpdate.getVisibleGraphNode() != null && this.view != null && !this.view.getSDWidget().isDisposed()) {
            this.setFrameName();
            this.view.setFrameAndEnsureVisibleSync(this.frame, traceInteractionUpdate.getVisibleGraphNode());
            return;
        }
        if (d != 0.0) {
            object = new TraceInteractionUpdate();
            ((TraceInteractionUpdate)object).setDateSelectionChanged(true);
            ((TraceInteractionUpdate)object).setDateToShow(d);
            this.updateSD((TraceInteractionUpdate)object);
            return;
        }
        if (this.view != null && !this.view.getSDWidget().isDisposed() && !this.monitor.isCanceled()) {
            this.setFrameName();
            this.view.setFrameSync(this.frame);
        }
    }

    protected void createFrame() {
        super.createFrame();
        this.frame.setLifelineCategories(traceCategories);
    }

    public void setFrameName() {
        if (this.frame == null) {
            return;
        }
        if (this.currentProcesses != null && this.currentProcesses.size() == 1) {
            TRCProcess tRCProcess = ((TraceProcess)this.currentProcesses.get(0)).getProcess();
            this.frame.setName(tRCProcess.getAgent().getAgentProxy().getProcessProxy().getName() + " [Pid " + tRCProcess.getPid() + "]" + this.pageMessage());
        } else {
            this.frame.setName(TraceSDPlugin.getResourceString("STR_SEVERAL_PROCESSES") + this.pageMessage());
        }
    }

    private String pageMessage() {
        String string = "";
        if (this.pages == 1) {
            return string;
        }
        string = " [" + (1 + this.pageNumber) + "/" + this.pages + " " + TraceSDPlugin.getResourceString("STR_PAGES") + "]";
        return string;
    }

    protected void computeModel() {
        this.totalNbMessages = 0;
        this.instancesMap = new HashMap();
        this.currentProcesses.init();
        TRCFullMethodInvocation tRCFullMethodInvocation = this.currentProcesses.consumeMethodInvocation();
        while (tRCFullMethodInvocation != null && !this.monitor.isCanceled()) {
            TRCFullMethodInvocation tRCFullMethodInvocation2 = (TRCFullMethodInvocation)tRCFullMethodInvocation.getInvokedBy();
            if (!this.isMessageCollapsed(tRCFullMethodInvocation2)) {
                EObject eObject = null;
                EObject eObject2 = null;
                if (tRCFullMethodInvocation2 != null) {
                    eObject = this.getLifelineEObjectFromMethodInvocation(tRCFullMethodInvocation2);
                    eObject2 = this.getLifelineEObjectFromMethodInvocation(tRCFullMethodInvocation);
                }
                if (!this.internalMessagesFiltered || eObject != eObject2) {
                    TraceLifelineDraft traceLifelineDraft = this.getTraceLifelineDraftForMethodInvocation(null, tRCFullMethodInvocation);
                    TraceLifelineDraft traceLifelineDraft2 = null;
                    if (tRCFullMethodInvocation2 != null) {
                        traceLifelineDraft2 = this.getTraceLifelineDraftForMethodInvocation(null, tRCFullMethodInvocation2);
                    }
                    if (!(traceLifelineDraft.isFiltered() || traceLifelineDraft2 != null && traceLifelineDraft2.isFiltered())) {
                        String string = tRCFullMethodInvocation.getMethod().getName();
                        if (this.isSyncMessageFiltered(string)) {
                            this.collapseCalledMessage(tRCFullMethodInvocation, this.instancesMap);
                        } else {
                            this.totalNbMessages += 2;
                        }
                    }
                }
            }
            tRCFullMethodInvocation = this.currentProcesses.consumeMethodInvocation();
        }
        this.pages = this.totalNbMessages / this.maximumMessagesByPage;
        if (this.totalNbMessages % this.maximumMessagesByPage > 0) {
            ++this.pages;
        }
        this.cleanCollapsedMessage(this.instancesMap);
        this.instancesMap = null;
    }

    public void fillPage(TraceInteractionUpdate traceInteractionUpdate) {
        Object object;
        Object object2;
        this.tracePages = new ArrayList();
        this.instancesMap = new HashMap();
        this.traceThreadMap = new HashMap();
        this.traceThreadList = new ArrayList();
        this.lastValidTime = 0.0;
        this.nbMessages = 0;
        this.nbMessagesInThisPage = 0;
        this.hasNextPage = false;
        this.currentMethodInvocationIndex = 0;
        this.currentProcesses.init();
        TRCFullMethodInvocation tRCFullMethodInvocation = this.currentProcesses.consumeMethodInvocation();
        while (tRCFullMethodInvocation != null && !this.monitor.isCanceled() && this.nbMessagesInThisPage < this.maximumMessagesByPage) {
            this.finishPendingReturns(traceInteractionUpdate, TraceInteractionUtils.getAbsoluteEntryTime(tRCFullMethodInvocation));
            object2 = this.createSyncMessage(tRCFullMethodInvocation, traceInteractionUpdate);
            object = this.getTraceCallStack(tRCFullMethodInvocation.getThread());
            ((TraceCallStack)object).pushCall((TraceSyncMessage)object2, tRCFullMethodInvocation);
            tRCFullMethodInvocation = this.currentProcesses.consumeMethodInvocation();
        }
        this.finishPendingReturns(traceInteractionUpdate, Double.MAX_VALUE);
        object2 = this.instancesMap.entrySet();
        object = object2.iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            TraceLifelineDraft traceLifelineDraft = (TraceLifelineDraft)entry.getValue();
            if (traceLifelineDraft.getNbUser() <= 0) continue;
            traceLifelineDraft.setEnd(this.nbMessagesInThisPage + 1);
            if (traceLifelineDraft.getStart() == Integer.MAX_VALUE) {
                traceLifelineDraft.setStart(0);
            }
            this.setExecutionOccurence(traceLifelineDraft);
        }
        this.instancesMap = null;
        this.traceThreadMap = null;
        this.traceThreadList = null;
        this.cleanCollapsedMessage(this.frame);
    }

    protected void finishPendingReturns(TraceInteractionUpdate traceInteractionUpdate, double d) {
        while (this.getTraceThreadListFirstTime() < d) {
            TraceCallStack traceCallStack = (TraceCallStack)this.traceThreadList.get(0);
            TraceMessageAndCallAssociation traceMessageAndCallAssociation = traceCallStack.popCall();
            TraceSyncMessageReturn traceSyncMessageReturn = this.createSyncMessageReturn(traceMessageAndCallAssociation.getMethodInvocation(), traceInteractionUpdate);
            if (traceMessageAndCallAssociation.getMessage() == null || traceSyncMessageReturn == null) continue;
            traceSyncMessageReturn.setMessage(traceMessageAndCallAssociation.getMessage());
        }
    }

    private TraceSyncMessage createSyncMessage(TRCFullMethodInvocation tRCFullMethodInvocation, TraceInteractionUpdate traceInteractionUpdate) {
        TraceSyncMessage traceSyncMessage;
        TRCFullMethodInvocation tRCFullMethodInvocation2 = (TRCFullMethodInvocation)tRCFullMethodInvocation.getInvokedBy();
        if (this.isMessageCollapsed(tRCFullMethodInvocation2)) {
            return null;
        }
        TraceLifelineDraft traceLifelineDraft = this.getTraceLifelineDraftForMethodInvocation(this.frame, tRCFullMethodInvocation);
        TraceLifelineDraft traceLifelineDraft2 = null;
        if (tRCFullMethodInvocation2 != null) {
            traceLifelineDraft2 = this.getTraceLifelineDraftForMethodInvocation(this.frame, tRCFullMethodInvocation2);
        }
        if (traceLifelineDraft.isFiltered() || traceLifelineDraft2 != null && traceLifelineDraft2.isFiltered()) {
            return null;
        }
        if (this.internalMessagesFiltered && traceLifelineDraft2 == traceLifelineDraft) {
            return null;
        }
        String string = tRCFullMethodInvocation.getMethod().getName();
        if (this.isSyncMessageFiltered(string)) {
            this.collapseCalledMessage(tRCFullMethodInvocation, this.frame);
            return null;
        }
        ++this.nbMessages;
        if (this.nbMessagesInThisPage == this.maximumMessagesByPage) {
            this.hasNextPage = true;
            return null;
        }
        traceLifelineDraft.addAUser();
        if ((this.nbMessages - 1) % this.maximumMessagesByPage == 0) {
            this.tracePages.add(new TracePage(TraceInteractionUtils.getAbsoluteEntryTime(tRCFullMethodInvocation)));
        } else if ((this.nbMessages - 1) % this.maximumMessagesByPage == this.maximumMessagesByPage - 1) {
            ((TracePage)this.tracePages.get(this.tracePages.size() - 1)).setLastTime(TraceInteractionUtils.getAbsoluteExitTime(tRCFullMethodInvocation));
        }
        if (traceInteractionUpdate.isPageChanged() && this.nbMessages - 1 < this.pageNumber * this.maximumMessagesByPage) {
            return null;
        }
        if (!traceInteractionUpdate.isPageChanged()) {
            if (traceInteractionUpdate.isDateSelectionChanged()) {
                if (TraceInteractionUtils.getAbsoluteEntryTime(tRCFullMethodInvocation) < traceInteractionUpdate.getDateToShow()) {
                    return null;
                }
                throw new FoundInPage(this.tracePages.size() - 1);
            }
            if (traceInteractionUpdate.isFindRequired() && traceInteractionUpdate.getFindCriteria().isSyncMessageSelected()) {
                if (TraceInteractionUtils.matchCriteria(string, traceInteractionUpdate.getFindCriteria())) {
                    throw new FoundInPage(this.tracePages.size() - 1);
                }
                return null;
            }
        }
        if (traceLifelineDraft.getNbUser() == 1) {
            traceLifelineDraft.setStart(this.nbMessagesInThisPage + 1);
        }
        String string2 = "";
        if (this.isMessageCollapsed(tRCFullMethodInvocation)) {
            string2 = "[+] ";
            traceSyncMessage = new TraceCollapsedSyncMessage();
        } else {
            traceSyncMessage = tRCFullMethodInvocation.getInvokes() != null && tRCFullMethodInvocation.getInvokes().size() > 0 ? new TraceCollapsableSyncMessage() : new TraceSyncMessage();
        }
        if (traceInteractionUpdate.isPageChanged()) {
            if (traceInteractionUpdate.isDateSelectionChanged() && TraceInteractionUtils.getAbsoluteEntryTime(tRCFullMethodInvocation) >= traceInteractionUpdate.getDateToShow() && traceInteractionUpdate.getVisibleGraphNode() == null) {
                traceInteractionUpdate.setVisibleGraphNode((GraphNode)traceSyncMessage);
            }
            if (traceInteractionUpdate.isFindRequired() && traceInteractionUpdate.getFindCriteria().isSyncMessageSelected() && TraceInteractionUtils.matchCriteria(string, traceInteractionUpdate.getFindCriteria())) {
                traceInteractionUpdate.addFindResult((GraphNode)traceSyncMessage);
            }
        }
        traceSyncMessage.model = tRCFullMethodInvocation;
        if (traceLifelineDraft2 != null) {
            traceLifelineDraft2.getLifeline().setCurrentEventOccurrence(this.nbMessagesInThisPage + 1);
            traceSyncMessage.setStartLifeline(traceLifelineDraft2.getLifeline());
            traceSyncMessage.setName(string2 + string.intern());
        } else {
            traceLifelineDraft.getLifeline().setCurrentEventOccurrence(this.nbMessagesInThisPage + 1);
            traceSyncMessage.setName(string2 + string + " (" + tRCFullMethodInvocation.getThread().getName() + ")");
        }
        traceSyncMessage.setEndLifeline(traceLifelineDraft.getLifeline());
        traceSyncMessage.setTime(TraceInteractionUtils.getAbsoluteEntryTime(tRCFullMethodInvocation));
        this.lastValidTime = TraceInteractionUtils.getAbsoluteEntryTime(tRCFullMethodInvocation);
        if (this.monitor.isCanceled()) {
            return null;
        }
        this.frame.addMessage((BaseMessage)traceSyncMessage);
        ++this.nbMessagesInThisPage;
        return traceSyncMessage;
    }

    private TraceSyncMessageReturn createSyncMessageReturn(TRCFullMethodInvocation tRCFullMethodInvocation, TraceInteractionUpdate traceInteractionUpdate) {
        TraceSyncMessageReturn traceSyncMessageReturn;
        TRCFullMethodInvocation tRCFullMethodInvocation2 = (TRCFullMethodInvocation)tRCFullMethodInvocation.getInvokedBy();
        if (this.isMessageCollapsed(tRCFullMethodInvocation2)) {
            return null;
        }
        TraceLifelineDraft traceLifelineDraft = this.getTraceLifelineDraftForMethodInvocation(this.frame, tRCFullMethodInvocation);
        TraceLifelineDraft traceLifelineDraft2 = null;
        if (tRCFullMethodInvocation2 != null) {
            traceLifelineDraft2 = this.getTraceLifelineDraftForMethodInvocation(this.frame, tRCFullMethodInvocation2);
        }
        if (traceLifelineDraft.isFiltered() || traceLifelineDraft2 != null && traceLifelineDraft2.isFiltered()) {
            return null;
        }
        if (this.internalMessagesFiltered && traceLifelineDraft2 == traceLifelineDraft) {
            return null;
        }
        String string = tRCFullMethodInvocation.getMethod().getName();
        if (this.isSyncMessageFiltered(string)) {
            this.collapseCalledMessage(tRCFullMethodInvocation, this.frame);
            return null;
        }
        ++this.nbMessages;
        if (this.nbMessagesInThisPage == this.maximumMessagesByPage) {
            this.hasNextPage = true;
            return null;
        }
        traceLifelineDraft.removeAUser();
        if ((this.nbMessages - 1) % this.maximumMessagesByPage == 0) {
            this.tracePages.add(new TracePage(TraceInteractionUtils.getAbsoluteExitTime(tRCFullMethodInvocation)));
        } else if ((this.nbMessages - 1) % this.maximumMessagesByPage == this.maximumMessagesByPage - 1) {
            ((TracePage)this.tracePages.get(this.tracePages.size() - 1)).setLastTime(TraceInteractionUtils.getAbsoluteExitTime(tRCFullMethodInvocation));
        }
        if (traceInteractionUpdate.isPageChanged() && this.nbMessages - 1 < this.pageNumber * this.maximumMessagesByPage) {
            return null;
        }
        if (!traceInteractionUpdate.isPageChanged()) {
            if (traceInteractionUpdate.isDateSelectionChanged()) {
                if (TraceInteractionUtils.getAbsoluteExitTime(tRCFullMethodInvocation) < traceInteractionUpdate.getDateToShow()) {
                    return null;
                }
                throw new FoundInPage(this.tracePages.size() - 1);
            }
            if (traceInteractionUpdate.isFindRequired() && traceInteractionUpdate.getFindCriteria().isSyncMessageReturnSelected()) {
                if (TraceInteractionUtils.matchCriteria(string, traceInteractionUpdate.getFindCriteria())) {
                    throw new FoundInPage(this.tracePages.size() - 1);
                }
                return null;
            }
        }
        if (traceLifelineDraft.getNbUser() == 0) {
            traceLifelineDraft.setEnd(this.nbMessagesInThisPage + 1);
            if (traceLifelineDraft.getStart() == Integer.MAX_VALUE) {
                traceLifelineDraft.setStart(0);
            }
            this.setExecutionOccurence(traceLifelineDraft);
        }
        String string2 = "";
        if (this.isMessageCollapsed(tRCFullMethodInvocation)) {
            string2 = "[+] ";
            traceSyncMessageReturn = new TraceCollapsedSyncMessageReturn();
        } else {
            traceSyncMessageReturn = tRCFullMethodInvocation.getInvokes() != null && tRCFullMethodInvocation.getInvokes().size() > 0 ? new TraceCollapsableSyncMessageReturn() : new TraceSyncMessageReturn();
        }
        if (traceInteractionUpdate.isPageChanged()) {
            if (traceInteractionUpdate.isDateSelectionChanged() && TraceInteractionUtils.getAbsoluteExitTime(tRCFullMethodInvocation) >= traceInteractionUpdate.getDateToShow() && traceInteractionUpdate.getVisibleGraphNode() == null) {
                traceInteractionUpdate.setVisibleGraphNode((GraphNode)traceSyncMessageReturn);
            }
            if (traceInteractionUpdate.isFindRequired() && traceInteractionUpdate.getFindCriteria().isSyncMessageReturnSelected() && TraceInteractionUtils.matchCriteria(string, traceInteractionUpdate.getFindCriteria())) {
                traceInteractionUpdate.addFindResult((GraphNode)traceSyncMessageReturn);
            }
        }
        traceSyncMessageReturn.model = tRCFullMethodInvocation;
        if (traceLifelineDraft2 != null) {
            traceLifelineDraft2.getLifeline().setCurrentEventOccurrence(this.nbMessagesInThisPage + 1);
            traceSyncMessageReturn.setEndLifeline(traceLifelineDraft2.getLifeline());
            traceSyncMessageReturn.setName(string2 + string.intern());
        } else {
            traceLifelineDraft.getLifeline().setCurrentEventOccurrence(this.nbMessagesInThisPage + 1);
            traceSyncMessageReturn.setName(string2 + string + " (" + tRCFullMethodInvocation.getThread().getName() + ")");
        }
        traceSyncMessageReturn.setStartLifeline(traceLifelineDraft.getLifeline());
        if (tRCFullMethodInvocation.getExitTime() > 0.0) {
            traceSyncMessageReturn.setTime(TraceInteractionUtils.getAbsoluteExitTime(tRCFullMethodInvocation));
            this.lastValidTime = TraceInteractionUtils.getAbsoluteExitTime(tRCFullMethodInvocation);
        } else {
            traceSyncMessageReturn.setTime(this.lastValidTime);
        }
        if (this.monitor.isCanceled()) {
            return null;
        }
        this.frame.addMessage((BaseMessage)traceSyncMessageReturn);
        ++this.nbMessagesInThisPage;
        return traceSyncMessageReturn;
    }

    protected TraceLifelineDraft getTraceLifelineDraftForMethodInvocation(Frame frame, TRCFullMethodInvocation tRCFullMethodInvocation) {
        EObject eObject = this.getLifelineEObjectFromMethodInvocation(tRCFullMethodInvocation);
        TRCTraceObject tRCTraceObject = tRCFullMethodInvocation.getOwningObject();
        TraceLifelineDraft traceLifelineDraft = (TraceLifelineDraft)this.instancesMap.get(eObject);
        if (traceLifelineDraft == null) {
            ArrayList arrayList;
            traceLifelineDraft = new TraceLifelineDraft();
            String string = this.getLifeLineTitle(eObject, true);
            if (this.isLifelineFiltered(string)) {
                traceLifelineDraft.setFiltered(true);
                return traceLifelineDraft;
            }
            ArrayList arrayList2 = arrayList = this.collapsedLifelines != null ? (ArrayList)this.collapsedLifelines.get(eObject) : null;
            if (arrayList != null) {
                ArrayList arrayList3 = (ArrayList)this.collapsedLifelines.get(arrayList);
                while (arrayList3 != null) {
                    arrayList = arrayList3;
                    arrayList3 = (ArrayList)this.collapsedLifelines.get(arrayList3);
                }
                string = this.getCollapsedLifelineName(arrayList, "");
                if (string.length() > 80) {
                    string = string.substring(0, 77) + "...";
                }
                if (this.isLifelineFiltered(string)) {
                    traceLifelineDraft.setFiltered(true);
                    return traceLifelineDraft;
                }
                if (frame == null) {
                    return traceLifelineDraft;
                }
                TraceCollapsedLifelines traceCollapsedLifelines = new TraceCollapsedLifelines();
                traceLifelineDraft.setLifeline(traceCollapsedLifelines);
                traceCollapsedLifelines.setCollapsedLifelines(arrayList);
                traceCollapsedLifelines.setName(string);
                this.putInstancesMap(arrayList, traceLifelineDraft);
                traceCollapsedLifelines.setCategory(2);
            } else {
                if (frame == null) {
                    return traceLifelineDraft;
                }
                TraceLifeline traceLifeline = new TraceLifeline();
                traceLifelineDraft.setLifeline(traceLifeline);
                traceLifeline.setEObject(eObject);
                this.instancesMap.put(eObject, traceLifelineDraft);
                if (tRCTraceObject.getIsA() != null) {
                    traceLifeline.setName(string);
                    traceLifeline.setCategory(this.getLifeLineCategory(eObject));
                }
            }
            frame.addLifeLine(traceLifelineDraft.getLifeline());
            traceLifelineDraft.setStart(Integer.MAX_VALUE);
            traceLifelineDraft.setEnd(0);
        }
        return traceLifelineDraft;
    }

    private void putInstancesMap(ArrayList arrayList, TraceLifelineDraft traceLifelineDraft) {
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof EObject) {
                this.instancesMap.put(e, traceLifelineDraft);
                continue;
            }
            if (!(e instanceof ArrayList)) continue;
            this.putInstancesMap((ArrayList)e, traceLifelineDraft);
        }
    }

    private String getCollapsedLifelineName(ArrayList arrayList, String string) {
        String string2 = "[";
        int n = 0;
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof EObject) {
                if (n > 0) {
                    string2 = string2 + "," + string;
                }
                string2 = string2 + this.getLifeLineTitle((EObject)e, false);
            } else if (e instanceof ArrayList) {
                if (n > 0) {
                    string2 = string2 + "," + string;
                }
                string2 = string2 + this.getCollapsedLifelineName((ArrayList)e, string + " ");
            }
            ++n;
        }
        return string2 + "]";
    }

    private void externalDateSelectionChanged(IDateSelection iDateSelection, TraceInteractionUpdate traceInteractionUpdate) {
        if (this.frame == null) {
            return;
        }
        IDateSelection iDateSelection2 = iDateSelection;
        EObject eObject = iDateSelection.getEObject();
        if (!(eObject instanceof TRCProcess) || this.currentProcesses == null || !this.currentProcesses.contains((TRCProcess)eObject)) {
            return;
        }
        double d = iDateSelection2.getStartDate();
        TRCProcess tRCProcess = (TRCProcess)eObject;
        if (iDateSelection2.getMeaning() == 0) {
            IDateSelection iDateSelection3;
            int n;
            Object object;
            IDateSelection iDateSelection4;
            if (this.frame.syncMessageCount() > 0) {
                iDateSelection4 = (TraceSyncMessage)this.frame.getSyncMessage(0);
                object = (TraceSyncMessage)this.frame.getSyncMessage(this.frame.syncMessageCount() - 1);
                if (((TraceSyncMessage)iDateSelection4).getStartDate() <= d && ((TraceSyncMessage)object).getStartDate() >= d) {
                    n = 0;
                    while (n < this.frame.syncMessageCount()) {
                        iDateSelection3 = (TraceSyncMessage)this.frame.getSyncMessage(n);
                        if (((TraceSyncMessage)iDateSelection3).getStartDate() >= iDateSelection2.getStartDate()) {
                            this.view.getSDWidget().ensureVisible((GraphNode)iDateSelection3);
                            return;
                        }
                        ++n;
                    }
                }
            }
            if (this.frame.syncMessageReturnCount() > 0) {
                iDateSelection4 = (TraceSyncMessageReturn)this.frame.getSyncMessageReturn(0);
                object = (TraceSyncMessageReturn)this.frame.getSyncMessageReturn(this.frame.syncMessageReturnCount() - 1);
                if (((TraceSyncMessageReturn)iDateSelection4).getStartDate() <= d && ((TraceSyncMessageReturn)object).getStartDate() >= d) {
                    n = 0;
                    while (n < this.frame.syncMessageReturnCount()) {
                        iDateSelection3 = (TraceSyncMessageReturn)this.frame.getSyncMessageReturn(n);
                        if (((TraceSyncMessageReturn)iDateSelection3).getStartDate() >= iDateSelection2.getStartDate()) {
                            this.view.getSDWidget().ensureVisible((GraphNode)iDateSelection3);
                            return;
                        }
                        ++n;
                    }
                }
            }
            if (this.tracePages != null && this.tracePages.size() > 0 && d <= ((TracePage)this.tracePages.get(this.tracePages.size() - 1)).getLastTime()) {
                int n2 = 0;
                while (n2 < this.tracePages.size()) {
                    object = (TracePage)this.tracePages.get(n2);
                    if (d >= ((TracePage)object).getFirstTime() && d <= ((TracePage)object).getLastTime()) {
                        traceInteractionUpdate.setDateSelectionChanged(true);
                        traceInteractionUpdate.setDateToShow(d);
                        traceInteractionUpdate.setPageChanged(true);
                        this.pageNumber = n2;
                        return;
                    }
                    ++n2;
                }
            }
            if (d < tRCProcess.getAgent().getStartTime() + tRCProcess.getStartTime()) {
                d += tRCProcess.getAgent().getStartTime() + tRCProcess.getStartTime();
            }
            traceInteractionUpdate.setDateSelectionChanged(true);
            traceInteractionUpdate.setDateToShow(d);
        }
    }

    private void subscribeForDateSelectionChanged(final IDateSelection iDateSelection) {
        if (this.dateSelectionTimer != null) {
            this.dateSelectionTimer.cancel();
        }
        this.dateSelectionTimer = new Timer();
        this.dateSelectionTimer.schedule(new TimerTask(){

            public void run() {
                Display.getDefault().syncExec(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        TraceInteractionUpdate traceInteractionUpdate = new TraceInteractionUpdate();
                        TraceInteractions.access$200(1.access$100(this.this$1), 1.access$000(this.this$1), traceInteractionUpdate);
                        if (traceInteractionUpdate.needsUpdate()) {
                            1.access$100(this.this$1).updateSDBackground(traceInteractionUpdate);
                        }
                    }
                });
                TraceInteractions.this.dateSelectionTimer = null;
            }

            static /* synthetic */ IDateSelection access$000(1 var0) {
                return var0.iDateSelection;
            }

            static /* synthetic */ TraceInteractions access$100(1 var0) {
                return var0.TraceInteractions.this;
            }
        }, 50L);
    }

    protected boolean externalExtendedSelectionChanged(IWorkbenchPart iWorkbenchPart, Object object, TraceInteractionUpdate traceInteractionUpdate) {
        if (object instanceof IDateSelection) {
            this.subscribeForDateSelectionChanged((IDateSelection)object);
            return true;
        }
        return false;
    }

    public boolean isSyncMessageSupported() {
        return true;
    }

    public boolean hasNextPage() {
        return this.hasNextPage;
    }

    public boolean hasPrevPage() {
        return this.pageNumber > 0;
    }

    public void nextPage() {
        ++this.pageNumber;
        TraceInteractionUpdate traceInteractionUpdate = new TraceInteractionUpdate();
        traceInteractionUpdate.setPageChanged(true);
        this.updateSDBackground(traceInteractionUpdate);
    }

    public void prevPage() {
        --this.pageNumber;
        TraceInteractionUpdate traceInteractionUpdate = new TraceInteractionUpdate();
        traceInteractionUpdate.setPageChanged(true);
        this.updateSDBackground(traceInteractionUpdate);
    }

    public int maxItemsByPageCount() {
        return this.maximumMessagesByPage;
    }

    public int itemsTotalCount() {
        return this.totalNbMessages;
    }

    public String noItemsText() {
        return TraceSDPlugin.getResourceString("PAGES_COUNT_NO_ITEMS");
    }

    public String oneItemText() {
        return TraceSDPlugin.getResourceString("PAGES_COUNT_ONE_ITEM");
    }

    public String itemsText() {
        return TraceSDPlugin.getResourceString("PAGES_COUNT_SEVERAL_ITEMS");
    }

    public int currentPage() {
        return this.pageNumber;
    }

    public int pagesCount() {
        return this.pages;
    }

    public void pageSettingsChanged(int n, int n2) {
        TraceInteractionUpdate traceInteractionUpdate = new TraceInteractionUpdate();
        traceInteractionUpdate.setMaxMessagesByPageChanged(this.maximumMessagesByPage != n);
        this.maximumMessagesByPage = n;
        traceInteractionUpdate.setPageChanged(this.pageNumber != n2);
        this.pageNumber = n2;
        if (traceInteractionUpdate.isMaxMessagesByPageChanged() || traceInteractionUpdate.isPageChanged()) {
            this.updateSDBackground(traceInteractionUpdate);
        }
    }

    public void pageNumberChanged(int n) {
        TraceInteractionUpdate traceInteractionUpdate = new TraceInteractionUpdate();
        traceInteractionUpdate.setPageChanged(this.pageNumber != n);
        this.pageNumber = n;
        if (traceInteractionUpdate.isPageChanged()) {
            this.updateSDBackground(traceInteractionUpdate);
        }
    }

    public void setFiltered(boolean bl) {
        if (this.internalMessagesFiltered != bl) {
            this.internalMessagesFiltered = bl;
            TraceInteractionUpdate traceInteractionUpdate = new TraceInteractionUpdate();
            traceInteractionUpdate.setInternalMessageFilteringChanged(true);
            this.updateSDBackground(traceInteractionUpdate);
        }
    }

    public ArrayList getCurrentFilters() {
        return this.currentFilters;
    }

    private boolean isLifelineFiltered(String string) {
        if (this.currentFilters != null) {
            Iterator iterator = ((AbstractList)this.currentFilters).iterator();
            while (iterator.hasNext()) {
                FilterCriteria filterCriteria = (FilterCriteria)iterator.next();
                if (!filterCriteria.isActive() || !filterCriteria.getCriteria().isLifeLineSelected() || !TraceInteractionUtils.matchCriteria(string, filterCriteria.getCriteria())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSyncMessageFiltered(String string) {
        if (this.currentFilters != null) {
            Iterator iterator = ((AbstractList)this.currentFilters).iterator();
            while (iterator.hasNext()) {
                FilterCriteria filterCriteria = (FilterCriteria)iterator.next();
                if (!filterCriteria.isActive() || !filterCriteria.getCriteria().isSyncMessageSelected() || !TraceInteractionUtils.matchCriteria(string, filterCriteria.getCriteria())) continue;
                return true;
            }
        }
        return false;
    }

    public void filterSelectedGraphNodes(ArrayList arrayList) {
        TraceInteractionUpdate traceInteractionUpdate;
        if (this.currentFilters == null) {
            this.currentFilters = new ArrayList();
        }
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            EObject eObject;
            traceInteractionUpdate = (GraphNode)iterator.next();
            Criteria criteria = new Criteria();
            if (traceInteractionUpdate instanceof IEObjectSelection && (eObject = ((IEObjectSelection)((Object)traceInteractionUpdate)).getEObject()) instanceof TRCFullMethodInvocation) {
                criteria.setExpression(((TRCFullMethodInvocation)eObject).getMethod().getName());
            }
            criteria.setCaseSenstiveSelected(true);
            if (traceInteractionUpdate instanceof TraceLifeline) {
                criteria.setExpression(traceInteractionUpdate.getName());
                criteria.setLifeLineSelected(true);
            } else if (traceInteractionUpdate instanceof TraceSyncMessage) {
                criteria.setExpression(((TRCFullMethodInvocation)((TraceSyncMessage)((Object)traceInteractionUpdate)).getEObject()).getMethod().getName());
                criteria.setSyncMessageSelected(true);
            } else if (traceInteractionUpdate instanceof TraceSyncMessageReturn) {
                criteria.setExpression(((TRCFullMethodInvocation)((TraceSyncMessageReturn)((Object)traceInteractionUpdate)).getEObject()).getMethod().getName());
                criteria.setSyncMessageSelected(true);
            }
            this.currentFilters.add(new FilterCriteria(criteria, true));
        }
        traceInteractionUpdate = new TraceInteractionUpdate();
        traceInteractionUpdate.setFilteringChanged(true);
        this.updateSDBackground(traceInteractionUpdate);
    }

    public boolean filter(ArrayList arrayList) {
        this.currentFilters = arrayList;
        TraceInteractionUpdate traceInteractionUpdate = new TraceInteractionUpdate();
        traceInteractionUpdate.setFilteringChanged(true);
        this.updateSDBackground(traceInteractionUpdate);
        return true;
    }

    public void collapseLifelines(ArrayList arrayList) {
        TraceInteractionUpdate traceInteractionUpdate;
        if (this.collapsedLifelines == null) {
            this.collapsedLifelines = new HashMap();
        }
        ArrayList<ArrayList> arrayList2 = new ArrayList<ArrayList>();
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            traceInteractionUpdate = (GraphNode)iterator.next();
            ArrayList arrayList3 = null;
            if (traceInteractionUpdate instanceof TraceCollapsedLifelines) {
                arrayList3 = ((TraceCollapsedLifelines)((Object)traceInteractionUpdate)).getCollapsedLifelines();
            } else {
                if (!(traceInteractionUpdate instanceof TraceLifeline)) continue;
                arrayList3 = ((TraceLifeline)((Object)traceInteractionUpdate)).getEObject();
            }
            arrayList2.add(arrayList3);
            this.collapsedLifelines.put(arrayList3, arrayList2);
        }
        traceInteractionUpdate = new TraceInteractionUpdate();
        traceInteractionUpdate.setHorizontalCollapsingChanged(true);
        this.updateSDBackground(traceInteractionUpdate);
    }

    public void expandLifelines(ArrayList arrayList) {
        TraceInteractionUpdate traceInteractionUpdate;
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            traceInteractionUpdate = (GraphNode)iterator.next();
            if (!(traceInteractionUpdate instanceof TraceCollapsedLifelines)) continue;
            ArrayList arrayList2 = ((TraceCollapsedLifelines)((Object)traceInteractionUpdate)).getCollapsedLifelines();
            Iterator iterator2 = ((AbstractList)arrayList2).iterator();
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                this.collapsedLifelines.put(e, null);
            }
        }
        traceInteractionUpdate = new TraceInteractionUpdate();
        traceInteractionUpdate.setHorizontalCollapsingChanged(true);
        this.updateSDBackground(traceInteractionUpdate);
    }

    private boolean isMessageCollapsed(TRCFullMethodInvocation tRCFullMethodInvocation) {
        if (tRCFullMethodInvocation == null || this.collapsedMessages == null) {
            return false;
        }
        if (this.collapsedMessages.get(tRCFullMethodInvocation) != null) {
            return true;
        }
        TRCFullMethodInvocation tRCFullMethodInvocation2 = (TRCFullMethodInvocation)tRCFullMethodInvocation.getInvokedBy();
        while (tRCFullMethodInvocation2 != null) {
            if (this.collapsedMessages.get(tRCFullMethodInvocation2) != null) {
                return true;
            }
            tRCFullMethodInvocation2 = (TRCFullMethodInvocation)tRCFullMethodInvocation2.getInvokedBy();
        }
        return false;
    }

    public void collapseCalledMessages(ArrayList arrayList) {
        Object object;
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            IDateSelection iDateSelection;
            object = iterator.next();
            TRCFullMethodInvocation tRCFullMethodInvocation = null;
            if (object instanceof TraceSyncMessage) {
                iDateSelection = (TraceSyncMessage)object;
                tRCFullMethodInvocation = (TRCFullMethodInvocation)((TraceSyncMessage)iDateSelection).getEObject();
            } else if (object instanceof TraceSyncMessageReturn) {
                iDateSelection = (TraceSyncMessageReturn)object;
                tRCFullMethodInvocation = (TRCFullMethodInvocation)((TraceSyncMessageReturn)iDateSelection).getEObject();
            }
            this.collapseCalledMessage(tRCFullMethodInvocation, this.currentMofObjectFromPDProjectExplorer);
        }
        object = new TraceInteractionUpdate();
        ((TraceInteractionUpdate)object).setVerticalCollapsingChanged(true);
        this.updateSDBackground((TraceInteractionUpdate)object);
    }

    private void collapseCalledMessage(TRCFullMethodInvocation tRCFullMethodInvocation, Object object) {
        if (tRCFullMethodInvocation != null) {
            if (this.collapsedMessages == null) {
                this.collapsedMessages = new HashMap();
            }
            this.collapsedMessages.put(tRCFullMethodInvocation, object);
        }
    }

    private void cleanCollapsedMessage(Object object) {
        if (this.collapsedMessages == null) {
            return;
        }
        Set set = this.collapsedMessages.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getValue() != object) continue;
            iterator.remove();
        }
    }

    public void expandCalledMessages(ArrayList arrayList) {
        Object object;
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            IDateSelection iDateSelection;
            object = iterator.next();
            TRCFullMethodInvocation tRCFullMethodInvocation = null;
            if (object instanceof TraceSyncMessage) {
                iDateSelection = (TraceSyncMessage)object;
                tRCFullMethodInvocation = (TRCFullMethodInvocation)((TraceSyncMessage)iDateSelection).getEObject();
            } else if (object instanceof TraceSyncMessageReturn) {
                iDateSelection = (TraceSyncMessageReturn)object;
                tRCFullMethodInvocation = (TRCFullMethodInvocation)((TraceSyncMessageReturn)iDateSelection).getEObject();
            }
            if (tRCFullMethodInvocation == null) continue;
            this.collapsedMessages.put(tRCFullMethodInvocation, null);
        }
        object = new TraceInteractionUpdate();
        ((TraceInteractionUpdate)object).setVerticalCollapsingChanged(true);
        this.updateSDBackground((TraceInteractionUpdate)object);
    }

    public void applyPreferences() {
        int n = (int)TraceSDPlugin.getDefault().getPreferenceStore().getLong("page_size");
        if (this.maximumMessagesByPage == n) {
            return;
        }
        TraceInteractionUpdate traceInteractionUpdate = new TraceInteractionUpdate();
        traceInteractionUpdate.setMaxMessagesByPageChanged(true);
        this.maximumMessagesByPage = n;
        this.updateSDBackground(traceInteractionUpdate);
    }

    static /* synthetic */ void access$200(TraceInteractions traceInteractions, IDateSelection iDateSelection, TraceInteractionUpdate traceInteractionUpdate) {
        traceInteractions.externalDateSelectionChanged(iDateSelection, traceInteractionUpdate);
    }

    static {
        TraceInteractions.traceCategories[0] = new LifelineCategories();
        traceCategories[0].setName(TraceSDPlugin.getResourceString("STR_CLASS"));
        traceCategories[0].setImage((IImage)new ImageImpl(TraceSDPlugin.getResourceImage("class.gif")));
        TraceInteractions.traceCategories[1] = new LifelineCategories();
        traceCategories[1].setName(TraceSDPlugin.getResourceString("STR_OBJECT"));
        traceCategories[1].setImage((IImage)new ImageImpl(TraceSDPlugin.getResourceImage("classobject_obj.gif")));
        TraceInteractions.traceCategories[2] = new LifelineCategories();
        traceCategories[2].setName(TraceSDPlugin.getResourceString("STR_COLLAPSED_LIFELINE"));
        traceCategories[2].setImage((IImage)new ImageImpl(TraceSDPlugin.getResourceImage("collapsed_obj.gif")));
    }
}

