/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.trace.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.eclipse.hyades.execution.trace.util.RecordArray;
import org.eclipse.hyades.execution.trace.util.Utilities;
import org.eclipse.hyades.logging.core.XmlUtility;

public class RecordVariable {
    public static final String PARAMETER = "parameter";
    public static final String RETURN_VALUE = "returnValue";
    public static final String ARRAY_ELEMENT = "arrayElement";
    private final String _event;
    private final int _id;
    private final Class _clazz;
    private final Object _value;

    public RecordVariable(String string, int n, Class clazz, Object object) {
        this._event = string;
        this._id = n;
        this._clazz = clazz;
        this._value = object;
    }

    public String toString() {
        Object object;
        if (this._value == null) {
            return null;
        }
        String string = null;
        if (this._clazz.isArray()) {
            string = new RecordArray(ARRAY_ELEMENT, this._clazz.getComponentType(), (Object[])this._value).toString();
        } else {
            object = Utilities.stringifyPrimitivesStrings(this._clazz, this._value);
            if (object != null) {
                string = XmlUtility.normalize((String)object);
            }
        }
        if (string == null) {
            try {
                object = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)object);
                objectOutputStream.writeObject(this._value);
                objectOutputStream.close();
                byte[] byArray = ((ByteArrayOutputStream)object).toByteArray();
                StringBuffer stringBuffer = new StringBuffer(byArray.length << 1);
                int n = 0;
                while (n < byArray.length) {
                    String string2 = Integer.toHexString(byArray[n] & 0xFF);
                    stringBuffer.append(string2.length() < 2 ? "0" + string2 : string2);
                    ++n;
                }
                string = stringBuffer.toString();
            }
            catch (NotSerializableException notSerializableException) {
                string = XmlUtility.normalize((String)this._value.toString());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }
        return "<" + this._event + (this._event == ARRAY_ELEMENT ? " index=\"" + this._id + "\"" : "") + (this._event == PARAMETER ? " parameterIdRef=\"" + this._id + "\"" : "") + (!this._clazz.isArray() ? " value=\"" + string + "\"/>" : ">\n" + string + "</" + this._event + ">");
    }
}

