/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.cbe;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;

public class CBEUtils {
    public static double computeAdjustedCreationTime(CBECommonBaseEvent cBECommonBaseEvent) {
        double d = cBECommonBaseEvent.getCreationTime();
        try {
            return d + cBECommonBaseEvent.getAgent().getAgentProxy().getProcessProxy().getNode().getDeltaTime();
        }
        catch (Exception exception) {
            return d;
        }
    }

    public static String formatCreationTime(CBECommonBaseEvent cBECommonBaseEvent, SimpleDateFormat simpleDateFormat) {
        String string = "0";
        if (cBECommonBaseEvent.getCreationTime() != 0.0) {
            try {
                short s = cBECommonBaseEvent.getTimeZone();
                double d = CBEUtils.computeAdjustedCreationTime(cBECommonBaseEvent);
                Double d2 = new Double(d);
                string = simpleDateFormat.format(new Date(d2.longValue() / 1000L + (long)(s * 60 * 1000)));
                String string2 = "" + d2.longValue() % 1000000L;
                string = string + "." + "000000".substring(0, 6 - string2.length()) + string2;
                string = string + (s > 0 ? "+00" : "-00").substring(0, 3 - ("" + Math.abs(s / 60)).length()) + Math.abs(s / 60);
                string = string + ":00".substring(0, 3 - ("" + Math.abs(s % 60)).length()) + Math.abs(s % 60);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }
}

