/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.preferences.internal;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileOptionsUI;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.help.WorkbenchHelp;

public class TraceOptionsPreferencePage {
    private TraceProfileOptionsUI _options;
    private IPreferenceStore _preferenceStore;
    private PreferencePage _preferencePage;

    public TraceOptionsPreferencePage(IPreferenceStore iPreferenceStore, PreferencePage preferencePage) {
        this._preferenceStore = iPreferenceStore;
        this._preferencePage = preferencePage;
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        WorkbenchHelp.setHelp((Control)composite, (String)(UIPlugin.getPluginId() + ".topp0000"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 5;
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        this._options = new TraceProfileOptionsUI();
        this._options.createControl(composite2);
        this._options.setPreferencePage(this._preferencePage);
        this._options.enableButtons();
        return composite2;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return this._preferenceStore;
    }

    public void init(IWorkbench iWorkbench) {
    }

    private void initializeDefaults() {
        this._options.setHeap(this._preferenceStore.getDefaultBoolean("prof_heap_stat"));
        this._options.setHeapDetails(this._preferenceStore.getDefaultBoolean("prof_heap_inst"));
        this._options.setExecution(this._preferenceStore.getDefaultBoolean("prof_execution"));
        this._options.setExecutionBoundary(this._preferenceStore.getDefaultBoolean("prof_execution_boundary"));
        this._options.setCollectionDepth(this._preferenceStore.getDefaultString("collect_depth"));
        this._options.setExecutionStatistic(this._preferenceStore.getDefaultBoolean("prof_exec_stat"));
        this._options.setExecutionFlow(!this._preferenceStore.getDefaultBoolean("prof_exec_stat"));
    }

    protected void performDefaults() {
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        UIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void storeValues() {
        this._options.storeValues();
    }
}

